/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.voronoi;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.triangulate.VoronoiDiagramBuilder;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class VoronoiAlgorithm
extends GeoAlgorithm {
    public static final String POINTS = "POINTS";
    public static final String TRIANGLES = "TRIANGLES";
    private IVectorLayer m_Points;
    private IVectorLayer m_Voronoi;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Voronoi_polygons"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points_layer"), 0, true);
            this.addOutputVectorLayer(TRIANGLES, Sextante.getText((String)"Voronoi_polygons"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Points = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (!this.m_bIsAutoExtent) {
            this.m_Points.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        Class[] types = new Class[]{Integer.class};
        String[] sNames = new String[]{"ID"};
        this.m_Voronoi = this.getNewVectorLayer(TRIANGLES, Sextante.getText((String)"Voronoi_polygons"), 2, types, sNames);
        int i = 0;
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        int iShapeCount = this.m_Points.getShapesCount();
        IFeatureIterator iter = this.m_Points.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            list.add(feature.getGeometry());
            ++i;
        }
        iter.close();
        this.m_Task.setDeterminate(false);
        GeometryFactory gf = new GeometryFactory();
        GeometryCollection geomcol = gf.createGeometryCollection(list.toArray(new Geometry[0]));
        VoronoiDiagramBuilder voronoi = new VoronoiDiagramBuilder();
        voronoi.setSites((Geometry)geomcol);
        Geometry polygons = voronoi.getDiagram(gf);
        int iPolygons = polygons.getNumGeometries();
        for (int iPolygon = 0; iPolygon < iPolygons; ++iPolygon) {
            Geometry triangle = polygons.getGeometryN(iPolygon);
            Object[] record = new Object[]{new Integer(iPolygon)};
            this.m_Voronoi.addFeature(triangle, record);
        }
        return !this.m_Task.isCanceled();
    }
}

