/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorize.vectorize;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class VectorizeAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    private IRasterLayer m_Window;
    private IVectorLayer m_Polygons;
    private int m_iNX;
    private int m_iNY;
    private int[][] m_Lock;
    private char[][] m_Area;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Vectorize_raster_layer__polygons"));
        this.setGroup(Sextante.getText((String)"Vectorization"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Input_layer"), true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        String[] sFields = new String[2];
        Class[] types = new Class[]{Integer.class, Double.class};
        this.m_Window = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_Window.setFullExtent();
        sFields[0] = "ID";
        sFields[1] = this.m_Window.getName();
        this.m_Polygons = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Resultado"), 2, types, sFields);
        this.createPolygons();
        return !this.m_Task.isCanceled();
    }

    private void createPolygons() {
        this.m_iNX = this.m_Window.getNX();
        this.m_iNY = this.m_Window.getNY();
        this.m_Lock = new int[this.m_iNY][this.m_iNX];
        this.m_Area = new char[this.m_iNY + 1][this.m_iNX + 1];
        int ID = 1;
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Window.getCellValueAsDouble(x, y);
                if (this.m_Window.isNoDataValue(dValue) || this.m_Lock[y][x] != 0) continue;
                this.Discrete_Lock(x, y, ID);
                this.Discrete_Area(x, y, ID);
                ++ID;
            }
        }
    }

    private void Discrete_Lock(int x, int y, int ID) {
        int ix;
        int iy;
        int[] xTo = new int[]{0, 1, 0, -1};
        int[] yTo = new int[]{1, 0, -1, 0};
        char[] goDir = new char[]{'\u0001', '\u0002', '\u0004', '\b'};
        char goTemp = '\u0000';
        char[] goStack = new char[50];
        int[] xStack = new int[50];
        int[] yStack = new int[50];
        int iStack = 0;
        double dValue = this.m_Window.getCellValueAsDouble(x, y);
        for (iy = 0; iy <= this.m_iNY; ++iy) {
            for (ix = 0; ix <= this.m_iNX; ++ix) {
                this.m_Area[iy][ix] = '\u0000';
            }
        }
        do {
            int i;
            if (this.m_Lock[y][x] == 0) {
                if (goStack.length <= iStack) {
                    char[] cAux = new char[goStack.length + 50];
                    System.arraycopy(goStack, 0, cAux, 0, goStack.length);
                    goStack = cAux;
                    int[] iAux = new int[xStack.length + 50];
                    System.arraycopy(xStack, 0, iAux, 0, xStack.length);
                    xStack = iAux;
                    iAux = new int[yStack.length + 50];
                    System.arraycopy(yStack, 0, iAux, 0, yStack.length);
                    yStack = iAux;
                }
                goStack[iStack] = '\u0000';
                this.m_Lock[y][x] = ID;
                block9: for (i = 0; i < 4; ++i) {
                    ix = x + xTo[i];
                    iy = y + yTo[i];
                    boolean isBorder = true;
                    double dValue2 = this.m_Window.getCellValueAsDouble(ix, iy);
                    if (ix >= 0 && ix < this.m_iNX && iy >= 0 && iy < this.m_iNY && dValue == dValue2) {
                        isBorder = false;
                        if (this.m_Lock[iy][ix] == 0) {
                            int n = iStack;
                            goStack[n] = (char)(goStack[n] | goDir[i]);
                        }
                    }
                    if (!isBorder) continue;
                    switch (i) {
                        case 0: {
                            char[] cArray = this.m_Area[y + 1];
                            int n = x;
                            cArray[n] = (char)(cArray[n] + '\u0001');
                            char[] cArray2 = this.m_Area[y + 1];
                            int n2 = x + 1;
                            cArray2[n2] = (char)(cArray2[n2] + '\u0001');
                            continue block9;
                        }
                        case 1: {
                            char[] cArray = this.m_Area[y];
                            int n = x + 1;
                            cArray[n] = (char)(cArray[n] + '\u0001');
                            char[] cArray3 = this.m_Area[y + 1];
                            int n3 = x + 1;
                            cArray3[n3] = (char)(cArray3[n3] + '\u0001');
                            continue block9;
                        }
                        case 2: {
                            char[] cArray = this.m_Area[y];
                            int n = x;
                            cArray[n] = (char)(cArray[n] + '\u0001');
                            char[] cArray4 = this.m_Area[y];
                            int n4 = x + 1;
                            cArray4[n4] = (char)(cArray4[n4] + '\u0001');
                            continue block9;
                        }
                        case 3: {
                            char[] cArray = this.m_Area[y];
                            int n = x;
                            cArray[n] = (char)(cArray[n] + '\u0001');
                            char[] cArray5 = this.m_Area[y + 1];
                            int n5 = x;
                            cArray5[n5] = (char)(cArray5[n5] + '\u0001');
                        }
                    }
                }
            }
            boolean doRecurse = false;
            for (i = 0; i < 4; ++i) {
                if ((goStack[iStack] & goDir[i]) == 0) continue;
                if (doRecurse) {
                    goTemp = (char)(goTemp | goDir[i]);
                    continue;
                }
                goTemp = '\u0000';
                doRecurse = true;
                xStack[iStack] = x;
                yStack[iStack] = y;
                x += xTo[i];
                y += yTo[i];
            }
            if (doRecurse) {
                goStack[iStack++] = goTemp;
                continue;
            }
            if (iStack <= 0) continue;
            x = xStack[--iStack];
            y = yStack[iStack];
        } while (iStack > 0);
    }

    private void Discrete_Area(int x, int y, int ID) {
        int i;
        boolean bContinue;
        int[] xTo = new int[]{0, 1, 0, -1};
        int[] yTo = new int[]{1, 0, -1, 0};
        int[] xLock = new int[]{0, 0, -1, -1};
        int[] yLock = new int[]{0, -1, -1, 0};
        double xMin = this.m_Window.getWindowGridExtent().getXMin();
        double yMax = this.m_Window.getWindowGridExtent().getYMax();
        double dCellSize = this.m_Window.getWindowCellSize();
        double xFirst = 0.0;
        double yFirst = 0.0;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        Object[] values = new Object[]{new Integer(ID), new Double(this.m_Window.getCellValueAsDouble(x, y))};
        xFirst = xMin + (double)x * dCellSize;
        yFirst = yMax - (double)y * dCellSize;
        coordinates.add(new Coordinate(xFirst, yFirst));
        int iStart = 0;
        boolean bStart = true;
        block0: do {
            int iy1;
            int ix1;
            int iy;
            int ix;
            coordinates.add(new Coordinate(xMin + (double)x * dCellSize, yMax - (double)y * dCellSize));
            this.m_Area[y][x] = '\u0000';
            bContinue = false;
            if (bStart) {
                for (i = 0; i < 4; ++i) {
                    ix = x + xTo[i];
                    iy = y + yTo[i];
                    if (ix < 0 || ix > this.m_iNX || iy < 0 || iy > this.m_iNY || this.m_Area[iy][ix] <= '\u0000') continue;
                    ix1 = x + xLock[i];
                    iy1 = y + yLock[i];
                    if (ix1 < 0 || ix1 > this.m_iNX || iy1 < 0 || iy1 > this.m_iNY || this.m_Lock[iy1][ix1] != ID) continue;
                    x = ix;
                    y = iy;
                    iStart = (i + 3) % 4;
                    bContinue = true;
                    bStart = false;
                    continue block0;
                }
            } else {
                for (i = iStart; i < iStart + 4; ++i) {
                    int dir = i % 4;
                    ix = x + xTo[dir];
                    iy = y + yTo[dir];
                    if (ix < 0 || ix > this.m_iNX || iy < 0 || iy > this.m_iNY || this.m_Area[iy][ix] <= '\u0000') continue;
                    if (i < iStart + 3) {
                        ix1 = x + xLock[dir];
                        iy1 = y + yLock[dir];
                        if (ix1 < 0 || ix1 > this.m_iNX || iy1 < 0 || iy1 > this.m_iNY || this.m_Lock[iy1][ix1] != ID) continue;
                        x = ix;
                        y = iy;
                        iStart = (i + 3) % 4;
                        bContinue = true;
                        continue block0;
                    }
                    x = ix;
                    y = iy;
                    bContinue = true;
                    iStart = (i + 3) % 4;
                    continue block0;
                }
            }
        } while (bContinue);
        coordinates.add(new Coordinate(xFirst, yFirst));
        Coordinate[] coords = new Coordinate[coordinates.size()];
        for (i = 0; i < coords.length; ++i) {
            coords[i] = (Coordinate)coordinates.get(i);
        }
        GeometryFactory gf = new GeometryFactory();
        if (coords.length > 1) {
            LinearRing ring = gf.createLinearRing(coords);
            Polygon polyg = gf.createPolygon(ring, null);
            this.m_Polygons.addFeature((Geometry)polyg, values);
        }
    }
}

