/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi.rtree;

import com.infomatiq.jsi.IntProcedure;
import com.infomatiq.jsi.Point;
import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.SpatialIndex;
import com.infomatiq.jsi.rtree.Node;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeSet;

public class RTree
implements SpatialIndex {
    private static final String version = "1.0b2";
    private static final int DEFAULT_MAX_NODE_ENTRIES = 10;
    int maxNodeEntries;
    int minNodeEntries;
    private TIntObjectHashMap nodeMap = new TIntObjectHashMap();
    private static final boolean INTERNAL_CONSISTENCY_CHECKING = false;
    private static final int ENTRY_STATUS_ASSIGNED = 0;
    private static final int ENTRY_STATUS_UNASSIGNED = 1;
    private byte[] entryStatus = null;
    private byte[] initialEntryStatus = null;
    private TIntStack parents = new TIntStack();
    private TIntStack parentsEntry = new TIntStack();
    private int treeHeight = 1;
    private int rootNodeId = 0;
    private int size = 0;
    private int highestUsedNodeId = this.rootNodeId;
    private TIntStack deletedNodeIds = new TIntStack();
    private TIntArrayList nearestIds = new TIntArrayList();
    private TIntProcedureVisit visitProc = new TIntProcedureVisit();
    private Rectangle oldRectangle = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);

    public void init(Properties props) {
        this.maxNodeEntries = Integer.parseInt(props.getProperty("MaxNodeEntries", "0"));
        this.minNodeEntries = Integer.parseInt(props.getProperty("MinNodeEntries", "0"));
        if (this.maxNodeEntries < 2) {
            this.maxNodeEntries = 10;
        }
        if (this.minNodeEntries < 1 || this.minNodeEntries > this.maxNodeEntries / 2) {
            this.minNodeEntries = this.maxNodeEntries / 2;
        }
        this.entryStatus = new byte[this.maxNodeEntries];
        this.initialEntryStatus = new byte[this.maxNodeEntries];
        int i = 0;
        while (i < this.maxNodeEntries) {
            this.initialEntryStatus[i] = 1;
            ++i;
        }
        Node root = new Node(this.rootNodeId, 1, this.maxNodeEntries);
        this.nodeMap.put(this.rootNodeId, (Object)root);
    }

    public void add(Rectangle r, int id) {
        this.add(r.copy(), id, 1);
        ++this.size;
    }

    private void add(Rectangle r, int id, int level) {
        Node n = this.chooseNode(r, level);
        Node newLeaf = null;
        if (n.entryCount < this.maxNodeEntries) {
            n.addEntryNoCopy(r, id);
        } else {
            newLeaf = this.splitNode(n, r, id);
        }
        Node newNode = this.adjustTree(n, newLeaf);
        if (newNode != null) {
            int oldRootNodeId = this.rootNodeId;
            Node oldRoot = this.getNode(oldRootNodeId);
            this.rootNodeId = this.getNextNodeId();
            ++this.treeHeight;
            Node root = new Node(this.rootNodeId, this.treeHeight, this.maxNodeEntries);
            root.addEntry(newNode.mbr, newNode.nodeId);
            root.addEntry(oldRoot.mbr, oldRoot.nodeId);
            this.nodeMap.put(this.rootNodeId, (Object)root);
        }
    }

    public boolean delete(Rectangle r, int id) {
        this.parents.clear();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.clear();
        this.parentsEntry.push(-1);
        Node n = null;
        int foundIndex = -1;
        while (foundIndex == -1 && this.parents.size() > 0) {
            n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                boolean contains = false;
                int i = startIndex;
                while (i < n.entryCount) {
                    if (n.entries[i].contains(r)) {
                        this.parents.push(n.ids[i]);
                        this.parentsEntry.pop();
                        this.parentsEntry.push(i);
                        this.parentsEntry.push(-1);
                        contains = true;
                        break;
                    }
                    ++i;
                }
                if (contains) {
                    continue;
                }
            } else {
                foundIndex = n.findEntry(r, id);
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
        if (foundIndex != -1) {
            n.deleteEntry(foundIndex, this.minNodeEntries);
            --this.size;
        }
        return foundIndex != -1;
    }

    public void nearest(Point p, IntProcedure v, float furthestDistance) {
        Node rootNode = this.getNode(this.rootNodeId);
        this.nearest(p, rootNode, furthestDistance);
        this.visitProc.setProcedure(v);
        this.nearestIds.forEach((TIntProcedure)this.visitProc);
        this.nearestIds.clear();
    }

    public void intersects(Rectangle r, IntProcedure v) {
        Node rootNode = this.getNode(this.rootNodeId);
        this.intersects(r, v, rootNode);
    }

    void iterate(Node n, IntProcedure v) {
        int i = 0;
        while (i < n.entryCount) {
            if (n.isLeaf()) {
                v.execute(n.ids[i]);
            } else {
                Node childNode = this.getNode(n.ids[i]);
                this.iterate(childNode, v);
            }
            ++i;
        }
    }

    public Iterator iterator() {
        final ArrayList list = new ArrayList();
        Node rootNode = this.getNode(this.rootNodeId);
        this.iterate(rootNode, new IntProcedure(){

            public boolean execute(int id) {
                list.add(new Integer(id));
                return true;
            }
        });
        return list.iterator();
    }

    public void contains(Rectangle r, IntProcedure v) {
        this.parents.clear();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.clear();
        this.parentsEntry.push(-1);
        while (this.parents.size() > 0) {
            Node n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                boolean intersects = false;
                int i = startIndex;
                while (i < n.entryCount) {
                    if (r.intersects(n.entries[i])) {
                        this.parents.push(n.ids[i]);
                        this.parentsEntry.pop();
                        this.parentsEntry.push(i);
                        this.parentsEntry.push(-1);
                        intersects = true;
                        break;
                    }
                    ++i;
                }
                if (intersects) {
                    continue;
                }
            } else {
                int i = 0;
                while (i < n.entryCount) {
                    if (r.contains(n.entries[i])) {
                        v.execute(n.ids[i]);
                    }
                    ++i;
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
    }

    public int size() {
        return this.size;
    }

    public Rectangle getBounds() {
        Rectangle bounds = null;
        Node n = this.getNode(this.getRootNodeId());
        if (n != null && n.getMBR() != null) {
            bounds = n.getMBR().copy();
        }
        return bounds;
    }

    public String getVersion() {
        return "RTree-1.0b2";
    }

    private int getNextNodeId() {
        int nextNodeId = 0;
        nextNodeId = this.deletedNodeIds.size() > 0 ? this.deletedNodeIds.pop() : 1 + this.highestUsedNodeId++;
        return nextNodeId;
    }

    public Node getNode(int index) {
        return (Node)this.nodeMap.get(index);
    }

    public int getHighestUsedNodeId() {
        return this.highestUsedNodeId;
    }

    public int getRootNodeId() {
        return this.rootNodeId;
    }

    private Node splitNode(Node n, Rectangle newRect, int newId) {
        float initialArea = 0.0f;
        Rectangle union = n.mbr.union(newRect);
        initialArea = union.area();
        System.arraycopy(this.initialEntryStatus, 0, this.entryStatus, 0, this.maxNodeEntries);
        Node newNode = null;
        newNode = new Node(this.getNextNodeId(), n.level, this.maxNodeEntries);
        this.nodeMap.put(newNode.nodeId, (Object)newNode);
        this.pickSeeds(n, newRect, newId, newNode);
        while (n.entryCount + newNode.entryCount < this.maxNodeEntries + 1) {
            if (this.maxNodeEntries + 1 - newNode.entryCount == this.minNodeEntries) {
                int i = 0;
                while (i < this.maxNodeEntries) {
                    if (this.entryStatus[i] == 1) {
                        this.entryStatus[i] = 0;
                        n.mbr.add(n.entries[i]);
                        ++n.entryCount;
                    }
                    ++i;
                }
                break;
            }
            if (this.maxNodeEntries + 1 - n.entryCount == this.minNodeEntries) {
                int i = 0;
                while (i < this.maxNodeEntries) {
                    if (this.entryStatus[i] == 1) {
                        this.entryStatus[i] = 0;
                        newNode.addEntryNoCopy(n.entries[i], n.ids[i]);
                        n.entries[i] = null;
                    }
                    ++i;
                }
                break;
            }
            this.pickNext(n, newNode);
        }
        n.reorganize(this);
        return newNode;
    }

    private void pickSeeds(Node n, Rectangle newRect, int newId, Node newNode) {
        float maxNormalizedSeparation = 0.0f;
        int highestLowIndex = 0;
        int lowestHighIndex = 0;
        n.mbr.add(newRect);
        int d = 0;
        while (d < 2) {
            float tempHighestLow = newRect.min[d];
            int tempHighestLowIndex = -1;
            float tempLowestHigh = newRect.max[d];
            int tempLowestHighIndex = -1;
            int i = 0;
            while (i < n.entryCount) {
                float tempLow = n.entries[i].min[d];
                if (tempLow >= tempHighestLow) {
                    tempHighestLow = tempLow;
                    tempHighestLowIndex = i;
                } else {
                    float tempHigh = n.entries[i].max[d];
                    if (tempHigh <= tempLowestHigh) {
                        tempLowestHigh = tempHigh;
                        tempLowestHighIndex = i;
                    }
                }
                float normalizedSeparation = (tempHighestLow - tempLowestHigh) / (n.mbr.max[d] - n.mbr.min[d]);
                if (normalizedSeparation > maxNormalizedSeparation) {
                    maxNormalizedSeparation = normalizedSeparation;
                    highestLowIndex = tempHighestLowIndex;
                    lowestHighIndex = tempLowestHighIndex;
                }
                ++i;
            }
            ++d;
        }
        if (highestLowIndex == -1) {
            newNode.addEntry(newRect, newId);
        } else {
            newNode.addEntryNoCopy(n.entries[highestLowIndex], n.ids[highestLowIndex]);
            n.entries[highestLowIndex] = null;
            n.entries[highestLowIndex] = newRect;
            n.ids[highestLowIndex] = newId;
        }
        if (lowestHighIndex == -1) {
            lowestHighIndex = highestLowIndex;
        }
        this.entryStatus[lowestHighIndex] = 0;
        n.entryCount = 1;
        n.mbr.set(n.entries[lowestHighIndex].min, n.entries[lowestHighIndex].max);
    }

    private int pickNext(Node n, Node newNode) {
        float maxDifference = Float.NEGATIVE_INFINITY;
        int next = 0;
        boolean nextGroup = false;
        maxDifference = Float.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.maxNodeEntries) {
            float newNodeIncrease;
            float nIncrease;
            float difference;
            if (this.entryStatus[i] == 1 && (difference = Math.abs((nIncrease = n.mbr.enlargement(n.entries[i])) - (newNodeIncrease = newNode.mbr.enlargement(n.entries[i])))) > maxDifference) {
                next = i;
                nextGroup = nIncrease < newNodeIncrease ? false : (newNodeIncrease < nIncrease ? true : (n.mbr.area() < newNode.mbr.area() ? false : (newNode.mbr.area() < n.mbr.area() ? true : newNode.entryCount >= this.maxNodeEntries / 2)));
                maxDifference = difference;
            }
            ++i;
        }
        this.entryStatus[next] = 0;
        if (!nextGroup) {
            n.mbr.add(n.entries[next]);
            ++n.entryCount;
        } else {
            newNode.addEntryNoCopy(n.entries[next], n.ids[next]);
            n.entries[next] = null;
        }
        return next;
    }

    public Collection nearest(final Point p, int numberOfNearest) {
        ArrayList<Integer> solution = new ArrayList<Integer>();
        Node rootNode = this.getNode(this.rootNodeId);
        Stack<Node> stack = new Stack<Node>();
        TreeSet<RectangleWithId> set = new TreeSet<RectangleWithId>(new Comparator(){

            public int compare(Object o1, Object o2) {
                float t2;
                if (!(o1 instanceof RectangleWithId)) {
                    return -1;
                }
                if (!(o2 instanceof RectangleWithId)) {
                    return 1;
                }
                RectangleWithId r1 = (RectangleWithId)o1;
                RectangleWithId r2 = (RectangleWithId)o2;
                float t1 = r1.r.distance(p);
                if (t1 > (t2 = r2.r.distance(p))) {
                    return 1;
                }
                if (t1 == t2) {
                    return 0;
                }
                return -1;
            }
        });
        stack.push(rootNode);
        while (stack.size() > 0) {
            Node n = (Node)stack.pop();
            int i = 0;
            while (i < n.entryCount) {
                if (n.isLeaf()) {
                    set.add(new RectangleWithId(n.entries[i], n.ids[i]));
                } else {
                    stack.push(this.getNode(n.ids[i]));
                }
                ++i;
            }
        }
        Iterator it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            RectangleWithId rid = (RectangleWithId)it.next();
            solution.add(new Integer(rid.id));
            if (++count >= numberOfNearest) break;
        }
        return solution;
    }

    public Collection nearest(final Rectangle r, int numberOfNearest) {
        ArrayList<Integer> solution = new ArrayList<Integer>();
        Node rootNode = this.getNode(this.rootNodeId);
        Stack<Node> stack = new Stack<Node>();
        TreeSet<RectangleWithId> set = new TreeSet<RectangleWithId>(new Comparator(){

            public int compare(Object o1, Object o2) {
                float t2;
                if (!(o1 instanceof RectangleWithId)) {
                    return -1;
                }
                if (!(o2 instanceof RectangleWithId)) {
                    return 1;
                }
                RectangleWithId r1 = (RectangleWithId)o1;
                RectangleWithId r2 = (RectangleWithId)o2;
                float t1 = r1.r.distance(r);
                if (t1 > (t2 = r2.r.distance(r))) {
                    return 1;
                }
                if (t1 == t2) {
                    return 0;
                }
                return -1;
            }
        });
        stack.push(rootNode);
        while (stack.size() > 0) {
            Node n = (Node)stack.pop();
            int i = 0;
            while (i < n.entryCount) {
                if (n.isLeaf()) {
                    set.add(new RectangleWithId(n.entries[i], n.ids[i]));
                } else {
                    stack.push(this.getNode(n.ids[i]));
                }
                ++i;
            }
        }
        Iterator it = set.iterator();
        int count = 0;
        while (it.hasNext()) {
            RectangleWithId rid = (RectangleWithId)it.next();
            solution.add(new Integer(rid.id));
            if (++count >= numberOfNearest) break;
        }
        return solution;
    }

    private float nearest(Point p, Node n, float nearestDistance) {
        int i = 0;
        while (i < n.entryCount) {
            float tempDistance = n.entries[i].distance(p);
            if (n.isLeaf()) {
                if (tempDistance < nearestDistance) {
                    nearestDistance = tempDistance;
                    this.nearestIds.clear();
                }
                if (tempDistance <= nearestDistance) {
                    this.nearestIds.add(n.ids[i]);
                }
            } else if (tempDistance <= nearestDistance) {
                nearestDistance = this.nearest(p, this.getNode(n.ids[i]), nearestDistance);
            }
            ++i;
        }
        return nearestDistance;
    }

    public void nearest(Rectangle r, IntProcedure v, float furthestDistance) {
        Node rootNode = this.getNode(this.rootNodeId);
        this.nearest(r, rootNode, furthestDistance);
        this.visitProc.setProcedure(v);
        this.nearestIds.forEach((TIntProcedure)this.visitProc);
        this.nearestIds.clear();
    }

    private float nearest(Rectangle r, Node n, float nearestDistance) {
        int i = 0;
        while (i < n.entryCount) {
            float tempDistance = n.entries[i].distance(r);
            if (n.isLeaf()) {
                if (tempDistance < nearestDistance) {
                    nearestDistance = tempDistance;
                    this.nearestIds.clear();
                }
                if (tempDistance <= nearestDistance) {
                    this.nearestIds.add(n.ids[i]);
                }
            } else if (tempDistance <= nearestDistance) {
                nearestDistance = this.nearest(r, this.getNode(n.ids[i]), nearestDistance);
            }
            ++i;
        }
        return nearestDistance;
    }

    private void intersects(Rectangle r, IntProcedure v, Node n) {
        int i = 0;
        while (i < n.entryCount) {
            if (r.intersects(n.entries[i])) {
                if (n.isLeaf()) {
                    v.execute(n.ids[i]);
                } else {
                    Node childNode = this.getNode(n.ids[i]);
                    this.intersects(r, v, childNode);
                }
            }
            ++i;
        }
    }

    private void condenseTree(Node l) {
        Node n = l;
        Node parent = null;
        int parentEntry = 0;
        TIntStack eliminatedNodeIds = new TIntStack();
        while (n.level != this.treeHeight) {
            parent = this.getNode(this.parents.pop());
            parentEntry = this.parentsEntry.pop();
            if (n.entryCount < this.minNodeEntries) {
                parent.deleteEntry(parentEntry, this.minNodeEntries);
                eliminatedNodeIds.push(n.nodeId);
            } else if (!n.mbr.equals(parent.entries[parentEntry])) {
                this.oldRectangle.set(parent.entries[parentEntry].min, parent.entries[parentEntry].max);
                parent.entries[parentEntry].set(n.mbr.min, n.mbr.max);
                parent.recalculateMBR(this.oldRectangle);
            }
            n = parent;
        }
        while (eliminatedNodeIds.size() > 0) {
            Node e = this.getNode(eliminatedNodeIds.pop());
            int j = 0;
            while (j < e.entryCount) {
                this.add(e.entries[j], e.ids[j], e.level);
                e.entries[j] = null;
                ++j;
            }
            e.entryCount = 0;
            this.deletedNodeIds.push(e.nodeId);
        }
    }

    private Node chooseNode(Rectangle r, int level) {
        Node n = this.getNode(this.rootNodeId);
        this.parents.clear();
        this.parentsEntry.clear();
        while (n.level != level) {
            Rectangle n0 = n.getEntry(0);
            float leastEnlargement = Float.MAX_VALUE;
            if (n0 != null) {
                leastEnlargement = n0.enlargement(r);
            } else {
                System.out.println("El nodo " + n.nodeId + " no tiene entradas");
            }
            int index = 0;
            int i = 1;
            while (i < n.entryCount) {
                Rectangle tempRectangle = n.getEntry(i);
                float tempEnlargement = tempRectangle.enlargement(r);
                if (tempEnlargement < leastEnlargement || tempEnlargement == leastEnlargement && tempRectangle.area() < n.getEntry(index).area()) {
                    index = i;
                    leastEnlargement = tempEnlargement;
                }
                ++i;
            }
            this.parents.push(n.nodeId);
            this.parentsEntry.push(index);
            n = this.getNode(n.ids[index]);
        }
        return n;
    }

    private Node adjustTree(Node n, Node nn) {
        while (n.level != this.treeHeight) {
            Node parent = this.getNode(this.parents.pop());
            int entry = this.parentsEntry.pop();
            if (!parent.entries[entry].equals(n.mbr)) {
                parent.entries[entry].set(n.mbr.min, n.mbr.max);
                parent.mbr.set(parent.entries[0].min, parent.entries[0].max);
                int i = 1;
                while (i < parent.entryCount) {
                    parent.mbr.add(parent.entries[i]);
                    ++i;
                }
            }
            Node newNode = null;
            if (nn != null) {
                if (parent.entryCount < this.maxNodeEntries) {
                    parent.addEntry(nn.mbr, nn.nodeId);
                } else {
                    newNode = this.splitNode(parent, nn.mbr.copy(), nn.nodeId);
                }
            }
            n = parent;
            nn = newNode;
            parent = null;
            newNode = null;
        }
        return nn;
    }

    private void checkConsistency(int nodeId, int expectedLevel, Rectangle expectedMBR) {
        Node n = this.getNode(nodeId);
        Rectangle calculatedMBR = this.calculateMBR(n);
        int i = 0;
        while (i < n.entryCount) {
            if (n.level > 1) {
                this.checkConsistency(n.ids[i], n.level - 1, n.entries[i]);
            }
            ++i;
        }
    }

    private Rectangle calculateMBR(Node n) {
        Rectangle mbr = new Rectangle(n.entries[0].min, n.entries[0].max);
        int i = 1;
        while (i < n.entryCount) {
            mbr.add(n.entries[i]);
            ++i;
        }
        return mbr;
    }

    private class TIntProcedureVisit
    implements TIntProcedure {
        public IntProcedure m_intProcedure = null;

        private TIntProcedureVisit() {
        }

        public void setProcedure(IntProcedure ip) {
            this.m_intProcedure = ip;
        }

        public boolean execute(int i) {
            this.m_intProcedure.execute(i);
            return true;
        }
    }

    class RectangleWithId {
        Rectangle r;
        int id;

        RectangleWithId(Rectangle r, int id) {
            this.r = r;
            this.id = id;
        }
    }
}

