/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.index.Data;
import org.geotools.index.DataDefinition;
import org.geotools.index.TreeException;
import org.geotools.index.quadtree.Node;
import org.geotools.index.quadtree.StoreException;

public class LazySearchIterator
implements Iterator {
    static final DataDefinition DATA_DEFINITION = new DataDefinition("US-ASCII");
    private static final int MAX_INDICES = 32768;
    Data next = null;
    Node current;
    int idIndex = 0;
    private boolean closed;
    private Envelope bounds;
    Iterator data;
    private Node root;

    static {
        DATA_DEFINITION.addField(Integer.class);
        DATA_DEFINITION.addField(Long.class);
    }

    public LazySearchIterator(Node root, Envelope bounds) {
        this.current = root;
        this.root = root;
        this.bounds = bounds;
        this.closed = false;
        this.next = null;
    }

    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Iterator has been closed!");
        }
        if (this.next != null) {
            return true;
        }
        if (this.data != null && this.data.hasNext()) {
            this.next = (Data)this.data.next();
        } else {
            this.fillCache();
            if (this.data != null && this.data.hasNext()) {
                this.next = (Data)this.data.next();
            }
        }
        return this.next != null;
    }

    private void fillCache() {
        ArrayList<Integer> indices = new ArrayList<Integer>(32768);
        ArrayList<Data> dataList = new ArrayList<Data>(32768);
        try {
            while (indices.size() < 32768 && this.current != null) {
                if (this.idIndex < this.current.getNumShapeIds() && !this.current.isVisited() && this.current.getBounds().intersects(this.bounds)) {
                    indices.add(new Integer(this.current.getShapeId(this.idIndex)));
                    ++this.idIndex;
                    continue;
                }
                this.current.setShapesId(new int[0]);
                this.idIndex = 0;
                boolean foundUnvisited = false;
                int i = 0;
                while (i < this.current.getNumSubNodes()) {
                    Node node = this.current.getSubNode(i);
                    if (!node.isVisited() && node.getBounds().intersects(this.bounds)) {
                        foundUnvisited = true;
                        this.current = node;
                        break;
                    }
                    ++i;
                }
                if (foundUnvisited) continue;
                this.current.setVisited(true);
                this.current = this.current.getParent();
            }
            Collections.sort(indices);
            for (Integer recno : indices) {
                Data data = new Data(DATA_DEFINITION);
                data.addValue(new Integer(recno + 1));
                dataList.add(data);
            }
        }
        catch (TreeException e) {
            throw new RuntimeException(e);
        }
        catch (StoreException e) {
            throw new RuntimeException(e);
        }
        this.data = dataList.iterator();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        Data temp = this.next;
        this.next = null;
        return temp;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws StoreException {
        this.closed = true;
    }
}

