/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.metadata.swing.basic.impl;

import java.awt.BorderLayout;
import javax.swing.JLabel;
import org.gvsig.metadata.Metadata;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.metadata.swing.basic.api.AbstractSimpleMetadataPanel;
import org.gvsig.metadata.swing.basic.api.JMetadataPanel;
import org.gvsig.metadata.swing.basic.api.MetadataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.DynFormManager;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynObjectValidateException;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicJMetadataPanel
extends JMetadataPanel {
    private static final Logger logger = LoggerFactory.getLogger(BasicJMetadataPanel.class);
    private static final long serialVersionUID = 6514865354393558940L;
    private JLabel lblName;
    private MetadataManager manager;
    private JDynForm dynform;
    private I18nManager i18nManager;

    public BasicJMetadataPanel(MetadataSwingManager uiManager, Metadata metadata, boolean editable) {
        super(uiManager, metadata, editable);
    }

    protected void initManagers() {
        this.manager = MetadataLocator.getMetadataManager();
        this.i18nManager = ToolsLocator.getI18nManager();
    }

    protected void initData() {
        String metadataName = "";
        if (!this.hasMetadata()) {
            return;
        }
        try {
            metadataName = this.getMetadata().getMetadataName();
            this.lblName.setText(this.i18nManager.getTranslation("_{0}_metadata", new String[]{this.i18nManager.getTranslation(metadataName)}));
        }
        catch (MetadataException e) {
            logger.warn("Can't init panel data", (Throwable)e);
        }
    }

    protected void initUI() {
        this.setLayout(new BorderLayout());
        this.lblName = new JLabel();
        this.add(this.lblName, "North");
    }

    public void saveMetadata() throws DynObjectValidateException {
        try {
            this.dynform.getValues((DynObject)this.getMetadata());
            this.getMetadata().getDynClass().validate((DynObject)this.getMetadata());
            this.manager.storeMetadata(this.getMetadata());
        }
        catch (MetadataException e) {
            logger.warn("Can't save metadata", (Throwable)e);
        }
    }

    protected AbstractSimpleMetadataPanel createMetadataComponent(Metadata metadata, boolean refresh) {
        if (metadata == null) {
            metadata = this.getMetadata();
        }
        DynFormManager dynformmgr = DynFormLocator.getDynFormManager();
        if (this.dynform == null) {
            this.dynform = dynformmgr.createJDynForm((DynObject)metadata);
        } else {
            this.dynform.setValues((DynObject)metadata);
        }
        this.add(this.dynform.asJComponent());
        this.updateUI();
        return this;
    }
}

