/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.metadata.swing.basic.impl;

import org.gvsig.metadata.Metadata;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.metadata.swing.basic.api.JMetadataPanel;
import org.gvsig.metadata.swing.basic.api.MetadataSwingManager;
import org.gvsig.metadata.swing.basic.impl.BasicJMetadataPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.usability.UsabilitySwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicMetadataSwingManager
implements MetadataSwingManager {
    private static final Logger logger = LoggerFactory.getLogger(BasicMetadataSwingManager.class);
    private I18nManager i18nManager = ToolsLocator.getI18nManager();

    public String translate(String message) {
        if (message != null) {
            return this.i18nManager.getTranslation(message);
        }
        return "";
    }

    public MetadataManager getManager() {
        return MetadataLocator.getMetadataManager();
    }

    public JMetadataPanel createJMetadataPanel(Metadata metadata, boolean editable) {
        try {
            this.getManager().loadMetadata(metadata);
        }
        catch (MetadataException e) {
            logger.warn("Can't load metadata", (Throwable)e);
        }
        BasicJMetadataPanel panel = new BasicJMetadataPanel(this, metadata, editable);
        panel.setMetadata(metadata);
        return panel;
    }

    public JMetadataPanel createJMetadataPanel(Metadata metadata) {
        return this.createJMetadataPanel(metadata, true);
    }

    public UsabilitySwingManager getUIBuilder() {
        return ToolsSwingLocator.getUsabilitySwingManager();
    }
}

