/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.selectiontools.app.extension.tools.behavior;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.tools.Behavior.CircleBehavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AbstractCircleListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.CircleListener;

public class CircleSelectionBehavior
extends CircleBehavior {
    private CircleListener listener;
    private Point2D m_PointAnt;

    public CircleSelectionBehavior(AbstractCircleListener zili) {
        super(zili);
        this.listener = zili;
    }

    public void paintComponent(Graphics g) {
        g.setColor(Color.black);
        g.setXORMode(Color.white);
        if (this.m_FirstPoint != null && this.m_LastPoint != null) {
            double radio = this.m_LastPoint.distance(this.m_FirstPoint);
            Arc2D.Double arc = new Arc2D.Double(this.m_FirstPoint.getX() - radio, this.m_FirstPoint.getY() - radio, 2.0 * radio, 2.0 * radio, 0.0, 360.0, 0);
            ((Graphics2D)g).draw(arc);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isMyButton(e)) {
            return;
        }
        Point pScreen = e.getPoint();
        this.m_PointAnt = pScreen;
        if (!this.isClicked && e.getButton() == 1) {
            this.m_FirstPoint = this.m_PointAnt = pScreen;
            this.isClicked = true;
        }
        if (this.listener.cancelDrawing()) {
            this.getMapControl().cancelDrawing();
            this.isClicked = false;
        }
        this.getMapControl().repaint();
    }

    public void mouseReleased(MouseEvent e) throws BehaviorException {
        if (!this.isMyButton(e)) {
            return;
        }
        if (this.m_FirstPoint == null || this.m_LastPoint == null) {
            return;
        }
        Point pScreen = e.getPoint();
        ViewPort vp = this.getMapControl().getMapContext().getViewPort();
        Point2D p1 = vp.toMapPoint(this.m_FirstPoint);
        Point2D p2 = vp.toMapPoint((Point2D)pScreen);
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(p1, p2);
        Rectangle rectPixel = new Rectangle();
        rectPixel.setFrameFromDiagonal(this.m_FirstPoint, pScreen);
        Double[] x = new Double[2];
        Double[] y = new Double[2];
        x[0] = p1.getX();
        x[1] = p2.getX();
        y[0] = p1.getY();
        y[1] = p2.getY();
        MeasureEvent event = new MeasureEvent(x, y, e);
        this.listener.circle(event);
        this.getMapControl().repaint();
        this.m_FirstPoint = null;
        this.m_LastPoint = null;
        this.isClicked = false;
    }

    public void mouseDragged(MouseEvent e) throws BehaviorException {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) throws BehaviorException {
        if (!this.isClicked) {
            return;
        }
        this.m_LastPoint = e.getPoint();
        if (this.m_FirstPoint == null) {
            return;
        }
        Point pScreen = e.getPoint();
        ViewPort vp = this.getMapControl().getMapContext().getViewPort();
        Point2D p1 = vp.toMapPoint(this.m_FirstPoint);
        Point2D p2 = vp.toMapPoint((Point2D)pScreen);
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(p1, p2);
        Rectangle rectPixel = new Rectangle();
        rectPixel.setFrameFromDiagonal(this.m_FirstPoint, pScreen);
        Double[] x = new Double[2];
        Double[] y = new Double[2];
        x[0] = p1.getX();
        x[1] = p2.getX();
        y[0] = p1.getY();
        y[1] = p2.getY();
        MeasureEvent event = new MeasureEvent(x, y, e);
        this.listener.circle(event);
        this.getMapControl().repaint();
    }
}

