/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.impl;

import org.cresques.cts.ICoordTrans;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.spi.ExportServiceManager;
import org.gvsig.fmap.geom.Geometry;

public class ExportGeometryUtils {
    public static ExportServiceManager.FixGeometryStatus fixGeometry(ExportParametersGeometry options, ICoordTrans coord_trans, Geometry geometry) {
        DefaultFixGeometryStatus status;
        if (geometry == null) {
            return new DefaultFixGeometryStatus(geometry);
        }
        block0 : switch (options.getGeometryChecks()) {
            case 1: {
                Geometry.ValidationStatus geometryCheck = geometry.getValidationStatus();
                if (geometryCheck.isValid()) {
                    status = new DefaultFixGeometryStatus(geometry);
                    break;
                }
                switch (options.getGeometryChecksAction()) {
                    case 0: {
                        status = new DefaultFixGeometryStatus(null);
                        break block0;
                    }
                    case 1: {
                        status = new DefaultFixGeometryStatus(1, geometryCheck.getMessage());
                        break block0;
                    }
                }
                status = new DefaultFixGeometryStatus(2, geometryCheck.getMessage());
                break;
            }
            case 2: {
                Geometry g;
                Geometry.ValidationStatus geometryCheck = geometry.getValidationStatus();
                if (geometryCheck.isValid()) {
                    status = new DefaultFixGeometryStatus(geometry);
                    break;
                }
                if (options.getTryToFixGeometry() && (g = geometry.makeValid()) != null) {
                    status = new DefaultFixGeometryStatus(g);
                    break;
                }
                switch (options.getGeometryChecksAction()) {
                    case 0: {
                        status = new DefaultFixGeometryStatus(null);
                        break block0;
                    }
                    case 1: {
                        status = new DefaultFixGeometryStatus(1, geometryCheck.getMessage());
                        break block0;
                    }
                }
                status = new DefaultFixGeometryStatus(2, geometryCheck.getMessage());
                break;
            }
            default: {
                status = new DefaultFixGeometryStatus(geometry);
            }
        }
        if (coord_trans != null && status.getState() == 0 && status.getGeometry() != null) {
            Geometry reproj_geom = status.getGeometry().cloneGeometry();
            reproj_geom.reProject(coord_trans);
            status.setGeometry(reproj_geom);
        }
        return status;
    }

    public static class DefaultFixGeometryStatus
    implements ExportServiceManager.FixGeometryStatus {
        private Geometry geometry;
        private final int state;
        private String message;

        public DefaultFixGeometryStatus(Geometry geometry, int state) {
            this.geometry = geometry;
            this.state = state;
        }

        public DefaultFixGeometryStatus(Geometry geometry) {
            this.geometry = geometry;
            this.state = 0;
        }

        public DefaultFixGeometryStatus(int state) {
            this.geometry = null;
            this.state = state;
        }

        public DefaultFixGeometryStatus(int state, String message) {
            this.geometry = null;
            this.state = state;
            this.message = message;
        }

        private void setGeometry(Geometry geometry) {
            this.geometry = geometry;
        }

        public Geometry getGeometry() {
            return this.geometry;
        }

        public int getState() {
            return this.state;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

