/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.date;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.ToolsLocator;

public class ToDateFunction
extends AbstractFunction {
    public ToDateFunction() {
        super("Date", "TO_DATE", Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3)), "Returns a date from the arguments", "TO_DATE({{date}}, format)", new String[]{"date - a string with a date", "format - Format to use to parse the date"}, "Date", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object date_obj = this.getObject(args, 0);
        String date = this.getStr(args, 0);
        String format = this.getStr(args, 1);
        try {
            if (date_obj instanceof Date) {
                java.sql.Date x = new java.sql.Date(((Date)date_obj).getTime());
                return x;
            }
            Locale locale = Locale.getDefault();
            if (args.length == 3) {
                locale = (Locale)ToolsLocator.getDataTypesManager().get(20).coerce((Object)this.getStr(args, 2));
            }
            SimpleDateFormat df = new SimpleDateFormat(format, locale);
            Date x = df.parse(date);
            java.sql.Date x2 = new java.sql.Date(x.getTime());
            return x2;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't parse date value '" + date + "' with format '" + format == null ? "" : format + "'", ex);
        }
    }
}

