/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.numeric;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class CoshFunction
extends AbstractFunction {
    public CoshFunction() {
        super("Numeric", "COSH", Range.is((Comparable)Integer.valueOf(1)), "Returns the hyperbolic cosine of a double value. The hyperbolic cosine of x is defined to be (ex + e-x)/2 where e is Euler's number.\nSpecial cases:\n- If the argument is NaN, then the result is NaN.\n- If the argument is infinite, then the result is positive infinity.\n- If the argument is zero, then the result is 1.0. \nThe computed result must be within 2.5 ulps of the exact result.", "COSH({{x}})", new String[]{"x - The number whose hyperbolic cosine is to be returned."}, "Double", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        double r = Math.cosh(this.getDouble(args, 0));
        return r;
    }
}

