/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.operator;

import org.apache.commons.math.util.MathUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.operator.AbstractBinaryOperator;

public class LtOperator
extends AbstractBinaryOperator {
    public LtOperator() {
        super("Boolean", "<", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    @Override
    public Object call(Interpreter interpreter, Object op1, Object op2) {
        if (op1 == null || op2 == null) {
            return null;
        }
        int type = this.getType(op1, op2);
        if ((type & 0x80) == 128) {
            return false;
        }
        if ((type & 0x100) == 256) {
            boolean value = this.getBigDecimal(op1, 1).compareTo(this.getBigDecimal(op2, 2)) < 0;
            return value;
        }
        if ((type & 8) == 8) {
            double accuracy = 1.110223E-16f;
            if (interpreter.getAccuracy() != null) {
                accuracy = interpreter.getAccuracy();
            }
            boolean value = MathUtils.compareTo((double)this.getDouble(op1, 1), (double)this.getDouble(op2, 2), (double)accuracy) < 0;
            return value;
        }
        if ((type & 4) == 4) {
            double accuracy = 1.110223E-16f;
            if (interpreter.getAccuracy() != null) {
                accuracy = interpreter.getAccuracy();
            }
            boolean value = MathUtils.compareTo((double)this.getFloat(op1, 1), (double)this.getFloat(op2, 2), (double)accuracy) < 0;
            return value;
        }
        if ((type & 2) == 2) {
            boolean value = Long.compare(this.getLong(op1, 1), this.getLong(op2, 2)) < 0;
            return value;
        }
        if ((type & 1) == 1) {
            boolean value = Integer.compare(this.getInt(op1, 1), this.getInt(op2, 2)) < 0;
            return value;
        }
        if (op2 instanceof Comparable && op2 instanceof Comparable) {
            boolean value = this.getComparable(op1, 1).compareTo(this.getComparable(op2, 2)) < 0;
            return value;
        }
        throw new IllegalArgumentException("Types not allowed in '" + this.name() + "' operand.");
    }
}

