/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.predicate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.function.operator.AbstractBinaryOperator;

public class LikeOperator
extends AbstractBinaryOperator {
    protected static final Integer ZERO_OR_MORE_CHARS = 0;
    protected static final Integer ONE_CHAR = 1;
    protected static Map<String, Pattern> patterns = new HashMap<String, Pattern>();
    private static final String REGEXP_CHARS_TO_ESCAPE = "|.?*()[]{}&\\";

    public LikeOperator() {
        super("String", "LIKE", true);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    @Override
    public Object call(Interpreter interpreter, Object op1, Object op2) {
        boolean top2 = op2 instanceof CharSequence;
        boolean top1 = op1 instanceof CharSequence;
        if (top1 && top2) {
            boolean value = LikeOperator.like(((CharSequence)op1).toString(), ((CharSequence)op2).toString());
            return value;
        }
        if (op1 == null && op2 == null) {
            return null;
        }
        if (op1 == null && top2) {
            return null;
        }
        if (op2 == null && top1) {
            return null;
        }
        throw new IllegalArgumentException("Types not allowed in '" + this.name() + "' operand.");
    }

    public static boolean like(String source, String match) {
        Pattern pattern = patterns.get(match);
        if (pattern == null) {
            if (patterns.size() > 20) {
                patterns = new HashMap<String, Pattern>();
            }
            List<Object> p = LikeOperator.compile(match);
            String regexp = LikeOperator.toRegExp(p);
            pattern = Pattern.compile(regexp);
            patterns.put(match, pattern);
        }
        Matcher m = pattern.matcher(source);
        return m.find();
    }

    protected static List<Object> compile(String pattern) {
        ArrayList<Object> format = new ArrayList<Object>();
        StringBuilder fill = new StringBuilder();
        int plen = pattern.length();
        Character lastSymbol = null;
        if (pattern.length() > 2 && pattern.charAt(0) == '/' && pattern.charAt(pattern.length() - 1) == '/') {
            format.add(pattern.substring(1, pattern.length() - 2));
        } else {
            for (int i = 0; i < plen; ++i) {
                boolean f = false;
                char c = pattern.charAt(i);
                if (lastSymbol != null && lastSymbol.charValue() == '\\') {
                    lastSymbol = null;
                    fill.append(c);
                    continue;
                }
                if (c == '%') {
                    if (fill.length() > 0) {
                        format.add(fill.toString());
                        fill.setLength(0);
                    }
                    format.add(ZERO_OR_MORE_CHARS);
                } else if (c == '_') {
                    if (fill.length() > 0) {
                        format.add(fill.toString());
                        fill.setLength(0);
                    }
                    format.add(ONE_CHAR);
                } else {
                    fill.append(c);
                }
                lastSymbol = Character.valueOf(c);
            }
            if (fill.length() > 0) {
                format.add(fill.toString());
            }
        }
        return format;
    }

    public static String toRegExp(List<Object> pattern) {
        if (pattern != null) {
            StringBuilder str = new StringBuilder("^");
            for (Object o : pattern) {
                if (o == ZERO_OR_MORE_CHARS) {
                    str.append(".*?");
                    continue;
                }
                if (o == ONE_CHAR) {
                    str.append(".?");
                    continue;
                }
                str.append(Pattern.quote((String)o));
            }
            return str.toString();
        }
        return null;
    }

    private static String escapeToRegexp(String s) {
        if (!StringUtils.containsAny((CharSequence)s, (CharSequence)REGEXP_CHARS_TO_ESCAPE)) {
            return s;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '[') {
                builder.append('\\');
                builder.append('[');
                continue;
            }
            if (ch == '\\') {
                builder.append('[');
                builder.append('\\');
                builder.append(']');
                continue;
            }
            if (StringUtils.contains((CharSequence)REGEXP_CHARS_TO_ESCAPE, (int)ch)) {
                builder.append('[');
                builder.append(ch);
                builder.append(']');
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }
}

