/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.symboltable;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.function.programming.CreateFnFunction;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.expressionevaluator.spi.AbstractSymbolTable;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmark;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;

public class BookmarksSymbolTable
extends AbstractSymbolTable
implements SymbolTable {
    static final String NAME = "Bookmarks";
    private static final String COMMENT_TYPE = "Type: ";
    private static final String COMMENT_TEMPLATE = "Template: ";
    private static final String COMMENT_PARAMETER = "Parameter: ";
    private static final String COMMENT_DESCRIPTION = "Description: ";

    public BookmarksSymbolTable(final String bookmarkGroup) {
        super("Bookmarks_" + bookmarkGroup);
        this.functions = new AbstractMap<String, Function>(){

            @Override
            public Set<Map.Entry<String, Function>> entrySet() {
                return new BookmarksFunctionsEntrySet(bookmarkGroup);
            }
        };
    }

    protected Map<String, Object> getVars() {
        return Collections.EMPTY_MAP;
    }

    private static void extractMetadata(AbstractFunction function, Code code) {
        try {
            String s;
            final MutableObject type = new MutableObject();
            final MutableObject template = new MutableObject();
            final ArrayList args = new ArrayList();
            final StringBuilder help = new StringBuilder();
            code.accept(new Visitor(){

                public void visit(Object obj) throws VisitCanceledException, BaseException {
                    Code code = (Code)obj;
                    if (code.code() == 2 && (((Code.Callable)code).name().equalsIgnoreCase("PASS") || ((Code.Callable)code).name().equalsIgnoreCase("COMMENT")) && ((Code.Callable)code).parameters().size() == 1 && ((Code)((Code.Callable)code).parameters().get(0)).code() == 0) {
                        String line = Objects.toString(((Code.Constant)((Code.Callable)code).parameters().get(0)).value(), null);
                        if (StringUtils.startsWithIgnoreCase((CharSequence)(line = line.trim()), (CharSequence)BookmarksSymbolTable.COMMENT_TYPE)) {
                            type.setValue((Object)line.substring(BookmarksSymbolTable.COMMENT_TYPE.length()));
                        } else if (StringUtils.startsWithIgnoreCase((CharSequence)line, (CharSequence)BookmarksSymbolTable.COMMENT_TEMPLATE)) {
                            template.setValue((Object)line.substring(BookmarksSymbolTable.COMMENT_TEMPLATE.length()));
                        } else if (StringUtils.startsWithIgnoreCase((CharSequence)line, (CharSequence)BookmarksSymbolTable.COMMENT_PARAMETER)) {
                            String s = line.substring(BookmarksSymbolTable.COMMENT_PARAMETER.length());
                            if (StringUtils.isNotBlank((CharSequence)s)) {
                                args.add(s);
                            }
                        } else if (StringUtils.startsWithIgnoreCase((CharSequence)line, (CharSequence)BookmarksSymbolTable.COMMENT_DESCRIPTION)) {
                            String s = line.substring(BookmarksSymbolTable.COMMENT_DESCRIPTION.length());
                            help.append(s);
                            help.append("\n");
                        }
                    }
                }
            });
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)type.getValue()))) {
                function.setReturnType((String)type.getValue());
            }
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)template.getValue()))) {
                function.setTemplate((String)template.getValue());
            }
            if (StringUtils.isNotBlank((CharSequence)(s = help.toString()))) {
                function.setDescription(s);
            }
            if (!args.isEmpty()) {
                function.setDescriptionArgs(args.toArray(new String[args.size()]));
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't extract metadata function from expresion.\n" + code.toString(), (Throwable)ex);
        }
    }

    private static AbstractFunction createFunction(String name, Expression exp) {
        Code code = exp.getCode();
        ArrayList<String> argNames = new ArrayList<String>();
        try {
            code.accept(o -> {
                Code.Callable c;
                if (((Code)o).code() == 2 && StringUtils.equalsIgnoreCase((CharSequence)(c = (Code.Callable)o).name(), (CharSequence)"VAR")) {
                    argNames.add(((Code.Identifier)c.parameters().get(0)).name());
                }
            });
        }
        catch (BaseException baseException) {
            // empty catch block
        }
        CreateFnFunction.UserFunction function = new CreateFnFunction.UserFunction(NAME, name, argNames, code, null, null);
        BookmarksSymbolTable.extractMetadata(function, code);
        return function;
    }

    private static List<String> getBookmarkNames(Bookmarks bookmarks) {
        ArrayList<String> fnbookmarks = new ArrayList<String>();
        for (Bookmark bookmark : bookmarks) {
            Object o;
            if (!StringUtils.startsWith((CharSequence)bookmark.getName(), (CharSequence)"$") || !((o = bookmark.getValue()) instanceof Expression)) continue;
            fnbookmarks.add(bookmark.getName());
        }
        return fnbookmarks;
    }

    private static class BookmarksFunctionsEntrySet
    extends AbstractSet<Map.Entry<String, Function>>
    implements Set<Map.Entry<String, Function>> {
        private final String bookmarkGroup;

        private BookmarksFunctionsEntrySet(String bookmarkGroup) {
            this.bookmarkGroup = bookmarkGroup;
        }

        @Override
        public int size() {
            Bookmarks bookmarks = ToolsLocator.getBookmarksAndHistoryManager().getBookmarksGroup(this.bookmarkGroup);
            if (bookmarks == null) {
                return 0;
            }
            List names = BookmarksSymbolTable.getBookmarkNames(bookmarks);
            return names.size();
        }

        @Override
        public Iterator<Map.Entry<String, Function>> iterator() {
            final Bookmarks bookmarks = ToolsLocator.getBookmarksAndHistoryManager().getBookmarksGroup(this.bookmarkGroup);
            if (bookmarks == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            Iterator<Map.Entry<String, Function>> it = new Iterator<Map.Entry<String, Function>>(){
                private Iterator<String> namesIt;
                {
                    this.namesIt = BookmarksSymbolTable.getBookmarkNames(bookmarks).iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.namesIt.hasNext();
                }

                @Override
                public Map.Entry<String, Function> next() {
                    String name = this.namesIt.next();
                    Bookmark bookmark = bookmarks.get(name);
                    return new AbstractMap.SimpleEntry<String, AbstractFunction>(name.toUpperCase(), BookmarksSymbolTable.createFunction(name, (Expression)bookmark.getValue()));
                }
            };
            return it;
        }
    }
}

