/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import org.gvsig.vcsgis.lib.SupportError;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSupportError
implements SupportError {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseSupportError.class);
    private int lastErrorCode;
    private String lastErrorMessage;

    public int getLastErrorCode() {
        return this.lastErrorCode;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public int error(int code) {
        return this.error(code, null);
    }

    public int error(int code, String message) {
        this.lastErrorCode = code;
        this.lastErrorMessage = message == null ? VCSGisUtils.getErrorMessage(code) : message;
        if (LOGGER.isDebugEnabled() && this.lastErrorCode != 0) {
            try {
                throw new Exception();
            }
            catch (Exception ex) {
                LOGGER.warn("Error code " + this.lastErrorCode + ", " + this.lastErrorMessage, (Throwable)ex);
            }
        }
        return code;
    }

    public void cleanLastError() {
        this.lastErrorCode = 0;
        this.lastErrorMessage = "";
    }
}

