/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.sql.Timestamp;
import java.util.Objects;
import javax.json.JsonObject;
import javax.json.stream.JsonGenerator;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.vcsgis.lib.VCSGisRevision;

public class VCSGisRevisionImpl
implements VCSGisRevision {
    private String entityCode;
    private String revisionCode;
    private Timestamp efectiveDate;
    private Timestamp revisionDate;
    private String userCode;
    private String comment;
    private long number;
    private String tags;
    private int topologyPlan;
    private long changesCount;

    public static void write(VCSGisRevision revision, JsonGenerator gen) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public VCSGisRevisionImpl(JsonObject jsonData) {
        this.entityCode = jsonData.getString("EntityCode", null);
        this.revisionCode = jsonData.getString("RevisionCode", null);
        this.efectiveDate = (Timestamp)DataTypeUtils.toTimestamp((Object)jsonData.getString("EfectiveDate", null), null);
        this.revisionDate = (Timestamp)DataTypeUtils.toTimestamp((Object)jsonData.getString("RevisionDate", null), null);
        this.userCode = jsonData.getString("UserCode", null);
        this.comment = jsonData.getString("Comment", null);
        this.tags = jsonData.getString("Tags", null);
        this.number = jsonData.getInt("Number", -1);
        this.topologyPlan = jsonData.getInt("TopologyPlan", -1);
        this.changesCount = jsonData.getInt("ChangesCount", 0);
    }

    public long getChangesCount() {
        return this.changesCount;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public String getRevisionCode() {
        return this.revisionCode;
    }

    public Timestamp getEfectiveDate() {
        return this.efectiveDate;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public Timestamp getRevisionDate() {
        return this.revisionDate;
    }

    public String getComment() {
        return this.comment;
    }

    public long getNumber() {
        return this.number;
    }

    public int getTopologyPlan() {
        return this.topologyPlan;
    }

    public String getTags() {
        return this.tags;
    }

    public String getLabel() {
        return VCSGisRevisionImpl.getLabel(this);
    }

    public VCSGisRevision getValue() {
        return this;
    }

    public void copyFrom(VCSGisRevision other) {
        this.entityCode = other.getEntityCode();
        this.revisionCode = other.getRevisionCode();
        this.efectiveDate = other.getEfectiveDate();
        this.revisionDate = other.getRevisionDate();
        this.userCode = other.getUserCode();
        this.comment = other.getComment();
        this.tags = other.getTags();
        this.number = other.getNumber();
        this.topologyPlan = other.getTopologyPlan();
        this.changesCount = other.getChangesCount();
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        return VCSGisRevisionImpl.toJsonBuilder(this);
    }

    public String toString() {
        return VCSGisRevisionImpl.toString(this);
    }

    public static JsonObjectBuilder toJsonBuilder(VCSGisRevision revision) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("EntityCode", revision.getEntityCode());
        builder.add("RevisionCode", revision.getRevisionCode());
        builder.add("EfectiveDate", Objects.toString(revision.getEfectiveDate(), null));
        builder.add("RevisionDate", Objects.toString(revision.getRevisionDate(), null));
        builder.add("UserCode", revision.getUserCode());
        builder.add("Comment", revision.getComment());
        builder.add("Tags", revision.getTags());
        builder.add("Number", revision.getNumber());
        builder.add("TopologyPlan", revision.getTopologyPlan());
        builder.add("ChangesCount", revision.getChangesCount());
        return builder;
    }

    public static String getLabel(VCSGisRevision revision) {
        return "r" + revision.getNumber() + " (" + revision.getRevisionDate() + ")";
    }

    public static String toString(VCSGisRevision revision) {
        return revision.toJson().toString().replace("\n", "");
    }
}

