/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.json.JsonObject;
import org.apache.commons.codec.binary.Hex;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlan;

public class VCSGisTopologyPlanImpl
implements VCSGisTopologyPlan {
    private String topologyPlanCode;
    private String name;
    private String description;
    private String data;

    public VCSGisTopologyPlanImpl() {
    }

    public VCSGisTopologyPlanImpl(JsonObject jsonData) {
        this.topologyPlanCode = jsonData.getString("TopologyPlanCode", null);
        this.name = jsonData.getString("Name", null);
        this.description = jsonData.getString("Description", null);
        this.data = jsonData.getString("Data", null);
    }

    public String getTopologyPlanCode() {
        return this.topologyPlanCode;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getData() {
        return this.data;
    }

    public String getLabel() {
        return this.getName();
    }

    public VCSGisTopologyPlan getValue() {
        return this;
    }

    public void copyFrom(VCSGisTopologyPlan other) {
        this.topologyPlanCode = other.getTopologyPlanCode();
        this.name = other.getName();
        this.description = other.getDescription();
        this.data = other.getData();
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        return VCSGisTopologyPlanImpl.toJsonBuilder(this);
    }

    public String toString() {
        return VCSGisTopologyPlanImpl.toString(this);
    }

    public static JsonObjectBuilder toJsonBuilder(VCSGisTopologyPlan topologyPlan) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("TopologyPlanCode", topologyPlan.getTopologyPlanCode());
        builder.add("Name", topologyPlan.getName());
        builder.add("Description", topologyPlan.getDescription());
        builder.add("Data", topologyPlan.getData());
        return builder;
    }

    public static String getLabel(VCSGisTopologyPlan topologyPlan) {
        return topologyPlan.getName();
    }

    public static String toString(VCSGisTopologyPlan topologyPlan) {
        return topologyPlan.getName();
    }

    public static String getHashCode(VCSGisTopologyPlan plan) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            VCSGisTopologyPlanImpl.updateMessageDigest(md, plan.getTopologyPlanCode());
            VCSGisTopologyPlanImpl.updateMessageDigest(md, plan.getName());
            VCSGisTopologyPlanImpl.updateMessageDigest(md, plan.getDescription());
            VCSGisTopologyPlanImpl.updateMessageDigest(md, plan.getData());
            VCSGisTopologyPlanImpl.updateMessageDigest(md, plan.getLabel());
            String hash = Hex.encodeHexString((byte[])md.digest());
            return hash;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Can't retrieve hash of topology plan.", ex);
        }
    }

    private static void updateMessageDigest(MessageDigest md, String value) {
        if (value != null) {
            md.update(value.getBytes(StandardCharsets.UTF_8));
        }
    }

    public String getHashCode() {
        return VCSGisTopologyPlanImpl.getHashCode(this);
    }
}

