/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.util.MapBuilder;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisEntityEditable;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisUtils.class);
    public static final String ENTITY_CODE = "EntityCode";
    public static final String ENTITY_NAME = "EntityName";
    public static final String ENTITY_DATATABLENAME = "DataTableName";
    public static final String ENTITY_DESCRIPTION = "Description";
    public static final String ENTITY_FEATUREIDFIELDNAME = "FeatureIdFieldName";
    public static final String ENTITY_FEATURETYPEASJSON = "FeatureTypeAsJson";
    public static final String ENTITY_FIELDFORLABEL = "FieldForLabel";
    public static final String ENTITY_GEOMETRYFIELDNAME = "GeometryFieldName";
    public static final String ENTITY_REVISIONCODE = "RevisionCode";
    public static final String ENTITY_TOPOLOGYPLANCODE = "TopologyPlanCode";
    public static final String ENTITY_USERCODE = "UserCode";
    public static final String ENTITY_CATEGORY = "Category";
    public static final String ENTITY_LABEL = "Label";
    public static final String ENTITY_AUTHORIZATIONS = "Authorizations";
    public static final String ENTITY_TOPOLOGYPLANMODE = "TopologyPlanMode";
    public static final String ENTITY_LOCALREVISIONCODE = "LocalRevisionCode";
    public static final String ENTITY_RESOURCES = "Resources";
    public static final String ENTITY_DATA_MODELS = "DataModels";
    public static final String ENTITY_CRS = "CRS";
    public static final String ENTITY_CUSTOMDATA = "customdata";
    private static final Map<Integer, String> ERRMSGS = new MapBuilder().add((Object)0, (Object)"_No_errors").add((Object)1, (Object)"_dbfile_is_null").add((Object)2, (Object)"_workingcopy_explorer_is_null").add((Object)6, (Object)"_label_is_null").add((Object)3, (Object)"_Cant_open_workingcopy").add((Object)4, (Object)"_Cant_open_workingcopy").add((Object)5, (Object)"_Store_not_in_control_version").add((Object)100, (Object)"_Cant_create_table").add((Object)110, (Object)"_Cant_create_config_table").add((Object)120, (Object)"_Cant_create_table_entities").add((Object)130, (Object)"_Cant_create_table_changes").add((Object)200, (Object)"_Entity_already_exists").add((Object)210, (Object)"_Entity_has_not_VCSGISCODE").add((Object)220, (Object)"_Cant_open_entities").add((Object)230, (Object)"_Cant_insert_entities").add((Object)300, (Object)"_Cant_open_changes").add((Object)310, (Object)"_Cant_insert_change").add((Object)400, (Object)"_Cant_open_store").add((Object)410, (Object)"_Cant_retrieve_source_features").add((Object)420, (Object)"_Cant_insert_features").add((Object)500, (Object)"_Cant_commit").add((Object)510, (Object)"_Cant_commit_workingcopy_is_out_of_date").add((Object)600, (Object)"_Cant_checkout").add((Object)70, (Object)"_Cant_update_entities").add((Object)81, (Object)"_Cant_prepare_update").add((Object)80, (Object)"_Cant_update").add((Object)7, (Object)"_Cant_execute_request").add((Object)8, (Object)"_Cant_build_request_response").add((Object)10, (Object)"_Cant_handle_request").add((Object)83, (Object)"_Cant_update_clean").add((Object)520, (Object)"_Cant_commit_with_feature_code_blank").add((Object)260, (Object)"Cant_add_entity_without_primary_key").add((Object)11, (Object)"_Cant_initialize_repository").add((Object)13, (Object)"_Data_can_be_empty").add((Object)14, (Object)"_Invalid_repository").add((Object)15, (Object)"_Invalid_revision").add((Object)16, (Object)"_Invalid_revision_for_entity").add((Object)250, (Object)"_Cant_retrieve_entities").add((Object)30, (Object)"_Cant_retrieve_users").add((Object)31, (Object)"_Cant_retrieve_topologyplans").add((Object)18, (Object)"_Cant_add_layer_to_view").add((Object)280, (Object)"_Cant_remove_entity").add((Object)330, (Object)"_Cant_remove_change").add((Object)19, (Object)"_Cant_authenticate_user").add((Object)20, (Object)"_Invalid_authentication_token").add((Object)21, (Object)"_User_not_authorized").add((Object)22, (Object)"_Authentication_expired").add((Object)23, (Object)"_Invalid_user_code").add((Object)700, (Object)"_Cant_revert").add((Object)34, (Object)"_Invalid_record_code").add((Object)35, (Object)"_Data_record_not_found").add((Object)25, (Object)"_Exception_during_operation").add((Object)800, (Object)"_Cant_prepare_workspace").add((Object)801, (Object)"_Repository_url_not_defined").add((Object)802, (Object)"_Working_copies_folder_not_defined").add((Object)25, (Object)"_Exception_during_operation").add((Object)520, (Object)"_Cant_commit_feature_code_is_blank").add((Object)530, (Object)"_Cant_commit_feature_data_is_blank").add((Object)37, (Object)"_Operation_not_allowed_with_linked_table").add((Object)39, (Object)"_Too_many_repositories_only_one_allowed").build();
    private static final Map<Integer, String> OPERATION_LABELS = new MapBuilder().add((Object)0, (Object)"Delete").add((Object)1, (Object)"Update").add((Object)2, (Object)"Insert").add((Object)3, (Object)"Add entity").build();
    private static final Map<Integer, String> STATE_LABELS = new MapBuilder().add((Object)1, (Object)"Unmodified").add((Object)2, (Object)"New").add((Object)4, (Object)"Modified").add((Object)6, (Object)"Outdated").add((Object)8, (Object)"Outdated and modified").add((Object)16, (Object)"Conflict").add((Object)128, (Object)"Disconnected").build();
    private static final Map<String, Map<String, Template>> SQL_TEMPLATES_BY_PROVIDER = new HashMap<String, Map<String, Template>>();

    public static String getErrorMessage(int errcode) {
        String msg = ERRMSGS.get(errcode);
        msg = ToolsLocator.getI18nManager().getTranslation(msg);
        return msg;
    }

    public static void copy(VCSGisEntity source, VCSGisEntityEditable target, Predicate<String> excludes) {
        if (excludes == null || !excludes.test(ENTITY_DATATABLENAME)) {
            target.setDataTableName(source.getDataTableName());
        }
        if (excludes == null || !excludes.test(ENTITY_DESCRIPTION)) {
            target.setDescription(source.getDescription());
        }
        if (excludes == null || !excludes.test(ENTITY_CODE)) {
            target.setEntityCode(source.getEntityCode());
        }
        if (excludes == null || !excludes.test(ENTITY_NAME)) {
            target.setEntityName(source.getEntityName());
        }
        if (excludes == null || !excludes.test(ENTITY_FEATUREIDFIELDNAME)) {
            target.setFeatureIdFieldName(source.getFeatureIdFieldName());
        }
        if (excludes == null || !excludes.test(ENTITY_FEATURETYPEASJSON)) {
            target.setFeatureTypeAsJson(source.getFeatureTypeAsJson());
        }
        if (excludes == null || !excludes.test(ENTITY_FIELDFORLABEL)) {
            target.setFieldForLabel(source.getFieldForLabel());
        }
        if (excludes == null || !excludes.test(ENTITY_GEOMETRYFIELDNAME)) {
            target.setGeometryFieldName(source.getGeometryFieldName());
        }
        if (excludes == null || !excludes.test(ENTITY_REVISIONCODE)) {
            target.setRepositoryRevisionCode(source.getRepositoryRevisionCode());
        }
        if (excludes == null || !excludes.test(ENTITY_TOPOLOGYPLANCODE)) {
            target.setTopologyPlanCode(source.getTopologyPlanCode());
        }
        if (excludes == null || !excludes.test(ENTITY_USERCODE)) {
            target.setUserCode(source.getUserCode());
        }
        if (excludes == null || !excludes.test(ENTITY_CATEGORY)) {
            target.setCategory(source.getCategory());
        }
        if (excludes == null || !excludes.test(ENTITY_LABEL)) {
            target.setLabel(source.getLabel());
        }
        if (excludes == null || !excludes.test(ENTITY_AUTHORIZATIONS)) {
            if (!(target instanceof VCSGisWorkspaceEntity)) {
                target.setAuthorizations(source.getAuthorizations());
            } else {
                target.setAuthorizations(null);
            }
        }
        if (excludes == null || !excludes.test(ENTITY_TOPOLOGYPLANMODE)) {
            target.setTopologyPlanMode(source.getTopologyPlanMode());
        }
        if (excludes == null || !excludes.test(ENTITY_RESOURCES)) {
            target.setResources(source.getResources());
        }
        if (excludes == null || !excludes.test(ENTITY_DATA_MODELS)) {
            target.setDataModels(source.getDataModels());
        }
        if ((excludes == null || !excludes.test(ENTITY_LOCALREVISIONCODE)) && source instanceof VCSGisWorkspaceEntity && target instanceof VCSGisWorkspaceEntity) {
            ((VCSGisWorkspaceEntity)target).setLocalRevisionCode(((VCSGisWorkspaceEntity)source).getLocalRevisionCode());
        }
        if (excludes == null || !excludes.test(ENTITY_CRS)) {
            target.setCRS(source.getCRS());
        }
    }

    public static JsonObjectBuilder toJsonBuilder(VCSGisEntity entity, Predicate<String> excludes) {
        JsonObjectBuilder jsonEntity = Json.createObjectBuilder();
        if (excludes == null || !excludes.test(ENTITY_DATATABLENAME)) {
            jsonEntity.add(ENTITY_DATATABLENAME, entity.getDataTableName());
        }
        if (excludes == null || !excludes.test(ENTITY_DESCRIPTION)) {
            jsonEntity.add(ENTITY_DESCRIPTION, entity.getDescription());
        }
        if (excludes == null || !excludes.test(ENTITY_CODE)) {
            jsonEntity.add(ENTITY_CODE, entity.getEntityCode());
        }
        if (excludes == null || !excludes.test(ENTITY_NAME)) {
            jsonEntity.add(ENTITY_NAME, entity.getEntityName());
        }
        if (excludes == null || !excludes.test(ENTITY_FEATUREIDFIELDNAME)) {
            jsonEntity.add(ENTITY_FEATUREIDFIELDNAME, entity.getFeatureIdFieldName());
        }
        if (excludes == null || !excludes.test(ENTITY_FEATURETYPEASJSON)) {
            jsonEntity.add(ENTITY_FEATURETYPEASJSON, entity.getFeatureTypeAsJson());
        }
        if (excludes == null || !excludes.test(ENTITY_FIELDFORLABEL)) {
            jsonEntity.add(ENTITY_FIELDFORLABEL, entity.getFieldForLabel());
        }
        if (excludes == null || !excludes.test(ENTITY_GEOMETRYFIELDNAME)) {
            jsonEntity.add(ENTITY_GEOMETRYFIELDNAME, entity.getGeometryFieldName());
        }
        if (excludes == null || !excludes.test(ENTITY_REVISIONCODE)) {
            jsonEntity.add(ENTITY_REVISIONCODE, entity.getRepositoryRevisionCode());
        }
        if (excludes == null || !excludes.test(ENTITY_TOPOLOGYPLANCODE)) {
            jsonEntity.add(ENTITY_TOPOLOGYPLANCODE, entity.getTopologyPlanCode());
        }
        if (excludes == null || !excludes.test(ENTITY_USERCODE)) {
            jsonEntity.add(ENTITY_USERCODE, entity.getUserCode());
        }
        if (excludes == null || !excludes.test(ENTITY_CATEGORY)) {
            jsonEntity.add(ENTITY_CATEGORY, entity.getCategory());
        }
        if (excludes == null || !excludes.test(ENTITY_LABEL)) {
            jsonEntity.add(ENTITY_LABEL, entity.getLabel());
        }
        if (excludes == null || !excludes.test(ENTITY_AUTHORIZATIONS)) {
            jsonEntity.addNull(ENTITY_AUTHORIZATIONS);
        }
        if (excludes == null || !excludes.test(ENTITY_TOPOLOGYPLANMODE)) {
            jsonEntity.add(ENTITY_TOPOLOGYPLANMODE, entity.getTopologyPlanMode());
        }
        if (excludes == null || !excludes.test(ENTITY_RESOURCES)) {
            jsonEntity.add(ENTITY_RESOURCES, entity.getResources());
        }
        if (excludes == null || !excludes.test(ENTITY_DATA_MODELS)) {
            jsonEntity.add(ENTITY_DATA_MODELS, entity.getDataModels());
        }
        if (entity instanceof VCSGisWorkspaceEntity && (excludes == null || !excludes.test(ENTITY_LOCALREVISIONCODE))) {
            jsonEntity.add(ENTITY_LOCALREVISIONCODE, ((VCSGisWorkspaceEntity)entity).getLocalRevisionCode());
        }
        if (!(excludes != null && excludes.test(ENTITY_CRS) || entity.getCRS() == null)) {
            jsonEntity.add(ENTITY_CRS, entity.getCRS());
        }
        if ((excludes == null || !excludes.test(ENTITY_CUSTOMDATA)) && StringUtils.isNotBlank((CharSequence)entity.getCustomData())) {
            jsonEntity.add(ENTITY_CUSTOMDATA, entity.getCustomData());
        }
        return jsonEntity;
    }

    public static void fromJson(VCSGisEntityEditable entity, JsonObject jsonEntity) {
        if (jsonEntity.containsKey((Object)ENTITY_DATATABLENAME)) {
            entity.setDataTableName(jsonEntity.getString(ENTITY_DATATABLENAME));
        }
        if (jsonEntity.containsKey((Object)ENTITY_DESCRIPTION)) {
            entity.setDescription(jsonEntity.getString(ENTITY_DESCRIPTION, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_CODE)) {
            entity.setEntityCode(jsonEntity.getString(ENTITY_CODE, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_NAME)) {
            entity.setEntityName(jsonEntity.getString(ENTITY_NAME, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_FEATUREIDFIELDNAME)) {
            entity.setFeatureIdFieldName(jsonEntity.getString(ENTITY_FEATUREIDFIELDNAME, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_FEATURETYPEASJSON)) {
            entity.setFeatureTypeAsJson(jsonEntity.getString(ENTITY_FEATURETYPEASJSON, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_FIELDFORLABEL)) {
            entity.setFieldForLabel(jsonEntity.getString(ENTITY_FIELDFORLABEL, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_GEOMETRYFIELDNAME)) {
            entity.setGeometryFieldName(jsonEntity.getString(ENTITY_GEOMETRYFIELDNAME, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_REVISIONCODE)) {
            entity.setRepositoryRevisionCode(jsonEntity.getString(ENTITY_REVISIONCODE, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_TOPOLOGYPLANCODE)) {
            entity.setTopologyPlanCode(jsonEntity.getString(ENTITY_TOPOLOGYPLANCODE, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_USERCODE)) {
            entity.setUserCode(jsonEntity.getString(ENTITY_USERCODE, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_CATEGORY)) {
            entity.setCategory(jsonEntity.getString(ENTITY_CATEGORY, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_LABEL)) {
            entity.setLabel(jsonEntity.getString(ENTITY_LABEL, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_AUTHORIZATIONS)) {
            if (entity instanceof VCSGisWorkspaceEntity) {
                entity.setAuthorizations(null);
            } else {
                entity.setAuthorizations(jsonEntity.getString(ENTITY_AUTHORIZATIONS, null));
            }
        }
        if (jsonEntity.containsKey((Object)ENTITY_TOPOLOGYPLANMODE)) {
            entity.setTopologyPlanMode(jsonEntity.getInt(ENTITY_TOPOLOGYPLANMODE, 0));
        }
        if (jsonEntity.containsKey((Object)ENTITY_RESOURCES)) {
            entity.setResources(jsonEntity.getString(ENTITY_RESOURCES, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_DATA_MODELS)) {
            entity.setDataModels(jsonEntity.getString(ENTITY_DATA_MODELS, null));
        }
        if (entity instanceof VCSGisWorkspaceEntity && jsonEntity.containsKey((Object)ENTITY_LOCALREVISIONCODE)) {
            ((VCSGisWorkspaceEntity)entity).setLocalRevisionCode(jsonEntity.getString(ENTITY_LOCALREVISIONCODE, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_CRS)) {
            entity.setCRS(jsonEntity.getString(ENTITY_CRS, null));
        }
        if (jsonEntity.containsKey((Object)ENTITY_CUSTOMDATA)) {
            entity.setCustomData(jsonEntity.getString(ENTITY_CUSTOMDATA, null));
        }
    }

    public static boolean isAuthorized(VCSGisEntity entity, String operation, VCSGisUser user) {
        String s = entity.getAuthorizations();
        if (StringUtils.isBlank((CharSequence)s)) {
            LOGGER.info("Repository authorization for '" + entity.getEntityName() + "' entity isn't actived.");
            return true;
        }
        String userid = user.getIdentifier().toLowerCase();
        try {
            JsonObject authorizations = Json.createObject((String)s);
            if (authorizations == null) {
                return false;
            }
            if (StringUtils.isBlank((CharSequence)userid) || StringUtils.isBlank((CharSequence)operation)) {
                return false;
            }
            JsonArray op = authorizations.getJsonArray(operation.toLowerCase());
            if (op == null) {
                return false;
            }
            for (JsonValue value : op) {
                String userOrRole = ((JsonString)value).getString();
                if (StringUtils.equalsIgnoreCase((CharSequence)userOrRole, (CharSequence)"*")) {
                    LOGGER.debug("Repository authorization for '" + operation + "' operation for '" + entity.getEntityName() + "' entity is allowed for all users.");
                    return true;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)userOrRole, (CharSequence)userid)) {
                    LOGGER.debug("Repository authorization for '" + operation + "' operation for '" + entity.getEntityName() + "' entity is allowed for user '" + userid + "'(" + user.getUserCode() + ").");
                    return true;
                }
                for (String role : user.getRolesAsList()) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)userOrRole, (CharSequence)("$" + role))) continue;
                    LOGGER.debug("Repository authorization for '" + operation + "' operation for '" + entity.getEntityName() + "' entity is allowed for user '" + userid + "/" + role + "' (" + user.getUserCode() + ").");
                    return true;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't verify authorization of user '" + userid + "'.", (Throwable)ex);
            return false;
        }
        return false;
    }

    public static String getOperationLabel(int operation) {
        return OPERATION_LABELS.getOrDefault(operation, "unknown");
    }

    public static String getStateLabel(int state) {
        return STATE_LABELS.getOrDefault(state, "unknown");
    }

    private static Map<String, Template> getSqlTemplates(String name) {
        List lines;
        boolean SEARCHING_ITEM = false;
        boolean READING_ITEM = true;
        InputStream sqls = VCSGisUtils.class.getResourceAsStream("/org/gvsig/vcsgis/lib/" + name + ".sql");
        HashMap<String, Template> expecteds = new HashMap<String, Template>();
        try {
            lines = IOUtils.readLines((InputStream)sqls);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't read sql templates for provider " + name, ex);
        }
        StringBuilder sb = null;
        Template currentItem = null;
        int lineno = 1;
        int state = 0;
        for (String line : lines) {
            line = line + "\n";
            switch (state) {
                case 0: {
                    if (line.toLowerCase().startsWith("@begin ")) {
                        currentItem = new Template(line.substring(7).trim());
                        sb = new StringBuilder();
                        state = 1;
                        break;
                    }
                    if (line.toLowerCase().startsWith("-- ") || line.toLowerCase().startsWith("@rem") || StringUtils.isBlank((CharSequence)line)) break;
                    throw new IllegalStateException("Syntax error at '" + name + "', line " + lineno + ".");
                }
                case 1: {
                    if (line.toLowerCase().startsWith("@end ")) {
                        String found = line.substring(5).trim();
                        if (!StringUtils.equals((CharSequence)currentItem.getName(), (CharSequence)found)) {
                            throw new IllegalStateException("Syntax error at '" + name + "', line " + lineno + ", expected @end " + currentItem.getName() + ", and found " + line + ".");
                        }
                        String s = sb.toString();
                        if (s.endsWith("\n")) {
                            s = s.substring(0, s.length() - 1);
                        }
                        currentItem.setCode(s);
                        expecteds.put(currentItem.getName(), currentItem);
                        state = 0;
                        break;
                    }
                    if (line.toLowerCase().startsWith("-- ") || line.toLowerCase().startsWith("@rem")) break;
                    if (line.toLowerCase().startsWith("@param ")) {
                        currentItem.addParameter(line.substring(7).trim());
                        break;
                    }
                    if (line.toLowerCase().startsWith("@const ")) {
                        String s = line.substring(7).trim();
                        String[] ss = StringUtils.split((String)s, (String)"=");
                        currentItem.addConstant(ss[0].trim(), ss[1].trim());
                        break;
                    }
                    sb.append(line);
                }
            }
            ++lineno;
        }
        if (state != 0) {
            throw new IllegalStateException("Syntax error at '" + name + "', expected @end " + currentItem.getName() + " and found EOF .");
        }
        return expecteds;
    }

    public static String getSqlTemplate(String providerName, String sqlId, Object ... args) {
        Template template;
        if (SQL_TEMPLATES_BY_PROVIDER.get(providerName) == null) {
            SQL_TEMPLATES_BY_PROVIDER.put(providerName, VCSGisUtils.getSqlTemplates(providerName));
        }
        if ((template = SQL_TEMPLATES_BY_PROVIDER.get(providerName).get(sqlId)) == null) {
            return null;
        }
        return template.getCode(args);
    }

    public static void updateMessageDigest(MessageDigest md, Feature f, String fieldName) {
        String s = f.getString(fieldName);
        if (s != null) {
            md.update(s.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static String getFirst(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            String[] ss = StringUtils.split((String)s, (String)",");
            if (ss.length < 1) {
                return null;
            }
            return ss[0];
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<String> getAsList(String s) {
        return VCSGisUtils.getAsList(s, true);
    }

    public static List<String> getAsList(String s, boolean toLowerCase) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return Collections.EMPTY_LIST;
        }
        try {
            String[] ss;
            ArrayList<String> l = new ArrayList<String>();
            for (String s1 : ss = StringUtils.split((String)s, (String)",")) {
                if (StringUtils.isBlank((CharSequence)(s1 = URLDecoder.decode(s1, "UTF-8")))) continue;
                if (toLowerCase) {
                    l.add(s1.trim().toLowerCase());
                    continue;
                }
                l.add(s1.trim());
            }
            return l;
        }
        catch (Exception ex) {
            return Collections.EMPTY_LIST;
        }
    }

    public static String getLabelOrName(VCSGisEntity entity) {
        String label = entity.getLabel();
        if (StringUtils.isBlank((CharSequence)label)) {
            label = entity.getEntityName();
        }
        return label;
    }

    public static String getFormatedLabel(final VCSGisEntity entity, String template) {
        try {
            StringSubstitutor sub = new StringSubstitutor(new StringLookup(){

                public String lookup(String key) {
                    if (StringUtils.equalsIgnoreCase((CharSequence)"label", (CharSequence)key)) {
                        return entity.getLabel();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"name", (CharSequence)key)) {
                        return entity.getEntityName();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"code", (CharSequence)key)) {
                        return entity.getEntityCode();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"category", (CharSequence)key)) {
                        return StringUtils.join((Iterable)entity.getCategoriesAsList(), (String)",");
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"revision", (CharSequence)key)) {
                        return entity.getRepositoryRevisionCode();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"datamodels", (CharSequence)key)) {
                        return entity.getDataModels();
                    }
                    if (StringUtils.equalsIgnoreCase((CharSequence)"description", (CharSequence)key)) {
                        return entity.getDescription();
                    }
                    return "";
                }
            });
            String s = sub.replace(template);
            if (StringUtils.isBlank((CharSequence)s)) {
                s = VCSGisUtils.getLabelOrName(entity);
            }
            return s;
        }
        catch (Throwable th) {
            return VCSGisUtils.getLabelOrName(entity);
        }
    }

    public static boolean isLinkedTable(VCSGisEntity entity) {
        try {
            JsonObject json = Json.createObject((String)entity.getCustomData());
            JsonObject x = json.getJsonObject("linkedrepository");
            return x != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static VCSGisRepository getLinkedRepository(VCSGisEntity entity) {
        try {
            String data = entity.getCustomData();
            if (StringUtils.isEmpty((CharSequence)data)) {
                return null;
            }
            JsonObject json = Json.createObject((String)data);
            if (json == null) {
                return null;
            }
            JsonObject x = json.getJsonObject("linkedrepository");
            if (x == null) {
                return null;
            }
            VCSGisManager manager = VCSGisLocator.getVCSGisManager();
            VCSGisRepository repo = manager.openRepository(x);
            return repo;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static class Template {
        List<String> parameters;
        Map<String, String> constants;
        String code;
        String name;

        public Template(String name) {
            this.name = name;
            this.parameters = new ArrayList<String>();
            this.constants = new HashMap<String, String>();
            this.code = null;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void addParameter(String parameter) {
            this.parameters.add(parameter);
        }

        public void addConstant(String name, String value) {
            this.constants.put(name, value);
        }

        public String getName() {
            return this.name;
        }

        public String getCode(Object ... params) {
            if (this.parameters.isEmpty()) {
                return String.format(this.code, params);
            }
            String s = this.code;
            for (int i = 0; i < this.parameters.size(); ++i) {
                s = s.replace("%" + this.parameters.get(i) + "$", "%" + (i + 1) + "$");
            }
            for (Map.Entry<String, String> entry : this.constants.entrySet()) {
                String cname = entry.getKey();
                String cvalue = entry.getValue();
                s = s.replace("%" + cname + "$s", cvalue);
            }
            if (ArrayUtils.isEmpty((Object[])params)) {
                return s;
            }
            s = String.format(s, params);
            return s;
        }

        public String toString() {
            return this.name;
        }
    }
}

