/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb;

import java.io.File;
import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.json.JsonObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.CachedValue;
import org.gvsig.vcsgis.lib.SupportError;
import org.gvsig.vcsgis.lib.VCSGisCodeGenerator;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.AbstractRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisIdentityController;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.identityControllerLocaldb.IdentityControllerImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AuthenticateRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.CheckoutRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.CommitRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.EntitiesRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.HistoryRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.ListWCRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.LogRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.PrepareWCRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.RevisionChangesRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.RowCreateRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.RowDeleteRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.RowIsOutofdateRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.RowUpdateRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.TopologyPlansRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.UpdateRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.requests.UsersRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.ConfigRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.DataRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.EntitiesRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.HooksRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.RevisionsRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.TopologyplanRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.UsersRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisAuthenticateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCheckoutRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCommitRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisEntitiesRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisHistoryRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisListWCRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisLogRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisPrepareWCRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRevisionChangesRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowCreateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowDeleteRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowIsOutofdateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowUpdateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisTopologyPlansRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisUpdateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisUsersRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisRepositoryLocaldbImpl
extends AbstractRepository
implements VCSGisRepositoryLocaldb {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisRepositoryLocaldbImpl.class);
    public static final String CONFIG_REPOSITORY_CODE_NAME = "REPOSITORY_CODE";
    public static final String CONFIG_AUTHENTICATION_NAME = "AUTHENTICATION";
    public static final String CONFIG_AUTHORIZATION_NAME = "AUTHORIZATION";
    public static final String CONFIG_PREPARED_WORKING_COPIES_FOLDER_NAME = "PREPARED_WORKING_COPIES_FOLDER";
    public static final String CONFIG_REPOSITORY_URL_NAME = "REPOSITORY_URL";
    public static final String CONFIG_TRUSTED_CLIENT_IP_NAME = "TRUSTED_CLIENT_IP";
    public static final String CONFIG_REPOSITORY_CRS = "REPOSITORY_CRS";
    public static final String CONFIG_TIMEOUT_FOR_RECEIVE_ELEMENTS = "TIMEOUT_FOR_RECEIVE_ELEMENTS";
    public static final String CONFIG_CHECKOUT_ALGORITHM = "CHECKOUT_ALGORITHM";
    public static final String CONFIG_INDEX_GEOMETRIES = "INDEX_GEOMETRIES";
    public static final String CONFIG_IDENTITY_CONTROLLER = "IDENTITY_CONTROLLER";
    public static final String CONFIG_CHECKOUT_WITH_REVNUMBER = "CHECKOUT_WITH_REVNUMBER";
    private JDBCServerExplorer server;
    private JDBCServerExplorerParameters serverParameters;
    private Map<String, FeatureStore> stores;
    private VCSGisCodeGenerator codeGenerator;
    private String code;
    private IProjection crs;
    private boolean allowAssignTheRevisionDate;
    private CachedValue<Boolean> authenticationRequired;
    private CachedValue<Boolean> authorizationRequired;
    private int dataTableBatchSize = -1;
    private HooksRepoTable.WatchersNotifier watchersNotifier;
    private int timeout_for_receive_elements;
    private Boolean indexGeometries;
    private SQLBuilder sqlbuilder;
    private VCSGisIdentityController identityController;
    private String identityControllerClassName;
    public Boolean buildBox2D_traces;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int create(JDBCServerExplorerParameters serverParameters, VCSGisCodeGenerator codeGenerator, IProjection crs, Envelope tablebbox, boolean indexGeometries, SimpleTaskStatus status) {
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("vcsgis init");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        LOGGER.debug("Initializing repository " + Objects.toString(serverParameters.toJson()).replace('\n', ' ').replaceAll("\"password\":\"[^\"]*\"", "\"password\":\"****\""));
        int r = 3;
        DataManager dataManager = DALLocator.getDataManager();
        JDBCServerExplorer server = null;
        String providerName = serverParameters.getProviderName();
        try {
            server = (JDBCServerExplorer)dataManager.openServerExplorer(providerName, (DataServerExplorerParameters)serverParameters);
        }
        catch (Exception ex) {
            throw new VCSGisRuntimeException(14, "Can't open server explorer.");
        }
        try {
            VCSGisRepositoryLocaldbImpl.execute(server, VCSGisUtils.getSqlTemplate(providerName, "createFunctionsPre1", new Object[0]));
            r = 4;
            status.setTitle("vcsgis init");
            DatabaseWorkspaceManager databaseWorkspaceManager = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)serverParameters);
            if (!databaseWorkspaceManager.existsTable(2)) {
                databaseWorkspaceManager.createTable(2);
            }
            if (!databaseWorkspaceManager.existsTable(0)) {
                databaseWorkspaceManager.createTable(0);
            }
            if (!databaseWorkspaceManager.existsTable(1)) {
                databaseWorkspaceManager.createTable(1);
                databaseWorkspaceManager.set("StoresRepository.id", "VCSGISREPO");
            }
            databaseWorkspaceManager.connect();
            FeatureType[] tables = new FeatureType[]{ConfigRepoTable.featureType(), UsersRepoTable.featureType(), TopologyplanRepoTable.featureType(), EntitiesRepoTable.featureType(), RevisionsRepoTable.featureType(), DataRepoTable.featureType(crs, tablebbox), HooksRepoTable.featureType()};
            r = 5;
            status.setRangeOfValues(0L, (long)tables.length);
            int step = 1;
            for (FeatureType table : tables) {
                status.message(table.getLabel());
                status.setCurValue((long)step++);
                r = 5 + step;
                JDBCNewStoreParameters table_params = server.getAddParameters();
                table_params.setDefaultFeatureType((FeatureType)table.getEditable());
                String tableName = table.getTags().getString("ID");
                table_params.setTable(tableName);
                server.add(server.getProviderName(), (NewDataStoreParameters)table_params, false);
                JDBCStoreParameters openParams = server.get(tableName);
                databaseWorkspaceManager.writeStoresRepositoryEntry(tableName, (DataStoreParameters)openParams);
            }
            VCSGisRepositoryLocaldbImpl.execute_ignoreerrors(server, VCSGisUtils.getSqlTemplate(providerName, "createRepositoryIndex1", new Object[0]));
            VCSGisRepositoryLocaldbImpl.execute_ignoreerrors(server, VCSGisUtils.getSqlTemplate(providerName, "createRepositoryIndex2", new Object[0]));
            VCSGisRepositoryLocaldbImpl.execute(server, VCSGisUtils.getSqlTemplate(providerName, "createFunctionsPost1", new Object[0]));
            VCSGisRepositoryLocaldbImpl repo = new VCSGisRepositoryLocaldbImpl();
            repo.initialize(serverParameters, codeGenerator, crs, indexGeometries);
            DisposeUtils.disposeQuietly((Disposable)repo);
            status.terminate();
        }
        catch (Exception ex) {
            status.abort();
            LOGGER.warn("Can't init repository.", (Throwable)ex);
            status.message(ex.getMessage());
            int n = r;
            return n;
        }
        finally {
            status.pop();
            DisposeUtils.disposeQuietly((Disposable)server);
        }
        return 0;
    }

    private static void execute_ignoreerrors(JDBCServerExplorer server, String sql) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            return;
        }
        try {
            server.execute(sql);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't execute sql (" + sql + ").\nMake sure you can access the database and have permissions to execute the SQL statement (create tables, indexes, procedures/functions, packages...).", (Throwable)ex);
        }
    }

    private static void execute(JDBCServerExplorer server, String sql) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            return;
        }
        try {
            server.execute(sql);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't execute sql (" + sql + ").\nMake sure you can access the database and have permissions to execute the SQL statement (create tables, indexes, procedures/functions, packages...).", (Throwable)ex);
            throw new VCSGisRuntimeException(25, "Can't execute SQL \n" + sql);
        }
    }

    public VCSGisRepositoryLocaldbImpl() {
        this.codeGenerator = null;
        this.stores = null;
        this.server = null;
        this.serverParameters = null;
        this.code = null;
        this.allowAssignTheRevisionDate = false;
        this.authenticationRequired = new CachedValue(3600000L, () -> {
            ConfigRepoTable varsTable = new ConfigRepoTable();
            return Boolean.valueOf(varsTable.get(this, CONFIG_AUTHENTICATION_NAME));
        });
        this.authorizationRequired = new CachedValue(3600000L, () -> {
            ConfigRepoTable varsTable = new ConfigRepoTable();
            return Boolean.valueOf(varsTable.get(this, CONFIG_AUTHORIZATION_NAME));
        });
        this.initIdentityController();
    }

    public VCSGisRepositoryLocaldbImpl(JDBCServerExplorerParameters serverParameters, VCSGisCodeGenerator codeGenerator) {
        this.stores = null;
        this.codeGenerator = codeGenerator;
        this.serverParameters = serverParameters;
        DataManager dataManager = DALLocator.getDataManager();
        try {
            this.server = (JDBCServerExplorer)dataManager.openServerExplorer(serverParameters.getProviderName(), (DataServerExplorerParameters)serverParameters);
        }
        catch (Exception ex) {
            throw new VCSGisRuntimeException(14, "Can't open server explorer.");
        }
        this.loadConfigTable();
        this.watchersNotifier = null;
        this.initIdentityController();
    }

    private void initIdentityController() {
        this.identityController = new IdentityControllerImpl(this);
        if (StringUtils.isNotBlank((CharSequence)this.identityControllerClassName)) {
            try {
                VCSGisIdentityController ic;
                Class<?> identityControllerClass = Class.forName(this.identityControllerClassName);
                Constructor<?> identityControllerConstructor = identityControllerClass.getConstructor(VCSGisRepositoryLocaldb.class);
                this.identityController = ic = (VCSGisIdentityController)identityControllerConstructor.newInstance(new Object[]{this});
                LOGGER.info("Installed identity controller '" + this.identityControllerClassName + "'.");
            }
            catch (Exception ex) {
                LOGGER.warn("Can't install identity controller '" + this.identityControllerClassName + "'.", (Throwable)ex);
            }
        }
    }

    public Map<String, String> getConfigValues(String ... names) {
        ConfigRepoTable varsTable = new ConfigRepoTable();
        Map<String, String> values = varsTable.getVars(this, names);
        return values;
    }

    public String getConfigValue(String name) {
        ConfigRepoTable varsTable = new ConfigRepoTable();
        String value = varsTable.get(this, name);
        return value;
    }

    public void setConfigValue(String name, String value) {
        ConfigRepoTable varsTable = new ConfigRepoTable();
        varsTable.set(this, name, value);
    }

    private void loadConfigTable() {
        String crs_s;
        ConfigRepoTable varsTable = new ConfigRepoTable();
        Map<String, String> vars = varsTable.getVars(this, CONFIG_REPOSITORY_CODE_NAME, CONFIG_REPOSITORY_CRS, CONFIG_TIMEOUT_FOR_RECEIVE_ELEMENTS, CONFIG_CHECKOUT_ALGORITHM, CONFIG_INDEX_GEOMETRIES, CONFIG_IDENTITY_CONTROLLER, "BUILDBOX2D_TRACES");
        this.code = vars.get(CONFIG_REPOSITORY_CODE_NAME);
        if (StringUtils.isBlank((CharSequence)this.code)) {
            throw new VCSGisRuntimeException(14, "The database can't have REPOSITORY_CODE variable.");
        }
        String timeout_s = vars.get(CONFIG_TIMEOUT_FOR_RECEIVE_ELEMENTS);
        this.timeout_for_receive_elements = 30000;
        if (StringUtils.isNotBlank((CharSequence)timeout_s)) {
            try {
                this.timeout_for_receive_elements = Integer.parseUnsignedInt(timeout_s);
            }
            catch (Exception ex) {
                LOGGER.warn("Invalid value (" + timeout_s + ") for " + CONFIG_TIMEOUT_FOR_RECEIVE_ELEMENTS + ".", (Throwable)ex);
            }
        }
        if (StringUtils.isBlank((CharSequence)(crs_s = vars.get(CONFIG_REPOSITORY_CRS)))) {
            throw new VCSGisRuntimeException(14, "The database can't have REPOSITORY_CRS variable.");
        }
        try {
            this.crs = CRSFactory.getCRS((String)crs_s);
        }
        catch (Throwable th) {
            throw new VCSGisRuntimeException(14, "Invalid REPOSITORY_CRS (" + crs_s + ").", th);
        }
        if (this.crs == null) {
            throw new VCSGisRuntimeException(14, "Invalid REPOSITORY_CRS (" + crs_s + ").");
        }
        String algorithm = this.getFirstID(vars, CONFIG_CHECKOUT_ALGORITHM, "USEDBFUNCTION", "USEDBFUNCTION", "USEAPPFILTER", "USESELECT");
        this.setProperty(CONFIG_CHECKOUT_ALGORITHM, algorithm);
        this.indexGeometries = Boolean.valueOf(this.getFirstID(vars, CONFIG_INDEX_GEOMETRIES, "false", "true", "false"));
        this.buildBox2D_traces = Boolean.valueOf(this.getFirstID(vars, "BUILDBOX2D_TRACES", "false", "true", "false"));
        this.identityControllerClassName = this.getFirstID(vars, CONFIG_IDENTITY_CONTROLLER, null, new String[0]);
        this.authenticationRequired = new CachedValue(3600000L, () -> Boolean.valueOf(varsTable.get(this, CONFIG_AUTHENTICATION_NAME)));
        this.authorizationRequired = new CachedValue(3600000L, () -> Boolean.valueOf(varsTable.get(this, CONFIG_AUTHORIZATION_NAME)));
    }

    private String getFirstID(Map<String, String> values, String name, String defaultValue, String ... availableValues) {
        String value = values.get(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = defaultValue;
        } else {
            Object[] x = StringUtils.split((String)value, (String)" ,;:()");
            if (ArrayUtils.isEmpty((Object[])x)) {
                value = defaultValue;
            } else {
                value = StringUtils.trimToNull((String)x[0]);
                if (value == null) {
                    value = defaultValue;
                }
            }
        }
        if (defaultValue == null && value == null) {
            return value;
        }
        if (availableValues != null) {
            boolean valid = false;
            for (String availableValue : availableValues) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)value, (CharSequence)availableValue)) continue;
                valid = true;
                value = availableValue;
                break;
            }
            if (!valid) {
                value = defaultValue;
                LOGGER.warn("Invalid value of config variable '" + name + "' (" + values.get(name) + ")");
            }
        }
        return value;
    }

    private void initialize(JDBCServerExplorerParameters serverParameters, VCSGisCodeGenerator codeGenerator, IProjection crs, boolean indexGeometries) {
        this.stores = null;
        this.codeGenerator = codeGenerator;
        this.serverParameters = serverParameters;
        DataManager dataManager = DALLocator.getDataManager();
        try {
            this.server = (JDBCServerExplorer)dataManager.openServerExplorer(serverParameters.getProviderName(), (DataServerExplorerParameters)serverParameters);
        }
        catch (Exception ex) {
            throw new VCSGisRuntimeException(14, "Can't open server explorer.");
        }
        String crsAbrev = "";
        if (crs != null) {
            crsAbrev = crs.getAbrev();
        }
        this.code = this.createUniqueCode();
        ConfigRepoTable varsTable = new ConfigRepoTable();
        varsTable.set(this, CONFIG_REPOSITORY_CODE_NAME, this.code);
        varsTable.set(this, CONFIG_AUTHENTICATION_NAME, "false");
        varsTable.set(this, CONFIG_AUTHORIZATION_NAME, "false");
        varsTable.set(this, CONFIG_PREPARED_WORKING_COPIES_FOLDER_NAME, "");
        varsTable.set(this, CONFIG_REPOSITORY_URL_NAME, "");
        varsTable.set(this, CONFIG_TRUSTED_CLIENT_IP_NAME, "");
        varsTable.set(this, CONFIG_REPOSITORY_CRS, crsAbrev);
        varsTable.set(this, CONFIG_CHECKOUT_ALGORITHM, VCSGisUtils.getSqlTemplate(this.server.getProviderName(), "defaultCheckoutMode", new Object[0]));
        varsTable.set(this, CONFIG_INDEX_GEOMETRIES, BooleanUtils.toStringTrueFalse((boolean)indexGeometries));
        varsTable.set(this, CONFIG_CHECKOUT_WITH_REVNUMBER, "false");
    }

    protected void doDispose() {
        if (this.stores != null) {
            for (FeatureStore store : this.stores.values()) {
                DisposeUtils.disposeQuietly((Disposable)store);
            }
            this.stores = null;
        }
        DisposeUtils.disposeQuietly((Disposable)this.server);
        this.server = null;
    }

    @Override
    public String getLabel() {
        return this.server.getParameters().getUrl();
    }

    @Override
    public String createUniqueCode() {
        return this.codeGenerator.generateCode();
    }

    public JDBCServerExplorer getServerExplorer() {
        return this.server;
    }

    public static void selfRegister() {
        Json.registerSerializer(VCSGisRepositoryLocaldbImpl.class);
    }

    public VCSGisCommitRequest createCommitRequest() {
        return new CommitRequestLocaldb(this);
    }

    public VCSGisUpdateRequest createUpdateRequest(String entityName) {
        return new UpdateRequestLocaldb(this, entityName);
    }

    public VCSGisCheckoutRequest createCheckoutRequest(String entityName) {
        return new CheckoutRequestLocaldb(this, entityName);
    }

    public void fromJson(JsonObject json) {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            DataServerExplorerParameters explorerParams = (DataServerExplorerParameters)Json.toObject((JsonObject)json, (String)"explorerParams");
            this.server = (JDBCServerExplorer)dataManager.openServerExplorer(explorerParams.getProviderName(), explorerParams);
            this.codeGenerator = VCSGisLocator.getVCSGisManager().getCodeGenerator();
            this.stores = new HashMap<String, FeatureStore>();
            this.code = json.getString("code", null);
            this.allowAssignTheRevisionDate = json.getBoolean("allowAssignTheRevisionDate", false);
            this.loadConfigTable();
            this.watchersNotifier = null;
            this.initIdentityController();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't restore repository from json object.", ex);
        }
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.add("explorerParams", (SupportToJson)this.server.getParameters());
        builder.add("code", this.code);
        builder.add("allowAssignTheRevisionDate", this.allowAssignTheRevisionDate);
        return builder;
    }

    public FeatureStore getFeatureStore(String tableName, boolean ignoreDalResource) {
        String key;
        FeatureStore store;
        if (this.stores == null) {
            this.stores = new HashMap<String, FeatureStore>();
        }
        if ((store = this.stores.get(key = tableName + "/" + ignoreDalResource)) == null) {
            store = this.openFeatureStore(tableName, null, ignoreDalResource);
            this.stores.put(key, store);
        }
        DisposeUtils.bind((Disposable)store);
        return store;
    }

    public FeatureStore openFeatureStore(String tableName, boolean ignoreDalResource) {
        return this.openFeatureStore(tableName, null, -1, ignoreDalResource);
    }

    public FeatureStore openFeatureStore(String tableName, String sql, boolean ignoreDalResource) {
        return this.openFeatureStore(tableName, sql, -1, ignoreDalResource);
    }

    public FeatureStore openFeatureStore(String tableName, String sql, int batchSize, boolean ignoreDalResource) {
        try {
            JDBCStoreParameters params = this.server.get(tableName);
            params = params.getCopy();
            params.setSQL(sql);
            if (batchSize >= 0) {
                params.setBatchSize(batchSize);
            }
            FeatureStore store = (FeatureStore)DALLocator.getDataManager().openStore(params.getProviderName(), (DataStoreParameters)params, ignoreDalResource);
            return store;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't open store '" + tableName + "'.", ex);
        }
    }

    public VCSGisEntitiesRequest createEntitiesRequest() {
        return new EntitiesRequestLocaldb(this);
    }

    public VCSGisListWCRequest createListWCRequest() {
        return new ListWCRequestLocaldb(this);
    }

    public VCSGisHistoryRequest createHistoryRequest(String entityName) {
        return new HistoryRequestLocaldb(this, entityName);
    }

    public VCSGisEntity getEntityByName(String entityName) {
        VCSGisEntitiesRequest request = this.createEntitiesRequest();
        if (request.execute() != 0) {
            return null;
        }
        for (VCSGisEntity repositoryEntity : request.getRepositoryEntities()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)repositoryEntity.getEntityName(), (CharSequence)entityName)) continue;
            return repositoryEntity;
        }
        return null;
    }

    public VCSGisRowCreateRequest createRowCreateRequest(String entityName, String localRevisionCode) {
        RowCreateRequestLocaldb request = new RowCreateRequestLocaldb(this, entityName, localRevisionCode);
        return request;
    }

    public VCSGisRowDeleteRequest createRowDeleteRequest(String entityName, String localRevisionCode) {
        RowDeleteRequestLocaldb request = new RowDeleteRequestLocaldb(this, entityName, localRevisionCode);
        return request;
    }

    public VCSGisRowUpdateRequest createRowUpdateRequest(String entityName, String localRevisionCode) {
        RowUpdateRequestLocaldb request = new RowUpdateRequestLocaldb(this, entityName, localRevisionCode);
        return request;
    }

    public VCSGisTopologyPlansRequest createTopologyPlansRequest() {
        TopologyPlansRequestLocaldb request = new TopologyPlansRequestLocaldb(this);
        return request;
    }

    public VCSGisUsersRequest createUsersRequest() {
        UsersRequestLocaldb request = new UsersRequestLocaldb(this);
        return request;
    }

    private HooksRepoTable.WatchersNotifier getWatchersNotifier() {
        if (this.watchersNotifier == null) {
            this.watchersNotifier = HooksRepoTable.createWatchersNotifier("DUMMY", this);
        }
        return this.watchersNotifier;
    }

    public void notifyWatchers(VCSGisRequest request) {
        this.getWatchersNotifier().notify(this.getUserCode(), request.getRequestName(), null, null);
    }

    public void notifyWatchers(VCSGisRequest request, String tableName, String revisionCode) {
        this.getWatchersNotifier().notify(this.getUserCode(), request.getRequestName(), tableName, revisionCode);
    }

    public boolean isAllowedToAssignTheRevisionDate() {
        return this.allowAssignTheRevisionDate;
    }

    public void setAllowAssignTheRevisionDate(boolean allowAssignTheRevisionDate) {
        this.allowAssignTheRevisionDate = allowAssignTheRevisionDate;
    }

    public VCSGisUser getUserByCode(String userCode) {
        try {
            UsersRepoTable users = new UsersRepoTable();
            UsersRepoTable.UserRepoRow theUser = users.getUserByCode(this, userCode);
            if (theUser == null && !this.isAuthenticationRequired()) {
                return VCSGisUser.GUEST;
            }
            return theUser;
        }
        catch (Exception ex) {
            LOGGER.trace("Can't retrieve user '" + userCode + "'.", (Throwable)ex);
            return null;
        }
    }

    public VCSGisUser getUserByName(String userName) {
        try {
            UsersRepoTable users = new UsersRepoTable();
            UsersRepoTable.UserRepoRow theUser = users.getUserById(this, userName);
            if (theUser == null && !this.isAuthenticationRequired()) {
                return VCSGisUser.GUEST;
            }
            return theUser;
        }
        catch (Exception ex) {
            LOGGER.trace("Can't retrieve user '" + userName + "'.", (Throwable)ex);
            return null;
        }
    }

    public Pair<String, VCSGisUser> getAuthenticationToken(String userid, String password, SupportError error) {
        return this.identityController.getAuthenticationToken(userid, password, error);
    }

    public Pair<String, VCSGisUser> getGuestAuthenticationToken() {
        return this.identityController.getGuestAuthenticationToken();
    }

    public boolean isAuthenticationRequired() {
        return (Boolean)this.authenticationRequired.get();
    }

    public boolean isAuthorizationRequired() {
        return (Boolean)this.authorizationRequired.get();
    }

    public int isAuthenticated(String userid, String authenticationToken, String operation, SupportError error) {
        return this.identityController.isAuthenticated(userid, authenticationToken, operation, error);
    }

    public int isAuthorized(String userid, String authenticationToken, String operation, SupportError error) {
        return this.identityController.isAuthorized(userid, authenticationToken, operation, error);
    }

    public boolean isAuthenticated(VCSGisRequest request) {
        int n = this.isAuthenticated(request.getUserCode(), request.getAuthenticationToken(), request.getRequestName(), (SupportError)request);
        return n == 0;
    }

    public boolean isAuthorized(VCSGisRequest request) {
        return this.isAuthorized(request, null);
    }

    public boolean isAuthorized(VCSGisRequest request, String operation) {
        int n;
        if (operation == null) {
            operation = request.getRequestName().toLowerCase();
        }
        return (n = this.isAuthorized(request.getUserCode(), request.getAuthenticationToken(), operation, (SupportError)request)) == 0;
    }

    public VCSGisAuthenticateRequest createAuthenticateRequest(String userName, String password) {
        AuthenticateRequestLocaldb request = new AuthenticateRequestLocaldb(this);
        request.setUserName(userName);
        request.setPassword(password);
        return request;
    }

    @Override
    public int getDataTableBatchSize() {
        if (this.dataTableBatchSize < 0) {
            ConfigRepoTable varsTable = new ConfigRepoTable();
            int n = -1;
            try {
                n = Integer.parseInt(varsTable.get(this, "DATA_TABLE_BATCH_SIZE"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n < 0) {
                n = 500;
            }
            this.dataTableBatchSize = n;
        }
        return this.dataTableBatchSize;
    }

    public VCSGisRowIsOutofdateRequest createRowIsOutofdatedRequest(String entityName, String localRevisionCode, String recordCode) {
        RowIsOutofdateRequestLocaldb req = new RowIsOutofdateRequestLocaldb(this, entityName, localRevisionCode, recordCode);
        return req;
    }

    public VCSGisPrepareWCRequest createPrepareWCRequest() {
        PrepareWCRequestLocaldb request = new PrepareWCRequestLocaldb(this);
        return request;
    }

    public VCSGisRevisionChangesRequest createRevisionChangesRequest(String entityName) {
        RevisionChangesRequestLocaldb request = new RevisionChangesRequestLocaldb(this, entityName);
        return request;
    }

    public VCSGisLogRequest createLogRequest(String entityName) {
        LogRequestLocaldb request = new LogRequestLocaldb(this, entityName);
        return request;
    }

    public File getWorkingCopiesFolder(SupportError error) {
        ConfigRepoTable configTable = new ConfigRepoTable();
        String folder_s = configTable.get(this, CONFIG_PREPARED_WORKING_COPIES_FOLDER_NAME);
        if (StringUtils.isBlank((CharSequence)folder_s)) {
            error.error(802);
            return null;
        }
        File folder = new File(folder_s);
        return folder;
    }

    public IProjection getCRS() {
        return CRSFactory.getCRS((String)"EPSG:25830");
    }

    public DataRepoTable getDataRepoTable(String dataTableName) {
        return new DataRepoTable(dataTableName, this.getCRS());
    }

    public long getTimeoutForReceiveElements() {
        return this.timeout_for_receive_elements;
    }

    public void setDataTableBatchSize(int dataTableBatchSize) {
        this.dataTableBatchSize = dataTableBatchSize;
    }

    public String sqldebug(String sql) throws SQLException {
        JDBCServerExplorer server = this.getServerExplorer();
        Object result = server.execute(sql);
        if (!(result instanceof ResultSet)) {
            String s = Objects.toString(result);
            System.out.println(s);
            return s;
        }
        StringBuilder lines = new StringBuilder();
        ResultSet rs = (ResultSet)result;
        ResultSetMetaData metadata = rs.getMetaData();
        while (rs.next()) {
            StringBuilder line = new StringBuilder();
            line.append("#");
            line.append(rs.getRow());
            line.append(":");
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                line.append(metadata.getColumnName(i));
                line.append("=");
                line.append(rs.getObject(i));
                line.append(",");
            }
            System.out.println(line.toString());
            if (lines.toString().length() >= 5120) continue;
            lines.append(line.toString());
            lines.append("\n");
        }
        rs.close();
        return lines.toString();
    }

    public boolean getIndexGeometries() {
        return this.indexGeometries;
    }

    public SQLBuilder getSQLBuilder() {
        if (this.sqlbuilder == null) {
            this.sqlbuilder = this.server.createSQLBuilder();
        }
        return this.sqlbuilder;
    }

    public void updateFeatureTypeOfEntity(String entity, FeatureType featureType) {
        EntitiesRepoTable entities = new EntitiesRepoTable();
        EntitiesRepoTable.EntityRepoRow e = entities.getByEntityCode(this, entity);
        if (e == null && (e = entities.getByEntityName(this, entity)) == null) {
            throw new IllegalArgumentException("Entity '" + entity + "' not found.");
        }
        e.setFeatureType(featureType);
        e.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntity(String entityCodeOrName) {
        DataManager dataManager = DALLocator.getDataManager();
        DataTransaction transaction = dataManager.createTransaction();
        try {
            EntitiesRepoTable entitiesTable = new EntitiesRepoTable();
            EntitiesRepoTable.EntityRepoRow entity = entitiesTable.getByEntityCode(this, entityCodeOrName);
            if (entity == null && (entity = entitiesTable.getByEntityName(this, entityCodeOrName)) == null) {
                LOGGER.warn("Can't find entity '" + entityCodeOrName + "' in repsitory '" + this.serverParameters.getUrl() + "'.");
                boolean bl = false;
                return bl;
            }
            transaction.begin();
            FeatureStore storeEntities = this.openFeatureStore("VCSGISREPO_ENTITIES", null, false);
            transaction.add((DataStore)storeEntities);
            storeEntities.edit(3);
            FeatureStore storeRevisions = this.openFeatureStore("VCSGISREPO_REVISIONS", null, false);
            transaction.add((DataStore)storeRevisions);
            storeRevisions.edit(3);
            FeatureStore storeData = this.openFeatureStore("VCSGISREPO_DATA", null, false);
            transaction.add((DataStore)storeData);
            storeData.edit(3);
            storeData.delete("COD_ENTITY = '" + entity.getEntityCode() + "'");
            storeRevisions.delete("COD_ENTITY = '" + entity.getEntityCode() + "'");
            storeEntities.delete("COD_ENTITY = '" + entity.getEntityCode() + "'");
            transaction.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't delete entity '" + entityCodeOrName + "' from repsitory '" + this.serverParameters.getUrl() + "'.", (Throwable)ex);
            DataTransaction.rollbackQuietly((DataTransaction)transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            DisposeUtils.dispose((Disposable)transaction);
        }
    }

    public void setWatchersNotifier(HooksRepoTable.WatchersNotifier watchersNotifier) {
        this.watchersNotifier = watchersNotifier;
    }

    public String getCode() {
        return this.code;
    }
}

