/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.tables;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.util.CachedValue;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.AbstractRepoTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HooksRepoTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HooksRepoTable.class);
    public static final String TABLE_NAME = "VCSGISREPO_HOOKS";
    public static final String COD_HOOK = "COD_HOOK";
    public static final String HOOK_OPERATION = "HOOK_OPERATION";
    public static final String HOOK_TYPE = "HOOK_TYPE";
    public static final String HOOK_COMMAND = "HOOK_COMMAND";
    public static final String CALLBACK_METHOD_DUMMY = "DUMMY";
    public static final String CALLBACK_METHOD_QUEUE = "USEQUEUE";
    public static final String CALLBACK_METHOD_EXECUTOR = "USEEXECUTOR";

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS Hooks");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.getTags().set("dynform.height", (Object)350);
        ft.getTags().set("dynform.width", (Object)500);
        ft.add(COD_HOOK, 8).setTag("dynform.readonly", (Object)true).setSize(60).setIsPrimaryKey(true).setLabel("Code").setReadOnly(false).setDefaultFieldValue((Object)"<%=replace(UUID(),'-','')%>");
        ft.add(HOOK_OPERATION, 8).setSize(50).setLabel("Operation").setHidden(true);
        ft.add(HOOK_TYPE, 4).setAllowNull(false).setLabel("Command type").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)0, "Cosa script"), new DynObjectValueItem((Object)1, "URL"), new DynObjectValueItem((Object)2, "Shell")}).setDefaultFieldValue((Object)1);
        ft.add(HOOK_COMMAND, 8).setDataProfileName("Text").setAllowNull(false).setSize(4096).setLabel("Command");
        return ft.getNotEditableCopy();
    }

    public static WatchersNotifier createWatchersNotifier(String method, VCSGisRepositoryLocaldb repo) {
        if (StringUtils.isBlank((CharSequence)method)) {
            method = CALLBACK_METHOD_DUMMY;
        }
        switch (method.toUpperCase()) {
            case "USEEXECUTOR": {
                return new WatchersNotifierExecutor(repo);
            }
            case "USEQUEUE": {
                return new WatchersNotifierQueue(repo);
            }
            default: {
                LOGGER.info("Invalid callback method '" + method + "', set dummy callback.");
            }
            case "DUMMY": 
        }
        return new WatchersNotifier(){

            @Override
            public void notify(String userCode, String requestName, String tableName, String revisionCode) {
                CallParameters data = new CallParameters(requestName, userCode, tableName, revisionCode);
                LOGGER.info("dummy notify (configure callback method?)" + data.toString());
            }

            @Override
            public void shutdown() {
            }
        };
    }

    private static class WatchersNotifierExecutor
    implements WatchersNotifier {
        private final WatchersNotifierHelper helper;
        private ExecutorService executor;

        private WatchersNotifierExecutor(VCSGisRepositoryLocaldb repo) {
            this.helper = new WatchersNotifierHelper(repo);
            this.executor = Executors.newFixedThreadPool(10);
        }

        @Override
        public void notify(String userCode, String requestName, String tableName, String revisionCode) {
            try {
                CallParameters data = new CallParameters(requestName, userCode, tableName, revisionCode);
                LOGGER.info("notify " + data.toString());
                this.executor.submit(() -> this.helper.callHooks(data));
            }
            catch (Exception ex) {
                LOGGER.warn("Can't execute post commit call.", (Throwable)ex);
            }
        }

        @Override
        public void shutdown() {
            this.executor.submit(() -> this.helper.shutdown());
            this.executor.shutdown();
            this.executor = null;
        }
    }

    private static class WatchersNotifierQueue
    extends Thread
    implements WatchersNotifier {
        private BlockingQueue<Message> calls = new ArrayBlockingQueue<Message>(1000, true);
        private WatchersNotifierHelper helper;
        private boolean need_start;

        public WatchersNotifierQueue(VCSGisRepositoryLocaldb repo) {
            super("VCSGis-RepositoryWatchersNotifier");
            this.helper = new WatchersNotifierHelper(repo);
            this.need_start = true;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        while (true) {
                            Message msg;
                            if (StringUtils.equalsIgnoreCase((CharSequence)(msg = this.calls.take()).getType(), (CharSequence)"notification")) {
                                CallParameters params = (CallParameters)msg.getBody();
                                this.helper.callHooks(params);
                                continue;
                            }
                            if (StringUtils.equalsIgnoreCase((CharSequence)msg.getType(), (CharSequence)"shutdown")) break;
                        }
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Can't call hooks.", (Throwable)ex);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.helper.shutdown();
                this.calls = null;
                this.helper = null;
            }
        }

        @Override
        public void notify(String userCode, String requestName, String tableName, String revisionCode) {
            if (this.calls == null) {
                return;
            }
            if (this.need_start) {
                this.start();
                this.need_start = false;
            }
            try {
                CallParameters data = new CallParameters(requestName, userCode, tableName, revisionCode);
                LOGGER.info("Queue a notification (" + data.toString() + ")");
                this.calls.put(new Message("notification", data));
            }
            catch (Exception ex) {
                LOGGER.warn("Can't enqueue post commit call.", (Throwable)ex);
            }
        }

        @Override
        public void shutdown() {
            try {
                this.calls.put(new Message("shutdown", null));
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Can't enqueue post cancellation call.", (Throwable)ex);
            }
        }

        private static class Message {
            private final String type;
            private final Object body;

            public Message(String type, Object body) {
                this.type = type;
                this.body = body;
            }

            public String getType() {
                return this.type;
            }

            public Object getBody() {
                return this.body;
            }
        }
    }

    private static class WatchersNotifierHelper {
        private VCSGisRepositoryLocaldbImpl repo;
        private final CachedValue<List<HooksRepoRow>> hooks;

        public WatchersNotifierHelper(final VCSGisRepositoryLocaldb repo) {
            this.repo = (VCSGisRepositoryLocaldbImpl)repo;
            DisposeUtils.bind((Disposable)this.repo);
            this.hooks = new CachedValue(60000L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void reload() {
                    if (repo == null) {
                        this.setValue(null);
                        return;
                    }
                    LOGGER.info("Reload hooks table");
                    ArrayList<HooksRepoRow> h = new ArrayList<HooksRepoRow>();
                    FeatureStore hooks = null;
                    DisposableFeatureSetIterable features = null;
                    try {
                        hooks = ((VCSGisRepositoryLocaldbImpl)repo).openFeatureStore(HooksRepoTable.TABLE_NAME, null, true);
                        features = hooks.getFeatureSet().iterable(true);
                        for (Feature f : features) {
                            h.add(new HooksRepoRow((VCSGisRepositoryLocaldbImpl)repo, f));
                        }
                    }
                    catch (DataException ex) {
                        try {
                            LOGGER.warn("Can't reaload hooks", (Throwable)ex);
                        }
                        catch (Throwable throwable) {
                            DisposeUtils.disposeQuietly(hooks);
                            DisposeUtils.disposeQuietly(features);
                            throw throwable;
                        }
                        DisposeUtils.disposeQuietly((Disposable)hooks);
                        DisposeUtils.disposeQuietly(features);
                        return;
                    }
                    DisposeUtils.disposeQuietly((Disposable)hooks);
                    DisposeUtils.disposeQuietly((Disposable)features);
                    this.setValue(h);
                }
            };
        }

        public void callHooks(CallParameters params) {
            if (params != null) {
                LOGGER.info("Process notification " + params.toString());
                for (HooksRepoRow hook : (List)this.hooks.get()) {
                    try {
                        hook.call(params.userCode, params.requestName, params.tableName, params.revisionCode);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't call hook '" + hook.getCode() + "'.", (Throwable)ex);
                    }
                }
            }
        }

        public void shutdown() {
            DisposeUtils.disposeQuietly((Disposable)this.repo);
            this.repo = null;
        }
    }

    public static interface WatchersNotifier {
        public void notify(String var1, String var2, String var3, String var4);

        public void shutdown();
    }

    private static class CallParameters {
        String requestName;
        String userCode;
        String tableName;
        String revisionCode;

        public CallParameters(String requestName, String userCode, String tableName, String revisionCode) {
            this.requestName = requestName;
            this.revisionCode = revisionCode;
            this.tableName = tableName;
            this.userCode = userCode;
        }

        public String toString() {
            ToStringBuilder x = new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE);
            x.append("requestName", (Object)this.requestName);
            x.append("tableName", (Object)this.tableName);
            x.append("revisionCode", (Object)this.revisionCode);
            x.append("userCode", (Object)this.userCode);
            return x.toString();
        }
    }

    public static class HooksRepoRow
    extends AbstractRepoTable.AbstractRow {
        public HooksRepoRow(VCSGisRepositoryLocaldbImpl repository) {
            super(repository, HooksRepoTable.TABLE_NAME, HooksRepoTable.COD_HOOK, null);
        }

        public HooksRepoRow(VCSGisRepositoryLocaldbImpl repository, Feature feature) {
            super(repository, HooksRepoTable.TABLE_NAME, HooksRepoTable.COD_HOOK, feature);
        }

        public String getOPeration() {
            return this.feature.getString(HooksRepoTable.HOOK_OPERATION);
        }

        public int getType() {
            return this.feature.getInt(HooksRepoTable.HOOK_TYPE);
        }

        public String getCommand() {
            return this.feature.getString(HooksRepoTable.HOOK_COMMAND);
        }

        private void call(String userCode, String requestName, String tableName, String revisionCode) {
            switch (this.getType()) {
                case 0: {
                    this.callCosa(userCode, requestName, tableName, revisionCode);
                    break;
                }
                case 1: {
                    this.callUrl(userCode, requestName, tableName, revisionCode);
                    break;
                }
                case 2: {
                    this.callCommand(userCode, requestName, tableName, revisionCode);
                    break;
                }
                default: {
                    LOGGER.warn("Hook type " + this.getType() + " not supported.");
                }
            }
        }

        private void callCosa(String userCode, String requestName, String tableName, String revisionCode) {
            MutableSymbolTable symboltable = ExpressionUtils.createSymbolTable();
            symboltable.setVar("USERCODE", (Object)userCode);
            symboltable.setVar("REQUESTNAME", (Object)requestName);
            symboltable.setVar("TABLENAME", (Object)tableName);
            symboltable.setVar("REVISIONCODE", (Object)revisionCode);
            ExpressionUtils.evaluate((SymbolTable)symboltable, (String)this.getCommand());
        }

        private void callUrl(String userCode, String requestName, String tableName, String revisionCode) {
            String url_s = this.getCommand();
            try {
                url_s = String.format(this.getCommand(), userCode, requestName, tableName, revisionCode);
                URL url = new URL(url_s);
                LOGGER.info("Call hook url " + url.toString());
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(30000);
                conn.setReadTimeout(30000);
                conn.connect();
                conn.getContent();
            }
            catch (Exception ex) {
                LOGGER.warn("Can't notify change (" + url_s + ").", (Throwable)ex);
            }
        }

        private void callCommand(String userCode, String requestName, String tableName, String revisionCode) {
            String cmd = this.getCommand();
            BufferedReader reader = null;
            try {
                String line;
                cmd = String.format(this.getCommand(), userCode, requestName, tableName, revisionCode);
                Process process = Runtime.getRuntime().exec(cmd);
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                }
                reader.close();
            }
            catch (Exception ex) {
                LOGGER.warn("Can't notify change (" + cmd + ").", (Throwable)ex);
                IOUtils.closeQuietly(reader);
            }
        }
    }
}

