/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.tables;

import java.sql.Timestamp;
import java.util.Date;
import javax.json.JsonObject;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.VCSGisRevisionImpl;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryRevision;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.AbstractRepoTable;

public class RevisionsRepoTable
extends AbstractRepoTable {
    public static final String TABLE_NAME = "VCSGISREPO_REVISIONS";
    public static final String COD_REVISION = "COD_REVISION";
    public static final String COD_USER = "COD_USER";
    public static final String COD_ENTITY = "COD_ENTITY";
    public static final String REVISION_NUMBER = "REV_NUMBER";
    public static final String REVISION_COMMENT = "REV_COMMENT";
    public static final String REVISION_EFECTIVEDATE = "REV_EFECTIVEDATE";
    public static final String REVISION_OPERATIONDATE = "REV_OPERATIONDATE";
    public static final String REVISION_TAGS = "REV_TAGS";
    public static final String REVISION_TOPOLOGYPLAN = "REV_TOPPLAN";
    public static final String REVISION_CHANGESCOUNT = "REV_CHANGESCOUNT";

    public RevisionsRepoTable() {
        super(TABLE_NAME, RevisionsRepoTable.featureType());
    }

    public RevisionRepoRow getByRevisionCode(VCSGisRepositoryLocaldbImpl repository, String revisionCode) {
        RevisionRepoRow revisionRepoRow;
        Feature f;
        FeatureStore store;
        block5: {
            store = null;
            store = repository.getFeatureStore(TABLE_NAME, true);
            f = store.findFirst("\"COD_REVISION\"='" + revisionCode + "'");
            if (f != null) break block5;
            RevisionRepoRow revisionRepoRow2 = null;
            DisposeUtils.disposeQuietly((Disposable)store);
            return revisionRepoRow2;
        }
        try {
            RevisionRepoRow row;
            revisionRepoRow = row = new RevisionRepoRow(repository, f);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve revision '" + revisionCode + "'.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return revisionRepoRow;
    }

    public RevisionRepoRow getLastRevisionOfEntity(VCSGisRepositoryLocaldbImpl repository, String entityCode) {
        RevisionRepoRow revisionRepoRow;
        Feature f;
        FeatureStore store;
        block5: {
            store = null;
            store = repository.getFeatureStore(TABLE_NAME, true);
            FeatureQuery query = store.createFeatureQuery("COD_ENTITY = '" + entityCode + "'", REVISION_NUMBER, false);
            f = store.findFirst(query);
            if (f != null) break block5;
            RevisionRepoRow revisionRepoRow2 = null;
            DisposeUtils.disposeQuietly((Disposable)store);
            return revisionRepoRow2;
        }
        try {
            RevisionRepoRow row;
            revisionRepoRow = row = new RevisionRepoRow(repository, f);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve last revision of entity '" + entityCode + "'.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return revisionRepoRow;
    }

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS Revisions");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.getTags().set("dynform.height", (Object)225);
        ft.getTags().set("dynform.width", (Object)570);
        ft.add(COD_REVISION, 8).setTag("dynform.readonly", (Object)true).setSize(60).setIsPrimaryKey(true).setLabel("Code").setReadOnly(false).setDefaultFieldValue((Object)"<%=replace(UUID(),'-','')%>");
        ft.add(COD_USER, 8).setForeingkey(true, false, "VCSGISREPO_USERS", COD_USER, "USER_ID").setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(60).setLabel("Cod. user");
        ft.add(COD_ENTITY, 8).setForeingkey(true, false, "VCSGISREPO_ENTITIES", COD_ENTITY, "ENT_NAME").setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(60).setLabel("Cod. entity");
        ft.add(REVISION_OPERATIONDATE, 11).setIsIndexed(true).setAllowIndexDuplicateds(true).setLabel("Revision date");
        ft.add(REVISION_EFECTIVEDATE, 11).setIsIndexed(true).setAllowIndexDuplicateds(true).setLabel("Efective Date");
        ft.add(REVISION_NUMBER, 5).setIsIndexed(true).setAllowIndexDuplicateds(false).setLabel("Revision number");
        ft.add(REVISION_TOPOLOGYPLAN, 4).setIsIndexed(false).setLabel("Topology plan").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)0, "Unknown"), new DynObjectValueItem((Object)1, "Passed"), new DynObjectValueItem((Object)2, "Not passed")});
        ft.add(REVISION_TAGS, 8).setSize(200).setLabel("Tags");
        ft.add(REVISION_COMMENT, 8).setDataProfileName("Text").setSize(500).setLabel("Comment");
        ft.add(REVISION_CHANGESCOUNT, 5).setIsIndexed(false).setLabel("Changes count");
        return ft.getNotEditableCopy();
    }

    public RevisionsRepoTable(String tableName, FeatureType featureType) {
        super(tableName, featureType);
    }

    public DisposableIterable<Feature> getRevisionsByDate(VCSGisRepositoryLocaldbImpl repository, String entityCode, Timestamp maxDate, Timestamp minDate, int maxNumberOfRevisions) {
        DisposableFeatureSetIterable disposableFeatureSetIterable;
        block5: {
            FeatureStore store = null;
            DisposableFeatureSetIterable features = null;
            try {
                ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(COD_ENTITY), (ExpressionBuilder.Value)builder.constant((Object)entityCode)));
                builder.and((ExpressionBuilder.Value)builder.ge((ExpressionBuilder.Value)builder.column(REVISION_OPERATIONDATE), (ExpressionBuilder.Value)builder.constant((Object)minDate)));
                builder.and((ExpressionBuilder.Value)builder.le((ExpressionBuilder.Value)builder.column(REVISION_OPERATIONDATE), (ExpressionBuilder.Value)builder.constant((Object)maxDate)));
                store = repository.openFeatureStore(TABLE_NAME, null, true);
                FeatureQuery query = store.createFeatureQuery(builder.toString(), REVISION_NUMBER, false);
                query.setLimit((long)maxNumberOfRevisions);
                FeatureSet fset = store.getFeatureSet(query);
                disposableFeatureSetIterable = features = fset.iterable();
                if (store == null) break block5;
            }
            catch (Exception ex) {
                try {
                    DisposeUtils.disposeQuietly(features);
                    throw new RuntimeException("Can't retrieve revisions of 'ENTITY[" + entityCode + "].", ex);
                }
                catch (Throwable throwable) {
                    if (store != null) {
                        DisposeUtils.dispose(store);
                    }
                    throw throwable;
                }
            }
            DisposeUtils.dispose((Disposable)store);
        }
        return disposableFeatureSetIterable;
    }

    public DisposableIterable<Feature> getRevisionsByRevisionNumber(VCSGisRepositoryLocaldbImpl repository, String entityCode, long maxRevisionNumber, long minRevisionNumber, int maxNumberOfRevisions) {
        DisposableFeatureSetIterable disposableFeatureSetIterable;
        block7: {
            FeatureStore store = null;
            DisposableFeatureSetIterable features = null;
            try {
                ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
                builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(COD_ENTITY), (ExpressionBuilder.Value)builder.constant((Object)entityCode)));
                if (minRevisionNumber >= 0L) {
                    builder.and((ExpressionBuilder.Value)builder.ge((ExpressionBuilder.Value)builder.column(REVISION_NUMBER), (ExpressionBuilder.Value)builder.constant((Object)minRevisionNumber)));
                }
                if (maxRevisionNumber >= 0L) {
                    builder.and((ExpressionBuilder.Value)builder.lt((ExpressionBuilder.Value)builder.column(REVISION_NUMBER), (ExpressionBuilder.Value)builder.constant((Object)maxRevisionNumber)));
                }
                store = repository.openFeatureStore(TABLE_NAME, null, true);
                FeatureQuery query = store.createFeatureQuery(builder.toString(), REVISION_NUMBER, false);
                query.setLimit((long)maxNumberOfRevisions);
                FeatureSet fset = store.getFeatureSet(query);
                disposableFeatureSetIterable = features = fset.iterable();
                if (store == null) break block7;
            }
            catch (Exception ex) {
                try {
                    DisposeUtils.disposeQuietly(features);
                    throw new RuntimeException("Can't retrieve revisions of 'ENTITY[" + entityCode + "].", ex);
                }
                catch (Throwable throwable) {
                    if (store != null) {
                        DisposeUtils.dispose(store);
                    }
                    throw throwable;
                }
            }
            DisposeUtils.dispose((Disposable)store);
        }
        return disposableFeatureSetIterable;
    }

    public long calculateNextRevisionNumber(FeatureStore store) {
        FeatureSet fset = null;
        try {
            fset = store.getFeatureSet();
            FeatureQuery query = store.createFeatureQuery();
            query.addAggregate("MAX", REVISION_NUMBER);
            Feature f = store.findFirst(query);
            int revnumber = 1;
            if (f != null && !f.isNull(REVISION_NUMBER)) {
                revnumber = f.getInt(REVISION_NUMBER) + 1;
            }
            long l = revnumber;
            return l;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't calculate revision number.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)fset);
        }
    }

    public static class RevisionRepoRow
    extends AbstractRepoTable.AbstractRow
    implements VCSGisRepositoryRevision {
        public RevisionRepoRow(VCSGisRepositoryLocaldbImpl repository) {
            super(repository, RevisionsRepoTable.TABLE_NAME, RevisionsRepoTable.COD_REVISION, null);
        }

        public RevisionRepoRow(VCSGisRepositoryLocaldbImpl repository, Feature feature) {
            super(repository, RevisionsRepoTable.TABLE_NAME, RevisionsRepoTable.COD_REVISION, feature);
        }

        public String getUserCode() {
            return this.feature.getString(RevisionsRepoTable.COD_USER);
        }

        public String getRevisionCode() {
            return this.getCode();
        }

        public String getEntityCode() {
            return this.feature.getString(RevisionsRepoTable.COD_ENTITY);
        }

        public Timestamp getRevisionDate() {
            return this.feature.getTimestamp(RevisionsRepoTable.REVISION_OPERATIONDATE);
        }

        public Timestamp getEfectiveDate() {
            return this.feature.getTimestamp(RevisionsRepoTable.REVISION_EFECTIVEDATE);
        }

        public String getTags() {
            return this.feature.getString(RevisionsRepoTable.REVISION_TAGS);
        }

        public long getNumber() {
            return this.feature.getLong(RevisionsRepoTable.REVISION_NUMBER);
        }

        public int getTopologyPlan() {
            return this.feature.getInt(RevisionsRepoTable.REVISION_TOPOLOGYPLAN);
        }

        public String getComment() {
            return this.feature.getString(RevisionsRepoTable.REVISION_COMMENT);
        }

        public void setUserCode(String code) {
            this.feature.set(RevisionsRepoTable.COD_USER, (Object)code);
        }

        public void setOperationDate(Timestamp date) {
            this.feature.set(RevisionsRepoTable.REVISION_OPERATIONDATE, (Object)date);
        }

        public void setEfectiveDate(Timestamp date) {
            this.feature.set(RevisionsRepoTable.REVISION_EFECTIVEDATE, (Object)date);
        }

        public void setRevisionDate(Date date) {
            this.feature.set(RevisionsRepoTable.REVISION_OPERATIONDATE, (Object)DataTypeUtils.toTimestamp((Date)date));
        }

        public void setEfectiveDate(Date date) {
            this.feature.set(RevisionsRepoTable.REVISION_EFECTIVEDATE, (Object)DataTypeUtils.toTimestamp((Date)date));
        }

        public void setTopologyPlan(int topologyPlan) {
            this.feature.set(RevisionsRepoTable.REVISION_TOPOLOGYPLAN, (Object)topologyPlan);
        }

        public void setTags(String tags) {
            this.feature.set(RevisionsRepoTable.REVISION_TAGS, (Object)tags);
        }

        public void setComment(String comment) {
            this.feature.set(RevisionsRepoTable.REVISION_COMMENT, (Object)comment);
        }

        public void setEntityCode(String code) {
            this.feature.set(RevisionsRepoTable.COD_ENTITY, (Object)code);
        }

        public void setRevisionNumber(long revnumber) {
            this.feature.set(RevisionsRepoTable.REVISION_NUMBER, (Object)revnumber);
        }

        public void setChangesCount(long count) {
            if (this.feature.hasValue(RevisionsRepoTable.REVISION_CHANGESCOUNT)) {
                this.feature.set(RevisionsRepoTable.REVISION_CHANGESCOUNT, (Object)count);
            }
        }

        public long getChangesCount() {
            if (this.feature.hasValue(RevisionsRepoTable.REVISION_CHANGESCOUNT)) {
                return this.feature.getLong(RevisionsRepoTable.REVISION_CHANGESCOUNT);
            }
            return 0L;
        }

        @Override
        public void insert(FeatureStore store) {
            super.insert(store);
        }

        public void copyFrom(VCSGisRevision other) {
            this.setCode(other.getRevisionCode());
            this.setComment(other.getComment());
            this.setEfectiveDate(other.getEfectiveDate());
            this.setEntityCode(other.getEntityCode());
            this.setRevisionDate(other.getRevisionDate());
            this.setTags(other.getTags());
            this.setUserCode(other.getUserCode());
            this.setChangesCount(other.getChangesCount());
        }

        public RevisionRepoRow getValue() {
            return this;
        }

        public String getLabel() {
            return VCSGisRevisionImpl.getLabel((VCSGisRevision)this);
        }

        public JsonObject toJson() {
            return this.toJsonBuilder().build();
        }

        public JsonObjectBuilder toJsonBuilder() {
            return VCSGisRevisionImpl.toJsonBuilder((VCSGisRevision)this);
        }

        public String toString() {
            return VCSGisRevisionImpl.toString((VCSGisRevision)this);
        }
    }
}

