/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.tables;

import java.security.MessageDigest;
import java.util.List;
import javax.json.JsonObject;
import org.apache.commons.codec.binary.Hex;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUserEditable;
import org.gvsig.vcsgis.lib.VCSGisUserImpl;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.AbstractRepoTable;

public class UsersRepoTable
extends AbstractRepoTable {
    public static final String TABLE_NAME = "VCSGISREPO_USERS";
    public static final String COD_USER = "COD_USER";
    public static final String USER_ID = "USER_ID";
    public static final String USER_PASSWORD = "USER_PASS";
    private static final String USER_ALLOWED_OPERATIONS = "USER_ALLOWEDOPERATIONS";
    private static final String USER_ROLES = "USER_ROLES";
    private static final String USER_DESCRIPTION = "USER_DESCRIPTION";

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS repository users");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.getTags().set("dynform.height", (Object)300);
        ft.getTags().set("dynform.width", (Object)570);
        ft.add(COD_USER, 8).setTag("dynform.readonly", (Object)true).setSize(60).setIsPrimaryKey(true).setLabel("Code").setReadOnly(false).setDefaultFieldValue((Object)"<%=replace(UUID(),'-','')%>").setHidden(true);
        ft.add(USER_ID, 8).setIsIndexed(true).setAllowIndexDuplicateds(false).setSize(50).setLabel("Identifier");
        ft.add(USER_PASSWORD, 8).setDataProfileName("Password").setIsIndexed(false).setAllowIndexDuplicateds(false).setSize(50).setLabel("Password");
        ft.add(USER_ALLOWED_OPERATIONS, 8).setDataProfileName("Text").setIsIndexed(false).setSize(200).setLabel("Allowed operations").setDefaultFieldValue((Object)"add,entities,commit,update,checkout,history,topologyplans,users,listwc").setDescription("Comma separated operation names without spaces (add,entities,commit,update,checkout,history,topologyplans,users,listwc,preparewc)");
        ft.add(USER_ROLES, 8).setDataProfileName("Text").setIsIndexed(false).setSize(200).setLabel("Roles").setDescription("Comma separated role names without spaces (admin,...)");
        ft.add(USER_DESCRIPTION, 8).setDataProfileName("Text").setSize(4096).setLabel("Description");
        ft.getAttributeDescriptor(USER_PASSWORD).getTags().set("dynform.password.crypt", (Object)"DES");
        return ft.getNotEditableCopy();
    }

    public UsersRepoTable() {
        super(TABLE_NAME, UsersRepoTable.featureType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRepoRow getUserById(VCSGisRepositoryLocaldb repo, String userId) {
        UserRepoRow userRepoRow;
        Feature f;
        FeatureStore store;
        block5: {
            store = null;
            store = repo.getFeatureStore(TABLE_NAME, true);
            f = store.findFirst("\"USER_ID\"='" + userId + "'");
            if (f != null) break block5;
            UserRepoRow userRepoRow2 = null;
            DisposeUtils.disposeQuietly((Disposable)store);
            return userRepoRow2;
        }
        try {
            userRepoRow = new UserRepoRow(repo, f);
        }
        catch (Exception ex) {
            UserRepoRow userRepoRow3;
            try {
                userRepoRow3 = null;
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)store);
            return userRepoRow3;
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return userRepoRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRepoRow getUserByCode(VCSGisRepositoryLocaldb repo, String userCode) {
        UserRepoRow userRepoRow;
        Feature f;
        FeatureStore store;
        block5: {
            store = null;
            store = repo.getFeatureStore(TABLE_NAME, true);
            f = store.findFirst("\"COD_USER\"='" + userCode + "'");
            if (f != null) break block5;
            UserRepoRow userRepoRow2 = null;
            DisposeUtils.disposeQuietly((Disposable)store);
            return userRepoRow2;
        }
        try {
            userRepoRow = new UserRepoRow(repo, f);
        }
        catch (Exception ex) {
            UserRepoRow userRepoRow3;
            try {
                userRepoRow3 = null;
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)store);
            return userRepoRow3;
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return userRepoRow;
    }

    public DisposableFeatureSetIterable getAll(VCSGisRepositoryLocaldb repository) {
        FeatureStore store = null;
        try {
            DisposableFeatureSetIterable changes;
            store = repository.getFeatureStore(TABLE_NAME, true);
            DisposableFeatureSetIterable disposableFeatureSetIterable = changes = store.getFeatureSet().iterable();
            return disposableFeatureSetIterable;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve all users.", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public String getHashCode(VCSGisRepositoryLocaldbImpl repository) {
        String string;
        FeatureStore store = null;
        DisposableFeatureSetIterable changes = null;
        try {
            String hash;
            MessageDigest md = MessageDigest.getInstance("MD5");
            store = repository.getFeatureStore(TABLE_NAME, true);
            changes = store.getFeatureSet().iterable();
            for (Feature change : changes) {
                VCSGisUtils.updateMessageDigest(md, change, COD_USER);
                VCSGisUtils.updateMessageDigest(md, change, USER_ID);
                VCSGisUtils.updateMessageDigest(md, change, USER_ALLOWED_OPERATIONS);
                VCSGisUtils.updateMessageDigest(md, change, USER_ROLES);
                VCSGisUtils.updateMessageDigest(md, change, USER_DESCRIPTION);
            }
            string = hash = Hex.encodeHexString((byte[])md.digest());
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve hash of users.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.dispose(changes);
                DisposeUtils.dispose(store);
                throw throwable;
            }
        }
        DisposeUtils.dispose((Disposable)changes);
        DisposeUtils.dispose((Disposable)store);
        return string;
    }

    public static class UserRepoRow
    extends AbstractRepoTable.AbstractRow
    implements VCSGisUserEditable {
        private List<String> operations_list;
        private List<String> roles_list;

        public UserRepoRow(VCSGisRepositoryLocaldb repository) {
            super(repository, UsersRepoTable.TABLE_NAME, UsersRepoTable.COD_USER, null);
        }

        public UserRepoRow(VCSGisRepositoryLocaldb repository, Feature feature) {
            super(repository, UsersRepoTable.TABLE_NAME, UsersRepoTable.COD_USER, feature);
        }

        public String getUserCode() {
            return this.getString(UsersRepoTable.COD_USER);
        }

        public String getIdentifier() {
            return this.getString(UsersRepoTable.USER_ID);
        }

        public String getPassword() {
            return this.getString(UsersRepoTable.USER_PASSWORD);
        }

        public String getDescription() {
            return this.getString(UsersRepoTable.USER_DESCRIPTION);
        }

        public String getAllowedOperations() {
            return this.getString(UsersRepoTable.USER_ALLOWED_OPERATIONS);
        }

        @Override
        public void setUserCode(String userCode) {
            this.set(UsersRepoTable.COD_USER, userCode);
        }

        public void setPassword(String password) {
            this.set(UsersRepoTable.USER_PASSWORD, password);
        }

        @Override
        public void setAllowedOperations(String operations) {
            this.set(UsersRepoTable.USER_ALLOWED_OPERATIONS, operations);
        }

        @Override
        public void setDescription(String description) {
            this.set(UsersRepoTable.USER_DESCRIPTION, description);
        }

        @Override
        public void setIdentifier(String identifier) {
            this.set(UsersRepoTable.USER_ID, identifier);
        }

        @Override
        public void copy(VCSGisUser source, VCSGisUser target) {
            VCSGisUserImpl.copyUser(source, (VCSGisUserEditable)target);
        }

        @Override
        public VCSGisUser clone() {
            try {
                VCSGisUserEditable other = (VCSGisUserEditable)super.clone();
                VCSGisUserImpl.copyUser(this, other);
                return other;
            }
            catch (CloneNotSupportedException ex) {
                return null;
            }
        }

        public void copyFrom(VCSGisUser other) {
            VCSGisUserImpl.copyUser(other, this);
        }

        public List<String> getAllowedOperationsAsList() {
            if (this.operations_list == null) {
                this.operations_list = VCSGisUserImpl.getAllowedOperationsAsList(this);
            }
            return this.operations_list;
        }

        public boolean isAllowedOperation(String operation) {
            return VCSGisUserImpl.isAllowedOperation(this, operation);
        }

        public void fromJson(JsonObject json) {
            VCSGisUserImpl.fromJson(this, json);
        }

        public JsonObject toJson() {
            return this.toJsonBuilder().build();
        }

        public JsonObjectBuilder toJsonBuilder() {
            return VCSGisUserImpl.toJsonBuilder(this);
        }

        public String toString() {
            return VCSGisUserImpl.toString(this);
        }

        public String getRoles() {
            return this.getString(UsersRepoTable.USER_ROLES);
        }

        public List<String> getRolesAsList() {
            if (this.roles_list == null) {
                this.roles_list = VCSGisUserImpl.getRolesAsList(this);
            }
            return this.roles_list;
        }

        @Override
        public void setRoles(String roles) {
            this.set(UsersRepoTable.USER_ROLES, roles);
        }
    }
}

