/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.Objects;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.commons.io.IOUtils;
import org.gvsig.json.Json;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.vcsgis.lib.PipedIterator;
import org.gvsig.vcsgis.lib.SAJParserImpl;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.VCSGisRevisionImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisHistoryRequest;
import org.gvsig.vcsgis.lib.requests.HistoryRequestHelper;

public class HistoryRequestClient
extends AbstractRequestClient
implements VCSGisHistoryRequest {
    public HistoryRequestClient(VCSGisRepositoryClientImpl repository, String entityName) {
        super(new HistoryRequestHelper(repository, entityName), "history");
    }

    @Override
    public HistoryRequestHelper helper() {
        return (HistoryRequestHelper)super.helper();
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public DisposableIterable<VCSGisRevision> getRevisions() {
        return this.helper().getRevisions();
    }

    public int requestDataProducer(OutputStream outputData) {
        return this.error(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestProducer(Writer outputData) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 1");
            org.gvsig.json.JsonObjectBuilder parametersBuilder = Json.createObjectBuilder();
            parametersBuilder.add("EntityName", this.getEntityName());
            parametersBuilder.add("MaxDate", Objects.toString(this.getMaxDate(), null));
            parametersBuilder.add("MinDate", Objects.toString(this.getMinDate(), null));
            parametersBuilder.add("MaxRevisionNumber", this.getMaxRevisionNumber());
            parametersBuilder.add("MinRevisionNumber", this.getMinRevisionNumber());
            parametersBuilder.add("MaxNumberOfRevisions", this.helper().maxNumberOfRevisions);
            org.gvsig.json.JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("Parameters", (JsonObjectBuilder)parametersBuilder);
            IOUtils.write((String)builder.toString(), (Writer)outputData);
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't produce Json data for " + this.getRequestName() + ".", (Throwable)ex);
            this.error(600, "Can't produce Json data for " + this.getRequestName() + ". " + ex.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Writer)outputData);
        }
    }

    @Override
    public void responseConsumer(BufferedReader inputData) {
        LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 1");
        PipedIterator<VCSGisRevision> dataIterator = new PipedIterator<VCSGisRevision>(this.getRepository().getTimeoutForReceiveElements());
        this.helper().revisions = dataIterator;
        LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 2");
        SAJParserImpl parser = new SAJParserImpl(inputData, (context, e, value) -> {
            if (e == null) {
                return;
            }
            switch (e) {
                case END_OBJECT: {
                    switch (context.getPathName()) {
                        case "/Parameters": {
                            JsonObject jsonParams = ((JsonObjectBuilder)value).build();
                            this.helper().error(jsonParams.getInt("StatusCode", 0), jsonParams.getString("StatusMessage", null));
                            this.notifyResponseConsumers();
                            break;
                        }
                        case "/Data/?": {
                            JsonObject jsonData = ((JsonObjectBuilder)value).build();
                            VCSGisRevisionImpl revision = new VCSGisRevisionImpl(jsonData);
                            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer data = " + jsonData.toString());
                            dataIterator.put(revision);
                        }
                    }
                    break;
                }
                case END_ARRAY: {
                    if (!"/Data".equals(context.getPathName())) break;
                    dataIterator.close();
                    break;
                }
                case START_ARRAY: {
                    switch (context.getPathName()) {
                        case "/Data": {
                            context.setArrayBuilder(null);
                        }
                    }
                }
            }
        });
        parser.parse();
        LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 3 (parse)");
        IOUtils.closeQuietly((Reader)inputData);
    }

    public Timestamp getMinDate() {
        return this.helper().getMinDate();
    }

    public Timestamp getMaxDate() {
        return this.helper().getMaxDate();
    }

    public long getMinRevisionNumber() {
        return this.helper().getMinRevisionNumber();
    }

    public long getMaxRevisionNumber() {
        return this.helper().getMaxRevisionNumber();
    }

    public void setDateRange(Timestamp min, Timestamp max) {
        this.helper().setDateRange(min, max);
    }

    public void setRevisionNumberRange(long min, long max) {
        this.helper().setRevisionNumberRange(min, max);
    }

    public void setMaxNumberOfRevisions(int maxNumberOfRevisions) {
        this.helper().setMaxNumberOfRevisions(maxNumberOfRevisions);
    }
}

