/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Writer;
import javax.json.JsonObject;
import org.apache.commons.io.IOUtils;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.vcsgis.lib.PipedIterator;
import org.gvsig.vcsgis.lib.SAJParserImpl;
import org.gvsig.vcsgis.lib.VCSGisRepositoryLogDataImpl;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLogData;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisLogRequest;
import org.gvsig.vcsgis.lib.requests.LogRequestHelper;

public class LogRequestClient
extends AbstractRequestClient
implements VCSGisLogRequest {
    public LogRequestClient(VCSGisRepositoryClientImpl repository, String entityName) {
        super(new LogRequestHelper(repository, entityName), "update");
    }

    @Override
    public LogRequestHelper helper() {
        return (LogRequestHelper)super.helper();
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public String getFeatureRelatedCode() {
        return this.helper().getFeatureRelatedCode();
    }

    public void setFeatureRelatedCode(String featureRelatedCode) {
        this.helper().setFeatureRelatedCode(featureRelatedCode);
    }

    public DisposableIterable<VCSGisRepositoryLogData> getData() {
        return this.helper().getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestProducer(Writer out) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] requestProducer 1");
            JsonObjectBuilder parametersBuilder = Json.createObjectBuilder();
            parametersBuilder.add("EntityName", this.getEntityName());
            parametersBuilder.add("FeatureRelatedCode", this.getFeatureRelatedCode());
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("Parameters", (javax.json.JsonObjectBuilder)parametersBuilder);
            IOUtils.write((String)builder.toString(), (Writer)out);
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't produce Json data for " + this.getRequestName() + " request.", (Throwable)ex);
            this.error(600, "Can't produce Json data for " + this.getRequestName() + " request. " + ex.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    @Override
    public void responseConsumer(BufferedReader request_contents) {
        LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 1");
        PipedIterator<VCSGisRepositoryLogData> dataIterator = new PipedIterator<VCSGisRepositoryLogData>(this.getRepository().getTimeoutForReceiveElements());
        this.helper().data = dataIterator;
        LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer 2");
        SAJParserImpl parser = new SAJParserImpl(request_contents, (context, e, value) -> {
            if (e == null) {
                return;
            }
            switch (e) {
                case END_OBJECT: {
                    switch (context.getPathName()) {
                        case "/Parameters": {
                            JsonObject jsonParams = ((javax.json.JsonObjectBuilder)value).build();
                            this.helper().error(jsonParams.getInt("StatusCode", 0), jsonParams.getString("StatusMessage", null));
                            this.helper().entityName = jsonParams.getString("EntityName", null);
                            this.notifyResponseConsumers();
                            break;
                        }
                        case "/Data/?": {
                            JsonObject jsonData = ((javax.json.JsonObjectBuilder)value).build();
                            VCSGisRepositoryLogDataImpl data = new VCSGisRepositoryLogDataImpl(jsonData);
                            dataIterator.put(data);
                        }
                    }
                    break;
                }
                case END_ARRAY: {
                    if (!"/Data".equals(context.getPathName())) break;
                    dataIterator.close();
                    break;
                }
                case START_ARRAY: {
                    switch (context.getPathName()) {
                        case "/Data": {
                            context.setArrayBuilder(null);
                        }
                    }
                }
            }
        });
        parser.parse();
    }
}

