/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlan;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanImpl;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisTopologyPlansRequest;
import org.gvsig.vcsgis.lib.requests.TopologyPlansRequestHelper;

public class TopologyPlansRequestClient
extends AbstractRequestClient
implements VCSGisTopologyPlansRequest {
    public TopologyPlansRequestClient(VCSGisRepositoryClientImpl repository) {
        super(new TopologyPlansRequestHelper(repository), "topologyplans");
    }

    @Override
    public TopologyPlansRequestHelper helper() {
        return (TopologyPlansRequestHelper)super.helper();
    }

    public List<VCSGisTopologyPlan> getTopologyPlans() {
        return this.helper().getTopologyPlans();
    }

    @Override
    public void requestProducer(Writer out) {
        this.error(0);
    }

    @Override
    public void responseConsumer(BufferedReader inputData) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer");
            ArrayList<VCSGisTopologyPlan> theTopologyPlans = new ArrayList<VCSGisTopologyPlan>();
            JsonReader reader = Json.createReader((Reader)inputData);
            JsonObject jsonResponse = reader.readObject();
            JsonObject jsonParameters = jsonResponse.getJsonObject("Parameters");
            int statusCode = jsonParameters.getInt("StatusCode", 31);
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer status code " + statusCode);
            if (statusCode != 0) {
                this.error(statusCode, jsonParameters.getString("StatusMessage", VCSGisUtils.getErrorMessage(statusCode)));
                return;
            }
            this.cleanLastError();
            JsonArray jsonTopologyPlans = jsonResponse.getJsonArray("TopologyPlans");
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer TopologyPlans " + jsonTopologyPlans.size());
            for (JsonValue x : jsonTopologyPlans) {
                VCSGisTopologyPlanImpl topologyPlan = new VCSGisTopologyPlanImpl((JsonObject)x);
                LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer TopologyPlans " + topologyPlan.getName());
                theTopologyPlans.add(topologyPlan);
            }
            this.helper().topologyplans = theTopologyPlans;
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer ok");
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve topology plans from '" + this.getRequestUrl() + "'.", (Throwable)ex);
            this.error(31, "Can't retrieve topology plans from '" + this.getRequestUrl() + "'.");
        }
    }
}

