/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.requests;

import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLogData;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisLogRequest;
import org.gvsig.vcsgis.lib.requests.AbstractRequestHelper;

public class LogRequestHelper
extends AbstractRequestHelper
implements VCSGisLogRequest {
    private static final String REQUEST_NAME = "Log";
    public String entityName;
    public String featureRelatedCode;
    public DisposableIterable<VCSGisRepositoryLogData> data;

    public LogRequestHelper(VCSGisRepository repository, String entityName) {
        super(repository, REQUEST_NAME);
        this.entityName = entityName;
        this.featureRelatedCode = null;
        this.data = null;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public DisposableIterable<VCSGisRepositoryLogData> getData() {
        if (this.data == null) {
            throw new IllegalStateException("The request needs to be executed before calling this method.");
        }
        return this.data;
    }

    @Override
    public void dispose() {
        super.dispose();
        DisposeUtils.disposeQuietly(this.data);
        this.data = null;
        this.entityName = null;
        this.featureRelatedCode = null;
    }

    public void setFeatureRelatedCode(String featureRelatedCode) {
        this.featureRelatedCode = featureRelatedCode;
    }

    public String getFeatureRelatedCode() {
        return this.featureRelatedCode;
    }
}

