/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server;

import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.server.VCSGisServerController;
import org.gvsig.vcsgis.lib.server.VCSGisServerHandler;
import org.gvsig.vcsgis.lib.server.handlers.AuthenticateHandler;
import org.gvsig.vcsgis.lib.server.handlers.CheckoutHandler;
import org.gvsig.vcsgis.lib.server.handlers.CommitHandler;
import org.gvsig.vcsgis.lib.server.handlers.EntitiesHandler;
import org.gvsig.vcsgis.lib.server.handlers.HistoryHandler;
import org.gvsig.vcsgis.lib.server.handlers.ListWCHandler;
import org.gvsig.vcsgis.lib.server.handlers.LogHandler;
import org.gvsig.vcsgis.lib.server.handlers.PrepareWCHandler;
import org.gvsig.vcsgis.lib.server.handlers.RevisionChangesHandler;
import org.gvsig.vcsgis.lib.server.handlers.RowCreateHandler;
import org.gvsig.vcsgis.lib.server.handlers.RowDeleteHandler;
import org.gvsig.vcsgis.lib.server.handlers.RowIsOutofdateHandler;
import org.gvsig.vcsgis.lib.server.handlers.RowUpdateHandler;
import org.gvsig.vcsgis.lib.server.handlers.TopologyPlansHandler;
import org.gvsig.vcsgis.lib.server.handlers.UpdateHandler;
import org.gvsig.vcsgis.lib.server.handlers.UsersHandler;

public class VCSGisServerControllerImpl
extends AbstractDisposable
implements VCSGisServerController {
    private VCSGisRepository repository;

    public VCSGisServerControllerImpl(VCSGisRepository repository) {
        this.repository = repository;
        DisposeUtils.bind((Disposable)this.repository);
    }

    protected void doDispose() {
        DisposeUtils.disposeQuietly((Disposable)this.repository);
        this.repository = null;
    }

    public VCSGisRepository getRepository() {
        return this.repository;
    }

    public VCSGisServerHandler createEntitiesHandler() {
        EntitiesHandler handler = new EntitiesHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createListWCHandler() {
        ListWCHandler handler = new ListWCHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createPrepareWCHandler() {
        PrepareWCHandler handler = new PrepareWCHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createCommitHandler() {
        CommitHandler handler = new CommitHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createUpdateHandler() {
        UpdateHandler handler = new UpdateHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createRevisionChangesHandler() {
        RevisionChangesHandler handler = new RevisionChangesHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createCheckoutHandler() {
        CheckoutHandler handler = new CheckoutHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createHistoryHandler() {
        HistoryHandler handler = new HistoryHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createRowCreateHandler() {
        RowCreateHandler handler = new RowCreateHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createRowUpdateHandler() {
        RowUpdateHandler handler = new RowUpdateHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createRowDeleteHandler() {
        RowDeleteHandler handler = new RowDeleteHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createRowIsOutofdateHandler() {
        RowIsOutofdateHandler handler = new RowIsOutofdateHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createUsersHandler() {
        UsersHandler handler = new UsersHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createTopologyPlansHandler() {
        TopologyPlansHandler handler = new TopologyPlansHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createAuthenticateHandler() {
        AuthenticateHandler handler = new AuthenticateHandler(this.repository);
        return handler;
    }

    public VCSGisServerHandler createLogHandler() {
        LogHandler handler = new LogHandler(this.repository);
        return handler;
    }
}

