/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.json.Json;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCheckoutRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class CheckoutHandler
extends AbstractVCSGisServertHandler {
    public CheckoutHandler(VCSGisRepository repository) {
        super(repository, "CheckoutHandler");
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        JsonObject jsonParameters = null;
        try {
            JsonReader reader = Json.createReader((Reader)request_contents);
            JsonObject jsonRequest = reader.readObject();
            jsonParameters = jsonRequest.getJsonObject("Parameters");
        }
        catch (JsonException reader) {
            // empty catch block
        }
        String entityName = params.get("EntityName");
        if (jsonParameters != null) {
            entityName = jsonParameters.getString("EntityName", entityName);
        }
        VCSGisCheckoutRequest request = this.getRepository().createCheckoutRequest(entityName);
        request.setAuthenticationTokenAndUser(params);
        if (jsonParameters == null) {
            request.setEfectiveDate(params.get("EfectiveDate"));
            request.setRevisionCode(params.get("RevisionCode"));
        } else {
            request.setEfectiveDate(jsonParameters.getString("EfectiveDate", params.get("EfectiveDate")));
            request.setRevisionCode(jsonParameters.getString("RevisionCode", params.get("RevisionCode")));
        }
        String roi_hexwkb = params.get("ROI");
        if (jsonParameters != null) {
            roi_hexwkb = jsonParameters.getString("ROI", null);
        }
        String roi_proj = params.get("ROIProjection");
        if (jsonParameters != null) {
            roi_proj = jsonParameters.getString("ROIProjection", null);
        }
        if (StringUtils.isNotBlank((CharSequence)roi_hexwkb)) {
            try {
                Geometry roi = GeometryLocator.getGeometryManager().createFrom(roi_hexwkb);
                if (StringUtils.isNotBlank((CharSequence)roi_proj)) {
                    IProjection proj = CRSFactory.getCRS((String)roi_proj);
                    roi.setProjection(proj);
                }
                request.setROI(roi.getEnvelope());
            }
            catch (GeometryException ex) {
                throw new RuntimeException("Can't parse roi (" + roi_hexwkb + ").", ex);
            }
        }
        req.setValue((Object)request);
        this.notifyRequestConsumers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        VCSGisCheckoutRequest request = (VCSGisCheckoutRequest)req;
        JsonGenerator gen = null;
        try {
            boolean use_revision_number = false;
            try {
                if (this.getRepository() instanceof VCSGisRepositoryLocaldb) {
                    VCSGisRepositoryLocaldb repo = (VCSGisRepositoryLocaldb)this.getRepository();
                    String use_revision_number_s = repo.getConfigValue("CHECKOUT_WITH_REVNUMBER");
                    use_revision_number = BooleanUtils.toBoolean((String)use_revision_number_s);
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Can't retrieve use_revision_number value", (Throwable)ex);
            }
            JsonGeneratorFactory genFactory = Json.createGeneratorFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
            gen = genFactory.createGenerator(response_contents);
            gen.writeStartObject();
            gen.writeStartObject("Parameters");
            gen.write("StatusCode", request.getLastErrorCode());
            this.notifyResponseConsumers();
            gen.flush();
            if (StringUtils.isBlank((CharSequence)request.getLastErrorMessage())) {
                gen.writeNull("StatusMessage");
            } else {
                gen.write("StatusMessage", request.getLastErrorMessage());
            }
            gen.write("Entity", (JsonValue)request.getEntity().toJson());
            gen.write("UsershashCode", request.getUsersHashCode());
            gen.write("TopologyPlansHashCode", request.getTopologyPlansHashCode());
            gen.writeEnd();
            gen.writeStartArray("Data");
            for (VCSGisRepositoryData data : request.getData()) {
                gen.writeStartObject();
                gen.write("DataCode", data.getDataCode());
                gen.write("Data", data.getData());
                if (use_revision_number) {
                    gen.write("RevisionNumber", data.getRevisionNumber());
                }
                gen.writeEnd();
                gen.flush();
            }
            gen.writeEnd();
            gen.writeEnd();
            gen.flush();
            response_contents.flush();
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't produce Json data for " + this.getName() + " response.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gen);
                gen.close();
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)gen);
            gen.close();
        }
        IOUtils.closeQuietly((Closeable)gen);
        gen.close();
    }
}

