/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.json.Json;
import org.gvsig.vcsgis.lib.ChangeImpl;
import org.gvsig.vcsgis.lib.PipedIterator;
import org.gvsig.vcsgis.lib.SAJParserImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisEntityEditable;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanStatus;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanStatusImpl;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCommitRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntityImpl;

public class CommitHandler
extends AbstractVCSGisServertHandler {
    public CommitHandler(VCSGisRepository repository) {
        super(repository, "CommitHandler");
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 1");
        final PipedIterator changesIterator = new PipedIterator(this.getRepository().getTimeoutForReceiveElements());
        final VCSGisCommitRequest request = this.getRepository().createCommitRequest();
        request.setAuthenticationTokenAndUser(params);
        request.add(changesIterator);
        req.setValue((Object)request);
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 2");
        SAJParserImpl parser = new SAJParserImpl(request_contents, new SAJParserImpl.SAJParserHandler(){

            @Override
            public void handle(SAJParserImpl.SAJParserContext context, JsonParser.Event e, Object value) {
                if (e == null) {
                    return;
                }
                switch (e) {
                    case END_OBJECT: {
                        switch (context.getPathName()) {
                            case "/Parameters": {
                                JsonObject jsonParams = ((JsonObjectBuilder)value).build();
                                if (jsonParams.isNull("EfectiveDate")) {
                                    request.setEfectiveDate(null);
                                } else {
                                    request.setEfectiveDate(Timestamp.valueOf(jsonParams.getString("EfectiveDate")));
                                }
                                if (jsonParams.isNull("RevisionDate")) {
                                    request.setRevisionDate(null);
                                } else {
                                    request.setRevisionDate(Timestamp.valueOf(jsonParams.getString("RevisionDate")));
                                }
                                if (jsonParams.isNull("Comment")) {
                                    request.setComment(null);
                                } else {
                                    request.setComment(jsonParams.getString("Comment"));
                                }
                                if (!jsonParams.isNull("Entities")) {
                                    for (JsonValue jsonvEntity : jsonParams.getJsonArray("Entities")) {
                                        VCSGisWorkspaceEntityImpl entity = new VCSGisWorkspaceEntityImpl((JsonObject)jsonvEntity);
                                        request.add((VCSGisWorkspaceEntity)entity);
                                    }
                                }
                                if (!jsonParams.isNull("NewEntityCodes")) {
                                    for (JsonValue jsonvEntityCode : jsonParams.getJsonArray("NewEntityCodes")) {
                                        request.markAsNew(((JsonString)jsonvEntityCode).getString());
                                    }
                                }
                                if (jsonParams.containsKey((Object)"TopologyPlans") && !jsonParams.isNull("TopologyPlans")) {
                                    for (JsonValue jsonTopologyPlanStatus : jsonParams.getJsonArray("TopologyPlans")) {
                                        VCSGisTopologyPlanStatusImpl planStatus = new VCSGisTopologyPlanStatusImpl((JsonObject)jsonTopologyPlanStatus);
                                        request.add((VCSGisTopologyPlanStatus)planStatus);
                                    }
                                }
                                CommitHandler.this.notifyRequestConsumers();
                                break;
                            }
                            case "/Data/?": {
                                JsonObject jsonChange = ((JsonObjectBuilder)value).build();
                                ChangeImpl change = new ChangeImpl(jsonChange);
                                changesIterator.put(change);
                            }
                        }
                        break;
                    }
                    case END_ARRAY: {
                        if (!"/Data".equals(context.getPathName())) break;
                        changesIterator.close();
                        break;
                    }
                    case START_ARRAY: {
                        switch (context.getPathName()) {
                            case "/Data": {
                                context.setArrayBuilder(null);
                            }
                        }
                        break;
                    }
                    case START_OBJECT: {
                        switch (context.getPathName()) {
                            default: 
                        }
                        break;
                    }
                }
            }
        });
        parser.parse();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 3 notifyRequestConsumers");
        this.notifyRequestConsumers();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 4 return");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] responseProducer 1");
        VCSGisCommitRequest request = (VCSGisCommitRequest)req;
        try {
            org.gvsig.json.JsonObjectBuilder builder = Json.createObjectBuilder();
            org.gvsig.json.JsonObjectBuilder jsonParams = Json.createObjectBuilder();
            jsonParams.add("StatusCode", request.getLastErrorCode());
            jsonParams.add("StatusMessage", request.getLastErrorMessage());
            org.gvsig.json.JsonArrayBuilder jsonEntities = Json.createArrayBuilder();
            for (VCSGisEntityEditable entity : request.getChangedLocalEntities()) {
                JsonObject jsonEntity = VCSGisUtils.toJsonBuilder((VCSGisEntity)entity, t -> StringUtils.equalsIgnoreCase((CharSequence)t, (CharSequence)"FeatureTypeAsJson")).build();
                jsonEntities.add(jsonEntity);
            }
            jsonParams.add("Entities", (JsonArrayBuilder)jsonEntities);
            builder.add("Parameters", (JsonObjectBuilder)jsonParams);
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 2 notifyResponseConsumers");
            this.notifyResponseConsumers();
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 3 write json to response");
            IOUtils.write((String)builder.toString(), (Writer)response_contents);
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 4 flush");
            response_contents.flush();
            LOGGER.debug("===: [" + this.getName() + "] responseProducer 5 return");
        }
        catch (Exception ex) {
            LOGGER.warn("Can't produce Json data for " + this.getName() + " response.", (Throwable)ex);
        }
        finally {
            LOGGER.debug("===: [" + this.getName() + "] responseProducer  6 close response_contents");
            IOUtils.closeQuietly((Writer)response_contents);
            LOGGER.debug("===: [" + this.getName() + "] responseProducer  7");
        }
    }
}

