/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.json.Json;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisHistoryRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class HistoryHandler
extends AbstractVCSGisServertHandler {
    public HistoryHandler(VCSGisRepository repository) {
        super(repository, "HistoryHandler");
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        JsonObject jsonParameters = null;
        try {
            JsonReader reader = Json.createReader((Reader)request_contents);
            JsonObject jsonRequest = reader.readObject();
            jsonParameters = jsonRequest.getJsonObject("Parameters");
        }
        catch (JsonException reader) {
            // empty catch block
        }
        String entityName = params.get("EntityName");
        if (jsonParameters != null) {
            entityName = jsonParameters.getString("EntityName", entityName);
        }
        VCSGisHistoryRequest request = this.getRepository().createHistoryRequest(entityName);
        request.setAuthenticationTokenAndUser(params);
        if (jsonParameters == null) {
            request.setDateRange(DataTypeUtils.toTimestamp((Object)params.get("MinDate")), DataTypeUtils.toTimestamp((Object)params.get("MaxDate")));
            request.setRevisionNumberRange(DataTypeUtils.toLong((Object)params.get("MinRevisionNumber"), (long)-1L), DataTypeUtils.toLong((Object)params.get("MaxRevisionNumber"), (long)-1L));
            request.setMaxNumberOfRevisions(DataTypeUtils.toInteger((Object)params.get("MaxNumberOfRevisions"), (int)-1));
        } else {
            request.setDateRange(DataTypeUtils.toTimestamp((Object)jsonParameters.getString("MinDate", params.get("MinDate"))), DataTypeUtils.toTimestamp((Object)jsonParameters.getString("MaxDate", params.get("MaxDate"))));
            request.setRevisionNumberRange(DataTypeUtils.toLong((Object)jsonParameters.getInt("MinRevisionNumber", -1)), DataTypeUtils.toLong((Object)jsonParameters.getInt("MaxRevisionNumber", -1)));
            request.setMaxNumberOfRevisions(jsonParameters.getInt("MaxNumberOfRevisions", -1));
        }
        req.setValue((Object)request);
        this.notifyRequestConsumers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        VCSGisHistoryRequest request = (VCSGisHistoryRequest)req;
        JsonGenerator gen = null;
        try {
            JsonGeneratorFactory genFactory = Json.createGeneratorFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
            gen = genFactory.createGenerator(response_contents);
            gen.writeStartObject();
            gen.writeStartObject("Parameters");
            gen.write("StatusCode", request.getLastErrorCode());
            this.notifyResponseConsumers();
            gen.flush();
            if (StringUtils.isBlank((CharSequence)request.getLastErrorMessage())) {
                gen.writeNull("StatusMessage");
            } else {
                gen.write("StatusMessage", request.getLastErrorMessage());
            }
            gen.writeEnd();
            gen.writeStartArray("Data");
            for (VCSGisRevision revision : request.getRevisions()) {
                gen.write((JsonValue)revision.toJson());
                gen.flush();
            }
            gen.writeEnd();
            gen.writeEnd();
            gen.flush();
            response_contents.flush();
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't produce Json data for " + this.getName() + " response.", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gen);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)gen);
        }
        IOUtils.closeQuietly((Closeable)gen);
    }
}

