/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlan;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisTopologyPlansRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class TopologyPlansHandler
extends AbstractVCSGisServertHandler {
    public TopologyPlansHandler(VCSGisRepository repository) {
        super(repository, "TopologyPlansHandler");
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 1");
        VCSGisTopologyPlansRequest request = this.getRepository().createTopologyPlansRequest();
        request.setAuthenticationTokenAndUser(params);
        req.setValue((Object)request);
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 2 notifyRequestConsumers");
        this.notifyRequestConsumers();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 3 return");
    }

    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  1");
        VCSGisTopologyPlansRequest request = (VCSGisTopologyPlansRequest)req;
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  3");
        List topologyPlans = request.getTopologyPlans();
        org.gvsig.json.JsonArrayBuilder jsonTopologyPlans = Json.createArrayBuilder();
        for (VCSGisTopologyPlan topologyPlan : topologyPlans) {
            LOGGER.debug("===: [" + this.getName() + "] responseProducer  4 entity " + topologyPlan.getName());
            jsonTopologyPlans.add((javax.json.JsonObjectBuilder)topologyPlan.toJsonBuilder());
        }
        JsonObjectBuilder jsonResponse = Json.createObjectBuilder();
        JsonObjectBuilder jsonParameters = Json.createObjectBuilder();
        jsonParameters.add("StatusCode", 0);
        jsonParameters.addNull("StatusMessage");
        jsonResponse.add("Parameters", (javax.json.JsonObjectBuilder)jsonParameters);
        jsonResponse.add("TopologyPlans", (JsonArrayBuilder)jsonTopologyPlans);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  5 notifyResponseConsumers");
        this.notifyResponseConsumers();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  6 write json");
        IOUtils.write((String)jsonResponse.toString(), (Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  7 flush");
        response_contents.flush();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  8 close");
        IOUtils.closeQuietly((Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  9 return");
    }
}

