/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers.simplewfs;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisEntitiesRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class DescribeFeatureHandler
extends AbstractVCSGisServertHandler {
    private String TYPENAME;

    public DescribeFeatureHandler(VCSGisRepository repository) {
        super(repository, "GetCapabilitiesHandler");
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    public VCSGisRepositoryLocaldb getRepository() {
        return (VCSGisRepositoryLocaldb)super.getRepository();
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 1");
        this.TYPENAME = params.get("TYPENAME");
        VCSGisEntitiesRequest request = this.getRepository().createEntitiesRequest();
        request.setAuthenticationTokenAndUser(params);
        req.setValue((Object)request);
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 2 notifyRequestConsumers");
        this.notifyRequestConsumers();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 3 return");
    }

    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  1");
        VCSGisEntitiesRequest request = (VCSGisEntitiesRequest)req;
        Map wfs_info = this.getRepository().getConfigValues(new String[]{"WFS_TITLE", "WFS_ABSTRACT", "WFS_KEYWORDS", "WFS_PROVIDERNAME", "WFS_PROVIDERSITE", "WFS_NAMESPACE", "REPOSITORY_URL"});
        String namespace = wfs_info.getOrDefault("WFS_NAMESPACE", "vcsgis");
        String repository_url = wfs_info.getOrDefault("REPOSITORY_URL", "http://localhost:9810");
        List entities = request.getRepositoryEntities();
        VCSGisEntity entity = null;
        for (VCSGisEntity cur_entity : entities) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)this.TYPENAME, (CharSequence)cur_entity.getEntityName())) continue;
            entity = cur_entity;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version='1.0' encoding=\"UTF-8\" ?>\n");
        builder.append("<schema\n");
        builder.append("   targetNamespace=\"").append(repository_url).append("\"\n");
        builder.append("   xmlns:").append(namespace).append("=\"").append(repository_url).append("\"\n");
        builder.append("   xmlns:ogc=\"http://www.opengis.net/ogc\"\n");
        builder.append("   xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"\n");
        builder.append("   xmlns=\"http://www.w3.org/2001/XMLSchema\"\n");
        builder.append("   xmlns:gml=\"http://www.opengis.net/gml\"\n");
        builder.append("   elementFormDefault=\"qualified\"");
        builder.append("   version=\"0.1\" ");
        builder.append("   >\n");
        builder.append("<import \n");
        builder.append("   namespace=\"http://www.opengis.net/gml\" \n");
        builder.append("   schemaLocation=\"http://schemas.opengis.net/gml/3.1.1/base/gml.xsd\"\n");
        builder.append("   />\n");
        builder.append("<element name=\"").append(entity.getEntityName()).append("\" type=\"").append(namespace).append(":").append(entity.getEntityName()).append("Type\" substitutionGroup=\"gml:_Feature\"/>\n");
        builder.append("<complexType name=\"");
        builder.append(entity.getEntityName());
        builder.append("Type\">\n");
        builder.append("<complexContent>\n");
        builder.append("<extension base=\"gml:AbstractFeatureType\">\n");
        builder.append("<sequence>\n");
        FeatureType ft = entity.getFeatureType();
        block13: for (FeatureAttributeDescriptor attr : ft) {
            switch (attr.getType()) {
                case 66: {
                    builder.append("<element name=\"").append(attr.getName()).append("\" type=\"gml:GeometryPropertyType\" minOccurs=\"0\" maxOccurs=\"1\"/>\n");
                    continue block13;
                }
                case 1: {
                    builder.append("<element name=\"").append(attr.getName()).append("\" type=\"xsd:boolean\"/>\n");
                    continue block13;
                }
                case 2: {
                    builder.append("<element name=\"").append(attr.getName()).append("\" type=\"xsd:byte\"/>\n");
                    continue block13;
                }
                case 4: {
                    builder.append("<element name=\"").append(attr.getName()).append("\" type=\"xsd:int\"/>\n");
                    continue block13;
                }
                case 5: {
                    builder.append("<element name=\"").append(attr.getName()).append("\" type=\"xsd:long\"/>\n");
                    continue block13;
                }
                case 9: {
                    builder.append("<element name=\"").append(attr.getName()).append("\" type=\"xsd:date\"/>\n");
                    continue block13;
                }
                case 10: {
                    builder.append("<element name=\"").append(attr.getName()).append("\" type=\"xsd:time\"/>\n");
                    continue block13;
                }
                case 11: {
                    builder.append("<element name=\"").append(attr.getName()).append("\" type=\"xsd:timestamp\"/>\n");
                    continue block13;
                }
                case 7: 
                case 19: {
                    builder.append("<element name=\"").append(attr.getName()).append("\" type=\"xsd:double\"/>\n");
                    continue block13;
                }
                case 6: {
                    builder.append("<element name=\"").append(attr.getName()).append("\" type=\"xsd:float\"/>\n");
                    continue block13;
                }
            }
            builder.append("<element name=\"").append(attr.getName()).append("\" type=\"xsd:string\"/>\n");
        }
        builder.append("</sequence>\n");
        builder.append("</extension>\n");
        builder.append("</complexContent>\n");
        builder.append("</complexType>\n");
        builder.append("</schema>\n");
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  5 notifyResponseConsumers");
        this.notifyResponseConsumers();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  6 write json");
        IOUtils.write((String)builder.toString(), (Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  7 flush");
        response_contents.flush();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  8 close");
        IOUtils.closeQuietly((Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  9 return");
    }
}

