/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers.simplewfs;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisEntitiesRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class GetCapabilitiesHandler
extends AbstractVCSGisServertHandler {
    public GetCapabilitiesHandler(VCSGisRepository repository) {
        super(repository, "GetCapabilitiesHandler");
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    public VCSGisRepositoryLocaldb getRepository() {
        return (VCSGisRepositoryLocaldb)super.getRepository();
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 1");
        VCSGisEntitiesRequest request = this.getRepository().createEntitiesRequest();
        request.setAuthenticationTokenAndUser(params);
        req.setValue((Object)request);
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 2 notifyRequestConsumers");
        this.notifyRequestConsumers();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 3 return");
    }

    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  1");
        VCSGisEntitiesRequest request = (VCSGisEntitiesRequest)req;
        Map wfs_info = this.getRepository().getConfigValues(new String[]{"WFS_TITLE", "WFS_ABSTRACT", "WFS_KEYWORDS", "WFS_PROVIDERNAME", "WFS_PROVIDERSITE", "WFS_NAMESPACE", "REPOSITORY_URL"});
        String namespace = wfs_info.getOrDefault("WFS_NAMESPACE", "vcsgis");
        String repository_url = wfs_info.getOrDefault("REPOSITORY_URL", "http://localhost:9810");
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version='1.0' encoding=\"UTF-8\" ?>\n");
        builder.append("<wfs:WFS_Capabilities \n");
        builder.append("   xmlns:").append(namespace).append("=\"").append(repository_url).append("\"\n");
        builder.append("   xmlns:gml=\"http://www.opengis.net/gml\" \n");
        builder.append("   xmlns:wfs=\"http://www.opengis.net/wfs\" \n");
        builder.append("   xmlns:ows=\"http://www.opengis.net/ows\" \n");
        builder.append("   xmlns:xlink=\"http://www.w3.org/1999/xlink\" \n");
        builder.append("   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        builder.append("   xmlns:ogc=\"http://www.opengis.net/ogc\" \n");
        builder.append("   xmlns=\"http://www.opengis.net/wfs\" \n");
        builder.append("   version=\"1.1.0\" \n");
        builder.append("   xsi:schemaLocation=\"http://www.opengis.net/wfs http://schemas.opengis.net/wfs/1.1.0/wfs.xsd\" ");
        builder.append("   >\n");
        this.generateServiceIdentification(wfs_info, builder);
        this.generateServiceProvider(wfs_info, builder);
        this.generateOperationsMetadata(wfs_info, builder);
        this.generateFeatureTypeList(wfs_info, builder, request.getRepositoryEntities());
        this.generateFilter_Capabilities(wfs_info, builder);
        builder.append("</wfs:WFS_Capabilities>\n");
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  5 notifyResponseConsumers");
        this.notifyResponseConsumers();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  6 write json");
        IOUtils.write((String)builder.toString(), (Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  7 flush");
        response_contents.flush();
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  8 close");
        IOUtils.closeQuietly((Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  9 return");
    }

    private void generateServiceIdentification(Map<String, String> wfs_info, StringBuilder builder) {
        builder.append("<ows:ServiceIdentification>\n");
        builder.append("<ows:Title>").append(wfs_info.getOrDefault("WFS_TITLE", this.getRepository().getLabel())).append("</ows:Title>\n");
        builder.append("<ows:Abstract>\n");
        builder.append(wfs_info.getOrDefault("WFS_ABSTRACT", "")).append("\n");
        builder.append("</ows:Abstract>\n");
        builder.append("<ows:Keywords>\n");
        String keywords = wfs_info.getOrDefault("WFS_KEYWORDS", "");
        for (String keyword : StringUtils.split((String)keywords, (char)';')) {
            builder.append("<ows:Keyword>").append(keyword).append("</ows:Keyword>\n");
        }
        builder.append("</ows:Keywords>\n");
        builder.append("<ows:ServiceType codeSpace=\"OGC\">OGC WFS</ows:ServiceType>\n");
        builder.append("<ows:ServiceTypeVersion>1.1.0</ows:ServiceTypeVersion>\n");
        builder.append("<ows:Fees>none</ows:Fees>\n");
        builder.append("<ows:AccessConstraints>none</ows:AccessConstraints>\n");
        builder.append("</ows:ServiceIdentification>\n");
    }

    private void generateServiceProvider(Map<String, String> wfs_info, StringBuilder builder) {
        builder.append("<ows:ServiceProvider>\n");
        builder.append("<ows:ProviderName>").append(wfs_info.getOrDefault("WFS_PROVIDERNAME", "Desconocido")).append("</ows:ProviderName>\n");
        builder.append("<ows:ProviderSite xlink:type=\"simple\" xlink:href=\"").append(wfs_info.getOrDefault("WFS_PROVIDERSITE", "Desconocido")).append("\"/>\n");
        builder.append("</ows:ServiceProvider>\n");
    }

    private void generateOperationsMetadata(Map<String, String> wfs_info, StringBuilder builder) {
        builder.append("<ows:OperationsMetadata>\n");
        this.generateOperationsMetadataGetCapabilities(wfs_info, builder);
        this.generateOperationsMetadataDescribeFeatureType(wfs_info, builder);
        this.generateOperationsMetadataGetFeature(wfs_info, builder);
        builder.append("</ows:OperationsMetadata>\n");
    }

    private void generateOperationsMetadataGetCapabilities(Map<String, String> wfs_info, StringBuilder builder) {
        String url = wfs_info.get("REPOSITORY_URL") + "/simplewfs?";
        builder.append("<ows:Operation name=\"GetCapabilities\">\n");
        builder.append("<ows:DCP>\n");
        builder.append("<ows:HTTP>\n");
        builder.append("<ows:Get xlink:type=\"simple\" xlink:href=\"").append(url).append("\"/>\n");
        builder.append("<ows:Post xlink:type=\"simple\" xlink:href=\"").append(url).append("\"/>\n");
        builder.append("</ows:HTTP>\n");
        builder.append("</ows:DCP>\n");
        builder.append("<ows:Parameter name=\"service\">\n");
        builder.append("<ows:Value>WFS</ows:Value>\n");
        builder.append("</ows:Parameter>\n");
        builder.append("<ows:Parameter name=\"AcceptVersions\">\n");
        builder.append("<ows:Value> 1.1.0</ows:Value>\n");
        builder.append("</ows:Parameter>\n");
        builder.append("<ows:Parameter name=\"AcceptFormats\">\n");
        builder.append("<ows:Value>text/xml</ows:Value>\n");
        builder.append("</ows:Parameter>\n");
        builder.append("</ows:Operation>\n");
    }

    private void generateOperationsMetadataDescribeFeatureType(Map<String, String> wfs_info, StringBuilder builder) {
        String url = wfs_info.get("REPOSITORY_URL") + "/simplewfs?";
        builder.append("<ows:Operation name=\"DescribeFeatureType\">\n");
        builder.append("<ows:DCP>\n");
        builder.append("<ows:HTTP>\n");
        builder.append("<ows:Get xlink:type=\"simple\" xlink:href=\"").append(url).append("\"/>\n");
        builder.append("<ows:Post xlink:type=\"simple\" xlink:href=\"").append(url).append("\"/>\n");
        builder.append("</ows:HTTP>\n");
        builder.append("</ows:DCP>\n");
        builder.append("<ows:Parameter name=\"outputFormat\">\n");
        builder.append("<ows:Value>XMLSCHEMA</ows:Value>\n");
        builder.append("<ows:Value>text/xml; subtype=gml/2.1.2</ows:Value>\n");
        builder.append("<ows:Value>text/xml; subtype=gml/3.1.1</ows:Value>\n");
        builder.append("</ows:Parameter>\n");
        builder.append("</ows:Operation>\n");
    }

    private void generateOperationsMetadataGetFeature(Map<String, String> wfs_info, StringBuilder builder) {
        String url = wfs_info.get("REPOSITORY_URL") + "/simplewfs?";
        builder.append("<ows:Operation name=\"GetFeature\">\n");
        builder.append("<ows:DCP>\n");
        builder.append("<ows:HTTP>\n");
        builder.append("<ows:Get xlink:type=\"simple\" xlink:href=\"").append(url).append("\"/>\n");
        builder.append("<ows:Post xlink:type=\"simple\" xlink:href=\"").append(url).append("\"/>\n");
        builder.append("</ows:HTTP>\n");
        builder.append("</ows:DCP>\n");
        builder.append("<ows:Parameter name=\"resultType\">\n");
        builder.append("<ows:Value>results</ows:Value>\n");
        builder.append("</ows:Parameter>\n");
        builder.append("<ows:Parameter name=\"outputFormat\">\n");
        builder.append("<ows:Value>text/xml; subtype=gml/3.1.1</ows:Value>\n");
        builder.append("</ows:Parameter>\n");
        builder.append("</ows:Operation>\n");
    }

    private void generateFeatureTypeList(Map<String, String> wfs_info, StringBuilder builder, List<VCSGisEntity> entities) {
        builder.append("<FeatureTypeList>\n");
        builder.append("<Operations>\n");
        builder.append("<Operation>Query</Operation>\n");
        builder.append("</Operations>\n");
        for (VCSGisEntity entity : entities) {
            this.generateFeatureType(wfs_info, builder, entity);
        }
        builder.append("</FeatureTypeList>\n");
    }

    private void generateFeatureType(Map<String, String> wfs_info, StringBuilder builder, VCSGisEntity entity) {
        IProjection crs;
        FeatureType ft = entity.getFeatureType();
        Envelope env = this.getEnvelope(ft, crs = this.getCRS(entity));
        if (env == null) {
            env = GeometryUtils.createEnvelope((double)-180.0, (double)-90.0, (double)180.0, (double)90.0, (int)0);
            env.setProjection(CRSFactory.getCRS((String)"EPSG:4326"));
        }
        if (env.getProjection() == null) {
            env.setProjection(crs);
        }
        if (!env.getProjection().getAbrev().equalsIgnoreCase("EPSG:4326")) {
            ICoordTrans ct = crs.getCT(CRSFactory.getCRS((String)"EPSG:4326"));
            env = env.convert(ct);
        }
        builder.append("<FeatureType>\n");
        builder.append("<Name>").append(entity.getEntityName()).append("</Name>\n");
        builder.append("<Title>").append(entity.getLabel()).append("</Title>\n");
        builder.append("<Abstract>\n");
        builder.append(entity.getDescription()).append(".\n");
        builder.append("</Abstract>\n");
        builder.append("<ows:Keywords>\n");
        builder.append("</ows:Keywords>\n");
        if (crs != null) {
            builder.append("<DefaultSRS>").append(crs.getAbrev()).append("</DefaultSRS>\n");
        }
        builder.append("<OutputFormats>\n");
        builder.append("<Format>text/xml; subtype=gml/3.1.1</Format>\n");
        builder.append("</OutputFormats>\n");
        builder.append("<ows:WGS84BoundingBox dimensions=\"2\">\n");
        builder.append("<ows:LowerCorner>").append(env.getLowerCorner().getX()).append(" ").append(env.getLowerCorner().getY()).append("</ows:LowerCorner>\n");
        builder.append("<ows:UpperCorner>").append(env.getUpperCorner().getX()).append(" ").append(env.getUpperCorner().getY()).append("</ows:UpperCorner>\n");
        builder.append("</ows:WGS84BoundingBox>\n");
        builder.append("</FeatureType>\n");
    }

    private void generateFilter_Capabilities(Map<String, String> wfs_info, StringBuilder builder) {
    }

    private IProjection getCRS(VCSGisEntity entity) {
        String s = entity.getCRS();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            IProjection crs = CRSFactory.getCRS((String)s);
            return crs;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Envelope getEnvelope(FeatureType ft, IProjection crs) {
        String env_s = ft.getTags().getString("DAL.forcedEnvelope", null);
        if (StringUtils.isBlank((CharSequence)env_s)) {
            return null;
        }
        Envelope env = GeometryUtils.createFrom((String)env_s).getEnvelope();
        if (crs != null) {
            env.setProjection(crs);
        }
        return env;
    }
}

