/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers.simplewfs;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import javax.json.JsonObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.json.Json;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCheckoutRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.handlers.AbstractVCSGisServertHandler;

public class GetFeatureHandler
extends AbstractVCSGisServertHandler {
    private String TYPENAME;
    private String FEATUREID;
    private String BBOX;
    private String STARTINDEX;
    private String MAXFEATURES;
    private String RESULTTYPE;
    private String TIME;

    public GetFeatureHandler(VCSGisRepository repository) {
        super(repository, "GetCapabilitiesHandler");
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    public VCSGisRepositoryLocaldb getRepository() {
        return (VCSGisRepositoryLocaldb)super.getRepository();
    }

    private IProjection getCRS(VCSGisEntity entity) {
        String s = entity.getCRS();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            IProjection crs = CRSFactory.getCRS((String)s);
            return crs;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Envelope getEnvelope(FeatureType ft, IProjection crs) {
        String env_s = ft.getTags().getString("DAL.forcedEnvelope", null);
        if (StringUtils.isBlank((CharSequence)env_s)) {
            return null;
        }
        Envelope env = GeometryUtils.createFrom((String)env_s).getEnvelope();
        if (crs != null) {
            env.setProjection(crs);
        }
        return env;
    }

    @Override
    protected void requestProducer(MutableObject<VCSGisRequest> req, Map<String, String> params, Reader request_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 1");
        this.TYPENAME = params.get("TYPENAME");
        this.FEATUREID = params.get("FEATUREID");
        this.BBOX = params.get("BBOX");
        this.STARTINDEX = params.get("STARTINDEX");
        this.MAXFEATURES = params.get("MAXFEATURES");
        this.RESULTTYPE = params.get("RESULTTYPE");
        this.TIME = params.get("TIME");
        VCSGisCheckoutRequest request = this.getRepository().createCheckoutRequest(this.TYPENAME);
        request.setAuthenticationTokenAndUser(params);
        req.setValue((Object)request);
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 2 notifyRequestConsumers");
        this.notifyRequestConsumers();
        LOGGER.debug("===: [" + this.getName() + "] requestProducer 3 return");
    }

    @Override
    protected void responseProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        Envelope env;
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  1");
        VCSGisCheckoutRequest request = (VCSGisCheckoutRequest)req;
        VCSGisEntity entity = request.getEntity();
        FeatureType ft = entity.getFeatureType();
        IProjection crs = this.getCRS(entity);
        if (crs == null) {
            crs = CRSFactory.getCRS((String)"EPSG:4326");
        }
        if ((env = this.getEnvelope(ft, crs)) == null) {
            env = GeometryUtils.createEnvelope((double)-180.0, (double)-90.0, (double)180.0, (double)90.0, (int)0);
            env.setProjection(CRSFactory.getCRS((String)"EPSG:4326"));
        }
        if (env.getProjection() == null) {
            env.setProjection(crs);
        }
        Map wfs_info = this.getRepository().getConfigValues(new String[]{"WFS_NAMESPACE", "REPOSITORY_URL"});
        String namespace = wfs_info.getOrDefault("WFS_NAMESPACE", "vcsgis");
        String repository_url = wfs_info.getOrDefault("REPOSITORY_URL", "http://localhost:9810");
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version='1.0' encoding=\"UTF-8\" ?>\n");
        builder.append("<wfs:FeatureCollection\n");
        builder.append("   xmlns:").append(namespace).append("=\"").append(repository_url).append("\"\n");
        builder.append("   xmlns:gml=\"http://www.opengis.net/gml\"\n");
        builder.append("   xmlns:wfs=\"http://www.opengis.net/wfs\"\n");
        builder.append("   xmlns:ogc=\"http://www.opengis.net/ogc\"\n");
        builder.append("   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        builder.append("   xsi:schemaLocation=\"").append(repository_url).append("/simplewfs?SERVICE=WFS&amp;REQUEST=DescribeFeatureType&amp;TYPENAME=").append(this.TYPENAME);
        builder.append("http://www.opengis.net/wfs ");
        builder.append("http://schemas.opengis.net/wfs/1.1.0/wfs.xsd");
        builder.append("\" ");
        builder.append("   >\n");
        builder.append("<gml:boundedBy>\n");
        builder.append("  <gml:Envelope srsName=\"").append(crs.getAbrev()).append("\">\n");
        builder.append("    <gml:LowerCorner>").append(env.getLowerCorner().getX()).append(" ").append(env.getLowerCorner().getY()).append("    </gml:LowerCorner>\n");
        builder.append("    <gml:UpperCorner>").append(env.getUpperCorner().getX()).append(" ").append(env.getUpperCorner().getY()).append("    </gml:UpperCorner>\n");
        builder.append("  </gml:Envelope>\n");
        builder.append("</gml:boundedBy>\n");
        builder.append("<gml:featureMember>\n");
        response_contents.write(builder.toString());
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  7 flush");
        response_contents.flush();
        for (VCSGisRepositoryData rdata : request.getData()) {
            String geom_s;
            JsonObject data = rdata.getDataAsJson();
            builder.setLength(0);
            builder.append("<");
            builder.append(namespace).append(":");
            builder.append(entity.getEntityName());
            builder.append(" fid=\"");
            builder.append(data.getString(entity.getFeatureIdFieldName()));
            builder.append("\">\n");
            Geometry geom = null;
            String geomName = ft.getDefaultGeometryAttributeName();
            if (StringUtils.isNotBlank((CharSequence)geomName) && StringUtils.isNotBlank((CharSequence)(geom_s = data.getString(geomName, null)))) {
                geom = GeometryUtils.createFrom((String)geom_s, (IProjection)crs);
            }
            if (geom != null) {
                if (geom.getProjection() == null) {
                    geom.setProjection(crs);
                }
                env = geom.getEnvelope();
                builder.append("<gml:boundedBy>\n");
                builder.append("  <gml:Envelope srsName=\"").append(env.getProjection().getAbrev()).append("\">\n");
                builder.append("    <gml:LowerCorner>").append(env.getLowerCorner().getX()).append(" ").append(env.getLowerCorner().getY()).append("    </gml:LowerCorner>\n");
                builder.append("    <gml:UpperCorner>").append(env.getUpperCorner().getX()).append(" ").append(env.getUpperCorner().getY()).append("    </gml:UpperCorner>\n");
                builder.append("  </gml:Envelope>\n");
                builder.append("</gml:boundedBy>\n");
            }
            for (FeatureAttributeDescriptor attr : ft) {
                Object value;
                String name = attr.getName();
                if (!data.containsKey((Object)name)) continue;
                if (attr.getType() == 66) {
                    String geom_s2;
                    Geometry geom1 = geom;
                    if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)geomName) && StringUtils.isNotBlank((CharSequence)(geom_s2 = data.getString(geomName, null)))) {
                        geom1 = GeometryUtils.createFrom((String)geom_s2, (IProjection)crs);
                    }
                    if (geom1 == null) {
                        value = null;
                    } else {
                        try {
                            value = geom1.convertTo("gml", new Object[0]);
                        }
                        catch (Exception ex) {
                            value = null;
                        }
                    }
                } else {
                    value = Json.toObject((JsonObject)data, (String)name);
                }
                builder.append("<");
                builder.append(namespace).append(":");
                builder.append(name);
                builder.append(">");
                builder.append(Objects.toString(value, ""));
                builder.append("</");
                builder.append(namespace).append(":");
                builder.append(name);
                builder.append(">\n");
            }
            builder.append("</");
            builder.append(namespace).append(":");
            builder.append(entity.getEntityName());
            builder.append(">\n");
            response_contents.write(builder.toString());
        }
        response_contents.write("</gml:featureMember>\n");
        response_contents.write("</wfs:FeatureCollection>\n");
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  8 close");
        IOUtils.closeQuietly((Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseProducer  9 return");
    }
}

