/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.servlets;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.gvsig.vcsgis.lib.BaseSupportError;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.server.VCSGisServerController;
import org.gvsig.vcsgis.lib.server.VCSGisServerHandler;
import org.gvsig.vcsgis.lib.server.servlets.AbstractVCSGisServlet;

public class VCSGisDownloadWCServlet
extends AbstractVCSGisServlet {
    @Override
    protected VCSGisServerHandler createHandler(VCSGisServerController vcsgisserver) {
        return null;
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BaseSupportError error = new BaseSupportError();
        Map<String, String> params = this.getRequestParameters(request);
        VCSGisRepositoryLocaldbImpl repository = (VCSGisRepositoryLocaldbImpl)this.createRepository();
        String authenticationToken = params.get("auth");
        String userCode = params.get("user");
        int n = repository.isAuthorized(userCode, authenticationToken, "downloadwc", error);
        if (n != 0) {
            throw new RuntimeException(error.getLastErrorMessage());
        }
        String location = params.get("location");
        File copiesFolder = repository.getWorkingCopiesFolder(error);
        if (copiesFolder == null) {
            throw new RuntimeException("Can't get working copies folder (" + error.getLastErrorMessage() + ").");
        }
        File file = new File(copiesFolder, location);
        if (!file.exists()) {
            LOGGER.warn("Can't get working copy (" + file.getAbsolutePath() + ")");
            throw new RuntimeException("Can't get working copy (" + location + ").");
        }
        FileInputStream fileInputStream = null;
        ServletOutputStream responseOutputStream = null;
        try {
            int bytes;
            String mimeType = request.getServletContext().getMimeType(file.getAbsolutePath());
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            response.setContentType(mimeType);
            response.addHeader("Content-Disposition", "attachment; filename=" + file.getAbsolutePath());
            response.setContentLength((int)file.length());
            fileInputStream = new FileInputStream(file);
            responseOutputStream = response.getOutputStream();
            while ((bytes = fileInputStream.read()) != -1) {
                responseOutputStream.write(bytes);
            }
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't download working copy", (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                IOUtils.closeQuietly(responseOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        IOUtils.closeQuietly((OutputStream)responseOutputStream);
    }
}

