/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.workspace;

import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.event.ChangeListener;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.paging.FeaturePagingHelper;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.vcsgis.lib.VCSGisChange;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceChanges;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChangesImpl<CHANGE extends VCSGisChange>
extends AbstractDisposable
implements VCSGisWorkspaceChanges<CHANGE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangesImpl.class);
    final FeaturePagingHelper changes;
    ChangeListenerHelper changeListernerHelper;
    private final String selectedFieldName;

    public ChangesImpl(GetItemWithSize64<Feature> changes, String selectedFieldName) {
        this.changes = (FeaturePagingHelper)changes;
        DisposeUtils.bind((Disposable)this.changes);
        this.changeListernerHelper = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
        this.selectedFieldName = selectedFieldName;
    }

    protected abstract CHANGE createChange(Feature var1);

    protected abstract void updateChange(FeatureStore var1, CHANGE var2);

    public void addSelectionInterval(long start, long end) {
        try {
            FeatureStore store = this.changes.getFeatureStore();
            store.edit(3);
            for (long i = start; i <= end; ++i) {
                Feature feat = this.changes.getFeatureAt(i);
                CHANGE row = this.createChange(feat);
                row.setSelected(true);
                this.updateChange(store, row);
            }
            store.finishEditingQuietly();
            this.changes.reload();
            this.fireChanges();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add to selection.", (Throwable)ex);
        }
    }

    public void removeSelectionInterval(long start, long end) {
        try {
            FeatureStore store = this.changes.getFeatureStore();
            store.edit(3);
            for (long i = start; i <= end; ++i) {
                Feature feat = this.changes.getFeatureAt(i);
                CHANGE row = this.createChange(feat);
                row.setSelected(false);
                this.updateChange(store, row);
            }
            store.finishEditingQuietly();
            this.changes.reload();
            this.fireChanges();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add to selection.", (Throwable)ex);
        }
    }

    public void setSelectionInterval(long start, long end) {
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_Select_interval_changes");
        status.setAutoremove(true);
        status.add();
        try {
            status.setRangeOfValues(start, end);
            status.message("_Updating_selection");
            FeatureStore store = this.changes.getFeatureStore();
            store.edit(3);
            store.update(new Object[]{this.selectedFieldName, false});
            for (long i = start; i <= end; ++i) {
                Feature feat = this.changes.getFeatureAt(i);
                CHANGE row = this.createChange(feat);
                row.setSelected(true);
                this.updateChange(store, row);
                status.setCurValue(i);
            }
            status.message("_Finising_process");
            store.finishEditingQuietly();
            status.message("_Reloading_changes");
            this.changes.reload();
            status.message("_Refresing");
            this.fireChanges();
            status.terminate();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't process.", (Throwable)ex);
            status.message("Can't process changes (" + ex.getMessage() + ")");
            status.abort();
        }
    }

    public void clearSelection() {
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_Clear_changes_selection");
        status.setAutoremove(true);
        status.add();
        try {
            status.setIndeterminate();
            status.message("_Updating_selection");
            FeatureStore store = this.changes.getFeatureStore();
            store.edit(3);
            store.update(new Object[]{this.selectedFieldName, false});
            status.message("_Finising_process");
            store.finishEditingQuietly();
            status.message("_Reloading_changes");
            this.changes.reload();
            status.message("_Refresing");
            this.fireChanges();
            status.terminate();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't process.", (Throwable)ex);
            status.message("Can't process changes (" + ex.getMessage() + ")");
            status.abort();
        }
    }

    public void setSelectionAll() {
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_Selecting_all_changes");
        status.setAutoremove(true);
        status.add();
        try {
            status.setIndeterminate();
            status.message("_Updating_selection");
            FeatureStore store = this.changes.getFeatureStore();
            store.edit(3);
            store.update(new Object[]{this.selectedFieldName, true});
            status.message("_Finising_process");
            store.finishEditingQuietly();
            status.message("_Reloading_changes");
            this.changes.reload();
            status.message("_Refresing");
            this.fireChanges();
            status.terminate();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't process.", (Throwable)ex);
            status.message("Can't process changes (" + ex.getMessage() + ")");
            status.abort();
        }
    }

    public void process(Iterator<Long> rows, Predicate<CHANGE> action) {
        SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_Processing_changes");
        status.setAutoremove(true);
        status.add();
        try {
            status.setRangeOfValues(0L, this.size64());
            status.message("_Processing");
            FeatureStore store = this.changes.getFeatureStore();
            store.edit(3);
            while (rows.hasNext()) {
                Long row = rows.next();
                Feature feat = this.changes.getFeatureAt(row.longValue());
                CHANGE change = this.createChange(feat);
                if (action.test(change)) {
                    this.updateChange(store, change);
                }
                status.incrementCurrentValue();
            }
            status.message("_Finising_process");
            store.finishEditingQuietly();
            status.message("_Reloading_changes");
            this.changes.reload();
            status.message("_Refresing");
            this.fireChanges();
            status.terminate();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't process.", (Throwable)ex);
            status.message("Can't process changes (" + ex.getMessage() + ")");
            status.abort();
        }
    }

    public boolean isSelectedIndex(long index) {
        try {
            Feature feat = this.changes.getFeatureAt(index);
            return feat.getBoolean(this.selectedFieldName);
        }
        catch (BaseException ex) {
            LOGGER.warn("Can't check if is selected.", (Throwable)ex);
            throw new RuntimeException("Can't check if is selected.", ex);
        }
    }

    public boolean isSelectionEmpty() {
        try {
            FeatureStore store = this.changes.getFeatureStore();
            Feature foundFeat = store.findFirst("\"" + this.selectedFieldName + "\"");
            return foundFeat == null;
        }
        catch (BaseException ex) {
            LOGGER.warn("Can't check if is empty selection.", (Throwable)ex);
            throw new RuntimeException("Can't check if is selected.", ex);
        }
    }

    public boolean isSelectionFromEntitiesEmpty(List<VCSGisEntity> entities) {
        try {
            if (entities.isEmpty()) {
                return false;
            }
            ExpressionBuilder expBuilder = ExpressionUtils.createExpressionBuilder();
            for (VCSGisEntity entity : entities) {
                if (entity == null) continue;
                expBuilder.or((ExpressionBuilder.Value)expBuilder.eq((ExpressionBuilder.Value)expBuilder.column("COD_ENTITY"), (ExpressionBuilder.Value)expBuilder.constant((Object)entity.getEntityCode())));
            }
            ExpressionBuilder.Value or = expBuilder.value();
            expBuilder.set(null);
            expBuilder.and((ExpressionBuilder.Value)expBuilder.column(this.selectedFieldName));
            expBuilder.and((ExpressionBuilder.Value)expBuilder.group(or));
            FeatureStore store = this.changes.getFeatureStore();
            Feature foundFeat = store.findFirst(expBuilder.toString());
            return foundFeat == null;
        }
        catch (BaseException ex) {
            LOGGER.warn("Can't check if is empty selection.", (Throwable)ex);
            throw new RuntimeException("Can't check if is selected.", ex);
        }
    }

    public long size64() {
        return this.changes.size64();
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public CHANGE get64(long position) {
        Feature f = (Feature)this.changes.get64(position);
        if (f == null) {
            return null;
        }
        return this.createChange(f);
    }

    private void fireChanges() {
        this.changeListernerHelper.fireEvent();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListernerHelper.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListernerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListernerHelper.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListernerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListernerHelper.hasChangeListeners();
    }

    protected void doDispose() throws BaseException {
        DisposeUtils.disposeQuietly((Disposable)this.changes);
    }
}

