/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.workspace;

import java.io.File;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.DatabaseStoresRepository;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.json.Json;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.future.FutureUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ChangeListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.ChainedIterator;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.tools.util.GetItemWithSizeAndIterator64;
import org.gvsig.tools.util.HasAFile;
import org.gvsig.tools.util.Rewind;
import org.gvsig.vcsgis.lib.DisposableIterableAdapter;
import org.gvsig.vcsgis.lib.UserCancelledException;
import org.gvsig.vcsgis.lib.VCSGisChange;
import org.gvsig.vcsgis.lib.VCSGisCodeGenerator;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisEntityEditable;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManagerImpl;
import org.gvsig.vcsgis.lib.VCSGisRepositoryLogDataImpl;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlan;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanStatus;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUserIdentificationRequester;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryChange;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLogData;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.EntitiesRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisAuthenticateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCheckoutRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCommitRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisEntitiesRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisHistoryRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisLogRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisTopologyPlansRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisUpdateRequest;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisUsersRequest;
import org.gvsig.vcsgis.lib.workspace.ChangesImpl;
import org.gvsig.vcsgis.lib.workspace.FeatureStoreObserver;
import org.gvsig.vcsgis.lib.workspace.StoreProperties;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceChange;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceChanges;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;
import org.gvsig.vcsgis.lib.workspace.tables.EntitiesTable;
import org.gvsig.vcsgis.lib.workspace.tables.LocalRevisionsTable;
import org.gvsig.vcsgis.lib.workspace.tables.LogsTable;
import org.gvsig.vcsgis.lib.workspace.tables.RemoteChangesTable;
import org.gvsig.vcsgis.lib.workspace.tables.TopologyplanTable;
import org.gvsig.vcsgis.lib.workspace.tables.UsersTable;
import org.gvsig.vcsgis.lib.workspace.tables.VarsTable;
import org.gvsig.vcsgis.lib.workspace.tables.WorkspaceChangesTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisWorkspaceImpl
extends AbstractDisposable
implements VCSGisWorkspace {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisWorkspaceImpl.class);
    public static final String CONFIG_WORKSPACE_CODE_NAME = "WORKSPACE_CODE";
    public static final String CONFIG_WORKSPACE_CODE_CHANGE_ON_FIRST_USE = "CHANGE_ON_FIRST_USE";
    public static final String CONFIG_WORKSPACE_LABEL_NAME = "WORKSPACE_LABEL";
    public static final String CONFIG_REPOSITORY_NAME = "REPOSITORY";
    public static final String CONFIG_USER_NAME = "USER";
    public static final String CONFIG_AUTHENTICATIONTOKEN_NAME = "AUTHENTICATIONTOKEN";
    public static final String CONFIG_REPOSITORY_ENTITY_CACHE_TIME_NAME = "REPOSITORY_ENTITY_CACHE_TIME";
    public static final String CONFIG_OFFLINE = "OFFLINE";
    public static final String CONFIG_ENTITY_LABEL_TEMPLATE = "ENTITY_LABEL_TEMPLATE";
    public static final String CONFIG_USE_SAFE_MODE = "USE_SAFE_MODE";
    private final Map<String, FeatureStore> storesCache;
    private Map<String, EntitiesTable.EntityRow> workspaceEntitiesByName;
    private Map<String, EntitiesTable.EntityRow> workspaceEntitiesByCode;
    private Map<String, VCSGisEntity> repositoryEntitiesByCode;
    private long repositoryEntitiesByCodeLastUpdate;
    private Set<FeatureStore> storeIgnoreChanges;
    private JDBCServerExplorer wsexplorer;
    private String code;
    private final VCSGisRepository repository;
    private final String label;
    private final FilteredLogger logger = new FilteredLogger(LOGGER, "VCSGisWorkspace", 10000L);
    private final VCSGisCodeGenerator codeGenerator;
    private final ChangeListenerHelper workspaceEntitiesChangeListeners;
    private final ChangeListenerHelper repositoryEntitiesChangeListeners;
    private Map<String, String> currentUserCodes;
    private Map<String, String> authenticationTokens;
    private VCSGisUserIdentificationRequester userIdentificationRequester;
    private long repositoryEntitiesCacheTime = 30000L;
    private boolean offline;
    private boolean safeMode;
    private String entityLabelTemplate;
    private boolean disposed = false;
    public static final Comparator<String> EQUALS_IGNORECASE_COMPARATOR = (o1, o2) -> StringUtils.compareIgnoreCase((String)o1, (String)o2);

    public VCSGisWorkspaceImpl(JDBCServerExplorer wsexplorer, VCSGisCodeGenerator codeGenerator, VCSGisRepository repository, String label) {
        this.codeGenerator = codeGenerator;
        this.storesCache = new HashMap<String, FeatureStore>();
        this.code = this.createUniqueCode();
        this.wsexplorer = wsexplorer;
        DisposeUtils.bind((Disposable)wsexplorer);
        this.repository = repository;
        DisposeUtils.bind((Disposable)repository);
        this.label = label;
        this.workspaceEntitiesChangeListeners = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
        this.repositoryEntitiesChangeListeners = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
        this.currentUserCodes = null;
        this.authenticationTokens = null;
        this.userIdentificationRequester = null;
        this.offline = false;
        this.safeMode = false;
        this.entityLabelTemplate = "${label}";
    }

    public VCSGisWorkspaceImpl(JDBCServerExplorer wsexplorer, VCSGisCodeGenerator codeGenerator) {
        this(wsexplorer, codeGenerator, (String)null, (String)null);
    }

    public VCSGisWorkspaceImpl(JDBCServerExplorer wsexplorer, VCSGisCodeGenerator codeGenerator, String newLabel) {
        this(wsexplorer, codeGenerator, codeGenerator.generateCode(), newLabel);
    }

    private VCSGisWorkspaceImpl(JDBCServerExplorer wsexplorer, VCSGisCodeGenerator codeGenerator, String newCode, String newLabel) {
        this.codeGenerator = codeGenerator;
        this.storesCache = new HashMap<String, FeatureStore>();
        this.wsexplorer = wsexplorer;
        DisposeUtils.bind((Disposable)wsexplorer);
        this.workspaceEntitiesChangeListeners = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
        this.repositoryEntitiesChangeListeners = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
        this.userIdentificationRequester = null;
        VarsTable varsTable = new VarsTable();
        if (StringUtils.isNotBlank((CharSequence)newCode)) {
            varsTable.set(this, CONFIG_WORKSPACE_CODE_NAME, newCode);
        }
        if (StringUtils.isNotBlank((CharSequence)newLabel)) {
            varsTable.set(this, CONFIG_WORKSPACE_LABEL_NAME, newLabel);
        }
        Map<String, String> vars = varsTable.getVars(this, CONFIG_REPOSITORY_NAME, CONFIG_WORKSPACE_CODE_NAME, CONFIG_USER_NAME, CONFIG_AUTHENTICATIONTOKEN_NAME, CONFIG_REPOSITORY_ENTITY_CACHE_TIME_NAME, CONFIG_WORKSPACE_LABEL_NAME, CONFIG_OFFLINE, CONFIG_ENTITY_LABEL_TEMPLATE, CONFIG_USE_SAFE_MODE);
        this.code = vars.get(CONFIG_WORKSPACE_CODE_NAME);
        if (this.code == null) {
            throw new RuntimeException("Can't retrieve code from workspace '" + this.getMessageLabel() + "'");
        }
        if (this.code.equalsIgnoreCase(CONFIG_WORKSPACE_CODE_CHANGE_ON_FIRST_USE)) {
            this.code = this.createUniqueCode();
            varsTable.set(this, CONFIG_WORKSPACE_CODE_NAME, this.code);
        }
        this.offline = DataTypeUtils.toBoolean((Object)vars.get(CONFIG_OFFLINE), (boolean)false);
        this.safeMode = false;
        this.entityLabelTemplate = vars.getOrDefault(CONFIG_ENTITY_LABEL_TEMPLATE, "${label}");
        this.repositoryEntitiesCacheTime = NumberUtils.toLong((String)vars.get(CONFIG_REPOSITORY_ENTITY_CACHE_TIME_NAME), (long)30000L);
        this.reloadWorkspaceEntities();
        this.repository = (VCSGisRepository)Json.toObject((String)vars.get(CONFIG_REPOSITORY_NAME));
        if (this.repository == null) {
            throw new RuntimeException("Can't retrieve repository from workspace '" + this.getMessageLabel() + "'");
        }
        this.setCurrentUserCode(this.repository, vars.get(CONFIG_USER_NAME));
        this.setAuthenticationToken(this.repository, vars.get(CONFIG_AUTHENTICATIONTOKEN_NAME));
        this.label = vars.get(CONFIG_WORKSPACE_LABEL_NAME);
    }

    private String getProviderName() {
        return this.wsexplorer.getProviderName();
    }

    public void initialize() throws Exception {
        DataManager dataManager = DALLocator.getDataManager();
        VarsTable varsTable = new VarsTable();
        varsTable.set(this, CONFIG_WORKSPACE_CODE_NAME, this.code);
        varsTable.set(this, CONFIG_WORKSPACE_LABEL_NAME, this.label);
        varsTable.set(this, CONFIG_REPOSITORY_NAME, this.repository.toJson().toString());
        varsTable.set(this, CONFIG_OFFLINE, BooleanUtils.toStringTrueFalse((boolean)this.offline));
        varsTable.set(this, CONFIG_USE_SAFE_MODE, BooleanUtils.toStringTrueFalse((boolean)this.safeMode));
        varsTable.set(this, CONFIG_ENTITY_LABEL_TEMPLATE, this.entityLabelTemplate);
    }

    private String getMessageLabel() {
        try {
            return this.wsexplorer.getParameters().getUrl();
        }
        catch (Exception ex) {
            return "unknown";
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        if (this.disposed) {
            return "BROKEN (" + this.label + ")";
        }
        return this.label;
    }

    public String getDebugInfo() {
        String url = this.getExplorerParameters() == null ? null : this.getExplorerParameters().getUrl();
        return "{ code:'" + Objects.toString(this.code) + "', label:'" + Objects.toString(this.label) + "', url:'" + Objects.toString(url) + "', disposed:'" + this.disposed + "'}";
    }

    protected void doDispose() {
        LOGGER.info("Workspace.dispose:" + this.getDebugInfo());
        this.disposed = true;
        for (Map.Entry<String, FeatureStore> entry : this.storesCache.entrySet()) {
            FeatureStore store = entry.getValue();
            if (store == null) continue;
            DisposeUtils.disposeQuietly((Disposable)store);
        }
        this.storesCache.clear();
        DisposeUtils.dispose((Disposable)this.wsexplorer);
        this.wsexplorer = null;
        this.code = null;
        DisposeUtils.disposeQuietly((Disposable)this.repository);
    }

    public JDBCServerExplorerParameters getExplorerParameters() {
        if (this.wsexplorer == null) {
            return null;
        }
        return this.wsexplorer.getParameters();
    }

    public boolean isInStoreIgnoreChanges(FeatureStore store) {
        if (this.storeIgnoreChanges == null) {
            return false;
        }
        return this.storeIgnoreChanges.contains(store);
    }

    private void addStoreIgnoreChanges(FeatureStore store) {
        if (this.storeIgnoreChanges == null) {
            this.storeIgnoreChanges = new HashSet<FeatureStore>();
        }
        this.storeIgnoreChanges.add(store);
    }

    private void removeStoreIgnoreChanges(FeatureStore store) {
        if (store == null) {
            return;
        }
        if (this.storeIgnoreChanges == null) {
            this.storeIgnoreChanges = new HashSet<FeatureStore>();
        }
        this.storeIgnoreChanges.remove(store);
    }

    public final void reloadWorkspaceEntities(Map<String, EntitiesTable.EntityRow> localEntities) {
        Disposable store = null;
        Disposable featureSet = null;
        try {
            HashMap<String, EntitiesTable.EntityRow> theEntitiesByName = new HashMap<String, EntitiesTable.EntityRow>();
            HashMap<String, EntitiesTable.EntityRow> theEntitiesByCode = new HashMap<String, EntitiesTable.EntityRow>();
            for (EntitiesTable.EntityRow entity : localEntities.values()) {
                theEntitiesByName.put(entity.getEntityName(), entity);
                theEntitiesByCode.put(entity.getCode(), entity);
                LOGGER.debug("===: loadEntities: " + entity.getEntityName() + " entity code " + entity.getEntityCode() + ", repo rev. " + entity.getRepositoryRevisionCode() + ", local rev. " + entity.getLocalRevisionCode());
            }
            this.workspaceEntitiesByName = theEntitiesByName;
            this.workspaceEntitiesByCode = theEntitiesByCode;
            this.workspaceEntitiesChangeListeners.fireEvent();
        }
        catch (Exception ex) {
            throw new VCSGisRuntimeException(250, VCSGisUtils.getErrorMessage(250));
        }
        finally {
            DisposeUtils.disposeQuietly(featureSet);
            DisposeUtils.disposeQuietly(store);
        }
    }

    public final void reloadWorkspaceEntities() {
        HashMap<String, EntitiesTable.EntityRow> localEntities = new HashMap<String, EntitiesTable.EntityRow>();
        EntitiesTable entitiesTable = new EntitiesTable();
        DisposableFeatureSetIterable allLocalEntities = null;
        try {
            allLocalEntities = entitiesTable.getAll(this);
            for (Feature lentity_f : allLocalEntities) {
                EntitiesTable.EntityRow entityRow = new EntitiesTable.EntityRow(this, lentity_f);
                localEntities.put(entityRow.getEntityName(), entityRow);
            }
        }
        catch (Exception ex) {
            throw new VCSGisRuntimeException(250, VCSGisUtils.getErrorMessage(250));
        }
        finally {
            DisposeUtils.dispose((Disposable)allLocalEntities);
        }
        this.reloadWorkspaceEntities(localEntities);
    }

    public ChangeListenerSupport getWorkspaceEntiesChangeListeners() {
        return this.workspaceEntitiesChangeListeners;
    }

    public ChangeListenerSupport getRepositoryEntiesChangeListeners() {
        return this.repositoryEntitiesChangeListeners;
    }

    public List<VCSGisWorkspaceEntity> getWorkspaceEntities() {
        if (this.disposed) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<VCSGisWorkspaceEntity> entities = new ArrayList<VCSGisWorkspaceEntity>();
        entities.addAll(this.getEntitiesAsEntityRow());
        return entities;
    }

    private Collection<EntitiesTable.EntityRow> getEntitiesAsEntityRow() {
        if (this.workspaceEntitiesByName == null) {
            this.reloadWorkspaceEntities();
        }
        return this.workspaceEntitiesByName.values();
    }

    public EntitiesTable.EntityRow getWorkspaceEntityByName(String name) {
        if (this.workspaceEntitiesByName == null) {
            this.reloadWorkspaceEntities();
        }
        return this.workspaceEntitiesByName.get(name);
    }

    public EntitiesTable.EntityRow getWorkspaceEntityByCode(String code) {
        if (this.workspaceEntitiesByCode == null) {
            this.reloadWorkspaceEntities();
        }
        return this.workspaceEntitiesByCode.get(code);
    }

    private void addWorkspaceEntity(EntitiesTable.EntityRow entity) {
        if (this.workspaceEntitiesByCode == null) {
            this.reloadWorkspaceEntities();
        }
        this.workspaceEntitiesByCode.put(entity.getEntityCode(), entity);
        this.workspaceEntitiesByName.put(entity.getEntityName(), entity);
    }

    private boolean existsInWorkspace(String entity) {
        EntitiesTable.EntityRow lentity = this.getWorkspaceEntity(entity);
        return lentity != null;
    }

    public boolean existsInWorkspace(OpenFeatureStoreParameters parameters) {
        if (!this.isInMyDatabase(parameters)) {
            return false;
        }
        JDBCStoreParameters params = (JDBCStoreParameters)parameters;
        return this.existsInWorkspace(params.getTable());
    }

    public boolean existsInWorkspace(VCSGisEntity entity) {
        if (entity == null) {
            return false;
        }
        if (this.existsInWorkspace(entity.getEntityName())) {
            return true;
        }
        return this.existsInWorkspace(entity.getEntityCode());
    }

    public EntitiesTable.EntityRow getWorkspaceEntity(String entity) {
        EntitiesTable.EntityRow wsentity = this.getWorkspaceEntityByCode(entity);
        if (wsentity == null) {
            wsentity = this.getWorkspaceEntityByName(entity);
        }
        return wsentity;
    }

    public VCSGisEntity getRepositoryEntityByCode(String entityCode) {
        if (this.isOffline()) {
            EntitiesTable.EntityRow xx = this.getWorkspaceEntityByCode(entityCode);
            if (xx == null || StringUtils.isBlank((CharSequence)xx.getRepositoryRevisionCode())) {
                return null;
            }
            return xx;
        }
        if (this.repositoryEntitiesByCode == null) {
            this.reloadRepositoryEntities(null);
        }
        return this.repositoryEntitiesByCode.get(entityCode);
    }

    public VCSGisEntity getRepositoryEntityByName(String entityName) {
        if (this.isOffline()) {
            EntitiesTable.EntityRow xx = this.getWorkspaceEntityByName(entityName);
            if (xx == null || StringUtils.isBlank((CharSequence)xx.getRepositoryRevisionCode())) {
                return null;
            }
            return xx;
        }
        if (this.repositoryEntitiesByCode == null) {
            this.reloadRepositoryEntities(null);
        }
        for (VCSGisEntity entity : this.repositoryEntitiesByCode.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)entity.getEntityName(), (CharSequence)entityName)) continue;
            return entity;
        }
        return null;
    }

    private boolean hasRepositoryEntities() {
        if (this.disposed) {
            return false;
        }
        return this.repositoryEntitiesByCode != null;
    }

    public List<VCSGisEntity> getRepositoryEntities() {
        if (this.disposed) {
            return Collections.EMPTY_LIST;
        }
        if (this.isOffline()) {
            ArrayList<VCSGisEntity> rentities = new ArrayList<VCSGisEntity>();
            for (VCSGisWorkspaceEntity workspaceEntity : this.getWorkspaceEntities()) {
                if (!StringUtils.isNotBlank((CharSequence)workspaceEntity.getRepositoryRevisionCode())) continue;
                rentities.add((VCSGisEntity)workspaceEntity);
            }
            return rentities;
        }
        if (this.repositoryEntitiesByCode == null) {
            this.reloadRepositoryEntities(null);
        }
        ArrayList<VCSGisEntity> entities = new ArrayList<VCSGisEntity>(this.repositoryEntitiesByCode.values());
        return entities;
    }

    public VCSGisEntity getEntity(String entityName) {
        EntitiesTable.EntityRow entity = this.getWorkspaceEntity(entityName);
        if (entity == null) {
            entity = this.getRepositoryEntity(entityName);
        }
        return entity;
    }

    public VCSGisEntity getRepositoryEntity(String entity) {
        if (this.isOffline()) {
            EntitiesTable.EntityRow xx = this.getWorkspaceEntity(entity);
            if (xx == null || StringUtils.isBlank((CharSequence)xx.getRepositoryRevisionCode())) {
                return null;
            }
            return xx;
        }
        VCSGisEntity rentity = this.getRepositoryEntityByCode(entity);
        if (rentity == null) {
            rentity = this.getRepositoryEntityByName(entity);
        }
        return rentity;
    }

    public void forceReloadWorkspaceEntities() {
        this.workspaceEntitiesByCode = null;
        this.workspaceEntitiesByName = null;
    }

    public void create_table(String name) {
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(name);
        if (entity == null) {
            throw new IllegalArgumentException("Can't locate informacion of table '" + name + "'.");
        }
        this.create_table((VCSGisEntity)entity);
    }

    public void create_table(VCSGisEntity entity) {
        this.create_table(entity, entity.getEntityName());
    }

    public void create_table(VCSGisEntity entity, String tableName) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity is null.");
        }
        try {
            JDBCNewStoreParameters addparams = (JDBCNewStoreParameters)this.wsexplorer.getAddParameters(tableName);
            addparams.setDefaultFeatureType(entity.getFeatureType());
            this.wsexplorer.add(this.getProviderName(), (NewDataStoreParameters)addparams, true);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create table '" + entity.getEntityName() + "'.", ex);
        }
    }

    public FeatureType getFeatureType(String tableName) {
        EntitiesTable.EntityRow entity = null;
        if (!VCSGisManagerImpl.INTERNAL_WORKSPACE_TABLES.contains(tableName)) {
            entity = this.getWorkspaceEntityByName(tableName);
            if (entity == null) {
                return null;
            }
            return entity.getFeatureType();
        }
        FeatureType ft = null;
        try {
            FeatureStore store = this.storesCache.get(tableName);
            if (store != null) {
                ft = store.getDefaultFeatureType();
            } else {
                DataManager dataManager = DALLocator.getDataManager();
                JDBCStoreParameters params = this.wsexplorer.get(tableName);
                store = (FeatureStore)dataManager.openStore(this.getProviderName(), (DataStoreParameters)params);
                this.storesCache.put(tableName, store);
                ft = store.getDefaultFeatureType();
            }
            return ft;
        }
        catch (Exception ex) {
            String msg = "can't open store from '" + this.getMessageLabel() + "'.";
            throw new RuntimeException(msg, ex);
        }
    }

    public FeatureStore getFeatureStore(String tableName) {
        EntitiesTable.EntityRow entity = null;
        if (!VCSGisManagerImpl.INTERNAL_WORKSPACE_TABLES.contains(tableName)) {
            entity = this.getWorkspaceEntityByName(tableName);
            if (entity == null) {
                return null;
            }
            return this.getFeatureStore((VCSGisEntity)entity);
        }
        FeatureStore store = this.storesCache.get(tableName);
        if (store != null) {
            DisposeUtils.bind((Disposable)store);
            return store;
        }
        DataManager dataManager = DALLocator.getDataManager();
        try {
            JDBCStoreParameters params = this.wsexplorer.get(tableName);
            store = (FeatureStore)dataManager.openStore(this.getProviderName(), (DataStoreParameters)params, true);
            this.storesCache.put(tableName, store);
            DisposeUtils.bind((Disposable)store);
            return store;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't open store from '" + this.getMessageLabel() + "'. This may not be a bug.", (Throwable)ex);
            return null;
        }
    }

    private FeatureStore getFeatureStore(VCSGisEntity entity) {
        FeatureStore store = this.storesCache.get(entity.getEntityName());
        if (store != null) {
            DisposeUtils.bind((Disposable)store);
            return store;
        }
        DataManager dataManager = DALLocator.getDataManager();
        try {
            JDBCStoreParameters params = this.wsexplorer.get(entity.getEntityName());
            store = (FeatureStore)dataManager.openStore(this.getProviderName(), (DataStoreParameters)params);
            StoreProperties.set(store, this, entity.getEntityName());
            this.storesCache.put(entity.getEntityName(), store);
            DisposeUtils.bind((Disposable)store);
            return store;
        }
        catch (Exception ex) {
            LOGGER.warn("can't open store from '" + this.getMessageLabel() + "'.", (Throwable)ex);
            return null;
        }
    }

    public FeatureStore openFeatureStore(VCSGisEntity entity) {
        DataManager dataManager = DALLocator.getDataManager();
        try {
            JDBCStoreParameters params = this.wsexplorer.get(entity.getEntityName());
            FeatureStore store = (FeatureStore)dataManager.openStore(this.getProviderName(), (DataStoreParameters)params);
            return store;
        }
        catch (Exception ex) {
            LOGGER.warn("can't open store from '" + this.getMessageLabel() + "'.", (Throwable)ex);
            return null;
        }
    }

    public FeatureStore openFeatureStore(String tableName, boolean ignoreDALResource) {
        DataManager dataManager = DALLocator.getDataManager();
        try {
            JDBCStoreParameters params = this.wsexplorer.get(tableName);
            FeatureStore store = (FeatureStore)dataManager.openStore(this.getProviderName(), (DataStoreParameters)params, ignoreDALResource);
            return store;
        }
        catch (Exception ex) {
            LOGGER.warn("can't open store from '" + this.getMessageLabel() + "'.", (Throwable)ex);
            return null;
        }
    }

    public OpenDataStoreParameters createOpenStoreParameters(String tableName) {
        try {
            JDBCStoreParameters params = this.wsexplorer.get(tableName);
            return params;
        }
        catch (Exception ex) {
            LOGGER.warn("can't create open store parameters from '" + this.getMessageLabel() + "'.", (Throwable)ex);
            return null;
        }
    }

    public final String createUniqueCode() {
        return this.codeGenerator.generateCode();
    }

    public String getErrorMessage(int errcode) {
        return VCSGisUtils.getErrorMessage(errcode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDeleteChanges(String editingSession, FeatureStore userStore, Expression exp) {
        String entityName = StoreProperties.getEntityName(userStore);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return 5;
        }
        if (this.isInStoreIgnoreChanges(userStore)) {
            return 0;
        }
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(entityName);
        if (entity == null) {
            return 5;
        }
        if (entity.getState() == 128) {
            return 0;
        }
        FeatureStore workspaceChangesStore = null;
        int err = 300;
        try {
            workspaceChangesStore = this.openFeatureStore("VCSGIS_WSCHANGES", false);
            workspaceChangesStore.edit(3);
            FeatureSet deletedsFeatures = userStore.getFeatureSet(exp);
            err = 310;
            for (Feature f : deletedsFeatures) {
                this.addDeleteChange(editingSession, entity, workspaceChangesStore, f.getString(entity.getFeatureIdFieldName()), f.getString(entity.getFieldForLabel()), f);
            }
            workspaceChangesStore.finishEditing();
            err = 0;
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't add  delete changes.", (Throwable)ex);
                FeatureStore.cancelEditingQuietly((FeatureStore)workspaceChangesStore);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(workspaceChangesStore);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)workspaceChangesStore);
        }
        DisposeUtils.disposeQuietly((Disposable)workspaceChangesStore);
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addChange(String editingSession, int operation, FeatureStore userStore, Feature feature) {
        String entityName = StoreProperties.getEntityName(userStore);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return 5;
        }
        if (this.isInStoreIgnoreChanges(userStore)) {
            LOGGER.debug("===: ADD_CHANGE: Skip (" + userStore.getName() + ")");
            return 0;
        }
        boolean isUserStoreInAppendMode = userStore.getMode() == 2;
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(entityName);
        if (entity.getState() == 128) {
            return 0;
        }
        FeatureStore changesStore = this.openFeatureStore("VCSGIS_WSCHANGES", false);
        try {
            changesStore.edit(3);
            String featureCode = feature.getString(entity.getFeatureIdFieldName());
            switch (operation) {
                case 0: {
                    Feature fuser22;
                    String label = feature.getString(entity.getFieldForLabel());
                    if (this.useSafeMode() && !isUserStoreInAppendMode && (fuser22 = userStore.findFirst("VCSGISCODE = '" + featureCode + "'")) == null) {
                        throw new RuntimeException("Can't get original feature for deleted vcsgiscode = '" + featureCode + "'");
                    }
                    int fuser22 = this.addDeleteChange(editingSession, entity, changesStore, featureCode, label, userStore.getOriginalFeature(feature));
                    return fuser22;
                }
                case 2: {
                    Feature fuser32;
                    if (this.useSafeMode() && !isUserStoreInAppendMode && (fuser32 = userStore.findFirst("VCSGISCODE = '" + featureCode + "'")) != null) {
                        throw new RuntimeException("Already exists feature with vcsgiscode = '" + featureCode + "'");
                    }
                    int fuser32 = this.addChange(editingSession, entity, operation, changesStore, feature, userStore.getOriginalFeature(feature), null);
                    return fuser32;
                }
                case 1: {
                    Feature fuser;
                    if (this.useSafeMode() && !isUserStoreInAppendMode && (fuser = userStore.findFirst("VCSGISCODE = '" + featureCode + "'")) == null) {
                        throw new RuntimeException("Can't get original feature for update vcsgiscode = '" + featureCode + "'");
                    }
                    int n = this.addChange(editingSession, entity, operation, changesStore, feature, userStore.getOriginalFeature(feature), null);
                    return n;
                }
            }
            LOGGER.warn("Unsupported operation " + operation + ".");
            int n = this.addChange(editingSession, entity, operation, changesStore, feature, userStore.getOriginalFeature(feature), null);
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add change (op " + VCSGisUtils.getOperationLabel(operation) + ", " + entity.getEntityName() + ")", (Throwable)ex);
            changesStore.cancelEditingQuietly();
            int n = 320;
            return n;
        }
        finally {
            changesStore.finishEditingQuietly();
            DisposeUtils.dispose((Disposable)changesStore);
        }
    }

    private int addChange(String editingSession, EntitiesTable.EntityRow entity, int operation, FeatureStore changesStore, Feature feature, Feature oldFeature, Map<String, Integer> previousOperations) {
        if (entity.getState() == 128) {
            return 0;
        }
        if (operation == 0) {
            String featureCode = feature.getString(entity.getFeatureIdFieldName());
            String label = feature.getString(entity.getFieldForLabel());
            return this.addDeleteChange(editingSession, entity, changesStore, featureCode, label, oldFeature);
        }
        if (oldFeature == null && feature instanceof EditableFeature) {
            oldFeature = ((EditableFeature)feature).getSource();
        }
        try {
            String featureCode = feature.getString(entity.getFeatureIdFieldName());
            Integer previousOperation = null;
            if (previousOperations != null) {
                previousOperation = previousOperations.get(featureCode);
            } else {
                Feature previousChange = changesStore.findFirst("WSCH_FEATURECODE = '" + featureCode + "'");
                if (previousChange != null) {
                    previousOperation = previousChange.getInt("WSCH_OPERATION");
                }
            }
            if (previousOperation != null) {
                switch (operation) {
                    case 2: {
                        LOGGER.warn("A insert change cannot be added as there is a previous change with operation " + previousOperation + " (featureCode=" + featureCode + ")");
                        return 320;
                    }
                    case 1: {
                        switch (previousOperation) {
                            case 1: 
                            case 2: {
                                return 0;
                            }
                            case 0: {
                                LOGGER.warn("A update change cannot be added as there is a previous change with operation delete (featureCode=" + featureCode + ")");
                                return 320;
                            }
                        }
                        LOGGER.warn("A update change cannot be added as there is a previous change with operation " + previousOperation + " (featureCode=" + featureCode + ")");
                        return 0;
                    }
                    case 0: {
                        return 320;
                    }
                }
                return 0;
            }
            WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, (Feature)changesStore.createNewFeature());
            change.newCode();
            change.setEditingSession(editingSession);
            change.setEntityCode(entity.getEntityCode());
            change.setFeatureCode(featureCode);
            change.setOperation(operation);
            change.setLabel(feature.getString(entity.getFieldForLabel()));
            if (oldFeature != null) {
                change.setData(oldFeature.toJson().toString());
            }
            change.setSelected(true);
            switch (operation) {
                case 2: {
                    change.setStatus(2);
                    break;
                }
                case 1: {
                    change.setStatus(4);
                }
            }
            change.insert(changesStore);
            if (previousOperations != null) {
                previousOperations.put(featureCode, change.getOperation());
            }
            this.updateEntityState(entity, change.getOperation());
            return 0;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add change (op " + VCSGisUtils.getOperationLabel(operation) + ", " + entity.getEntityName() + ")", (Throwable)ex);
            return 320;
        }
    }

    private int addDeleteChange(String editingSession, EntitiesTable.EntityRow entity, FeatureStore changesStore, String featureCode, String label, Feature oldFeature) {
        if (entity.getState() == 128) {
            return 0;
        }
        try {
            WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
            WorkspaceChangesTable.WorkspaceChangeRow previousChange = changesTable.find(this, changesStore, entity.getEntityCode(), featureCode);
            if (previousChange != null) {
                switch (previousChange.getOperation()) {
                    case 2: {
                        previousChange.setOperation(4);
                        previousChange.setSelected(true);
                        previousChange.setPreviousOperation(2);
                        previousChange.setEditingSession(editingSession);
                        previousChange.update(changesStore);
                        this.updateEntityState(entity, previousChange.getOperation());
                        return 0;
                    }
                    case 1: {
                        previousChange.setOperation(0);
                        previousChange.setSelected(true);
                        previousChange.setPreviousOperation(previousChange.getOperation());
                        previousChange.setEditingSession(editingSession);
                        previousChange.update(changesStore);
                        this.updateEntityState(entity, previousChange.getOperation());
                        return 0;
                    }
                    case 0: {
                        LOGGER.warn("A delete change cannot be added as there is a previous change with operation delete (featureCode=" + featureCode + ")");
                        return 320;
                    }
                    case 4: {
                        LOGGER.warn("A delete change cannot be added as there is a previous change with operation ignore (featureCode=" + featureCode + ")");
                        return 320;
                    }
                }
                LOGGER.warn("A delete change cannot be added as there is a previous change with operation " + previousChange.getOperation() + " (featureCode=" + featureCode + ")");
            }
            WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, (Feature)changesStore.createNewFeature());
            change.newCode();
            change.setPreviousOperation(-1);
            change.setEditingSession(editingSession);
            change.setEntityCode(entity.getEntityCode());
            change.setFeatureCode(featureCode);
            change.setOperation(0);
            change.setLabel(label);
            if (oldFeature != null) {
                change.setData(oldFeature.toJson().toString());
            }
            change.setSelected(true);
            change.setStatus(4);
            change.insert(changesStore);
            this.updateEntityState(entity, change.getOperation());
            return 0;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't add delete change (" + entity.getEntityName() + ")", (Throwable)ex);
            return 320;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntityState(EntitiesTable.EntityRow entity, int operation) throws DataException {
        if (entity.getState() == 128) {
            return;
        }
        boolean save = false;
        block1 : switch (operation) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                switch (entity.getState()) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: {
                        break block1;
                    }
                    case 1: {
                        entity.setState(4);
                        save = true;
                        break block1;
                    }
                    case 6: {
                        entity.setState(8);
                        save = true;
                        break block1;
                    }
                }
                break;
            }
            case 3: {
                entity.setState(2);
                save = true;
            }
        }
        if (save) {
            FeatureStore entitiesStore = null;
            try {
                entitiesStore = this.openFeatureStore("VCSGIS_ENTITIES", true);
                entitiesStore.edit(1);
                entity.update(entitiesStore);
                entitiesStore.finishEditing();
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(entitiesStore);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)entitiesStore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntityState(EntitiesTable.EntityRow entity, boolean save) throws DataException {
        block4: {
            block3: {
                if (entity.getState() == 128) {
                    return;
                }
                if (!save) break block3;
                FeatureStore entitiesStore = null;
                try {
                    entitiesStore = this.openFeatureStore("VCSGIS_ENTITIES", true);
                    entitiesStore.edit(1);
                    entity.updateState();
                    entity.update(entitiesStore);
                    entitiesStore.finishEditing();
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(entitiesStore);
                    throw throwable;
                }
                DisposeUtils.disposeQuietly((Disposable)entitiesStore);
                break block4;
            }
            entity.updateState();
        }
    }

    public int addEntity(FeatureType featureType, String name, String description, String fieldForLabel) {
        return this.addEntity(featureType, name, description, fieldForLabel, null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addEntity(FeatureType featureType, String name, String description, String fieldForLabel, String category, String label, String model, String resources, String pkName) {
        Disposable store = null;
        int err = 0;
        try {
            IProjection crs;
            LOGGER.debug("===: ADD_ENTITY " + this.getCode() + ", '" + this.getLabel() + "', " + name);
            EditableFeatureType ft = featureType.getCopy().getEditable();
            for (FeatureAttributeDescriptor attr : ft.getPrimaryKey()) {
                EditableFeatureAttributeDescriptor editAttr = (EditableFeatureAttributeDescriptor)attr;
                editAttr.setIsPrimaryKey(false);
                editAttr.setAllowNull(false);
                editAttr.setIsIndexed(true);
                editAttr.setAllowIndexDuplicateds(false);
            }
            EditableFeatureAttributeDescriptor attr = (EditableFeatureAttributeDescriptor)ft.getAttributeDescriptor("VCSGISCODE");
            if (attr == null) {
                err = 210;
                attr = (EditableFeatureAttributeDescriptor)ft.add("VCSGISCODE", 8).setSize(60).setIsPrimaryKey(true).setIsIndexed(true).setAllowIndexDuplicateds(false).setLabel("VCSGIS Code");
                ft.setHasOID(false);
            } else if (!attr.isPrimaryKey()) {
                attr.setIsPrimaryKey(true);
                ft.setHasOID(false);
            }
            attr.getTags().set("dynform.readonly", (Object)true);
            EditableFeatureAttributeDescriptor geomattr = (EditableFeatureAttributeDescriptor)ft.getDefaultGeometryAttribute();
            if (geomattr != null) {
                geomattr.setIsIndexed(true);
            }
            featureType = ft.getNotEditableCopy();
            String defaultFieldForLabel = null;
            FeatureAttributeDescriptor[] pk = featureType.getPrimaryKey();
            defaultFieldForLabel = pk == null || pk.length < 1 ? featureType.getAttributeName(0) : pk[0].getName();
            err = 220;
            Tags tags = featureType.getTags();
            EntitiesTable.EntityRow entity = new EntitiesTable.EntityRow(this);
            entity.newCode();
            entity.setEntityName(name);
            entity.setDataTableName("VCSGISREPO_DATA");
            entity.setFeatureIdFieldName("VCSGISCODE");
            entity.setGeometryFieldName(featureType.getDefaultGeometryAttributeName());
            entity.setDescription(description);
            entity.setFieldForLabel(StringUtils.equalsIgnoreCase((CharSequence)fieldForLabel, (CharSequence)"@AUTODETECT") ? tags.getString("vcsgis.fieldforlabel", defaultFieldForLabel) : fieldForLabel);
            entity.setFeatureTypeAsJson(featureType.toJsonBuilder().toString());
            entity.setLocalRevisionCode(null);
            entity.setRepositoryRevisionCode(null);
            entity.setCategory(StringUtils.equalsIgnoreCase((CharSequence)category, (CharSequence)"@AUTODETECT") ? tags.getString("vcsgis.category", null) : category);
            entity.setDataModels(StringUtils.equalsIgnoreCase((CharSequence)model, (CharSequence)"@AUTODETECT") ? tags.getString("vcsgis.datamodel", null) : model);
            entity.setResources(StringUtils.equalsIgnoreCase((CharSequence)resources, (CharSequence)"@AUTODETECT") ? tags.getString("vcsgis.resources", null) : resources);
            entity.setLabel(StringUtils.equalsIgnoreCase((CharSequence)label, (CharSequence)"@AUTODETECT") ? tags.getString("vcsgis.label", null) : label);
            if (geomattr != null && (crs = geomattr.getSRS()) != null) {
                entity.setCRS(crs);
            }
            entity.setState(2);
            entity.insert();
            this.addWorkspaceEntity(entity);
            this.forceReloadWorkspaceEntities();
            err = 310;
            WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this);
            change.newCode();
            change.setEditingSession(null);
            change.setEntityCode(entity.getCode());
            change.setFeatureCode(null);
            change.setOperation(3);
            change.setSelected(true);
            change.insert();
            this.create_table((VCSGisEntity)entity);
        }
        catch (VCSGisRuntimeException ex) {
            LOGGER.warn("can't add entity '" + name + "'.", (Throwable)ex);
            if (store != null) {
                store.cancelEditingQuietly();
            }
            int n = ex.getErrnum();
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("can't add entity '" + name + "'.", (Throwable)ex);
            if (store != null) {
                store.cancelEditingQuietly();
            }
            int n = err;
            return n;
        }
        finally {
            DisposeUtils.disposeQuietly(store);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addChanges(FeatureStore store, String editingSession, Iterator<Feature> insertedsFeatures, Iterator<Feature> updatedsFeatures, Iterator<FeatureReference> deletedsFeatures, Iterator<FeatureType.FeatureTypeChanged> changedsFeatureTypes) {
        String entityName = StoreProperties.getEntityName(store);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return 5;
        }
        if (this.isInStoreIgnoreChanges(store)) {
            LOGGER.debug("===: ADD_CHANGE: Skip (" + store.getName() + ")");
            return 0;
        }
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(entityName);
        if (entity == null) {
            return 5;
        }
        if (entity.getState() == 128) {
            return 0;
        }
        if (this.isCorrupt((VCSGisEntity)entity, store, 0)) {
            return 0;
        }
        FeatureStore workspaceChangesStore = null;
        int err = 300;
        try {
            Feature f;
            workspaceChangesStore = this.openFeatureStore("VCSGIS_WSCHANGES", false);
            err = 310;
            Map<String, Integer> previousOperations = null;
            if (updatedsFeatures instanceof Rewind && insertedsFeatures instanceof Rewind) {
                previousOperations = this.calculatePreviousOperations(entity, workspaceChangesStore, insertedsFeatures, updatedsFeatures);
                workspaceChangesStore.edit(2);
            } else {
                workspaceChangesStore.edit(3);
            }
            if (insertedsFeatures != null) {
                while (insertedsFeatures.hasNext()) {
                    f = insertedsFeatures.next();
                    if (f == null) continue;
                    if (this.useSafeMode()) {
                        String vcsgiscode = f.getString("VCSGISCODE");
                        Feature fuser = store.findFirst("VCSGISCODE = '" + vcsgiscode + "'");
                        if (fuser != null) {
                            err = 310;
                            throw new RuntimeException("Feature already exists for vcsgiscode = '" + vcsgiscode + "'");
                        }
                    }
                    this.addChange(editingSession, entity, 2, workspaceChangesStore, f, null, previousOperations);
                }
            }
            if (updatedsFeatures != null) {
                while (updatedsFeatures.hasNext()) {
                    f = updatedsFeatures.next();
                    if (f == null) continue;
                    Feature originalFeature = store.getOriginalFeature(f);
                    if (this.useSafeMode()) {
                        String vcsgiscode = originalFeature.getString("VCSGISCODE");
                        Feature fuser = store.findFirst("VCSGISCODE = '" + vcsgiscode + "'");
                        if (fuser == null) {
                            err = 310;
                            throw new RuntimeException("Can't get original feature for updated vcsgiscode = '" + vcsgiscode + "'");
                        }
                    }
                    this.addChange(editingSession, entity, 1, workspaceChangesStore, f, originalFeature, previousOperations);
                }
            }
            if (previousOperations != null) {
                workspaceChangesStore.finishEditing();
                workspaceChangesStore.edit(3);
            }
            if (deletedsFeatures != null) {
                while (deletedsFeatures.hasNext()) {
                    Feature f2;
                    FeatureReference fr = deletedsFeatures.next();
                    if (fr == null || (f2 = fr.getFeatureQuietly()) == null) continue;
                    Feature originalFeature = store.getOriginalFeature(fr);
                    if (this.useSafeMode()) {
                        String vcsgiscode = originalFeature.getString("VCSGISCODE");
                        Feature fuser = store.findFirst("VCSGISCODE = '" + vcsgiscode + "'");
                        if (fuser == null) {
                            err = 310;
                            throw new RuntimeException("Can't get original feature for deleted vcsgiscode = '" + vcsgiscode + "'");
                        }
                    }
                    this.addDeleteChange(editingSession, entity, workspaceChangesStore, f2.getString(entity.getFeatureIdFieldName()), f2.getString(entity.getFieldForLabel()), originalFeature);
                }
            }
            workspaceChangesStore.finishEditing();
            if (changedsFeatureTypes != null && changedsFeatureTypes.hasNext()) {
                try {
                    entity.setState(128);
                    entity.update();
                }
                catch (Throwable t) {
                    LOGGER.warn("Can't update entity state");
                }
            }
            err = 0;
        }
        catch (Exception ex) {
            block27: {
                try {
                    LOGGER.warn("Can't add changes.", (Throwable)ex);
                    if (workspaceChangesStore == null) break block27;
                    workspaceChangesStore.cancelEditingQuietly();
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(workspaceChangesStore);
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)workspaceChangesStore);
        }
        DisposeUtils.disposeQuietly((Disposable)workspaceChangesStore);
        return err;
    }

    private Map<String, Integer> calculatePreviousOperations0(EntitiesTable.EntityRow entity, FeatureStore changesStore, Iterator<Feature> insertedsFeatures, Iterator<Feature> updatedsFeatures) {
        try {
            HashMap<String, Integer> previousOperations = new HashMap<String, Integer>();
            ChainedIterator it = new ChainedIterator(new Iterator[]{insertedsFeatures, updatedsFeatures});
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                String featureCode = feature.getString(entity.getFeatureIdFieldName());
                Feature previousChange = changesStore.findFirst("WSCH_FEATURECODE = '" + featureCode + "'");
                if (previousChange == null) continue;
                int previousOperation = previousChange.getInt("WSCH_OPERATION");
                previousOperations.put(featureCode, previousOperation);
            }
            ((Rewind)insertedsFeatures).rewind();
            ((Rewind)updatedsFeatures).rewind();
            return previousOperations;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't calculate previus operations.", (Throwable)ex);
            return null;
        }
    }

    private Map<String, Integer> calculatePreviousOperations(EntitiesTable.EntityRow entity, FeatureStore changesStore, Iterator<Feature> insertedsFeatures, Iterator<Feature> updatedsFeatures) {
        try {
            HashMap<String, Integer> previousOperations = new HashMap<String, Integer>();
            ChainedIterator it = new ChainedIterator(new Iterator[]{insertedsFeatures, updatedsFeatures});
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            int count = 0;
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                String featureCode = feature.getString(entity.getFeatureIdFieldName());
                builder.or((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column("WSCH_FEATURECODE"), (ExpressionBuilder.Value)builder.constant((Object)featureCode)));
                String filter = builder.build();
                if (it.hasNext() && ++count != 200) continue;
                if (filter != null) {
                    FeatureSet set = changesStore.getFeatureSet(filter);
                    for (Feature previousChange : set) {
                        if (previousChange == null) continue;
                        String featureCode2 = previousChange.getString("WSCH_FEATURECODE");
                        int previousOperation = previousChange.getInt("WSCH_OPERATION");
                        previousOperations.put(featureCode2, previousOperation);
                    }
                    DisposeUtils.disposeQuietly((Disposable)set);
                }
                builder = ExpressionUtils.createExpressionBuilder();
                count = 0;
            }
            ((Rewind)insertedsFeatures).rewind();
            ((Rewind)updatedsFeatures).rewind();
            return previousOperations;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't calculate previus operations.", (Throwable)ex);
            return null;
        }
    }

    public int cancelChanges(FeatureStore store, String editingSession) {
        String entityName = StoreProperties.getEntityName(store);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return 5;
        }
        if (this.isInStoreIgnoreChanges(store)) {
            LOGGER.debug("===: CANCEL_CHANGES: Skip (" + store.getName() + ")");
            return 0;
        }
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(entityName);
        if (entity == null) {
            return 5;
        }
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        changesTable.revertChangedLocalChanges(this, (VCSGisEntity)entity, editingSession);
        changesTable.removeLocalChanges(this, (VCSGisEntity)entity, editingSession);
        return 0;
    }

    public int acceptChanges(FeatureStore store, String editingSession) {
        String entityName = StoreProperties.getEntityName(store);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return 5;
        }
        if (this.isInStoreIgnoreChanges(store)) {
            LOGGER.debug("===: CANCEL_CHANGES: Skip (" + store.getName() + ")");
            return 0;
        }
        EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(entityName);
        if (entity == null) {
            return 5;
        }
        if (entity.getState() == 128) {
            return 0;
        }
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        changesTable.removeIgnoredLocalChanges(this, (VCSGisEntity)entity, editingSession);
        return 0;
    }

    public int add(String name, FeatureStore source, String fieldForLabel) {
        return this.add(name, source, fieldForLabel, null, null, null, null, null, true, null);
    }

    public int add(String name, FeatureStore source, String fieldForLabel, String category, String label) {
        return this.add(name, source, fieldForLabel, category, label, null, null, null, true, null);
    }

    public int add(String name, FeatureStore source, String fieldForLabel, String category, String label, String model, String resources, String pkName, boolean importData, SimpleTaskStatus status) {
        if (this.isInMyDatabase(source)) {
            return this.addExistingTable(name, source, fieldForLabel, category, label, model, resources, pkName, status);
        }
        return this.addNewTable(null, name, source, fieldForLabel, category, label, model, resources, pkName, importData, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int addNewTable(String editingSession, String name, FeatureStore source, String fieldForLabel, String category, String label, String model, String resources, String pkName, boolean importData, SimpleTaskStatus status) {
        int n;
        FeatureStore changesStore;
        DataTransaction transaction;
        block18: {
            int n2;
            block17: {
                if (this.getEntity(name) != null) {
                    return 200;
                }
                I18nManager i18n = ToolsLocator.getI18nManager();
                if (status == null) {
                    status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Add_layer"));
                    status.setAutoremove(true);
                    status.add();
                } else {
                    status.push();
                }
                FeatureStore target = null;
                FeatureSet srcFeatures = null;
                int errcode = 0;
                transaction = null;
                changesStore = null;
                try {
                    transaction = DALLocator.getDataManager().createTransaction();
                    transaction.begin();
                    LOGGER.debug("===: ADD " + this.getCode() + ", '" + this.getLabel() + "', " + name);
                    EntitiesTable.EntityRow entity = this.getWorkspaceEntityByName(name);
                    if (entity != null) {
                        int n3 = 200;
                        return n3;
                    }
                    status.message(i18n.getTranslation("_Adding_table_layer"));
                    FeatureType ft = source.getDefaultFeatureTypeQuietly();
                    errcode = this.addEntity(ft, name, null, fieldForLabel, category, label, model, resources, pkName);
                    if (errcode != 0) {
                        transaction.rollbackQuietly();
                        int n4 = errcode;
                        return n4;
                    }
                    errcode = 400;
                    target = this.openFeatureStore(name, false);
                    transaction.add((DataStore)target);
                    errcode = 410;
                    status.message(i18n.getTranslation("_Preparing_source"));
                    srcFeatures = source.getFeatureSet();
                    transaction.add((Disposable)srcFeatures);
                    errcode = 420;
                    target.edit(2);
                    changesStore = this.openFeatureStore("VCSGIS_WSCHANGES", false);
                    transaction.add((DataStore)changesStore);
                    changesStore.edit(2);
                    this.addStoreIgnoreChanges(target);
                    entity = this.getWorkspaceEntityByName(name);
                    if (importData) {
                        status.message(null);
                        status.setRangeOfValues(0L, srcFeatures.size64());
                        status.setCurValue(0L);
                        for (Feature srcFeature : srcFeatures) {
                            if (status.isCancellationRequested()) {
                                throw new UserCancelledException();
                            }
                            String featureCode = this.createUniqueCode();
                            EditableFeature targetFeature = target.createNewFeature(srcFeature);
                            targetFeature.set("VCSGISCODE", (Object)featureCode);
                            target.insert(targetFeature);
                            WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this);
                            change.newCode();
                            change.setEntityCode(entity.getEntityCode());
                            change.setFeatureCode(featureCode);
                            change.setOperation(2);
                            change.setLabel(targetFeature.getString(entity.getFieldForLabel()));
                            change.setSelected(true);
                            change.setStatus(2);
                            change.insert(changesStore);
                            status.incrementCurrentValue();
                            if (!status.isCancellationRequested()) continue;
                            transaction.rollbackQuietly();
                            status.cancel();
                            n2 = 17;
                            DisposeUtils.disposeQuietly((Disposable)transaction);
                            break block17;
                        }
                    }
                    status.message(i18n.getTranslation("_Finishing"));
                    target.finishEditing();
                    transaction.commit();
                    this.forceReloadWorkspaceEntities();
                    status.terminate();
                    n = 0;
                    DisposeUtils.disposeQuietly((Disposable)transaction);
                    break block18;
                }
                catch (UserCancelledException ex) {
                    LOGGER.warn("User cancelled");
                    status.cancel();
                    DataTransaction.rollbackQuietly((DataTransaction)transaction);
                    throw new UserCancelledException();
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't add features to '" + name + "' in '" + this.getMessageLabel() + "'.", (Throwable)ex);
                    status.abort();
                    DataTransaction.rollbackQuietly((DataTransaction)transaction);
                    int n5 = errcode;
                    return n5;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)changesStore);
            status.pop();
            return n2;
        }
        DisposeUtils.disposeQuietly((Disposable)changesStore);
        status.pop();
        return n;
        finally {
            DisposeUtils.disposeQuietly((Disposable)transaction);
            DisposeUtils.disposeQuietly(changesStore);
            status.pop();
        }
    }

    /*
     * Exception decompiling
     */
    private int addExistingTable(String name, FeatureStore source, String fieldForLabel, String category, String label, String model, String resources, String pkName, SimpleTaskStatus status) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public VCSGisWorkspaceChanges<VCSGisWorkspaceChange> getLocalChanges() {
        return this.getLocalChanges(null);
    }

    public VCSGisWorkspaceChanges<VCSGisWorkspaceChange> getLocalChanges(List<VCSGisEntity> entities) {
        return this.getLocalChanges(entities, null);
    }

    public VCSGisWorkspaceChanges<VCSGisWorkspaceChange> getLocalChanges(List<VCSGisEntity> entities, String filter) {
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        ChangesImpl<WorkspaceChangesTable.WorkspaceChangeRow> changes = new ChangesImpl<WorkspaceChangesTable.WorkspaceChangeRow>(changesTable.getByEntityCode(this, entities, filter), "WSCH_SELECTED"){

            @Override
            protected WorkspaceChangesTable.WorkspaceChangeRow createChange(Feature f) {
                return new WorkspaceChangesTable.WorkspaceChangeRow(VCSGisWorkspaceImpl.this, f);
            }

            @Override
            protected void updateChange(FeatureStore store, WorkspaceChangesTable.WorkspaceChangeRow change) {
                change.update(store);
            }
        };
        return changes;
    }

    public boolean hasLocalChanges(List<VCSGisEntity> entities) {
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        boolean hasChanges = changesTable.hasLocalChangesByEntityCode(this, entities);
        return hasChanges;
    }

    public VCSGisRepository getRepository() {
        return this.repository;
    }

    public List<VCSGisEntity> getEntitiesOfRemoteChanges() {
        ArrayList<VCSGisEntity> res = new ArrayList<VCSGisEntity>();
        RemoteChangesTable changesTable = new RemoteChangesTable();
        DisposableFeatureSetIterable features = changesTable.getGroupedByEntity(this);
        EntitiesRepoTable entitiesRepoTable = new EntitiesRepoTable();
        for (Feature feature : features) {
            EntitiesRepoTable.EntityRepoRow entity = entitiesRepoTable.getByEntityCode((VCSGisRepositoryLocaldbImpl)this.getRepository(), feature.getString("COD_ENTITY"));
            res.add((VCSGisEntity)entity);
        }
        DisposeUtils.disposeQuietly((Disposable)features);
        return res;
    }

    public VCSGisWorkspaceChanges<VCSGisRepositoryChange> getRemoteChanges() {
        return this.getRemoteChangesByEntity(new String[]{null});
    }

    public VCSGisWorkspaceChanges<VCSGisRepositoryChange> getRemoteChangesByEntity(String ... entityNames) {
        String[] entityCodes = null;
        if (ArrayUtils.isNotEmpty((Object[])entityNames)) {
            entityCodes = new String[entityNames.length];
            for (int i = 0; i < entityNames.length; ++i) {
                String entityName = entityNames[i];
                if (StringUtils.isBlank((CharSequence)entityName)) {
                    entityCodes[i] = null;
                    continue;
                }
                EntitiesTable.EntityRow entity = this.getWorkspaceEntity(entityName);
                if (entity == null && (entity = this.getRepositoryEntity(entityName)) == null) {
                    return null;
                }
                entityCodes[i] = entity.getEntityCode();
            }
        }
        RemoteChangesTable changesTable = new RemoteChangesTable();
        GetItemWithSize64<Feature> changesByEntity = changesTable.getByEntityCode(this, entityCodes);
        ChangesImpl<RemoteChangesTable.RemoteChangeRow> changes = new ChangesImpl<RemoteChangesTable.RemoteChangeRow>(changesByEntity, "RCH_SELECTED"){

            @Override
            protected RemoteChangesTable.RemoteChangeRow createChange(Feature f) {
                return new RemoteChangesTable.RemoteChangeRow(VCSGisWorkspaceImpl.this, f);
            }

            @Override
            protected void updateChange(FeatureStore store, RemoteChangesTable.RemoteChangeRow change) {
                change.update(store);
            }
        };
        DisposeUtils.disposeQuietly(changesByEntity);
        return changes;
    }

    private Timestamp now() {
        return Timestamp.from(LocalDateTime.now().toInstant(ZoneOffset.UTC));
    }

    public List<VCSGisEntity> getEntitiesOfLocalChanges() {
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        ArrayList<VCSGisEntity> entities = new ArrayList<VCSGisEntity>();
        DisposableFeatureSetIterable changesGroupedByEntity = changesTable.getGroupedByEntity(this);
        for (Feature fchange : changesGroupedByEntity) {
            WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, fchange);
            VCSGisWorkspaceEntity localEntity = change.getEntity();
            if (!change.isSelected()) continue;
            entities.add((VCSGisEntity)localEntity);
        }
        return entities;
    }

    private List<String> convertToEntityCodes(List<String> entities) {
        if (entities == null) {
            return null;
        }
        ArrayList<String> entityCodes = new ArrayList<String>();
        for (String entity : entities) {
            entityCodes.add(this.getWorkspaceEntity(entity).getEntityCode());
        }
        return entityCodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareCommitRequest(VCSGisCommitRequest request, List<String> entityCodes, Timestamp revisiondate, Timestamp efectivedate, String comment, SimpleTaskStatus status) {
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Prepare commit request");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        boolean useSeleccion = true;
        try {
            request.setEfectiveDate(efectivedate);
            request.setRevisionDate(revisiondate);
            request.setComment(comment);
            WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
            LOGGER.debug("===: COMMIT: Adding changed local entities");
            status.message("Searching changed entities");
            DisposableFeatureSetIterable changesGroupedByEntity = changesTable.getGroupedByEntity(this);
            status.setCurValue(0L);
            HashSet<String> repositoryCodes = new HashSet<String>();
            for (Object fchange : changesGroupedByEntity) {
                WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, (Feature)fchange);
                VCSGisWorkspaceEntity localEntity = change.getEntity();
                if (localEntity == null) continue;
                LOGGER.debug("===: COMMIT: add used entity = " + fchange.toJson().toString().replace('\n', ' '));
                if (change.isSelected() && (CollectionUtils.isEmpty(entityCodes) || entityCodes.contains(localEntity.getEntityCode()))) {
                    VCSGisRepository linkedRepo;
                    request.add(request.createEntity(localEntity));
                    if (localEntity.isLinkedTable() && (linkedRepo = localEntity.getLinkedRepository()) != null) {
                        repositoryCodes.add(linkedRepo.getCode());
                    }
                }
                switch (this.getEditMode((VCSGisEntity)localEntity)) {
                    case -1: {
                        throw new IllegalStateException("The store you are trying to commit cannot be accessed. (" + localEntity.getEntityName() + ").");
                    }
                    case 1: {
                        throw new IllegalStateException("Can't commit a store that is being edited (" + localEntity.getEntityName() + ").");
                    }
                }
                status.incrementCurrentValue();
            }
            changesGroupedByEntity.dispose();
            if (repositoryCodes.size() > 1) {
                LOGGER.info("Too many repositories, only one allowed in commit.");
                I18nManager i18n = ToolsLocator.getI18nManager();
                throw new VCSGisRuntimeException(39, i18n.getTranslation("_Too_many_repositories_only_one_allowed_in_commit"));
            }
            LOGGER.debug("===: COMMIT: Mark new local entities");
            status.message("Searching new entities");
            DisposableFeatureSetIterable changesOfAddEntities = changesTable.getByOperation(this, 3);
            for (Feature fchange : changesOfAddEntities) {
                WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, fchange);
                if (change.getEntity() == null || !change.isSelected() || !CollectionUtils.isEmpty(entityCodes) && !entityCodes.contains(change.getEntityCode())) continue;
                request.markAsNew((VCSGisEntity)change.getEntity());
            }
            changesOfAddEntities.dispose();
            LOGGER.debug("===: COMMIT: Adding data");
            status.message("Searching changed data");
            DisposableFeatureSetIterable changes = changesTable.getSelectedsWithoutAddEntity(this, entityCodes);
            if (changes != null) {
                final SimpleTaskStatus localstatus = status;
                request.add((DisposableIterable)new DisposableIterableAdapter((DisposableIterable)changes, new DisposableIterableAdapter.ItemConverter<Feature, VCSGisChange>(){

                    @Override
                    public VCSGisChange convert(Feature f) {
                        try {
                            localstatus.incrementCurrentValue();
                            return new WorkspaceChangesTable.WorkspaceChangeRow(VCSGisWorkspaceImpl.this, f);
                        }
                        catch (Exception ex) {
                            localstatus.abort();
                            throw ex;
                        }
                    }
                }){

                    @Override
                    public void cancelled() throws UserCancelledException {
                        if (localstatus.isCancellationRequested()) {
                            localstatus.cancel();
                            throw new UserCancelledException();
                        }
                    }

                    public Iterator iterator() {
                        localstatus.setRangeOfValues(0L, this.size64());
                        return super.iterator();
                    }
                });
            }
            status.terminate();
        }
        finally {
            status.pop();
        }
        return useSeleccion;
    }

    public boolean canCommit() {
        return this.canCommit(null);
    }

    public boolean canCommit(MutableObject<String> message) {
        return this.canCommit(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canCommit(MutableObject<String> message, List<String> entityCodes) {
        Object msg;
        if (this.isOffline()) {
            return false;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (entityCodes == null) {
            LOGGER.warn("entityCodes is null");
            if (message == null) return false;
            String msg2 = i18n.getTranslation("_It_is_mandatory_to_indicate_the_tables_on_which_you_want_to_commit");
            message.setValue((Object)msg2);
            return false;
        }
        ArrayList<String> outdatedEntityNames = new ArrayList<String>();
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        DisposableFeatureSetIterable changesGroupedByEntity = null;
        try {
            String msg32;
            HashSet<String> repositoryCodes = new HashSet<String>();
            repositoryCodes.add(this.getRepository().getCode());
            for (String entityCode : entityCodes) {
                VCSGisRepository linkedRepo;
                EntitiesTable.EntityRow entity = this.getWorkspaceEntity(entityCode);
                int maskStatus = entity.getState();
                if ((maskStatus & 0x100) == 256) {
                    LOGGER.info("Entity '" + entity.getEntityName() + "' marked as corrupt.");
                    if (message != null) {
                        msg32 = i18n.getTranslation("_Some_of_the_selected_tables_are_marked_as_corrupt") + ". (" + entity.getEntityName() + ")";
                        message.setValue((Object)msg32);
                    }
                    boolean msg32 = false;
                    DisposeUtils.dispose((Disposable)changesGroupedByEntity);
                    return msg32;
                }
                if ((maskStatus & 0x80) == 128) {
                    LOGGER.info("Entity '" + entity.getEntityName() + "' marked as disconnected.");
                    if (message != null) {
                        msg32 = i18n.getTranslation("_Some_of_the_selected_tables_are_marked_as_disconnected") + ". (" + entity.getEntityName() + ")";
                        message.setValue((Object)msg32);
                    }
                    boolean msg4 = false;
                    DisposeUtils.dispose((Disposable)changesGroupedByEntity);
                    return msg4;
                }
                if (!entity.isLinkedTable() || (linkedRepo = entity.getLinkedRepository()) == null) continue;
                repositoryCodes.add(linkedRepo.getCode());
            }
            if (repositoryCodes.size() > 1) {
                LOGGER.info("Too many repositories, only one allowed in commit.");
                if (message != null) {
                    msg = i18n.getTranslation("_Too_many_repositories_only_one_allowed");
                    message.setValue(msg);
                }
                boolean msg5 = false;
                DisposeUtils.dispose((Disposable)changesGroupedByEntity);
                return msg5;
            }
            changesGroupedByEntity = changesTable.getGroupedByEntity(this);
            for (Feature fchange : changesGroupedByEntity) {
                WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, fchange);
                VCSGisWorkspaceEntity entity = change.getEntity();
                if (entity == null) continue;
                if (CollectionUtils.isEmpty(entityCodes) || entityCodes.contains(entity.getEntityCode())) {
                    LOGGER.debug("===: CAN-COMMIT: add used entity = " + fchange.toJson().toString().replace('\n', ' '));
                    if (change.isSelected() && entity.isOutdated()) {
                        outdatedEntityNames.add(entity.getEntityName());
                    }
                }
                switch (this.getEditMode((VCSGisEntity)entity)) {
                    case -1: {
                        LOGGER.info("Can access to '" + entity.getEntityName() + "'.");
                        if (message != null) {
                            msg32 = i18n.getTranslation("_Some_of_the_selected_tables_are_damaged") + ". (" + entity.getEntityName() + ")";
                            message.setValue((Object)msg32);
                        }
                        boolean msg6 = false;
                        DisposeUtils.dispose((Disposable)changesGroupedByEntity);
                        return msg6;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        LOGGER.info("Table '" + entity.getEntityName() + "' is editing.");
                        if (message != null) {
                            msg32 = i18n.getTranslation("_Selected_tables_are_editing") + ". (" + entity.getEntityName() + ")";
                            message.setValue((Object)msg32);
                        }
                        boolean bl = false;
                        DisposeUtils.dispose((Disposable)changesGroupedByEntity);
                        return bl;
                    }
                }
            }
            DisposeUtils.dispose((Disposable)changesGroupedByEntity);
            if (!outdatedEntityNames.isEmpty()) {
                LOGGER.info("Somme tables in working copy are outdated (" + StringUtils.join(outdatedEntityNames, (String)",") + ").");
                if (message != null) {
                    msg = i18n.getTranslation("_Tables_in_working_copy_are_outdated") + ". (" + StringUtils.join(outdatedEntityNames, (String)", ") + ")";
                    message.setValue(msg);
                }
                boolean msg7 = false;
                DisposeUtils.dispose((Disposable)changesGroupedByEntity);
                return msg7;
            }
            boolean msg7 = true;
            DisposeUtils.dispose((Disposable)changesGroupedByEntity);
            return msg7;
        }
        catch (Exception ex) {
            LOGGER.warn("You cannot check that a commit can be done", (Throwable)ex);
            if (message != null) {
                msg = i18n.getTranslation("_You_cannot_check_that_a_commit_can_be_done");
                message.setValue(msg);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            DisposeUtils.dispose(changesGroupedByEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VCSGisWorkspaceEntity> getEntitiesWithSelectedChanges() {
        ArrayList<VCSGisWorkspaceEntity> entities = new ArrayList<VCSGisWorkspaceEntity>();
        WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
        DisposableFeatureSetIterable changesGroupedByEntity = null;
        try {
            changesGroupedByEntity = changesTable.getGroupedByEntity(this);
            for (Feature fchange : changesGroupedByEntity) {
                WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, fchange);
                VCSGisWorkspaceEntity entity = change.getEntity();
                if (!change.isSelected()) continue;
                entities.add(entity);
            }
            ArrayList<VCSGisWorkspaceEntity> arrayList = entities;
            return arrayList;
        }
        catch (Exception ex) {
            List<VCSGisWorkspaceEntity> list = null;
            return list;
        }
        finally {
            DisposeUtils.dispose((Disposable)changesGroupedByEntity);
        }
    }

    public int commit() {
        return this.commit(null, null, this.now(), null, null, null);
    }

    public int commit(Timestamp efectivedate, String comment, SimpleTaskStatus status) {
        return this.commit(null, null, efectivedate, comment, status, null);
    }

    public int commit(Timestamp revisiondate, Timestamp efectivedate, String comment, SimpleTaskStatus status) {
        return this.commit(null, revisiondate, efectivedate, comment, status, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int commit(List<String> entityCodes, Timestamp revisiondate, Timestamp efectivedate, String comment, SimpleTaskStatus status, List<VCSGisTopologyPlanStatus> topologyPlanStatusList) {
        int n;
        if (this.isOffline()) {
            return 10000;
        }
        VCSGisCommitRequest request = null;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Commit");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        try {
            status.setIndeterminate();
            entityCodes = this.convertToEntityCodes(entityCodes);
            EntitiesTable entitiesTable = new EntitiesTable();
            WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
            status.message("Preparing commit");
            this.updateEntitiesFromRepository(status);
            VCSGisRepository repo = this.getRepository();
            request = repo.createCommitRequest();
            request.setAuthenticationToken(this.getAuthenticationToken(repo));
            request.setUserCode(this.getCurrentUserCode(repo));
            if (topologyPlanStatusList != null) {
                for (VCSGisTopologyPlanStatus topologyPlanStatus : topologyPlanStatusList) {
                    request.add(topologyPlanStatus);
                }
            }
            boolean useSeleccion = this.prepareCommitRequest(request, entityCodes, revisiondate, efectivedate, comment, status);
            status.message("Executing commit request");
            status.setIndeterminate();
            if (this.execute((VCSGisRequest)request) != 0) {
                LOGGER.warn(request.getLastErrorMessage());
                status.message("Can't commit changes (error " + request.getLastErrorCode() + ")");
                status.abort();
                int topologyPlanStatus = request.getLastErrorCode();
                DisposeUtils.disposeQuietly((Disposable)request);
                status.pop();
                return topologyPlanStatus;
            }
            status.message("Removing local list of changes");
            if (useSeleccion) {
                changesTable.deleteSelecteds(this, entityCodes);
            } else {
                changesTable.deleteAll(this);
            }
            status.message("Updating local metadata");
            FeatureStore entitiesStore = null;
            try {
                entitiesStore = this.openFeatureStore("VCSGIS_ENTITIES", true);
                entitiesStore.edit(1);
                List changedLocalentities = request.getChangedLocalEntities();
                status.setRangeOfValues(0L, (long)changedLocalentities.size());
                status.setCurValue(0L);
                for (VCSGisEntity rentity : changedLocalentities) {
                    EntitiesTable.EntityRow entityRow = entitiesTable.getByEntityName(this, rentity.getEntityName());
                    if (entityRow != null) {
                        entityRow.copyfrom(rentity);
                        entityRow.setLocalRevisionCode(rentity.getRepositoryRevisionCode());
                        this.updateEntityState(entityRow, false);
                        entityRow.update(entitiesStore);
                    }
                    status.incrementCurrentValue();
                }
                entitiesStore.finishEditing();
                this.forceReloadWorkspaceEntities();
            }
            catch (Exception e) {
                try {
                    FeatureStore.cancelEditingQuietly((FeatureStore)entitiesStore);
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(entitiesStore);
                    entitiesStore = null;
                    throw throwable;
                }
                DisposeUtils.disposeQuietly((Disposable)entitiesStore);
                entitiesStore = null;
            }
            DisposeUtils.disposeQuietly((Disposable)entitiesStore);
            entitiesStore = null;
            if (request.hasNewEntities()) {
                this.repositoryEntitiesByCodeLastUpdate = 0L;
            }
            status.message("Commit completed");
            status.terminate();
            n = 0;
            DisposeUtils.disposeQuietly((Disposable)request);
        }
        catch (VCSGisRuntimeException ex) {
            LOGGER.warn("Can't commit changes.", (Throwable)ex);
            status.message("Can't commit changes. " + ex.getLocalizedMessage());
            status.abort();
            int n2 = ex.getErrnum() == 0 ? 500 : ex.getErrnum();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)request);
            status.pop();
            return n2;
            catch (Exception ex2) {
                LOGGER.warn("Can't commit changes.", (Throwable)ex2);
                status.message("Can't commit changes");
                status.abort();
                int n3 = 500;
                return n3;
            }
        }
        finally {
            DisposeUtils.disposeQuietly(request);
            status.pop();
        }
        status.pop();
        return n;
    }

    public int checkout(String tableName) {
        return this.checkout(tableName, null, null, null, null);
    }

    public int checkout(String tableName, String revisionCode) {
        return this.checkout(tableName, revisionCode, null, null, null);
    }

    public int checkout(String tableName, String revisionCode, SimpleTaskStatus status) {
        return this.checkout(tableName, revisionCode, null, null, status);
    }

    public int checkout(String tableName, String revisionCode, Timestamp efectiveDate, SimpleTaskStatus status) {
        return this.checkout(tableName, revisionCode, null, null, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkout(String tableName, String revisionCode, Timestamp efectiveDate, Envelope roi, SimpleTaskStatus status) {
        int n;
        VCSGisCheckoutRequest request;
        FeatureStore entitiesStore;
        FeatureStore target;
        block41: {
            int n2;
            block40: {
                int n3;
                block39: {
                    int n4;
                    block38: {
                        if (this.isOffline()) {
                            return 10001;
                        }
                        target = null;
                        entitiesStore = null;
                        int errcode = 0;
                        request = null;
                        if (status == null) {
                            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_VCS_Checkout");
                            status.setAutoremove(true);
                            status.add();
                        } else {
                            status.push();
                        }
                        status.setIndeterminate();
                        try {
                            LOGGER.debug("===: CHECKOUT " + this.getCode() + ", '" + this.getLabel() + "', " + tableName);
                            status.message("Preparing checkout");
                            EntitiesTable.EntityRow lentity = this.getWorkspaceEntityByName(tableName);
                            if (lentity != null) {
                                status.message("Table " + tableName + " already exists");
                                status.abort();
                                int n5 = 200;
                                return n5;
                            }
                            switch (this.getEditMode((VCSGisEntity)lentity)) {
                                case -1: {
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 3: {
                                    LOGGER.info("Table '" + lentity.getEntityName() + "' is editing.");
                                    I18nManager i18n = ToolsLocator.getI18nManager();
                                    String msg = i18n.getTranslation("_Some_of_the_selected_tables_are_in_edition") + "\n(" + lentity.getEntityName() + ")";
                                    status.message(msg);
                                    status.abort();
                                    n4 = 26;
                                    DisposeUtils.disposeQuietly((Disposable)request);
                                    if (target != null) {
                                        this.removeStoreIgnoreChanges(target);
                                    }
                                    break block38;
                                }
                            }
                            this.updateEntitiesFromRepository(status);
                            VCSGisEntity rentity = this.getRepositoryEntity(tableName);
                            VCSGisRepository repo = this.getRepository(rentity);
                            request = repo.createCheckoutRequest(tableName);
                            request.setAuthenticationToken(this.getAuthenticationToken(repo));
                            request.setUserCode(this.getCurrentUserCode(repo));
                            request.setEfectiveDate(efectiveDate);
                            request.setRevisionCode(revisionCode);
                            request.setROI(roi);
                            status.message("Executing checkout request for " + tableName);
                            if (this.execute((VCSGisRequest)request) != 0) {
                                status.message("Can't checkout " + tableName + " (error " + request.getLastErrorCode() + ")");
                                status.abort();
                                n3 = request.getLastErrorCode();
                                DisposeUtils.disposeQuietly((Disposable)request);
                                break block39;
                            }
                            status.message("Updating " + tableName + " metadata");
                            entitiesStore = this.openFeatureStore("VCSGIS_ENTITIES", true);
                            entitiesStore.edit(1);
                            lentity = new EntitiesTable.EntityRow(this);
                            if (rentity.isLinkedTable()) {
                                rentity.copyto((VCSGisEntityEditable)lentity);
                                VCSGisUtils.copy(request.getEntity(), (VCSGisEntityEditable)lentity, new Predicate<String>(){

                                    @Override
                                    public boolean test(String t) {
                                        return StringUtils.equalsAny((CharSequence)t, (CharSequence[])new CharSequence[]{"Description", "FeatureTypeAsJson", "FieldForLabel", "Category", "Label", "Resources", "DataModels", "customdata"});
                                    }
                                });
                            } else {
                                rentity = request.getEntity();
                                rentity.copyto((VCSGisEntityEditable)lentity);
                            }
                            if (efectiveDate != null) {
                                lentity.setState(128);
                            } else if (StringUtils.isBlank((CharSequence)revisionCode)) {
                                lentity.setState(6);
                            } else {
                                lentity.setState(1);
                            }
                            lentity.insert(entitiesStore);
                            LOGGER.debug("===: CHECKOUT " + this.getCode() + ", '" + this.getLabel() + "', " + tableName + ", rev." + rentity.getRepositoryRevisionCode());
                            status.message("Creating table " + tableName);
                            this.create_table((VCSGisEntity)lentity);
                            status.message("Adding features in " + tableName);
                            errcode = 400;
                            target = this.openFeatureStore((VCSGisEntity)lentity);
                            this.addStoreIgnoreChanges(target);
                            DisposableIterable data = request.getData();
                            status.setCurValue(0L);
                            errcode = 420;
                            target.edit(2);
                            FilteredLogger log = new FilteredLogger(LOGGER, "checkout", 100);
                            FilteredLogger log_info = new FilteredLogger(LOGGER, "checkout", 60000L);
                            for (VCSGisRepositoryData d : data) {
                                if (status.isCancellationRequested()) {
                                    FeatureStore.cancelEditingQuietly((FeatureStore)target);
                                    FeatureStore.cancelEditingQuietly((FeatureStore)entitiesStore);
                                    status.cancel();
                                    n2 = 10000;
                                    DisposeUtils.disposeQuietly((Disposable)request);
                                    break block40;
                                }
                                JsonObject json = d.getDataAsJson();
                                if (json == null) {
                                    log.warn("A feature (VCSGISCODE=" + d.getFeatureRelatedCode() + ") has been retrieved with the DAT_DATA field set to null.");
                                } else {
                                    EditableFeature f = target.createNewFeature(json);
                                    target.insert(f);
                                }
                                log_info.info("Checkout " + status.getLabel());
                                status.incrementCurrentValue();
                            }
                            target.finishEditing();
                            status.message("Updating " + tableName + " metadata");
                            if (StringUtils.isBlank((CharSequence)revisionCode)) {
                                lentity.setLocalRevisionCode(rentity.getRepositoryRevisionCode());
                            } else {
                                lentity.setLocalRevisionCode(revisionCode);
                            }
                            if (!this.isCorrupt((VCSGisEntity)lentity, target, 0, false)) {
                                this.updateEntityState(lentity, false);
                            }
                            lentity.update(entitiesStore);
                            entitiesStore.finishEditing();
                            this.forceReloadWorkspaceEntities();
                            this.updateResourcesTableIfNotExists((VCSGisEntity)lentity);
                            UsersTable usersTable = new UsersTable();
                            if (StringUtils.isNotBlank((CharSequence)request.getUsersHashCode()) && !StringUtils.equalsIgnoreCase((CharSequence)usersTable.getHashCode(this), (CharSequence)request.getUsersHashCode())) {
                                this.updateUsersFromRepository(status);
                            }
                            TopologyplanTable topologyPlansTable = new TopologyplanTable();
                            if (StringUtils.isNotBlank((CharSequence)request.getTopologyPlansHashCode()) && !StringUtils.equalsIgnoreCase((CharSequence)topologyPlansTable.getHashCode(this), (CharSequence)request.getTopologyPlansHashCode())) {
                                this.updateTopologyPlansFromRepository(status);
                            }
                            status.message("Checkout completed");
                            status.terminate();
                            n = 0;
                            DisposeUtils.disposeQuietly((Disposable)request);
                            break block41;
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Can't checkout.", (Throwable)ex);
                            status.message("Can't checkout");
                            status.abort();
                            FeatureStore.cancelEditingQuietly(target);
                            FeatureStore.cancelEditingQuietly(entitiesStore);
                            int n6 = errcode;
                            return n6;
                        }
                    }
                    DisposeUtils.disposeQuietly(target);
                    DisposeUtils.disposeQuietly(entitiesStore);
                    status.pop();
                    return n4;
                }
                if (target != null) {
                    this.removeStoreIgnoreChanges(target);
                }
                DisposeUtils.disposeQuietly(target);
                DisposeUtils.disposeQuietly((Disposable)entitiesStore);
                status.pop();
                return n3;
            }
            if (target != null) {
                this.removeStoreIgnoreChanges(target);
            }
            DisposeUtils.disposeQuietly((Disposable)target);
            DisposeUtils.disposeQuietly((Disposable)entitiesStore);
            status.pop();
            return n2;
        }
        if (target != null) {
            this.removeStoreIgnoreChanges(target);
        }
        DisposeUtils.disposeQuietly((Disposable)target);
        DisposeUtils.disposeQuietly((Disposable)entitiesStore);
        status.pop();
        return n;
        finally {
            DisposeUtils.disposeQuietly(request);
            if (target != null) {
                this.removeStoreIgnoreChanges(target);
            }
            DisposeUtils.disposeQuietly(target);
            DisposeUtils.disposeQuietly(entitiesStore);
            status.pop();
        }
    }

    private void updateResourcesTableIfNotExists(VCSGisEntity entity) {
        String resources = entity.getResources();
        if (StringUtils.isNotBlank((CharSequence)resources)) {
            try {
                if (!this.existsInWorkspace(resources)) {
                    this.checkout(resources, null);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Can't checkout resources table '" + resources + "'", (Throwable)e);
            }
            this.getExplorer().setCustomResources(entity.getEntityName(), resources, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkout(List<String> tableNames, SimpleTaskStatus status) {
        if (this.isOffline()) {
            return 10001;
        }
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_VCS_Checkout");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        try {
            status.setRangeOfValues(0L, (long)tableNames.size());
            status.setCurValue(1L);
            for (String tableName : tableNames) {
                int r = this.checkout(tableName, null, status);
                if (status.isCancellationRequested()) {
                    status.cancel();
                    int n = r;
                    return n;
                }
                if (r != 0) {
                    status.abort();
                    int n = r;
                    return n;
                }
                status.incrementCurrentValue();
            }
            status.terminate();
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            status.abort();
            int n = 600;
            return n;
        }
        finally {
            status.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(List<String> tableNames, SimpleTaskStatus status) {
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_Update");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        try {
            status.setRangeOfValues(0L, (long)tableNames.size());
            status.setCurValue(1L);
            for (String tableName : tableNames) {
                MutableLong localChangesCreated = new MutableLong();
                int r = this.update(tableName, true, false, localChangesCreated, null, status);
                switch (r) {
                    case 0: 
                    case 82: {
                        break;
                    }
                    default: {
                        int n = r;
                        return n;
                    }
                }
                status.incrementCurrentValue();
            }
            status.terminate();
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            status.abort();
            int n = 80;
            return n;
        }
        finally {
            status.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUsersFromRepository(SimpleTaskStatus status) {
        VCSGisUsersRequest request;
        FeatureStore usersStore;
        block7: {
            if (this.isOffline()) {
                return;
            }
            usersStore = null;
            request = null;
            VCSGisRepository repo = this.getRepository();
            request = repo.createUsersRequest();
            request.setAuthenticationToken(this.getAuthenticationToken(repo));
            request.setUserCode(this.getCurrentUserCode(repo));
            status.message("Executing users request");
            if (this.execute((VCSGisRequest)request, false) == 0) break block7;
            status.message("Can't get users (error " + request.getLastErrorCode() + ")");
            DisposeUtils.disposeQuietly((Disposable)request);
            DisposeUtils.disposeQuietly((Disposable)usersStore);
            return;
        }
        try {
            status.message("Updating users information");
            usersStore = this.openFeatureStore("VCSGIS_USERS", false);
            usersStore.edit(3);
            usersStore.delete("TRUE");
            for (VCSGisUser user : request.getUsers()) {
                UsersTable.UserRow row = new UsersTable.UserRow(this);
                row.copyFrom(user);
                row.insert(usersStore);
            }
            usersStore.finishEditing();
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't update users.", (Throwable)ex);
                status.message("Can't update users");
                FeatureStore.cancelEditingQuietly(usersStore);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(request);
                DisposeUtils.disposeQuietly(usersStore);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)request);
            DisposeUtils.disposeQuietly(usersStore);
        }
        DisposeUtils.disposeQuietly((Disposable)request);
        DisposeUtils.disposeQuietly((Disposable)usersStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTopologyPlansFromRepository(SimpleTaskStatus status) {
        VCSGisTopologyPlansRequest request;
        FeatureStore topologyPlanStore;
        block10: {
            if (this.isOffline()) {
                return;
            }
            topologyPlanStore = null;
            request = null;
            if (status == null) {
                status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_VCS_Checkout");
                status.setAutoremove(true);
                status.add();
            } else {
                status.push();
            }
            VCSGisRepository repo = this.getRepository();
            request = repo.createTopologyPlansRequest();
            request.setAuthenticationToken(this.getAuthenticationToken(repo));
            request.setUserCode(this.getCurrentUserCode(repo));
            status.message("Executing topology plans request");
            if (this.execute((VCSGisRequest)request) == 0) break block10;
            status.message("Can't get topology plans (error " + request.getLastErrorCode() + ")");
            DisposeUtils.disposeQuietly((Disposable)request);
            DisposeUtils.disposeQuietly((Disposable)topologyPlanStore);
            status.pop();
            return;
        }
        try {
            status.message("Updating topology plans information");
            topologyPlanStore = this.openFeatureStore("VCSGIS_TOPOLOGYPLANS", false);
            topologyPlanStore.edit(3);
            topologyPlanStore.delete("TRUE");
            for (VCSGisTopologyPlan topologyPlan : request.getTopologyPlans()) {
                if (status.isCancellationRequested()) {
                    throw new UserCancelledException();
                }
                TopologyplanTable.TopologyPlanRow row = new TopologyplanTable.TopologyPlanRow(this);
                row.copyFrom(topologyPlan);
                row.insert(topologyPlanStore);
            }
            topologyPlanStore.finishEditing();
            status.terminate();
        }
        catch (Exception ex) {
            try {
                LOGGER.warn("Can't update topology plans.", (Throwable)ex);
                status.message("Can't update topology plans");
                status.abort();
                FeatureStore.cancelEditingQuietly(topologyPlanStore);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(request);
                DisposeUtils.disposeQuietly(topologyPlanStore);
                status.pop();
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)request);
            DisposeUtils.disposeQuietly(topologyPlanStore);
            status.pop();
        }
        DisposeUtils.disposeQuietly((Disposable)request);
        DisposeUtils.disposeQuietly((Disposable)topologyPlanStore);
        status.pop();
    }

    public int updateEntitiesFromRepository() {
        return this.updateEntitiesFromRepository(null);
    }

    private boolean hasRelevantChanges(VCSGisEntity rentity, EntitiesTable.EntityRow lentity) {
        if (!StringUtils.equals((CharSequence)rentity.getRepositoryRevisionCode(), (CharSequence)lentity.getRepositoryRevisionCode())) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)rentity.getCategory(), (CharSequence)lentity.getCategory())) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)rentity.getDataModels(), (CharSequence)lentity.getDataModels())) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)rentity.getFeatureTypeAsJson(), (CharSequence)lentity.getFeatureTypeAsJson())) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)rentity.getLabel(), (CharSequence)lentity.getLabel())) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)rentity.getFieldForLabel(), (CharSequence)lentity.getFieldForLabel())) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)rentity.getResources(), (CharSequence)lentity.getResources())) {
            return true;
        }
        if (!StringUtils.equals((CharSequence)rentity.getTopologyPlanCode(), (CharSequence)lentity.getTopologyPlanCode())) {
            return true;
        }
        return rentity.getTopologyPlanMode() != lentity.getTopologyPlanMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int updateEntitiesFromRepository(SimpleTaskStatus status) {
        int localEntities2;
        if (this.isOffline()) {
            return 0;
        }
        LOGGER.debug("===: UPDATE_ENTITIES " + this.getCode() + ", '" + this.getLabel() + "'");
        FeatureStore entitiesStore = null;
        EntitiesTable entitiesTable = new EntitiesTable();
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Update metadata tables");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        try {
            status.message("Preparing update metadata tables");
            if (!this.isRepositoryEntitiesCached()) {
                EntitiesTable.EntityRow entityRow;
                this.reloadRepositoryEntities(status);
                entitiesStore = this.openFeatureStore("VCSGIS_ENTITIES", true);
                entitiesStore.edit(1);
                HashMap<String, EntitiesTable.EntityRow> localEntities2 = new HashMap<String, EntitiesTable.EntityRow>();
                DisposableFeatureSetIterable allLocalEntities = entitiesTable.getAll(this);
                for (Feature lentity_f : allLocalEntities) {
                    entityRow = new EntitiesTable.EntityRow(this, lentity_f);
                    localEntities2.put(entityRow.getEntityName(), entityRow);
                }
                DisposeUtils.dispose((Disposable)allLocalEntities);
                for (VCSGisEntity rentity : this.getRepositoryEntities()) {
                    entityRow = (EntitiesTable.EntityRow)localEntities2.get(rentity.getEntityName());
                    if (entityRow == null || !this.hasRelevantChanges(rentity, entityRow)) continue;
                    rentity.copyto((VCSGisEntityEditable)entityRow);
                    entityRow.updateState();
                    entityRow.update(entitiesStore);
                    localEntities2.put(entityRow.getEntityName(), entityRow);
                }
                if (entitiesStore.getPendingChangesCount() > 0L) {
                    entitiesStore.finishEditingQuietly();
                    this.reloadWorkspaceEntities();
                } else {
                    entitiesStore.finishEditingQuietly();
                }
            }
            status.message("Update metadata tables completed");
            status.terminate();
            localEntities2 = 0;
        }
        catch (Exception ex) {
            int n;
            try {
                LOGGER.warn("Can't update metadata tables.", (Throwable)ex);
                status.message("Can't update metadata tables");
                status.abort();
                if (entitiesStore != null) {
                    entitiesStore.cancelEditingQuietly();
                }
                n = 70;
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(entitiesStore);
                entitiesStore = null;
                status.pop();
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)entitiesStore);
            entitiesStore = null;
            status.pop();
            return n;
        }
        DisposeUtils.disposeQuietly((Disposable)entitiesStore);
        entitiesStore = null;
        status.pop();
        return localEntities2;
    }

    public int updatePrepare(String tableName) {
        return this.updatePrepare(tableName, null);
    }

    public boolean canUpdate(MutableObject<String> message, String tableName) {
        if (this.isOffline()) {
            return false;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        EntitiesTable.EntityRow lentity = this.getWorkspaceEntityByName(tableName);
        if (lentity == null) {
            if (message != null) {
                String msg = i18n.getTranslation("_Cant_update_table_XtablaX_dont_exists", new String[]{tableName});
                message.setValue((Object)msg);
            }
            return false;
        }
        switch (this.getEditMode((VCSGisEntity)lentity)) {
            case -1: {
                if (message != null) {
                    String msg = i18n.getTranslation("_Cant_update_table_XtablaX_dont_exists", new String[]{tableName});
                    message.setValue((Object)msg);
                }
                return false;
            }
            case 1: 
            case 2: 
            case 3: {
                LOGGER.info("Table '" + lentity.getEntityName() + "' is editing.");
                if (message != null) {
                    String msg = i18n.getTranslation("_Cant_update_table_XtablaX_are_in_edition", new String[]{tableName});
                    message.setValue((Object)msg);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updatePrepare(String tableName, SimpleTaskStatus status) {
        int n;
        DataTransaction transaction;
        block44: {
            int msg2;
            block43: {
                int n2;
                block42: {
                    int n3;
                    block41: {
                        int n4;
                        block40: {
                            if (this.isOffline()) {
                                return 10001;
                            }
                            LOGGER.debug("===: UPDATE_PREPARE: " + tableName + " WS " + this.getCode() + ", '" + this.getLabel() + "'");
                            if (status == null) {
                                status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Update-prepare " + tableName);
                                status.setAutoremove(true);
                                status.add();
                            } else {
                                status.push();
                            }
                            FeatureStore remoteChangesStore = null;
                            VCSGisUpdateRequest request = null;
                            DisposableIterable remoteChanges = null;
                            WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
                            FeatureStore userStore = null;
                            FeatureStore localChangesStore = null;
                            FeatureStore entitiesStore = null;
                            transaction = null;
                            try {
                                if (status.isCancellationRequested()) {
                                    throw new UserCancelledException();
                                }
                                this.updateEntitiesFromRepository(status);
                                EntitiesTable.EntityRow lentity = this.getWorkspaceEntityByName(tableName);
                                if (lentity == null) {
                                    status.message("Can't update-prepare " + tableName + ", don't exists.");
                                    status.abort();
                                    n4 = 85;
                                    DisposeUtils.disposeQuietly((Disposable)transaction);
                                    break block40;
                                }
                                switch (this.getEditMode((VCSGisEntity)lentity)) {
                                    case -1: {
                                        status.message("Can't update-prepare " + tableName + ", don't exists.");
                                        status.abort();
                                        n3 = 85;
                                        DisposeUtils.disposeQuietly((Disposable)transaction);
                                        break block41;
                                    }
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        LOGGER.info("Table '" + lentity.getEntityName() + "' is editing.");
                                        I18nManager i18n = ToolsLocator.getI18nManager();
                                        String msg2 = i18n.getTranslation("_Some_of_the_selected_tables_are_in_edition") + "\n(" + lentity.getEntityName() + ")";
                                        status.message(msg2);
                                        status.abort();
                                        n2 = 26;
                                        DisposeUtils.disposeQuietly((Disposable)transaction);
                                        break block42;
                                    }
                                    default: {
                                        transaction = DALLocator.getDataManager().createTransaction();
                                        transaction.begin();
                                        transaction.add((DataServerExplorer)this.getExplorer(), false);
                                        status.message("Preparing update-prepare");
                                        VCSGisRepository repo = this.getRepository((VCSGisEntity)lentity);
                                        request = repo.createUpdateRequest(tableName);
                                        transaction.add((Disposable)request);
                                        request.setAuthenticationToken(this.getAuthenticationToken(repo));
                                        request.setUserCode(this.getCurrentUserCode(repo));
                                        request.setLocalRevisionCode(lentity.getLocalRevisionCode());
                                        entitiesStore = this.openFeatureStore("VCSGIS_ENTITIES", true);
                                        transaction.add((DataStore)entitiesStore);
                                        status.message("Executing update-prepare request");
                                        if (this.execute((VCSGisRequest)request) != 0) {
                                            status.message("Can't update-prepare " + tableName + " (error " + request.getLastErrorCode() + ")");
                                            status.abort();
                                            msg2 = request.getLastErrorCode();
                                            DisposeUtils.disposeQuietly((Disposable)transaction);
                                            break block43;
                                        }
                                        if (status.isCancellationRequested()) {
                                            throw new UserCancelledException();
                                        }
                                        entitiesStore.edit(1);
                                        status.message("Updating " + tableName + " metadata");
                                        LOGGER.debug("===: UPDATE_PREPARE: " + tableName + " request code " + request.getCode());
                                        VCSGisEntity rentity = request.getEntity();
                                        if (lentity == null) {
                                            lentity = new EntitiesTable.EntityRow(this);
                                            lentity.copyfrom(rentity);
                                            lentity.setLocalRevisionCode(null);
                                            lentity.setState(32);
                                            lentity.insert(entitiesStore);
                                        } else {
                                            VCSGisUtils.copy(rentity, (VCSGisEntityEditable)lentity, t -> StringUtils.equals((CharSequence)t, (CharSequence)"FeatureTypeAsJson") && rentity.getFeatureTypeAsJson() == null);
                                            lentity.updateState(transaction);
                                            lentity.update(entitiesStore);
                                        }
                                        String entityCode = lentity.getCode();
                                        LOGGER.debug("===: UPDATE_PREPARE: " + tableName + " entity code " + entityCode + ", repo rev. " + lentity.getRepositoryRevisionCode() + ", local rev. " + lentity.getLocalRevisionCode());
                                        status.message("Preparing remote changes container in working-copy");
                                        remoteChangesStore = this.openFeatureStore("VCSGIS_REMOTECHANGES", true);
                                        transaction.add((DataStore)remoteChangesStore);
                                        remoteChangesStore.edit(3);
                                        status.message("Deleting previous temporary remote changes");
                                        LOGGER.debug("===: UPDATE_PREPARE: Delete updates table in working-copy");
                                        remoteChangesStore.delete("\"COD_ENTITY\"='" + entityCode + "'");
                                        remoteChangesStore.finishEditing();
                                        remoteChangesStore.edit(2);
                                        remoteChanges = request.getData();
                                        transaction.add((Disposable)remoteChanges);
                                        status.setCurValue(0L);
                                        LOGGER.debug("===: UPDATE_PREPARE: Inserting updates (repo->working-copy)");
                                        userStore = this.openFeatureStore((VCSGisEntity)lentity);
                                        localChangesStore = this.openFeatureStore("VCSGIS_WSCHANGES", true);
                                        transaction.add((DataStore)userStore);
                                        transaction.add((DataStore)localChangesStore);
                                        localChangesStore.edit(3);
                                        status.message("Downloading list of remote changes");
                                        for (VCSGisRepositoryData remoteChange : remoteChanges) {
                                            if (status.isCancellationRequested()) {
                                                throw new UserCancelledException();
                                            }
                                            RemoteChangesTable.RemoteChangeRow remoteChangeRow = new RemoteChangesTable.RemoteChangeRow(this);
                                            remoteChangeRow.newCode();
                                            remoteChangeRow.setData(remoteChange.getData());
                                            remoteChangeRow.setEntityCode(remoteChange.getEntityCode());
                                            remoteChangeRow.setDataCode(remoteChange.getFeatureRelatedCode());
                                            remoteChangeRow.setOperation(remoteChange.getOperation());
                                            remoteChangeRow.setRevisionCode(remoteChange.getRevisionCode());
                                            remoteChangeRow.setRevisionNumber(remoteChange.getRevisionNumber());
                                            remoteChangeRow.setEfectiveDate(remoteChange.getEfectiveDate());
                                            switch (remoteChange.getOperation()) {
                                                case 2: {
                                                    remoteChangeRow.setStatus(2);
                                                    break;
                                                }
                                                case 0: 
                                                case 1: {
                                                    remoteChangeRow.setStatus(6);
                                                    break;
                                                }
                                                default: {
                                                    remoteChangeRow.setStatus(1);
                                                }
                                            }
                                            if (this.hasConflictRemoteChangeWithUserTable((VCSGisEntity)lentity, remoteChange, userStore)) {
                                                remoteChangeRow.setStatus(16);
                                                lentity.setState(16);
                                            }
                                            LOGGER.debug("===: UPDATE_PREPARE: repository change: operation = " + remoteChangeRow.getOperation() + ", " + remoteChangeRow.getOperationLabel());
                                            LOGGER.debug("===: UPDATE_PREPARE: repository change: RelatedFeatureCode = " + remoteChangeRow.getRelatedFeatureCode());
                                            LOGGER.debug("===: UPDATE_PREPARE: local entity state = " + lentity.getState() + ", " + lentity.getStateLabel());
                                            switch (lentity.getState()) {
                                                case 1: 
                                                case 6: {
                                                    remoteChangeRow.setSelected(true);
                                                    break;
                                                }
                                                case 16: {
                                                    remoteChangeRow.setSelected(false);
                                                    DisposableIterable<WorkspaceChangesTable.WorkspaceChangeRow> localChanges = changesTable.getChangesWidthUserData(this, (VCSGisEntity)lentity, remoteChangeRow, localChangesStore, transaction);
                                                    if (localChanges != null) {
                                                        for (WorkspaceChangesTable.WorkspaceChangeRow localChange : localChanges) {
                                                            LOGGER.debug("===: UPDATE_PREPARE: conflicts. " + localChange.getRelatedFeatureData().replace('\n', ' '));
                                                            localChange.setStatus(16);
                                                            localChange.update(localChangesStore);
                                                        }
                                                        localChanges.dispose();
                                                    }
                                                }
                                                case 2: 
                                                case 4: 
                                                case 8: {
                                                    WorkspaceChangesTable.WorkspaceChangeRow localChange = changesTable.getByEntityAndDataCode(this, entityCode, remoteChangeRow.getRelatedFeatureCode(), localChangesStore);
                                                    if (localChange == null) {
                                                        LOGGER.debug("===: UPDATE_PREPARE: no local modificacion, update local data");
                                                        if (remoteChangeRow.getStatus() == 16) break;
                                                        remoteChangeRow.setSelected(true);
                                                        break;
                                                    }
                                                    LOGGER.debug("===: UPDATE_PREPARE: not update. Local data is modified. " + localChange.getRelatedFeatureData().replace('\n', ' '));
                                                    remoteChangeRow.setSelected(false);
                                                    if (localChange.getStatus() == 16) break;
                                                    localChange.setStatus(8);
                                                    localChange.update(localChangesStore);
                                                    break;
                                                }
                                            }
                                            remoteChangeRow.insert(remoteChangesStore);
                                            status.incrementCurrentValue();
                                        }
                                        LOGGER.debug("===: UPDATE_PREPARE: finish inserting updates");
                                        lentity.update(entitiesStore);
                                        remoteChangesStore.finishEditing();
                                        localChangesStore.finishEditing();
                                        entitiesStore.finishEditing();
                                        this.updateLocallyModyfiedRemoteChanges();
                                        UsersTable usersTable = new UsersTable();
                                        if (StringUtils.isNotBlank((CharSequence)request.getUsersHashCode()) && !StringUtils.equalsIgnoreCase((CharSequence)usersTable.getHashCode(this), (CharSequence)request.getUsersHashCode())) {
                                            this.updateUsersFromRepository(status);
                                        }
                                        TopologyplanTable topologyPlansTable = new TopologyplanTable();
                                        if (StringUtils.isNotBlank((CharSequence)request.getTopologyPlansHashCode()) && !StringUtils.equalsIgnoreCase((CharSequence)topologyPlansTable.getHashCode(this), (CharSequence)request.getTopologyPlansHashCode())) {
                                            this.updateTopologyPlansFromRepository(status);
                                        }
                                        transaction.commit();
                                        this.forceReloadWorkspaceEntities();
                                        status.message("Update-prepare completed");
                                        status.terminate();
                                        n = 0;
                                        DisposeUtils.disposeQuietly((Disposable)transaction);
                                        break;
                                    }
                                }
                                break block44;
                            }
                            catch (UserCancelledException ex) {
                                LOGGER.warn("User cancelled.", (Throwable)ex);
                                status.message("User cancelled");
                                status.cancel();
                                DataTransaction.rollbackQuietly(transaction);
                                throw ex;
                            }
                        }
                        status.pop();
                        return n4;
                    }
                    status.pop();
                    return n3;
                }
                status.pop();
                return n2;
            }
            status.pop();
            return msg2;
        }
        status.pop();
        return n;
        catch (Exception ex2) {
            LOGGER.warn("Can't prepare update.", (Throwable)ex2);
            status.message("Can't prepare update");
            status.abort();
            DataTransaction.rollbackQuietly(transaction);
            int n5 = 81;
            return n5;
        }
        finally {
            DisposeUtils.disposeQuietly(transaction);
            status.pop();
        }
    }

    private void updateLocallyModyfiedRemoteChanges() {
        RemoteChangesTable changes = new RemoteChangesTable();
        changes.updateStateFromLocalChanges(this, 8);
    }

    private boolean hasConflictRemoteChangeWithUserTable(VCSGisEntity lentity, VCSGisRepositoryData remoteChange, FeatureStore store) throws DataException {
        if (store != null) {
            FeatureType featType = store.getDefaultFeatureType();
            JsonObject data = remoteChange.getDataAsJson();
            ExpressionEvaluatorManager expManager = ExpressionEvaluatorLocator.getManager();
            ExpressionBuilder builder = expManager.createExpressionBuilder();
            builder.set(null);
            for (FeatureAttributeDescriptor attr : featType) {
                if (!attr.isIndexed() || attr.allowIndexDuplicateds()) continue;
                Object value = Json.toObject((JsonObject)data, (String)attr.getName());
                builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attr.getName()), (ExpressionBuilder.Value)builder.constant(value)));
                Feature f = store.findFirst(builder.toString());
                if (f == null || StringUtils.equals((CharSequence)f.getString(lentity.getFeatureIdFieldName()), (CharSequence)remoteChange.getFeatureRelatedCode())) continue;
                return true;
            }
        }
        return false;
    }

    private DisposableFeatureSetIterable getUserFeaturesConflictWithRemoteChange(VCSGisEntity lentity, RemoteChangesTable.RemoteChangeRow remoteChange, FeatureStore store) throws DataException {
        if (store == null) {
            return null;
        }
        FeatureType featType = lentity.getFeatureType();
        JsonObject data = remoteChange.getRelatedFeatureDataAsJson();
        ExpressionEvaluatorManager expManager = ExpressionEvaluatorLocator.getManager();
        ExpressionBuilder builder = expManager.createExpressionBuilder();
        builder.set(null);
        for (FeatureAttributeDescriptor attr : featType) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)lentity.getFeatureIdFieldName(), (CharSequence[])new CharSequence[]{attr.getName()}) || !attr.isIndexed() || attr.allowIndexDuplicateds()) continue;
            Object value = Json.toObject((JsonObject)data, (String)attr.getName());
            builder.or((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attr.getName()), (ExpressionBuilder.Value)builder.constant(value)));
        }
        ExpressionBuilder.Value value = builder.value();
        if (value == null) {
            return null;
        }
        ExpressionBuilder.BinaryOperator filter = builder.and((ExpressionBuilder.Value)builder.not((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(lentity.getFeatureIdFieldName()), (ExpressionBuilder.Value)builder.constant((Object)remoteChange.getRelatedFeatureCode()))), value);
        FeatureSet feats = store.getFeatureSet(filter.toString());
        return feats.iterable();
    }

    public int updateClean(String entityCode) {
        return this.updateClean(entityCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateClean(String entityCode, SimpleTaskStatus status) {
        VCSGisEntity entity = this.getEntity(entityCode);
        if (entity == null) {
            return 240;
        }
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Update-clean " + entity.getEntityName());
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        try {
            status.message("Deleting temporary remote changes (" + entity.getEntityName() + ")");
            RemoteChangesTable remoteChangesTable = new RemoteChangesTable();
            remoteChangesTable.delete(this, entityCode);
            status.message("Delete temporary remote changes completed");
            status.terminate();
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't deleting temporary remote changes of " + entity.getEntityName() + ".", (Throwable)ex);
            status.message("Can't deleting temporary remote changes of " + entity.getEntityName() + ".");
            status.abort();
            int n = 83;
            return n;
        }
        finally {
            status.pop();
        }
    }

    public int update(String tableName) {
        return this.update(tableName, false, false, null);
    }

    public int update(String tableName, SimpleTaskStatus status) {
        return this.update(tableName, false, false, status);
    }

    public int merge(String tableName) {
        return this.update(tableName, false, true, null);
    }

    public int merge(String tableName, SimpleTaskStatus status) {
        return this.update(tableName, false, true, null, null, status);
    }

    public int merge(String tableName, MutableLong localChangesCreated, SimpleTaskStatus status) {
        return this.update(tableName, false, true, localChangesCreated, null, status);
    }

    public int update(String tableName, boolean prepare, boolean merge, SimpleTaskStatus status) {
        return this.update(tableName, prepare, merge, null, null, status);
    }

    public int update(String tableName, VCSGisWorkspace.UpdateChangeListener changeListener, SimpleTaskStatus status) {
        return this.update(tableName, false, false, null, changeListener, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public int update(String tableName, boolean prepare, boolean merge, MutableLong localChangesModifieds, VCSGisWorkspace.UpdateChangeListener changeListener, SimpleTaskStatus status) {
        int n;
        if (this.isOffline()) {
            return 10001;
        }
        SafeUpdateChangeListener safeChangeListener = new SafeUpdateChangeListener(changeListener);
        if (localChangesModifieds == null) {
            localChangesModifieds = new MutableLong(0L);
        }
        int errcode = 0;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Update " + tableName);
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        if (prepare && (errcode = this.updatePrepare(tableName, status)) != 0) {
            return errcode;
        }
        LOGGER.debug("===: UPDATE " + this.getCode() + ", '" + this.getLabel() + "', " + tableName);
        RemoteChangesTable remoteChangesTable = new RemoteChangesTable();
        WorkspaceChangesTable localChangesTable = new WorkspaceChangesTable();
        DisposableFeatureSetIterable remoteChanges = null;
        FeatureStore workspaceChangesStore = null;
        FeatureStore remoteChangesStore = null;
        FeatureStore userStore = null;
        FeatureStore entitiesStore = null;
        DataTransaction transaction = null;
        try {
            EditableFeature ef;
            if (status.isCancellationRequested()) {
                throw new UserCancelledException();
            }
            transaction = DALLocator.getDataManager().createTransaction();
            transaction.begin();
            entitiesStore = this.openFeatureStore("VCSGIS_ENTITIES", true);
            transaction.add((DataStore)entitiesStore);
            entitiesStore.edit(3);
            String maxRevisionCode = null;
            long maxRevisionNumber = 0L;
            EntitiesTable.EntityRow lentity = this.getWorkspaceEntityByName(tableName);
            if (lentity == null) {
                lentity = new EntitiesTable.EntityRow(this);
                VCSGisEntity rentity = this.getRepositoryEntityByName(tableName);
                lentity.copyfrom(rentity);
                lentity.setLocalRevisionCode(null);
                lentity.update(entitiesStore);
            } else {
                maxRevisionCode = lentity.getLocalRevisionCode();
                VCSGisEntity rentity2 = this.getRepositoryEntityByName(tableName);
                lentity.setCategory(rentity2.getCategory());
                lentity.setDescription(rentity2.getDescription());
                lentity.setLabel(rentity2.getLabel());
            }
            if (!merge) {
                status.message("Checking the need to merge");
                if (remoteChangesTable.updateNeedMerge(this, lentity.getEntityCode())) {
                    status.message("Can't update without merge.");
                    status.abort();
                    int rentity2 = 82;
                    return rentity2;
                }
            }
            String dataCodeFieldName = lentity.getFeatureIdFieldName();
            status.message("Searching remote changes (" + lentity.getEntityName() + ")");
            userStore = this.openFeatureStore((VCSGisEntity)lentity);
            if (userStore == null) {
                this.create_table((VCSGisEntity)lentity);
                userStore = this.openFeatureStore((VCSGisEntity)lentity);
            }
            transaction.add((DataStore)userStore);
            userStore.edit(3);
            workspaceChangesStore = this.openFeatureStore("VCSGIS_WSCHANGES", true);
            transaction.add((DataStore)workspaceChangesStore);
            workspaceChangesStore.edit(3);
            remoteChangesStore = this.openFeatureStore("VCSGIS_REMOTECHANGES", true);
            transaction.add((DataStore)remoteChangesStore);
            remoteChangesStore.edit(3);
            remoteChanges = remoteChangesTable.getSelectedsByEntityCodeAsIterator(this, lentity.getCode());
            transaction.add((Disposable)remoteChanges);
            status.setCurValue(0L);
            if (!remoteChanges.isEmpty()) {
                this.addStoreIgnoreChanges(userStore);
                status.message("Updating table (" + lentity.getEntityName() + ")");
                FeatureType type = userStore.getDefaultFeatureTypeQuietly();
                ExpressionEvaluatorManager expManager = ExpressionEvaluatorLocator.getManager();
                ExpressionBuilder builder = expManager.createExpressionBuilder();
                FilteredLogger log = new FilteredLogger(LOGGER, "update", 100);
                for (Feature feature : remoteChanges) {
                    if (status.isCancellationRequested()) {
                        throw new UserCancelledException();
                    }
                    RemoteChangesTable.RemoteChangeRow remoteChangeRow = new RemoteChangesTable.RemoteChangeRow(this, feature);
                    if (maxRevisionNumber < remoteChangeRow.getRevisionNumber()) {
                        maxRevisionNumber = remoteChangeRow.getRevisionNumber();
                        maxRevisionCode = remoteChangeRow.getRevisionCode();
                    }
                    switch (remoteChangeRow.getOperation()) {
                        case 2: {
                            FeatureAttributeDescriptor[] feats;
                            LOGGER.debug("===: UPDATE: insert");
                            switch (remoteChangeRow.getStatus()) {
                                case 16: {
                                    feats = this.getUserFeaturesConflictWithRemoteChange((VCSGisEntity)lentity, remoteChangeRow, userStore);
                                    if (feats == null) break;
                                    for (Feature feature2 : feats) {
                                        if (feature2 == null) continue;
                                        feats.getFeatureSet().delete(feature2);
                                        workspaceChangesStore.delete("\"WSCH_FEATURECODE\" = '" + feature2.getString(lentity.getFeatureIdFieldName()) + "'");
                                    }
                                    DisposeUtils.disposeQuietly((Disposable)feats);
                                }
                            }
                            JsonObject dataJson = remoteChangeRow.getRelatedFeatureDataAsJson();
                            if (dataJson == null) {
                                log.warn("A feature (VCSGISCODE=" + remoteChangeRow.getRelatedFeatureCode() + ") has been retrieved with the DAT_DATA field set to null.");
                                break;
                            }
                            ef = userStore.createNewFeature(dataJson);
                            userStore.insert(ef);
                            safeChangeListener.afterInsert((VCSGisEntity)lentity, (Feature)ef);
                            break;
                        }
                        case 1: {
                            void var33_42;
                            LOGGER.debug("===: UPDATE: update");
                            JsonObject dataJson = remoteChangeRow.getRelatedFeatureDataAsJson();
                            if (dataJson == null) {
                                log.warn("A feature (VCSGISCODE=" + remoteChangeRow.getRelatedFeatureCode() + ") has been retrieved with the DAT_DATA field set to null.");
                                break;
                            }
                            builder.set(null);
                            FeatureAttributeDescriptor[] feats = type.getPrimaryKey();
                            int n2 = feats.length;
                            boolean bl = false;
                            while (var33_42 < n2) {
                                FeatureAttributeDescriptor attr = feats[var33_42];
                                builder.and((ExpressionBuilder.Value)builder.eq((ExpressionBuilder.Value)builder.column(attr.getName()), (ExpressionBuilder.Value)builder.constant(Json.toObject((JsonValue)((JsonValue)dataJson.get((Object)attr.getName()))))));
                                ++var33_42;
                            }
                            Feature f = userStore.findFirst(builder.toString());
                            if (f == null) {
                                WorkspaceChangesTable.WorkspaceChangeRow localChange = localChangesTable.find(this, workspaceChangesStore, lentity.getEntityCode(), remoteChangeRow.getRelatedFeatureCode());
                                if (localChange != null) {
                                    if (localChange.getOperation() == 0) {
                                        ef = userStore.createNewFeature(dataJson);
                                        userStore.insert(ef);
                                        safeChangeListener.afterInsert((VCSGisEntity)lentity, (Feature)ef);
                                        break;
                                    }
                                    throw new NullPointerException("Can't update null feature (" + builder.toString() + ").");
                                }
                                ef = userStore.createNewFeature(dataJson);
                                userStore.insert(ef);
                                safeChangeListener.afterInsert((VCSGisEntity)lentity, (Feature)ef);
                                break;
                            }
                            ef = f.getEditable();
                            ef.copyFrom(dataJson);
                            if (this.removeMissingValues(ef, dataJson)) {
                                log.warn("Missing attributes in the json (kill the admin?)");
                            }
                            userStore.update(ef);
                            safeChangeListener.afterUpdate((VCSGisEntity)lentity, f, (Feature)ef);
                            break;
                        }
                        case 0: {
                            LOGGER.debug("===: UPDATE: delete");
                            String deleteFilter = "\"" + dataCodeFieldName + "\"='" + remoteChangeRow.getRelatedFeatureCode() + "'";
                            safeChangeListener.beforeDelete((VCSGisEntity)lentity, userStore, deleteFilter, remoteChangeRow.getRelatedFeatureCode());
                            userStore.delete(deleteFilter);
                        }
                    }
                    status.incrementCurrentValue();
                }
            }
            if (merge) {
                status.message("Searching local changes to merge (" + lentity.getEntityName() + ")");
                DisposeUtils.disposeQuietly((Disposable)remoteChanges);
                remoteChanges = remoteChangesTable.getNotSelectedsByEntityCodeAsIterator(this, lentity.getCode());
                transaction.add((Disposable)remoteChanges);
                status.setCurValue(0L);
                if (!remoteChanges.isEmpty()) {
                    this.addStoreIgnoreChanges(userStore);
                    status.message("Adding to local changes (" + lentity.getEntityName() + ")");
                    for (Feature feature : remoteChanges) {
                        if (status.isCancellationRequested()) {
                            throw new UserCancelledException();
                        }
                        RemoteChangesTable.RemoteChangeRow remoteChangeRow = new RemoteChangesTable.RemoteChangeRow(this, feature);
                        if (maxRevisionNumber < remoteChangeRow.getRevisionNumber()) {
                            maxRevisionNumber = remoteChangeRow.getRevisionNumber();
                            maxRevisionCode = remoteChangeRow.getRevisionCode();
                        }
                        Feature f = userStore.findFirst("\"" + lentity.getFeatureIdFieldName() + "\" = '" + remoteChangeRow.getRelatedFeatureCode() + "'");
                        switch (remoteChangeRow.getOperation()) {
                            case 2: {
                                LOGGER.debug("===: UPDATE: insert");
                                if (f == null) {
                                    LOGGER.debug("===: UPDATE: add delete operation to RelatedFeatureCode " + remoteChangeRow.getRelatedFeatureCode());
                                    this.addDeleteChange(null, lentity, workspaceChangesStore, remoteChangeRow.getRelatedFeatureCode(), null, null);
                                } else {
                                    LOGGER.debug("===: UPDATE: add update operation to RelatedFeatureCode " + remoteChangeRow.getRelatedFeatureCode());
                                    this.addChange(null, lentity, 1, workspaceChangesStore, f, feature, null);
                                }
                                localChangesModifieds.increment();
                                break;
                            }
                            case 1: {
                                LOGGER.debug("===: UPDATE: update");
                                if (f == null) {
                                    LOGGER.debug("===: UPDATE: add delete operation to RelatedFeatureCode " + remoteChangeRow.getRelatedFeatureCode());
                                    this.addDeleteChange(null, lentity, workspaceChangesStore, remoteChangeRow.getRelatedFeatureCode(), null, null);
                                } else {
                                    LOGGER.debug("===: UPDATE: add update operation to RelatedFeatureCode " + remoteChangeRow.getRelatedFeatureCode());
                                    this.addChange(null, lentity, 1, workspaceChangesStore, f, feature, null);
                                }
                                localChangesModifieds.increment();
                                break;
                            }
                            case 0: {
                                LOGGER.debug("===: UPDATE: delete");
                                if (f != null) {
                                    userStore.delete("\"" + dataCodeFieldName + "\"='" + remoteChangeRow.getRelatedFeatureCode() + "'");
                                    ef = userStore.createNewFeature(f);
                                    String newRelatedFeatureCode = this.createUniqueCode();
                                    ef.setString(lentity.getFeatureIdFieldName(), newRelatedFeatureCode);
                                    userStore.insert(ef);
                                    workspaceChangesStore.delete("\"WSCH_FEATURECODE\"='" + remoteChangeRow.getRelatedFeatureCode() + "'");
                                    LOGGER.debug("===: UPDATE: add insert operation to RelatedFeatureCode " + newRelatedFeatureCode);
                                    this.addChange(null, lentity, 2, workspaceChangesStore, (Feature)ef, null, null);
                                    localChangesModifieds.increment();
                                    break;
                                }
                                this.removeLocalDeleteIfExists(remoteChangeRow.getRelatedFeatureCode(), workspaceChangesStore);
                                localChangesModifieds.increment();
                            }
                        }
                        status.incrementCurrentValue();
                    }
                }
            }
            localChangesTable.removeLocalChangesRelatedToSelectedRemoteChanges(this, (VCSGisEntity)lentity);
            remoteChangesTable.delete(remoteChangesStore, lentity.getEntityCode());
            status.message("Updating metadata tables");
            if (FutureUtils.use((String)"LAST_REVISION_OF_REPO_ENTITY")) {
                lentity.setLocalRevisionCode(lentity.getRepositoryRevisionCode());
            } else {
                lentity.setLocalRevisionCode(maxRevisionCode);
            }
            if (!this.isCorrupt((VCSGisEntity)lentity, userStore, 0, false)) {
                lentity.updateState(transaction);
            }
            lentity.update(entitiesStore);
            transaction.commit();
            this.forceReloadWorkspaceEntities();
            status.message("Update completed");
            status.terminate();
            n = 0;
            this.removeStoreIgnoreChanges(userStore);
        }
        catch (UserCancelledException ex) {
            LOGGER.warn("User cancelled.", (Throwable)ex);
            status.message("User cancelled");
            status.cancel();
            DataTransaction.rollbackQuietly((DataTransaction)transaction);
            throw new UserCancelledException();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't update.", (Throwable)ex);
            status.message("Can't update");
            status.abort();
            int n2 = 80;
            return n2;
        }
        finally {
            this.removeStoreIgnoreChanges(userStore);
            DisposeUtils.disposeQuietly((Disposable)transaction);
            status.pop();
        }
        DisposeUtils.disposeQuietly((Disposable)transaction);
        status.pop();
        return n;
    }

    public JDBCServerExplorer getExplorer() {
        return this.wsexplorer;
    }

    public void clearRepositoryEntitiesCached() {
        this.repositoryEntitiesByCode = null;
    }

    private boolean isRepositoryEntitiesCached() {
        if (this.repositoryEntitiesByCode == null) {
            return false;
        }
        long now = new Date().getTime();
        return now - this.repositoryEntitiesByCodeLastUpdate < this.repositoryEntitiesCacheTime;
    }

    public synchronized void reloadRepositoryEntities(SimpleTaskStatus status) {
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Repository tables");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        Disposable store = null;
        Disposable fset = null;
        try {
            if (this.isRepositoryEntitiesCached()) {
                this.repositoryEntitiesByCodeLastUpdate = new Date().getTime();
                return;
            }
            status.message("Getting repository table metadata");
            VCSGisRepository repo = this.getRepository();
            VCSGisEntitiesRequest request = repo.createEntitiesRequest();
            request.setAuthenticationToken(this.getAuthenticationToken(repo));
            request.setUserCode(this.getCurrentUserCode(repo));
            if (this.execute((VCSGisRequest)request) != 0) {
                throw new VCSGisRuntimeException(request.getLastErrorCode(), request.getLastErrorMessage());
            }
            List entities = request.getRepositoryEntities();
            request.dispose();
            HashMap<String, VCSGisEntity> tmp = new HashMap<String, VCSGisEntity>();
            entities.forEach(entity -> tmp.put(entity.getEntityCode(), (VCSGisEntity)entity));
            this.repositoryEntitiesByCode = tmp;
            status.message("Repository tables metadata update completed");
            status.terminate();
            this.repositoryEntitiesByCodeLastUpdate = new Date().getTime();
            this.repositoryEntitiesChangeListeners.fireEvent();
        }
        catch (VCSGisRuntimeException ex) {
            FeatureStore.cancelEditingQuietly(store);
            status.message("Can't get repository tables metadata");
            status.abort();
            throw ex;
        }
        catch (Exception ex) {
            FeatureStore.cancelEditingQuietly(store);
            status.message("Can't get repository tables metadata");
            status.abort();
            throw new VCSGisRuntimeException(250, VCSGisUtils.getErrorMessage(250), (Throwable)ex);
        }
        finally {
            DisposeUtils.disposeQuietly(fset);
            DisposeUtils.disposeQuietly(store);
            status.pop();
        }
    }

    public boolean updateNeedMerge(String entityName) {
        if (this.isOffline()) {
            return false;
        }
        RemoteChangesTable remoteChangesTable = new RemoteChangesTable();
        EntitiesTable.EntityRow entity = this.getWorkspaceEntity(entityName);
        if (entity == null) {
            entity = this.getRepositoryEntity(entityName);
        }
        return remoteChangesTable.updateNeedMerge(this, entity.getEntityCode());
    }

    public void addToConnectionPool() {
        JDBCServerExplorerParameters params = this.getExplorerParameters();
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.getDataServerExplorerPool().add(this.getLabel(), (DataServerExplorerParameters)params);
    }

    public boolean isInMyDatabase(FeatureStore store) {
        if (!(store.getParameters() instanceof JDBCStoreParameters)) {
            return false;
        }
        JDBCStoreParameters storeParams = (JDBCStoreParameters)store.getParameters();
        JDBCServerExplorerParameters explorerParams = this.getExplorerParameters();
        if (!StringUtils.equalsIgnoreCase((CharSequence)storeParams.getProviderName(), (CharSequence)explorerParams.getProviderName())) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)storeParams.getUrl(), (CharSequence)explorerParams.getUrl());
    }

    public boolean isInMyDatabase(OpenFeatureStoreParameters parameters) {
        if (!(parameters instanceof JDBCStoreParameters)) {
            return false;
        }
        JDBCStoreParameters storeParams = (JDBCStoreParameters)parameters;
        JDBCServerExplorerParameters explorerParams = this.getExplorerParameters();
        if (!StringUtils.equalsIgnoreCase((CharSequence)storeParams.getProviderName(), (CharSequence)explorerParams.getProviderName())) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)storeParams.getUrl(), (CharSequence)explorerParams.getUrl());
    }

    public boolean isInMyDatabase(String tableName) {
        try {
            File f;
            if (StringUtils.isBlank((CharSequence)tableName)) {
                return false;
            }
            JDBCServerExplorer explorer = this.getExplorer();
            JDBCServerExplorerParameters explorerParams = explorer.getParameters();
            if (explorerParams instanceof HasAFile && !(f = ((HasAFile)explorerParams).getFile()).exists()) {
                return false;
            }
            JDBCStoreParameters parameters = explorer.get(tableName);
            return explorer.exists((DataStoreParameters)parameters);
        }
        catch (DataException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int history(String entityName, String group, Timestamp minDate, Timestamp maxDate, int maxNumberOfRevisions, SimpleTaskStatus status) {
        if (this.isOffline()) {
            return 10001;
        }
        int errcode = 0;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("History" + entityName);
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        DataTransaction transaction = DALLocator.getDataManager().createTransaction();
        try {
            transaction.begin();
            LOGGER.debug("===: HISTORY " + this.getCode() + ", '" + this.getLabel() + "', " + entityName);
            if (maxNumberOfRevisions < 0) {
                maxNumberOfRevisions = 1000;
            }
            if (minDate != null && maxDate != null && minDate.compareTo(maxDate) > 0) {
                Timestamp x = minDate;
                minDate = maxDate;
                maxDate = x;
            }
            this.reloadWorkspaceEntities();
            VCSGisEntity lentity = this.getEntity(entityName);
            if (lentity == null) {
                status.message("Can't find table '" + entityName + "'");
                status.abort();
                int n = 240;
                return n;
            }
            status.message("Executing history request");
            VCSGisRepository repo = this.getRepository();
            VCSGisHistoryRequest request = repo.createHistoryRequest(entityName);
            transaction.add((Disposable)request);
            request.setAuthenticationToken(this.getAuthenticationToken(repo));
            request.setUserCode(this.getCurrentUserCode(repo));
            request.setDateRange(minDate, maxDate);
            request.setMaxNumberOfRevisions(maxNumberOfRevisions);
            request.setRevisionNumberRange(-1L, -1L);
            if (this.execute((VCSGisRequest)request) != 0) {
                status.message("Can't retriev history of " + entityName + " (error " + request.getLastErrorCode() + ")");
                status.abort();
                int n = request.getLastErrorCode();
                return n;
            }
            LocalRevisionsTable localRevisionsTable = new LocalRevisionsTable();
            FeatureStore localRevisionsStore = this.openFeatureStore("VCSGIS_LOCALREVISIONS", true);
            transaction.add((DataStore)localRevisionsStore);
            localRevisionsStore.edit(3);
            status.message("Deleting previous local revision information");
            localRevisionsTable.deleteByEntityCodeAndGroup(this, localRevisionsStore, lentity.getEntityCode(), group);
            DisposableIterable revisions = request.getRevisions();
            status.message("Adding to local revisions");
            status.setCurValue(0L);
            long minRevision = -1L;
            minDate = this.now();
            errcode = 420;
            for (VCSGisRevision revision : revisions) {
                LocalRevisionsTable.LocalRevisionRow row = new LocalRevisionsTable.LocalRevisionRow(this);
                row.copyFrom(revision);
                row.setGroup(group);
                row.insert(localRevisionsStore);
                if (minRevision < 0L || minRevision > row.getNumber()) {
                    minRevision = row.getNumber();
                }
                if (minDate.compareTo(row.getRevisionDate()) > 0) {
                    minDate = row.getRevisionDate();
                }
                status.incrementCurrentValue();
            }
            localRevisionsStore.finishEditing();
            VarsTable varsTable = new VarsTable();
            varsTable.set(this, "history_" + entityName + "_" + group + "_MinDate", minDate.toString());
            varsTable.set(this, "history_" + entityName + "_" + group + "_MinRevision", String.valueOf(minRevision));
            transaction.commit();
            status.message("History completed");
            status.terminate();
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve history.", (Throwable)ex);
            transaction.rollbackQuietly();
            status.message("Can't retrieve history");
            status.abort();
            int n = errcode;
            return n;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)transaction);
            status.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int history(String entityName, String group, int maxNumberOfRevisions, SimpleTaskStatus status) {
        if (this.isOffline()) {
            return 10001;
        }
        int errcode = 0;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("History" + entityName);
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        DataTransaction transaction = DALLocator.getDataManager().createTransaction();
        try {
            transaction.begin();
            LOGGER.debug("===: HISTORY " + this.getCode() + ", '" + this.getLabel() + "', " + entityName);
            if (maxNumberOfRevisions < 0) {
                maxNumberOfRevisions = 1000;
            }
            this.reloadWorkspaceEntities();
            EntitiesTable.EntityRow lentity = this.getWorkspaceEntityByName(entityName);
            if (lentity == null) {
                status.message("Can't find table '" + entityName + "'");
                status.abort();
                int n = 240;
                return n;
            }
            VarsTable varsTable = new VarsTable();
            long minRevision = Long.valueOf(varsTable.get(this, "history_" + entityName + "_" + group + "_MinRevision"));
            status.message("Executing history request");
            VCSGisRepository repo = this.getRepository();
            VCSGisHistoryRequest request = repo.createHistoryRequest(entityName);
            transaction.add((Disposable)request);
            request.setAuthenticationToken(this.getAuthenticationToken(repo));
            request.setUserCode(this.getCurrentUserCode(repo));
            request.setDateRange(null, null);
            request.setMaxNumberOfRevisions(maxNumberOfRevisions);
            request.setRevisionNumberRange(-1L, minRevision);
            if (this.execute((VCSGisRequest)request) != 0) {
                status.message("Can't retriev history of " + entityName + " (error " + request.getLastErrorCode() + ")");
                status.abort();
                int n = request.getLastErrorCode();
                return n;
            }
            FeatureStore localRevisionsStore = this.openFeatureStore("VCSGIS_LOCALREVISIONS", true);
            transaction.add((DataStore)localRevisionsStore);
            localRevisionsStore.edit(3);
            DisposableIterable revisions = request.getRevisions();
            status.message("Adding to local revisions");
            status.setCurValue(0L);
            errcode = 420;
            minRevision = -1L;
            Timestamp minDate = this.now();
            for (VCSGisRevision revision : revisions) {
                LocalRevisionsTable.LocalRevisionRow row = new LocalRevisionsTable.LocalRevisionRow(this);
                row.copyFrom(revision);
                row.setGroup(group);
                if (!row.exists(localRevisionsStore)) {
                    row.insert(localRevisionsStore);
                }
                if (minRevision < 0L || minRevision > row.getNumber()) {
                    minRevision = row.getNumber();
                }
                if (minDate.compareTo(row.getRevisionDate()) > 0) {
                    minDate = row.getRevisionDate();
                }
                status.incrementCurrentValue();
            }
            localRevisionsStore.finishEditing();
            varsTable.set(this, "history_" + entityName + "_" + group + "_MinDate", minDate.toString());
            varsTable.set(this, "history_" + entityName + "_" + group + "_MinRevision", String.valueOf(minRevision));
            transaction.commit();
            status.message("history completed");
            status.terminate();
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve history.", (Throwable)ex);
            transaction.rollbackQuietly();
            status.message("Can't retrieve history");
            status.abort();
            int n = errcode;
            return n;
        }
        finally {
            transaction.dispose();
            status.pop();
        }
    }

    public GetItemWithSize64<VCSGisRevision> getRevisions(String entityName, String group, String filter) {
        LocalRevisionsTable localRevisionsTable = new LocalRevisionsTable();
        this.reloadWorkspaceEntities();
        VCSGisEntity lentity = this.getEntity(entityName);
        if (lentity == null) {
            throw new IllegalArgumentException("EntityName '" + entityName + "' not found.");
        }
        VCSGisWorkspaceImpl workspace = this;
        GetItemWithSizeAndIterator64<Feature> revisionsf = localRevisionsTable.getRevisions(this, lentity.getEntityCode(), group, filter);
        GetItemWithSize64Disposable revisions = new GetItemWithSize64Disposable(workspace, revisionsf);
        DisposeUtils.disposeQuietly(revisionsf);
        return revisions;
    }

    public FeatureStore getRevisionsStore() {
        FeatureStore store = this.openFeatureStore("VCSGIS_LOCALREVISIONS", false);
        return store;
    }

    private boolean removeMissingValues(EditableFeature ef, JsonObject dataJson) {
        boolean hasMissingValues = false;
        try {
            FeatureType ftype = ef.getType();
            for (FeatureAttributeDescriptor attr : ftype) {
                if (dataJson.containsKey((Object)attr.getName()) || !attr.allowNull() || !attr.isReadOnly() || attr.isPrimaryKey()) continue;
                ef.set(attr.getName(), null);
                hasMissingValues = true;
            }
            return hasMissingValues;
        }
        catch (Exception e) {
            LOGGER.debug("Can't remove missing values", (Throwable)e);
            return hasMissingValues;
        }
    }

    public String getUserName(String userCodeOrId) {
        VCSGisUser user = this.getUser(userCodeOrId);
        if (user == null) {
            return null;
        }
        return user.getIdentifier();
    }

    public VCSGisUser getUser(String userCodeOrId) {
        UsersTable usersTable = new UsersTable();
        VCSGisUser user = usersTable.getUserByIdentifier(this, userCodeOrId);
        if (user != null) {
            return user;
        }
        if (this.isValidUserCode(userCodeOrId)) {
            user = usersTable.getUserByCode(this, userCodeOrId);
        }
        return user;
    }

    public Feature getRelatedFeature(VCSGisEntity entity, String featureCode) {
        Feature feature;
        FeatureStore store = null;
        try {
            Feature f;
            store = this.getFeatureStore(entity.getEntityName());
            feature = f = store.findFirst("\"" + entity.getFeatureIdFieldName() + "\"='" + featureCode + "'");
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve feature '" + entity.getEntityName() + "/" + this.code + "'.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return feature;
    }

    public Feature getRelatedFeature(VCSGisRepositoryChange change) {
        EntitiesTable.EntityRow entity = this.getWorkspaceEntity(change.getEntityCode());
        return this.getRelatedFeature((VCSGisEntity)entity, change.getRelatedFeatureCode());
    }

    @Deprecated
    public int removeEntity(String nameOrCode) {
        int err = 0;
        EntitiesTable.EntityRow entity = this.getWorkspaceEntity(nameOrCode);
        if (entity == null) {
            err = 240;
            return err;
        }
        return this.removeEntity((VCSGisEntity)entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeEntity(VCSGisEntity entity) {
        if (entity == null) {
            return 36;
        }
        int err = 0;
        DataTransaction transaction = DALLocator.getDataManager().createTransaction();
        try {
            transaction.begin();
            EntitiesTable.EntityRow entity1 = this.getWorkspaceEntityByCode(entity.getEntityCode());
            EntitiesTable.EntityRow entity2 = this.getWorkspaceEntityByName(entity.getEntityName());
            err = entity1 != null && entity2 != null && StringUtils.equalsIgnoreCase((CharSequence)entity1.getEntityName(), (CharSequence)entity2.getEntityName()) && StringUtils.equalsIgnoreCase((CharSequence)entity1.getEntityCode(), (CharSequence)entity2.getEntityCode()) ? this.doRemoveEntity((VCSGisEntity)entity1, transaction) : (entity1 != null ? this.doRemoveEntity((VCSGisEntity)entity1, transaction) : (entity2 != null ? this.doRemoveEntity((VCSGisEntity)entity2, transaction) : this.doRemoveEntity(entity, transaction)));
            transaction.commit();
            this.forceReloadWorkspaceEntities();
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't remove entity.", (Throwable)ex);
            transaction.rollbackQuietly();
            int n = err;
            return n;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeEntities(List<String> namesOrCodes) {
        int err = 0;
        DataTransaction transaction = DALLocator.getDataManager().createTransaction();
        try {
            transaction.begin();
            for (String nameOrCode : namesOrCodes) {
                EntitiesTable.EntityRow entity = this.getWorkspaceEntity(nameOrCode);
                if (entity == null) {
                    int n = err = 240;
                    return n;
                }
                this.doRemoveEntity((VCSGisEntity)entity, transaction);
            }
            transaction.commit();
            this.forceReloadWorkspaceEntities();
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't remove entity.", (Throwable)ex);
            transaction.rollbackQuietly();
            int n = err;
            return n;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)transaction);
        }
    }

    private int doRemoveEntity(VCSGisEntity entity, DataTransaction transaction) throws DataException {
        LOGGER.debug("===: REMOVE ENTITY " + entity.getEntityName());
        int err = 330;
        FeatureStore changesStore = this.openFeatureStore("VCSGIS_WSCHANGES", true);
        transaction.add((DataStore)changesStore);
        changesStore.edit(1);
        changesStore.delete("\"COD_ENTITY\"='" + entity.getEntityCode() + "'");
        changesStore.finishEditing();
        FeatureStore remoteChangesStore = this.openFeatureStore("VCSGIS_REMOTECHANGES", true);
        transaction.add((DataStore)remoteChangesStore);
        remoteChangesStore.edit(1);
        remoteChangesStore.delete("\"COD_ENTITY\"='" + entity.getEntityCode() + "'");
        remoteChangesStore.finishEditing();
        FeatureStore revisionsStore = this.openFeatureStore("VCSGIS_LOCALREVISIONS", true);
        transaction.add((DataStore)revisionsStore);
        revisionsStore.edit(1);
        revisionsStore.delete("\"COD_ENTITY\"='" + entity.getEntityCode() + "'");
        revisionsStore.finishEditing();
        err = 280;
        FeatureStore entitiesStore = this.openFeatureStore("VCSGIS_ENTITIES", true);
        transaction.add((DataStore)entitiesStore);
        entitiesStore.edit(1);
        entitiesStore.delete("\"COD_ENTITY\"='" + entity.getEntityCode() + "'");
        entitiesStore.finishEditing();
        err = 280;
        FeatureStore store = this.openFeatureStore(entity);
        if (store != null) {
            ResourcesStorage.Resource resource;
            transaction.add((DataStore)store);
            ResourcesStorage resourcesStorage = store.getResourcesStorage();
            if (resourcesStorage != null && (resource = resourcesStorage.getResource("dal")) != null) {
                resourcesStorage.remove(resource.getName());
            }
            transaction.add((DataServerExplorer)this.wsexplorer, false);
            this.wsexplorer.remove(store.getParameters());
        }
        return err;
    }

    public boolean authenticate(SimpleTaskStatus status) {
        if (this.isOffline()) {
            return false;
        }
        VCSGisRepository repo = this.getRepository();
        if (StringUtils.isNotBlank((CharSequence)this.getCurrentUserCode(repo))) {
            return true;
        }
        int r = this.authenticate(repo, null, null, status);
        switch (r) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return this.userIdentificationRequester != null && this.userIdentificationRequester.requestIdentification() && (r = this.authenticate(this.userIdentificationRequester.getUserId(), this.userIdentificationRequester.getPassword(), null)) == 0;
            }
        }
        return true;
    }

    public int authenticate(String userId, String password, SimpleTaskStatus status) {
        return this.authenticate(this.getRepository(), userId, password, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int authenticate(VCSGisRepository repository, String userId, String password, SimpleTaskStatus status) {
        if (this.isOffline()) {
            return 10001;
        }
        int errcode = 0;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Authenticate-" + userId);
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        try {
            if (repository == null) {
                repository = this.getRepository();
            }
            VCSGisAuthenticateRequest request = repository.createAuthenticateRequest(userId, password);
            LOGGER.info("Client " + this.getCode() + " execute '" + request.getRequestName() + "' with user '" + request.getUserName() + "'");
            if (request.execute() != 0) {
                status.message(request.getLastErrorMessage());
                status.abort();
                LOGGER.info("Client " + this.getCode() + " execute '" + request.getRequestName() + "' with user '" + request.getUserName() + "' Error");
                int n = request.getLastErrorCode();
                return n;
            }
            VarsTable varsTable = new VarsTable();
            varsTable.set(this, CONFIG_USER_NAME, request.getUserCode());
            varsTable.set(this, CONFIG_AUTHENTICATIONTOKEN_NAME, request.getAuthenticationToken());
            this.setCurrentUserCode(repository, request.getUserCode());
            this.setAuthenticationToken(repository, request.getAuthenticationToken());
            this.getRepository().setAuthenticationToken(request.getAuthenticationToken());
            this.getRepository().setUserCode(request.getUserCode());
            ((VCSGisManagerImpl)VCSGisLocator.getVCSGisManager()).addToIdentityManager(this);
            LOGGER.info("Client " + this.getCode() + " execute '" + request.getRequestName() + "' with user '" + request.getUserName() + "' Ok userCode='" + request.getUserCode() + "', token='" + request.getAuthenticationToken() + "'");
            status.message("Authentication completed");
            status.terminate();
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't authenticate user.", (Throwable)ex);
            status.message("Can't authenticate user");
            status.abort();
            int n = errcode;
            return n;
        }
        finally {
            status.pop();
        }
    }

    public void setUserIdentificationRequester(VCSGisUserIdentificationRequester userIdentificationRequester) {
        this.userIdentificationRequester = userIdentificationRequester;
    }

    public VCSGisUserIdentificationRequester getUserIdentificationRequester() {
        return this.userIdentificationRequester;
    }

    private int execute(VCSGisRequest request) {
        return this.execute(request, true);
    }

    private int execute(VCSGisRequest request, boolean requestCredentialIfNeed) {
        if (this.isOffline()) {
            return 10001;
        }
        VCSGisRepository repo = request.getRepository();
        block3: while (true) {
            LOGGER.info("Client " + this.getCode() + " execute '" + request.getRequestName() + "' with user '" + this.getCurrentUserCode(repo) + "' token = " + this.getAuthenticationToken(repo));
            request.cleanLastError();
            switch (request.execute()) {
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    if (!requestCredentialIfNeed || this.userIdentificationRequester == null || !this.userIdentificationRequester.requestIdentification()) break block3;
                    int r = this.authenticate(this.userIdentificationRequester.getUserId(), this.userIdentificationRequester.getPassword(), null);
                    if (r != 0) continue block3;
                    request.setAuthenticationToken(this.getAuthenticationToken(repo));
                    request.setUserCode(this.getCurrentUserCode(repo));
                    continue block3;
                }
            }
            break;
        }
        return request.getLastErrorCode();
    }

    public static boolean contains(Collection collection, Object value, Comparator comparator) {
        for (Object item : collection) {
            if (comparator.compare(item, value) != 0) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getEntityCategories() {
        String category;
        if (this.disposed) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> categories = new ArrayList<String>();
        if (this.hasRepositoryEntities()) {
            for (VCSGisEntity vCSGisEntity : this.getRepositoryEntities()) {
                category = vCSGisEntity.getCategory();
                if (!StringUtils.isNotBlank((CharSequence)category) || VCSGisWorkspaceImpl.contains(categories, category, EQUALS_IGNORECASE_COMPARATOR)) continue;
                categories.add(category);
            }
        }
        for (VCSGisEntity vCSGisEntity : this.getWorkspaceEntities()) {
            category = vCSGisEntity.getCategory();
            if (!StringUtils.isNotBlank((CharSequence)category) || VCSGisWorkspaceImpl.contains(categories, category, EQUALS_IGNORECASE_COMPARATOR)) continue;
            categories.add(category);
        }
        Collections.sort(categories);
        return Collections.unmodifiableCollection(categories);
    }

    public Collection<String> getWorkspaceEntityCategories() {
        if (this.disposed) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> categories = new ArrayList<String>();
        for (VCSGisEntity vCSGisEntity : this.getWorkspaceEntities()) {
            String category = vCSGisEntity.getCategory();
            if (!StringUtils.isNotBlank((CharSequence)category) || VCSGisWorkspaceImpl.contains(categories, category, EQUALS_IGNORECASE_COMPARATOR)) continue;
            categories.add(category);
        }
        Collections.sort(categories);
        return Collections.unmodifiableCollection(categories);
    }

    public VCSGisTopologyPlan getTopologyPlan(String topologyPlanCode) {
        if (StringUtils.isBlank((CharSequence)topologyPlanCode)) {
            return null;
        }
        TopologyplanTable topologyplanTable = new TopologyplanTable();
        return topologyplanTable.getByCode(this, topologyPlanCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int importHistory(FeatureStore sourceStore, String name, String label, String category, String attrNameForLabel, String fieldCodeName, String fieldDateName, String fieldOrderName) {
        int n;
        FeatureSet sourceFeatures;
        FeatureStore target;
        block18: {
            int n2;
            block17: {
                int editableTargetFeature2;
                block16: {
                    if (this.isOffline()) {
                        return 10001;
                    }
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    SimpleTaskStatus status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(i18n.getTranslation("_Import_history"));
                    status.setAutoremove(true);
                    status.add();
                    target = null;
                    sourceFeatures = null;
                    try {
                        VCSGisRepository repo = this.getRepository();
                        if (repo instanceof VCSGisRepositoryLocaldbImpl) {
                            ((VCSGisRepositoryLocaldbImpl)repo).setAllowAssignTheRevisionDate(true);
                        }
                        int result = this.addEntity(sourceStore.getDefaultFeatureTypeQuietly(), name, null, attrNameForLabel, category, label, null, null, null);
                        target = this.openFeatureStore(name, false);
                        FeatureQuery query = sourceStore.createFeatureQuery();
                        ExpressionBuilder expBuilder = ExpressionUtils.createExpressionBuilder();
                        query.getOrder().add(fieldDateName, true);
                        if (StringUtils.isNotBlank((CharSequence)fieldOrderName)) {
                            query.getOrder().add(fieldOrderName, true);
                        }
                        sourceFeatures = sourceStore.getFeatureSet(query);
                        target.edit(3);
                        Timestamp lastRevisionDate = null;
                        status.setRangeOfValues(0L, sourceFeatures.size64());
                        status.setCurValue(0L);
                        for (Feature sourceFeature : sourceFeatures) {
                            block20: {
                                Feature targetFeature;
                                block19: {
                                    EditableFeature editableTargetFeature2;
                                    String filter = expBuilder.eq((ExpressionBuilder.Value)expBuilder.column(fieldCodeName), (ExpressionBuilder.Value)expBuilder.constant(sourceFeature.get(fieldCodeName))).toString();
                                    targetFeature = target.findFirst(filter);
                                    if (targetFeature != null) break block19;
                                    if (lastRevisionDate == null) {
                                        lastRevisionDate = sourceFeature.getTimestamp(fieldDateName);
                                    }
                                    if (Objects.equals(lastRevisionDate, sourceFeature.getTimestamp(fieldDateName))) {
                                        editableTargetFeature2 = target.createNewFeature(sourceFeature);
                                        target.insert(editableTargetFeature2);
                                        break block20;
                                    } else {
                                        result = this.commit(lastRevisionDate, lastRevisionDate, null, null);
                                        if (result != 0) {
                                            editableTargetFeature2 = result;
                                            DisposeUtils.disposeQuietly((Disposable)sourceFeatures);
                                            break block16;
                                        }
                                        editableTargetFeature2 = target.createNewFeature(sourceFeature);
                                        target.insert(editableTargetFeature2);
                                        lastRevisionDate = sourceFeature.getTimestamp(fieldDateName);
                                    }
                                    break block20;
                                }
                                EditableFeature ef = targetFeature.getEditable();
                                ef.copyFrom(sourceFeature);
                                ef.setUpdatable(true);
                                target.update(ef);
                            }
                            status.incrementCurrentValue();
                        }
                        result = this.commit(lastRevisionDate, lastRevisionDate, null, null);
                        if (result != 0) {
                            n2 = result;
                            DisposeUtils.disposeQuietly((Disposable)sourceFeatures);
                            break block17;
                        }
                        target.finishEditing();
                        status.terminate();
                        n = 0;
                        DisposeUtils.disposeQuietly((Disposable)sourceFeatures);
                        break block18;
                    }
                    catch (Exception ex) {
                        status.abort();
                        int n3 = -1;
                        return n3;
                    }
                }
                DisposeUtils.disposeQuietly((Disposable)target);
                return editableTargetFeature2;
            }
            DisposeUtils.disposeQuietly((Disposable)target);
            return n2;
        }
        DisposeUtils.disposeQuietly((Disposable)target);
        return n;
        finally {
            DisposeUtils.disposeQuietly(sourceFeatures);
            DisposeUtils.disposeQuietly(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalChangesSelectedCount(String entityCode) {
        int n;
        DisposableFeatureSetIterable changes = null;
        try {
            int n2;
            WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
            changes = changesTable.getSelectedsByEntityCodeAsIterator(this, entityCode);
            n = n2 = (int)changes.size64();
        }
        catch (Throwable throwable) {
            DisposeUtils.disposeQuietly(changes);
            throw throwable;
        }
        DisposeUtils.disposeQuietly((Disposable)changes);
        return n;
    }

    public int revert(String nameOrCode) {
        return this.revert(nameOrCode, null);
    }

    public int revert(String nameOrCode, SimpleTaskStatus status) {
        return this.revert(nameOrCode, false, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int revert(String nameOrCode, boolean continueOnError, SimpleTaskStatus status) {
        int n;
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Commit");
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        FeatureStore entitiesStore = null;
        FeatureStore userStore = null;
        DataTransaction transaction = null;
        try {
            LOGGER.debug("===: REVERT " + this.getCode() + ", " + this.getLabel() + ", " + nameOrCode);
            transaction = DALLocator.getDataManager().createTransaction();
            transaction.begin();
            status.message("Reverting");
            EntitiesTable.EntityRow entity = this.getWorkspaceEntity(nameOrCode);
            WorkspaceChangesTable changesTable = new WorkspaceChangesTable();
            FeatureStore changesStore = null;
            DisposableFeatureSetIterable changes = changesTable.getSelectedsByEntityCodeAsIterator(this, entity.getEntityCode());
            transaction.add((Disposable)changes);
            if (!changes.isEmpty()) {
                if (!continueOnError || changes.size64() > 1L) {
                    // empty if block
                }
                userStore = this.openFeatureStore((VCSGisEntity)entity);
                this.addStoreIgnoreChanges(userStore);
                transaction.add((DataStore)userStore, userStore.getName(), true);
                userStore.edit(3);
                changesStore = this.openFeatureStore("VCSGIS_WSCHANGES", true);
                transaction.add((DataStore)changesStore, "VCSGIS_WSCHANGES", true);
                changesStore.edit(3);
                status.setCurValue(0L);
                status.setRangeOfValues(0L, changes.size64());
                for (Feature feature : changes) {
                    WorkspaceChangesTable.WorkspaceChangeRow change = new WorkspaceChangesTable.WorkspaceChangeRow(this, feature);
                    change.revert(userStore, changesStore, continueOnError);
                    status.incrementCurrentValue();
                }
                userStore.finishEditing();
                changesStore.finishEditing();
            }
            entitiesStore = this.openFeatureStore("VCSGIS_ENTITIES", true);
            transaction.add((DataStore)entitiesStore, "VCSGIS_ENTITIES");
            entitiesStore.edit(1);
            entity.updateState(transaction);
            entity.update(entitiesStore);
            entitiesStore.finishEditing();
            transaction.commit();
            this.forceReloadWorkspaceEntities();
            status.message("Revert completed");
            status.terminate();
            n = 0;
            this.removeStoreIgnoreChanges(userStore);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't revert changes.", (Throwable)ex);
            status.message("Can't revert changes");
            status.abort();
            int n2 = 700;
            return n2;
        }
        finally {
            this.removeStoreIgnoreChanges(userStore);
            DisposeUtils.disposeQuietly(transaction);
            status.pop();
        }
        DisposeUtils.disposeQuietly((Disposable)transaction);
        status.pop();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int export(String entityName, String tableName, String revisionCode, Timestamp efectiveDate, Envelope roi, SimpleTaskStatus status) {
        int n;
        VCSGisCheckoutRequest request;
        Disposable entitiesStore;
        FeatureStore target;
        block20: {
            int n2;
            block19: {
                int n3;
                block18: {
                    target = null;
                    entitiesStore = null;
                    int errcode = 0;
                    request = null;
                    if (status == null) {
                        status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("_Export");
                        status.setAutoremove(true);
                        status.add();
                    } else {
                        status.push();
                    }
                    try {
                        LOGGER.debug("===: EXPORT " + this.getCode() + ", '" + this.getLabel() + "', " + tableName);
                        status.message("Preparing export");
                        VCSGisEntity lentity = this.getEntity(entityName);
                        if (lentity == null) {
                            status.message("Table " + tableName + " not exists");
                            status.abort();
                            n3 = 240;
                            DisposeUtils.disposeQuietly((Disposable)request);
                            if (target != null) {
                                this.removeStoreIgnoreChanges(target);
                            }
                            break block18;
                        }
                        this.updateEntitiesFromRepository(status);
                        VCSGisRepository repo = this.getRepository(lentity);
                        request = repo.createCheckoutRequest(entityName);
                        request.setAuthenticationToken(this.getAuthenticationToken(repo));
                        request.setUserCode(this.getCurrentUserCode(repo));
                        request.setEfectiveDate(efectiveDate);
                        request.setRevisionCode(revisionCode);
                        request.setROI(roi);
                        status.message("Executing export request for " + tableName);
                        if (this.execute((VCSGisRequest)request) != 0) {
                            status.message("Can't export " + tableName + " (error " + request.getLastErrorCode() + ")");
                            status.abort();
                            n2 = request.getLastErrorCode();
                            DisposeUtils.disposeQuietly((Disposable)request);
                            break block19;
                        }
                        status.message("Updating " + tableName + " metadata");
                        status.message("Creating table " + tableName);
                        this.create_table(lentity, tableName);
                        status.message("Adding features in " + tableName);
                        errcode = 400;
                        target = this.openFeatureStore(tableName, false);
                        this.addStoreIgnoreChanges(target);
                        DisposableIterable data = request.getData();
                        status.setCurValue(0L);
                        errcode = 420;
                        target.edit(2);
                        FilteredLogger log = new FilteredLogger(LOGGER, "checkout", 100);
                        for (VCSGisRepositoryData d : data) {
                            JsonObject json = d.getDataAsJson();
                            if (json == null) {
                                log.warn("A feature (VCSGISCODE=" + d.getFeatureRelatedCode() + ") has been retrieved with the DAT_DATA field set to null.");
                            } else {
                                EditableFeature f = target.createNewFeature(json);
                                target.insert(f);
                            }
                            status.incrementCurrentValue();
                        }
                        target.finishEditing();
                        status.message("Updating " + tableName + " metadata");
                        request.dispose();
                        status.message("Export completed");
                        status.terminate();
                        n = 0;
                        DisposeUtils.disposeQuietly((Disposable)request);
                        break block20;
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't export.", (Throwable)ex);
                        status.message("Can't export");
                        status.abort();
                        FeatureStore.cancelEditingQuietly(target);
                        FeatureStore.cancelEditingQuietly(entitiesStore);
                        int n4 = errcode;
                        return n4;
                    }
                }
                DisposeUtils.disposeQuietly(target);
                DisposeUtils.disposeQuietly(entitiesStore);
                status.pop();
                return n3;
            }
            if (target != null) {
                this.removeStoreIgnoreChanges(target);
            }
            DisposeUtils.disposeQuietly(target);
            DisposeUtils.disposeQuietly(entitiesStore);
            status.pop();
            return n2;
        }
        if (target != null) {
            this.removeStoreIgnoreChanges(target);
        }
        DisposeUtils.disposeQuietly((Disposable)target);
        DisposeUtils.disposeQuietly(entitiesStore);
        status.pop();
        return n;
        finally {
            DisposeUtils.disposeQuietly(request);
            if (target != null) {
                this.removeStoreIgnoreChanges(target);
            }
            DisposeUtils.disposeQuietly(target);
            DisposeUtils.disposeQuietly(entitiesStore);
            status.pop();
        }
    }

    public List<String> getDataModels() {
        return this.getRepositoryDataModels();
    }

    public List<String> getRepositoryDataModels() {
        List<VCSGisEntity> rEntities = this.getRepositoryEntities();
        HashSet dataModels = new HashSet();
        for (VCSGisEntity entity : rEntities) {
            List dataModelsEntity = entity.getDataModelsAsList();
            dataModels.addAll(dataModelsEntity);
        }
        ArrayList<String> list = new ArrayList<String>(dataModels);
        Collections.sort(list);
        return list;
    }

    public List<String> getWorkspaceDataModels() {
        List<VCSGisWorkspaceEntity> entities = this.getWorkspaceEntities();
        HashSet dataModels = new HashSet();
        for (VCSGisEntity vCSGisEntity : entities) {
            List dataModelsEntity = vCSGisEntity.getDataModelsAsList();
            dataModels.addAll(dataModelsEntity);
        }
        ArrayList<String> list = new ArrayList<String>(dataModels);
        Collections.sort(list);
        return list;
    }

    public void logout() {
        VarsTable varsTable = new VarsTable();
        varsTable.delete(this, CONFIG_USER_NAME);
        varsTable.delete(this, CONFIG_AUTHENTICATIONTOKEN_NAME);
        this.currentUserCodes = null;
        this.authenticationTokens = null;
        ToolsLocator.getIdentityManager().logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEditMode(VCSGisEntity entity) {
        FeatureStore userStore = null;
        try {
            userStore = this.openFeatureStore(entity);
            if (userStore == null) {
                int n = -1;
                return n;
            }
            int n = FeatureStoreObserver.getEditMode(userStore);
            return n;
        }
        finally {
            DisposeUtils.dispose((Disposable)userStore);
        }
    }

    public boolean isOutOfDate(FeatureStore store, Feature feature) {
        if (this.isOffline()) {
            return false;
        }
        String tableName = store.getName();
        EntitiesTable.EntityRow lentity = this.getWorkspaceEntityByName(tableName);
        if (lentity == null) {
            throw new IllegalArgumentException("Table '" + tableName + "' not in workspace.");
        }
        String recordCode = feature.getString(lentity.getFeatureIdFieldName());
        return this.isOutOfDate(lentity, recordCode);
    }

    public boolean isOutOfDate(String tableName, String recordCode) {
        if (this.isOffline()) {
            return false;
        }
        EntitiesTable.EntityRow lentity = this.getWorkspaceEntityByName(tableName);
        if (lentity == null) {
            throw new IllegalArgumentException("Table '" + tableName + "' not in workspace.");
        }
        return this.isOutOfDate(lentity, recordCode);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOutOfDate(VCSGisWorkspaceEntity entity, String recordCode) {
        if (this.isOffline()) {
            return false;
        }
        if (entity == null) {
            throw new IllegalArgumentException("Entity can be null");
        }
        if (StringUtils.isBlank((CharSequence)recordCode)) {
            throw new IllegalArgumentException("Record code can be blank");
        }
        if (!StringUtils.containsOnly((CharSequence)recordCode, (String)"0123456789abcdefABCDEF_")) {
            throw new IllegalArgumentException("Record code is not valid");
        }
        request = null;
        try {
            repo = this.getRepository((VCSGisEntity)entity);
            request = repo.createRowIsOutofdatedRequest(entity.getEntityName(), entity.getLocalRevisionCode(), recordCode);
            request.setAuthenticationToken(this.getAuthenticationToken(repo));
            request.setUserCode(this.getCurrentUserCode(repo));
            if (this.execute((VCSGisRequest)request) == 0) ** GOTO lbl31
            if (request.getLastErrorCode() == 35) {
                var5_7 = false;
            }
            ** GOTO lbl-1000
        }
        catch (VCSGisRuntimeException ex) {
            try {
                throw ex;
                catch (Exception ex) {
                    throw new RuntimeException("Can't check if record '" + recordCode + "' of table '" + entity.getEntityName() + "' is out of date.", ex);
                }
            }
            catch (Throwable var6_9) {
                DisposeUtils.disposeQuietly(request);
                throw var6_9;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)request);
        return var5_7;
lbl-1000:
        // 1 sources

        {
            throw new VCSGisRuntimeException(request.getLastErrorCode(), request.getLastErrorMessage());
lbl31:
            // 1 sources

            var5_8 = request.isOutdated();
        }
        DisposeUtils.disposeQuietly((Disposable)request);
        return var5_8;
    }

    public String getCurrentUserCode() {
        return this.getCurrentUserCode(this.getRepository());
    }

    public VCSGisUser getCurrentUser() {
        String userCode = this.getCurrentUserCode(this.getRepository());
        return this.getUser(userCode);
    }

    public boolean isValidUserCode(String code) {
        return StringUtils.containsOnly((CharSequence)code, (String)"0123456789abcdefABCDEF_");
    }

    public boolean isTheRepositoryLocal() {
        VCSGisRepository repo = this.getRepository();
        return repo instanceof VCSGisRepositoryLocaldbImpl;
    }

    public boolean setAllowAssignTheRevisionDate(boolean allow) {
        VCSGisRepository repo = this.getRepository();
        if (repo instanceof VCSGisRepositoryLocaldbImpl) {
            ((VCSGisRepositoryLocaldbImpl)repo).setAllowAssignTheRevisionDate(true);
            return true;
        }
        return false;
    }

    public void registerDataModelRepository(String modelName) {
        DataManager dataManager = DALLocator.getDataManager();
        String modelResources = null;
        DatabaseStoresRepository modelRepository = null;
        for (VCSGisEntity vCSGisEntity : this.getWorkspaceEntities()) {
            List entityModels = vCSGisEntity.getDataModelsAsList();
            if (!entityModels.contains(modelName)) continue;
            if (modelRepository == null) {
                modelRepository = dataManager.createDatabaseStoresRepository(modelName, this.getLabel(), (DataServerExplorerParameters)this.getExplorerParameters());
                modelRepository.setProperty("VCSGISModel", (Object)true);
                modelRepository.setProperty("VCSGISLocalUrl", (Object)this.getExplorerParameters().getUrl());
            }
            OpenDataStoreParameters params = this.createOpenStoreParameters(vCSGisEntity.getEntityName());
            if (modelResources == null && StringUtils.isNotBlank((CharSequence)vCSGisEntity.getResources())) {
                modelResources = vCSGisEntity.getResources();
            }
            modelRepository.add(vCSGisEntity.getEntityName(), (DataStoreParameters)params, vCSGisEntity.getLabelOrName());
        }
        if (modelRepository == null) {
            return;
        }
        StoresRepository globalRepository = dataManager.getStoresRepository();
        globalRepository.addRepository(modelRepository);
        if (StringUtils.isNotBlank(modelResources)) {
            try {
                JDBCServerExplorer jDBCServerExplorer = this.getExplorer();
                jDBCServerExplorer.setCustomResources(modelName, modelResources, true);
            }
            catch (Throwable throwable) {
                LOGGER.warn("Can't register resources for model '" + modelName + "' (resources=" + modelResources + ").", throwable);
            }
        }
        this.callModel(modelName, "onConnect", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object callModel(String modelName, String functionName, Object[] args) {
        ResourcesStorage modelResourcesStorge;
        block4: {
            Object object;
            modelResourcesStorge = null;
            try {
                JDBCServerExplorer explorer = this.getExplorer();
                modelResourcesStorge = explorer.getResourcesStorage(modelName);
                Script script = ExpressionUtils.getScript((ResourcesStorage)modelResourcesStorge, (String)"modelsc");
                if (script == null) break block4;
                object = script.invokeFunction(functionName, args);
            }
            catch (Throwable t) {
                try {
                    LOGGER.warn("Can't call '" + functionName + "' for model '" + modelName + "'.", t);
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(modelResourcesStorge);
                    throw throwable;
                }
                DisposeUtils.disposeQuietly((Disposable)modelResourcesStorge);
            }
            DisposeUtils.disposeQuietly((Disposable)modelResourcesStorge);
            return object;
        }
        DisposeUtils.disposeQuietly((Disposable)modelResourcesStorge);
        return null;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public String getEntityLabelTemplate() {
        return this.entityLabelTemplate;
    }

    public String formatEntityLabel(VCSGisEntity entity) {
        String s = VCSGisUtils.getFormatedLabel(entity, this.entityLabelTemplate);
        if (s == null) {
            s = entity.getLabelOrName();
        }
        return s;
    }

    public boolean useSafeMode() {
        return this.safeMode;
    }

    public boolean isAResourceTable(String entityName) {
        if (StringUtils.isBlank((CharSequence)entityName)) {
            return false;
        }
        try {
            List<VCSGisWorkspaceEntity> entities = this.getWorkspaceEntities();
            if (entities == null) {
                return false;
            }
            for (VCSGisWorkspaceEntity entity : entities) {
                if (entity == null || !StringUtils.equalsIgnoreCase((CharSequence)entityName, (CharSequence)entity.getResources())) continue;
                return true;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Problems checking is '" + entityName + "' is a resorces table.", t);
        }
        return false;
    }

    public boolean isCorrupt(VCSGisEntity entity, FeatureStore store, int level) {
        return this.isCorrupt(entity, store, level, true);
    }

    public boolean isCorrupt(VCSGisEntity entity, FeatureStore store, int level, boolean saveToDisk) {
        if (!(entity instanceof VCSGisWorkspaceEntity)) {
            return true;
        }
        VCSGisWorkspaceEntity lentity = (VCSGisWorkspaceEntity)entity;
        int stateMask = lentity.getState();
        if ((stateMask & 0x100) == 256) {
            return true;
        }
        if ((stateMask & 0x80) == 128) {
            return false;
        }
        boolean corrupt = false;
        FeatureType storeft = store.getDefaultFeatureTypeQuietly();
        if (storeft.get(entity.getFeatureIdFieldName()) == null) {
            corrupt = true;
        }
        if (corrupt) {
            LOGGER.warn("The table or entity '" + entity.getEntityName() + "' is corrupt. Missing requiered field '" + entity.getFeatureIdFieldName() + "'.");
            if (entity instanceof EntitiesTable.EntityRow) {
                EntitiesTable.EntityRow rowEntity = (EntitiesTable.EntityRow)entity;
                try {
                    if ((stateMask & 0x180) != 384) {
                        rowEntity.setState(384);
                        if (saveToDisk) {
                            rowEntity.update();
                        }
                    }
                }
                catch (Throwable t) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Can't mark as disconected the entity '" + entity.getEntityName() + "'.", t);
                    }
                    LOGGER.warn("Can't mark as disconected the entity '" + entity.getEntityName() + "'.");
                }
            }
        }
        return corrupt;
    }

    public List<String> getWorkspaceResourcesTableNames() {
        List<VCSGisWorkspaceEntity> entities = this.getWorkspaceEntities();
        HashSet<String> resourceNames = new HashSet<String>();
        for (VCSGisEntity vCSGisEntity : entities) {
            String resources;
            if (vCSGisEntity == null || StringUtils.isBlank((CharSequence)(resources = vCSGisEntity.getResources()))) continue;
            resourceNames.add(resources);
        }
        if (resourceNames.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>(resourceNames);
        Collections.sort(list);
        return list;
    }

    private VCSGisRepository getRepository(VCSGisEntity entity) {
        if (entity != null && entity.isLinkedTable()) {
            return entity.getLinkedRepository();
        }
        return this.getRepository();
    }

    private String getAuthenticationToken(VCSGisRepository repository) {
        if (this.authenticationTokens == null) {
            return null;
        }
        String repocode = repository == null ? this.getRepository().getCode() : repository.getCode();
        return this.authenticationTokens.get(repocode);
    }

    private void setAuthenticationToken(VCSGisRepository repository, String token) {
        String repocode = repository == null ? this.getRepository().getCode() : repository.getCode();
        if (this.authenticationTokens == null) {
            this.authenticationTokens = new HashMap<String, String>();
        }
        this.authenticationTokens.put(repocode, token);
    }

    private String getCurrentUserCode(VCSGisRepository repository) {
        if (this.currentUserCodes == null) {
            return null;
        }
        String repocode = repository == null ? this.getRepository().getCode() : repository.getCode();
        return this.currentUserCodes.get(repocode);
    }

    private void setCurrentUserCode(VCSGisRepository repository, String userCode) {
        String repocode = repository == null ? this.getRepository().getCode() : repository.getCode();
        if (this.currentUserCodes == null) {
            this.currentUserCodes = new HashMap<String, String>();
        }
        this.currentUserCodes.put(repocode, userCode);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<VCSGisRepositoryLogData> log(String tableName, String featureRelatedCode, SimpleTaskStatus status) {
        AbstractList<VCSGisRepositoryLogData> abstractList;
        if (this.isOffline()) {
            return Collections.EMPTY_LIST;
        }
        LOGGER.debug("===: LOG: " + tableName + "/" + featureRelatedCode + " WS " + this.getCode() + ", '" + this.getLabel() + "'");
        if (status == null) {
            status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("Log " + tableName + "/" + featureRelatedCode);
            status.setAutoremove(true);
            status.add();
        } else {
            status.push();
        }
        FeatureStore logsStore = null;
        VCSGisLogRequest request = null;
        DisposableIterable logsChanges = null;
        DataTransaction transaction = null;
        LogsTable logsTable = new LogsTable();
        try {
            if (status.isCancellationRequested()) {
                throw new UserCancelledException();
            }
            this.updateEntitiesFromRepository(status);
            EntitiesTable.EntityRow lentity = this.getWorkspaceEntityByName(tableName);
            if (lentity == null) {
                status.message("Can't get log, table" + tableName + ", don't exists.");
                status.abort();
                throw new RuntimeException("Table " + tableName + ", don't exists");
            }
            transaction = DALLocator.getDataManager().createTransaction();
            transaction.begin();
            transaction.add((DataServerExplorer)this.getExplorer(), false);
            status.message("Preparing log");
            VCSGisRepository repo = this.getRepository((VCSGisEntity)lentity);
            request = repo.createLogRequest(tableName);
            transaction.add((Disposable)request);
            request.setAuthenticationToken(this.getAuthenticationToken(repo));
            request.setUserCode(this.getCurrentUserCode(repo));
            request.setFeatureRelatedCode(featureRelatedCode);
            status.message("Executing log request");
            if (this.execute((VCSGisRequest)request) != 0) {
                status.message("Can't log " + tableName + " (error " + request.getLastErrorCode() + ")");
                status.abort();
                throw new RuntimeException("Error " + request.getLastErrorCode() + ", " + request.getLastErrorMessage());
            }
            if (status.isCancellationRequested()) {
                throw new UserCancelledException();
            }
            String entityCode = lentity.getCode();
            status.message("Preparing remote changes container in working-copy");
            logsStore = this.openFeatureStore("VCSGIS_LOGS", true);
            transaction.add((DataStore)logsStore);
            logsStore.edit(3);
            status.message("Deleting previous temporary remote changes");
            LOGGER.debug("===: LOG: Delete updates table in working-copy");
            logsTable.delete(this, featureRelatedCode);
            logsStore.finishEditing();
            logsStore.edit(2);
            logsChanges = request.getData();
            transaction.add((Disposable)logsChanges);
            status.setCurValue(0L);
            LOGGER.debug("===: LOG: Inserting log (repo->working-copy)");
            status.message("Downloading list of remote changes");
            for (VCSGisRepositoryLogData log : logsChanges) {
                if (status.isCancellationRequested()) {
                    throw new UserCancelledException();
                }
                LogsTable.LogRow logRow = new LogsTable.LogRow(this);
                logRow.fromJson(log.toJson());
                logRow.newCode();
                logRow.insert(logsStore);
                status.incrementCurrentValue();
            }
            LOGGER.debug("===: LOG: finish inserting updates");
            logsStore.finishEditing();
            transaction.commit();
            final GetItemWithSize64<Feature> logsAsFeatures = logsTable.getByEntityCode(this, featureRelatedCode);
            AbstractList<VCSGisRepositoryLogData> logs = new AbstractList<VCSGisRepositoryLogData>(){

                @Override
                public VCSGisRepositoryLogData get(int index) {
                    Feature feature = (Feature)logsAsFeatures.get64((long)index);
                    VCSGisRepositoryLogDataImpl row = new VCSGisRepositoryLogDataImpl(feature);
                    return row;
                }

                @Override
                public int size() {
                    return (int)logsAsFeatures.size64();
                }
            };
            status.message("Log-prepare completed");
            status.terminate();
            abstractList = logs;
        }
        catch (UserCancelledException ex) {
            try {
                LOGGER.warn("User cancelled.", (Throwable)ex);
                status.message("User cancelled");
                status.cancel();
                DataTransaction.rollbackQuietly(transaction);
                throw ex;
                catch (Exception ex2) {
                    LOGGER.warn("Can't get log.", (Throwable)ex2);
                    status.message("Can't get log");
                    status.abort();
                    DataTransaction.rollbackQuietly(transaction);
                    throw new RuntimeException(ex2);
                }
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(transaction);
                status.pop();
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)transaction);
        status.pop();
        return abstractList;
    }

    private void removeLocalDeleteIfExists(String relatedFeatureCode, FeatureStore changesStore) {
        try {
            changesStore.delete("\"WSCH_FEATURECODE\" = '" + relatedFeatureCode + "' AND " + "\"" + "WSCH_OPERATION" + "\" = " + 0);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't delete local-delete if exists", e);
        }
    }

    public void setConfigValue(String name, String value) {
        VarsTable varsTable = new VarsTable();
        varsTable.set(this, name, value);
    }

    private static class GetItemWithSize64Disposable
    extends AbstractDisposable
    implements GetItemWithSize64<VCSGisRevision> {
        private final VCSGisWorkspace workspace;
        private final GetItemWithSizeAndIterator64<Feature> revisionsf;

        public GetItemWithSize64Disposable(VCSGisWorkspace workspace, GetItemWithSizeAndIterator64<Feature> revisionsf) {
            this.workspace = workspace;
            this.revisionsf = revisionsf;
            DisposeUtils.bind((Disposable)workspace);
            DisposeUtils.bind(revisionsf);
        }

        protected void doDispose() throws BaseException {
            DisposeUtils.disposeQuietly((Disposable)this.workspace);
            DisposeUtils.disposeQuietly(this.revisionsf);
        }

        public long size64() {
            return this.revisionsf.size64();
        }

        public VCSGisRevision get64(long position) {
            Feature f = (Feature)this.revisionsf.get64(position);
            LocalRevisionsTable.LocalRevisionRow revision = new LocalRevisionsTable.LocalRevisionRow(this.workspace, f);
            return revision;
        }
    }

    private static class SafeUpdateChangeListener
    implements VCSGisWorkspace.UpdateChangeListener {
        private final VCSGisWorkspace.UpdateChangeListener delegate;

        public SafeUpdateChangeListener(VCSGisWorkspace.UpdateChangeListener delegate) {
            this.delegate = delegate;
        }

        public void afterUpdate(VCSGisEntity entity, Feature oldFeature, Feature newFeature) {
            if (this.delegate == null) {
                return;
            }
            try {
                this.delegate.afterUpdate(entity, oldFeature, newFeature);
            }
            catch (Throwable t) {
                LOGGER.debug("Can't notify the feature update", t);
            }
        }

        public void afterInsert(VCSGisEntity entity, Feature feature) {
            if (this.delegate == null) {
                return;
            }
            try {
                this.delegate.afterInsert(entity, feature);
            }
            catch (Throwable t) {
                LOGGER.debug("Can't notify the feature insertion", t);
            }
        }

        public void beforeDelete(VCSGisEntity entity, FeatureStore store, String filter, String code) {
            if (this.delegate == null) {
                return;
            }
            try {
                this.delegate.beforeDelete(entity, store, filter, code);
            }
            catch (Throwable t) {
                LOGGER.debug("Can't notify the deletion of the feature", t);
            }
        }
    }
}

