/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.workspace.tables;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.tables.AbstractTable;

public class VarsTable
extends AbstractTable {
    public static final String TABLE_NAME = "VCSGIS_CONFIG";
    private static final String COD_CONFIG = "COD_CONFIG";
    private static final String VAR_NAME = "CFG_NAME";
    private static final String VAR_VALUE = "CFG_VALUE";

    public VarsTable() {
        super(TABLE_NAME, VarsTable.featureType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(VCSGisWorkspace workspace, String name) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            Feature f = store.findFirst("\"CFG_NAME\"='" + name + "'");
            if (f == null) {
                String string = null;
                return string;
            }
            String string = f.getString(VAR_VALUE);
            return string;
        }
        catch (Exception ex) {
            String string = null;
            return string;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getVars(VCSGisWorkspace workspace, String ... names) {
        HashMap<String, String> hashMap;
        FeatureStore store = null;
        FeatureSet set = null;
        HashMap<String, String> vars = new HashMap<String, String>();
        try {
            ExpressionBuilder filter = ExpressionUtils.createExpressionBuilder();
            for (DisposableIterator name : names) {
                filter.or((ExpressionBuilder.Value)filter.eq((ExpressionBuilder.Value)filter.variable(VAR_NAME), (ExpressionBuilder.Value)filter.constant((Object)name)));
            }
            store = workspace.getFeatureStore(TABLE_NAME);
            set = store.getFeatureSet(filter.build());
            for (Feature feature : set) {
                vars.put(feature.getString(VAR_NAME), feature.getString(VAR_VALUE));
            }
            hashMap = vars;
            DisposeUtils.disposeQuietly((Disposable)set);
        }
        catch (Exception ex) {
            Map<String, String> map = null;
            return map;
        }
        finally {
            DisposeUtils.disposeQuietly(set);
            DisposeUtils.disposeQuietly(store);
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(VCSGisWorkspace workspace, String name, String value) {
        FeatureStore store = null;
        try {
            store = workspace.openFeatureStore(TABLE_NAME, false);
            Feature f = store.findFirst("\"CFG_NAME\"='" + name + "'");
            if (f == null) {
                store.edit(2);
                EditableFeature ef = store.createNewFeature();
                ef.set(VAR_NAME, (Object)name);
                ef.set(VAR_VALUE, (Object)value);
                store.insert(ef);
                store.finishEditing();
            } else {
                EditableFeature ef = f.getEditable();
                ef.set(VAR_VALUE, (Object)value);
                store.edit();
                store.update(ef);
                store.finishEditing();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't store value for '" + name + "'.", (Throwable)ex);
        }
        finally {
            if (store != null && (store.isAppending() || store.isEditing())) {
                store.cancelEditingQuietly();
            }
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(VCSGisWorkspace workspace, String name) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            store.edit(1);
            store.delete("\"CFG_NAME\"='" + name + "'");
            store.finishEditing();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't delete value for '" + name + "'.", (Throwable)ex);
        }
        finally {
            if (store != null && (store.isAppending() || store.isEditing())) {
                store.cancelEditingQuietly();
            }
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS Config");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.add(COD_CONFIG, 8).setTag("dynform.readonly", (Object)true).setSize(60).setIsPrimaryKey(true).setLabel("Code").setReadOnly(false).setDefaultFieldValue((Object)"<%=replace(UUID(),'-','')%>").setHidden(true);
        ft.add(VAR_NAME, 8).setSize(100).setIsIndexed(true).setAllowIndexDuplicateds(false).setLabel("Name");
        ft.add(VAR_VALUE, 8).setSize(4096).setLabel("Value");
        return ft.getNotEditableCopy();
    }

    public static class VarRow
    extends AbstractTable.AbstractRow {
        public VarRow(VCSGisWorkspace workspace) {
            super(workspace, VarsTable.TABLE_NAME, VarsTable.VAR_NAME);
        }

        public VarRow(VCSGisWorkspace workspace, Feature feature) {
            super(workspace, VarsTable.TABLE_NAME, VarsTable.VAR_NAME, feature);
        }

        public String getName() {
            return this.getString(VarsTable.VAR_NAME);
        }

        public String getValue() {
            return this.getString(VarsTable.VAR_VALUE);
        }

        public void setName(String name) {
            this.set(VarsTable.VAR_NAME, name);
        }

        public void setValue(String value) {
            this.set(VarsTable.VAR_VALUE, value);
        }
    }
}

