/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.htmlbuilder.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.htmlbuilder.HTMLBuilder;

public class DefaultHTMLBuilder
implements HTMLBuilder {
    public HTMLBuilder.HTMLElement custom(String value) {
        return new CustomHTMLElement(value);
    }

    public HTMLBuilder.HTMLElement plain(String value) {
        return new CustomHTMLElement(StringEscapeUtils.escapeHtml4((String)value));
    }

    public HTMLBuilder.HTMLElement plainWithNl(String value) {
        return new CustomHTMLElement(StringEscapeUtils.escapeHtml4((String)value).replace("\n", "<br>\n"));
    }

    public HTMLBuilder.HTMLElement contents(HTMLBuilder.HTMLElement ... values) {
        return new ContentsHTMLElement().contents(values);
    }

    public HTMLBuilder.HTMLColor color(Color color) {
        return new DefaultHTMLColor(color);
    }

    public HTMLBuilder.HTMLColor color(int r, int g, int b) {
        return new DefaultHTMLColor(r, g, b);
    }

    public HTMLBuilder.HTMLColor color(String color) {
        return new DefaultHTMLColor(color);
    }

    public HTMLBuilder.HTMLComplexElement a(String link, Object ... contents) {
        return new DefaultHTMLElement("a", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement a(Object ... contents) {
        return new DefaultHTMLElement("a", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement abbr(Object ... contents) {
        return new DefaultHTMLElement("abbr", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement acronym(Object ... contents) {
        return new DefaultHTMLElement("acronym", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement address(Object ... contents) {
        return new DefaultHTMLElement("address", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement area(Object ... contents) {
        return new DefaultHTMLElement("area", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement article(Object ... contents) {
        return new DefaultHTMLElement("article", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement aside(Object ... contents) {
        return new DefaultHTMLElement("aside", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement b(Object ... contents) {
        return new DefaultHTMLElement("b", true, true, contents);
    }

    public HTMLBuilder.HTMLElementWithAttributes base() {
        return new DefaultHTMLElement("base", false, true, new Object[0]);
    }

    public HTMLBuilder.HTMLElementWithAttributes basefont() {
        return new DefaultHTMLElement("basefont", false, true, new Object[0]);
    }

    public HTMLBuilder.HTMLComplexElement bdi(Object ... contents) {
        return new DefaultHTMLElement("bdi", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement bdo(Object ... contents) {
        return new DefaultHTMLElement("bdo", true, true, contents);
    }

    @Deprecated
    public HTMLBuilder.HTMLElementWithContents big(Object ... contents) {
        return new DefaultHTMLElement("big", true, false, contents);
    }

    public HTMLBuilder.HTMLComplexElement blockquote(Object ... contents) {
        return new DefaultHTMLElement("blockquote", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement body(Object ... contents) {
        return new DefaultHTMLElement("body", true, true, contents);
    }

    public HTMLBuilder.HTMLElement br() {
        return new DefaultHTMLElement("br", false, false, new Object[0]);
    }

    public HTMLBuilder.HTMLComplexElement button(Object ... contents) {
        return new DefaultHTMLElement("button", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement canvas(Object ... contents) {
        return new DefaultHTMLElement("canvas", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement caption(Object ... contents) {
        return new DefaultHTMLElement("caption", true, true, contents);
    }

    @Deprecated
    public HTMLBuilder.HTMLElementWithContents center(Object ... contents) {
        return new DefaultHTMLElement("center", true, false, contents);
    }

    public HTMLBuilder.HTMLComplexElement cite(Object ... contents) {
        return new DefaultHTMLElement("cite", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement code(Object ... contents) {
        return new DefaultHTMLElement("code", true, true, contents);
    }

    public HTMLBuilder.HTMLElementWithAttributes col() {
        return new DefaultHTMLElement("col", false, true, new Object[0]);
    }

    public HTMLBuilder.HTMLComplexElement colgroup(Object ... contents) {
        return new DefaultHTMLElement("colgroup", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement data(Object ... contents) {
        return new DefaultHTMLElement("data", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement datalist(Object ... contents) {
        return new DefaultHTMLElement("datalist", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement dd(Object ... contents) {
        return new DefaultHTMLElement("dd", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement del(Object ... contents) {
        return new DefaultHTMLElement("del", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement details(Object ... contents) {
        return new DefaultHTMLElement("details", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement dfn(Object ... contents) {
        return new DefaultHTMLElement("dfn", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement dialog(Object ... contents) {
        return new DefaultHTMLElement("dialog", true, true, contents);
    }

    public HTMLBuilder.HTMLElementWithContents dir(Object ... contents) {
        return new DefaultHTMLElement("dir", true, false, contents);
    }

    public HTMLBuilder.HTMLComplexElement div(Object ... contents) {
        return new DefaultHTMLElement("div", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement dl(Object ... contents) {
        return new DefaultHTMLElement("dl", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement dt(Object ... contents) {
        return new DefaultHTMLElement("dt", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement em(Object ... contents) {
        return new DefaultHTMLElement("em", true, true, contents);
    }

    public HTMLBuilder.HTMLElementWithAttributes embed() {
        return new DefaultHTMLElement("embed", false, true, new Object[0]);
    }

    public HTMLBuilder.HTMLComplexElement fieldset(Object ... contents) {
        return new DefaultHTMLElement("fieldset", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement figcaption(Object ... contents) {
        return new DefaultHTMLElement("figcaption", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement figure(Object ... contents) {
        return new DefaultHTMLElement("figure", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement font(Object ... contents) {
        return new DefaultHTMLElement("font", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement font(int size, HTMLBuilder.HTMLColor color) {
        return this.font(new Object[0]).set("size", size).set("color", color);
    }

    public HTMLBuilder.HTMLComplexElement font(int size, HTMLBuilder.HTMLColor color, String face, Object ... contents) {
        return this.font(size, color).set("face", face);
    }

    public HTMLBuilder.HTMLComplexElement footer(Object ... contents) {
        return new DefaultHTMLElement("footer", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement form(Object ... contents) {
        return new DefaultHTMLElement("form", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement frame(Object ... contents) {
        return new DefaultHTMLElement("frame", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement frameset(Object ... contents) {
        return new DefaultHTMLElement("frameset", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement h1(Object ... contents) {
        return new DefaultHTMLElement("h1", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement h2(Object ... contents) {
        return new DefaultHTMLElement("h2", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement h3(Object ... contents) {
        return new DefaultHTMLElement("h3", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement h4(Object ... contents) {
        return new DefaultHTMLElement("h4", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement h5(Object ... contents) {
        return new DefaultHTMLElement("h5", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement h6(Object ... contents) {
        return new DefaultHTMLElement("h6", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement head(Object ... contents) {
        return new DefaultHTMLElement("head", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement header(Object ... contents) {
        return new DefaultHTMLElement("header", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement hr(Object ... contents) {
        return new DefaultHTMLElement("hr", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement html(Object ... contents) {
        return new DefaultHTMLElement("html", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement i(Object ... contents) {
        return new DefaultHTMLElement("i", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement iframe(Object ... contents) {
        return new DefaultHTMLElement("iframe", true, true, contents);
    }

    public HTMLBuilder.HTMLElementWithAttributes img() {
        return new DefaultHTMLElement("img", false, true, new Object[0]);
    }

    public HTMLBuilder.HTMLElementWithAttributes input(Object ... contents) {
        return new DefaultHTMLElement("input", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement ins(Object ... contents) {
        return new DefaultHTMLElement("ins", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement kbd(Object ... contents) {
        return new DefaultHTMLElement("kbd", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement label(Object ... contents) {
        return new DefaultHTMLElement("label", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement legend(Object ... contents) {
        return new DefaultHTMLElement("legend", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement li(Object ... contents) {
        return new DefaultHTMLElement("li", true, true, contents);
    }

    public HTMLBuilder.HTMLElementWithAttributes link() {
        return new DefaultHTMLElement("ins", false, true, new Object[0]);
    }

    public HTMLBuilder.HTMLElementWithAttributes link(String rel, String type, String href) {
        return this.link().set("rel", rel).set("type", type).set("href", href);
    }

    public HTMLBuilder.HTMLComplexElement main(Object ... contents) {
        return new DefaultHTMLElement("main", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement map(Object ... contents) {
        return new DefaultHTMLElement("map", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement mark(Object ... contents) {
        return new DefaultHTMLElement("mark", true, true, contents);
    }

    public HTMLBuilder.HTMLElementWithAttributes meta() {
        return new DefaultHTMLElement("meta", false, true, new Object[0]);
    }

    public HTMLBuilder.HTMLElementWithAttributes meta(String charset) {
        return this.mark(new Object[0]).set("charset", charset);
    }

    public HTMLBuilder.HTMLElementWithAttributes meta(String name, String content) {
        return this.mark(new Object[0]).set("name", name).set("content", content);
    }

    public HTMLBuilder.HTMLComplexElement meter(Object ... contents) {
        return new DefaultHTMLElement("meter", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement nav(Object ... contents) {
        return new DefaultHTMLElement("nav", true, true, contents);
    }

    public HTMLBuilder.HTMLElementWithContents noframes(Object ... contents) {
        return new DefaultHTMLElement("noframes", true, false, contents);
    }

    public HTMLBuilder.HTMLElementWithContents noscript(Object ... contents) {
        return new DefaultHTMLElement("noscript", true, false, contents);
    }

    public HTMLBuilder.HTMLComplexElement object(Object ... contents) {
        return new DefaultHTMLElement("object", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement ol(Object ... contents) {
        return new DefaultHTMLElement("ol", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement optgroup(Object ... contents) {
        return new DefaultHTMLElement("optgroup", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement option(Object ... contents) {
        return new DefaultHTMLElement("option", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement output(Object ... contents) {
        return new DefaultHTMLElement("output", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement p(Object ... contents) {
        return new DefaultHTMLElement("p", true, true, contents);
    }

    public HTMLBuilder.HTMLElementWithAttributes param() {
        return new DefaultHTMLElement("param", false, true, new Object[0]);
    }

    public HTMLBuilder.HTMLComplexElement pre(Object ... contents) {
        return new DefaultHTMLElement("pre", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement progress(Object ... contents) {
        return new DefaultHTMLElement("progress", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement q(Object ... contents) {
        return new DefaultHTMLElement("q", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement rp(Object ... contents) {
        return new DefaultHTMLElement("rp", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement rt(Object ... contents) {
        return new DefaultHTMLElement("rt", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement ruby(Object ... contents) {
        return new DefaultHTMLElement("ruby", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement s(Object ... contents) {
        return new DefaultHTMLElement("s", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement samp(Object ... contents) {
        return new DefaultHTMLElement("samp", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement script(Object ... contents) {
        return new DefaultHTMLElement("script", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement section(Object ... contents) {
        return new DefaultHTMLElement("section", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement select(Object ... contents) {
        return new DefaultHTMLElement("select", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement small(Object ... contents) {
        return new DefaultHTMLElement("small", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement source(Object ... contents) {
        return new DefaultHTMLElement("source", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement span(Object ... contents) {
        return new DefaultHTMLElement("span", true, true, contents);
    }

    public HTMLBuilder.HTMLElementWithContents strike(Object ... contents) {
        return new DefaultHTMLElement("strike", true, false, new Object[0]);
    }

    public HTMLBuilder.HTMLComplexElement strong(Object ... contents) {
        return new DefaultHTMLElement("strong", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement style(Object ... contents) {
        return new DefaultHTMLElement("style", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement sub(Object ... contents) {
        return new DefaultHTMLElement("sub", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement summary(Object ... contents) {
        return new DefaultHTMLElement("summary", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement sup(Object ... contents) {
        return new DefaultHTMLElement("sup", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement svg(Object ... contents) {
        return new DefaultHTMLElement("svg", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement table(Object ... contents) {
        return new DefaultHTMLElement("table", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement table(int border, int cellpadding, int cellspacing) {
        return this.table(new Object[0]).set("border", border).set("cellpadding", cellpadding).set("cellspacing", cellspacing);
    }

    public HTMLBuilder.HTMLComplexElement table(int border, int cellpadding, int cellspacing, int widthpercent) {
        return this.table(border, cellpadding, cellspacing).set("width", String.valueOf(widthpercent) + "%");
    }

    public HTMLBuilder.HTMLComplexElement tbody(Object ... contents) {
        return new DefaultHTMLElement("tbody", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement td(Object ... contents) {
        return new DefaultHTMLElement("td", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement td(boolean wrap, int colspan) {
        return this.td(wrap, colspan, null);
    }

    public HTMLBuilder.HTMLComplexElement td(boolean wrap, int colspan, String valign) {
        HTMLBuilder.HTMLComplexElement x = this.td(new Object[0]);
        if (!wrap) {
            x.set("nowrap");
        }
        if (colspan > 1) {
            x.set("colspan", colspan);
        }
        if (!StringUtils.isEmpty((CharSequence)valign)) {
            x.set("valign", valign);
        }
        return x;
    }

    public HTMLBuilder.HTMLComplexElement template(Object ... contents) {
        return new DefaultHTMLElement("template", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement textarea(Object ... contents) {
        return new DefaultHTMLElement("textarea", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement textarea(int rows, int cols) {
        return this.textarea(new Object[0]).set("rows", rows).set("cols", cols);
    }

    public HTMLBuilder.HTMLComplexElement textarea(int rows, int cols, int maxlength) {
        return this.textarea(rows, cols).set("maxlength", maxlength);
    }

    public HTMLBuilder.HTMLComplexElement tfoot(Object ... contents) {
        return new DefaultHTMLElement("tfoot", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement th(Object ... contents) {
        return new DefaultHTMLElement("th", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement thead(Object ... contents) {
        return new DefaultHTMLElement("thead", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement time(Object ... contents) {
        return new DefaultHTMLElement("time", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement time(String datetime) {
        return this.time(new Object[0]).set("datetime", datetime);
    }

    public HTMLBuilder.HTMLComplexElement time(Date datetime) {
        return this.time(new Object[0]).set("datetime", datetime.getYear() + "-" + datetime.getMonth() + "-" + datetime.getDay() + " " + datetime.getHours() + ":" + datetime.getMinutes());
    }

    public HTMLBuilder.HTMLComplexElement title(Object ... contents) {
        return new DefaultHTMLElement("title", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement tr(Object ... contents) {
        return new DefaultHTMLElement("tr", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement tr(String valign) {
        return this.tr(new Object[0]).set("valign", valign);
    }

    public HTMLBuilder.HTMLComplexElement tr(HTMLBuilder.HTMLColor color) {
        return this.tr(new Object[0]).set("bgcolor", color);
    }

    public HTMLBuilder.HTMLComplexElement tr(String valign, HTMLBuilder.HTMLColor color) {
        return this.tr(color).set("valign", valign);
    }

    public HTMLBuilder.HTMLComplexElement track(Object ... contents) {
        return new DefaultHTMLElement("track", true, true, contents);
    }

    public HTMLBuilder.HTMLElementWithContents tt(Object ... contents) {
        return new DefaultHTMLElement("tt", true, false, contents);
    }

    public HTMLBuilder.HTMLComplexElement u(Object ... contents) {
        return new DefaultHTMLElement("u", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement ul(Object ... contents) {
        return new DefaultHTMLElement("ul", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement var(Object ... contents) {
        return new DefaultHTMLElement("var", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement video(Object ... contents) {
        return new DefaultHTMLElement("video", true, true, contents);
    }

    public HTMLBuilder.HTMLComplexElement wbr(Object ... contents) {
        return new DefaultHTMLElement("wbr", true, true, contents);
    }

    public class DefaultHTMLColor
    implements HTMLBuilder.HTMLColor {
        private String color = "white";

        public DefaultHTMLColor(String color) {
            this.color = color;
        }

        public DefaultHTMLColor(int r, int g, int b) {
            this("rgb(" + r + "," + g + "," + b + ")");
        }

        public DefaultHTMLColor(Color color) {
            this(color.getRed(), color.getGreen(), color.getBlue());
        }

        public boolean allowContents() {
            return false;
        }

        public boolean allowAttributes() {
            return false;
        }

        public String toHTML() {
            return this.color;
        }

        public String toString() {
            return this.color;
        }
    }

    public class DefaultHTMLElement
    implements HTMLBuilder.HTMLComplexElement {
        private final String name;
        private final boolean allowContents;
        private final boolean allowAttributes;
        private Map<String, String> attributes;
        private Map<String, String> style;
        private ContentsHTMLElement contents;

        public DefaultHTMLElement(String name, boolean allowContents, boolean allowAttributes, Object ... contents) {
            this.name = name;
            this.allowAttributes = allowAttributes;
            this.allowContents = allowContents;
            this.attributes = null;
            this.contents = null;
            if (this.allowContents) {
                this.contents(contents);
            }
        }

        public Map<String, String> getAttributes() {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, String>();
            }
            return this.attributes;
        }

        public Map<String, String> getStyle() {
            if (this.style == null) {
                this.style = new LinkedHashMap<String, String>();
            }
            return this.style;
        }

        public List<HTMLBuilder.HTMLElement> getContents() {
            if (this.contents == null) {
                this.contents = new ContentsHTMLElement();
            }
            return this.contents.getContents();
        }

        public HTMLBuilder.HTMLComplexElement set(String name, String value) {
            if (!this.allowAttributes()) {
                throw new RuntimeException("The element '" + this.name + "' don't allow attributes.");
            }
            this.getAttributes().put(name, value);
            return this;
        }

        public HTMLBuilder.HTMLComplexElement set(String name) {
            return this.set(name, (String)null);
        }

        public HTMLBuilder.HTMLComplexElement set(String name, int value) {
            return this.set(name, String.valueOf(value));
        }

        public HTMLBuilder.HTMLComplexElement set(String name, double value) {
            return this.set(name, String.valueOf(value));
        }

        public HTMLBuilder.HTMLComplexElement set(String name, HTMLBuilder.HTMLColor value) {
            return this.set(name, value.toHTML());
        }

        public HTMLBuilder.HTMLComplexElement style(String name, String value) {
            if (!this.allowAttributes()) {
                throw new RuntimeException("The element '" + this.name + "' don't allow attributes.");
            }
            this.getStyle().put(name, value);
            return this;
        }

        public HTMLBuilder.HTMLComplexElement style(String name, int value) {
            return this.style(name, String.valueOf(value));
        }

        public HTMLBuilder.HTMLComplexElement style(String name, double value) {
            return this.style(name, String.valueOf(value));
        }

        public HTMLBuilder.HTMLComplexElement style(String name, HTMLBuilder.HTMLColor value) {
            return this.style(name, value.toHTML());
        }

        public HTMLBuilder.HTMLComplexElement contents(Object ... values) {
            if (values == null) {
                return this;
            }
            if (!this.allowContents()) {
                throw new RuntimeException("The element '" + this.name + "' don't allow contents.");
            }
            for (Object value : values) {
                if (value == null) continue;
                if (value instanceof HTMLBuilder.HTMLElement) {
                    this.getContents().add((HTMLBuilder.HTMLElement)value);
                    continue;
                }
                this.getContents().add(DefaultHTMLBuilder.this.custom(value.toString()));
            }
            return this;
        }

        public boolean allowContents() {
            return this.allowContents;
        }

        public boolean allowAttributes() {
            return this.allowAttributes;
        }

        public String toHTML() {
            StringBuilder builder = new StringBuilder();
            builder.append("<");
            builder.append(this.name);
            if (this.attributes != null) {
                for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                    builder.append(" ");
                    builder.append(entry.getKey());
                    if (entry.getValue() == null) continue;
                    builder.append("=\"");
                    builder.append(StringEscapeUtils.escapeHtml4((String)entry.getValue()));
                    builder.append("\"");
                }
            }
            if (this.style != null) {
                builder.append(" style=\"");
                for (Map.Entry<String, String> entry : this.style.entrySet()) {
                    builder.append(entry.getKey());
                    builder.append(":");
                    builder.append(StringEscapeUtils.escapeHtml4((String)entry.getValue()));
                    builder.append(" ");
                }
                builder.append("\"");
            }
            if (this.contents != null) {
                builder.append(">\n");
                builder.append(this.contents.toHTML());
                builder.append("</");
                builder.append(this.name);
                builder.append(">\n");
            } else {
                builder.append("/>\n");
            }
            return builder.toString();
        }

        public String toString() {
            return this.toHTML();
        }
    }

    public class ContentsHTMLElement
    implements HTMLBuilder.HTMLElementWithContents {
        private final List<HTMLBuilder.HTMLElement> contents = new ArrayList<HTMLBuilder.HTMLElement>();

        public boolean allowContents() {
            return true;
        }

        public boolean allowAttributes() {
            return false;
        }

        public String toHTML() {
            StringBuilder builder = new StringBuilder();
            for (HTMLBuilder.HTMLElement content : this.contents) {
                builder.append(content.toHTML());
            }
            return builder.toString();
        }

        public String toString() {
            return this.toHTML();
        }

        public HTMLBuilder.HTMLElementWithContents contents(Object ... values) {
            if (values == null) {
                return this;
            }
            for (Object value : values) {
                if (value == null) continue;
                if (value instanceof HTMLBuilder.HTMLElement) {
                    this.contents.add((HTMLBuilder.HTMLElement)value);
                    continue;
                }
                this.contents.add(DefaultHTMLBuilder.this.custom(value.toString()));
            }
            return this;
        }

        public List<HTMLBuilder.HTMLElement> getContents() {
            return this.contents;
        }
    }

    public class CustomHTMLElement
    implements HTMLBuilder.HTMLElement {
        private final String text;

        CustomHTMLElement(String text) {
            this.text = text;
        }

        public boolean allowContents() {
            return false;
        }

        public boolean allowAttributes() {
            return false;
        }

        public String toHTML() {
            return this.text;
        }

        public String toString() {
            return this.toHTML();
        }
    }
}

