/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.derivedgeometries.swing.impl;

import java.util.ArrayList;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesParameters;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesProcess;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.EditingNotification;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.task.AbstractMonitorableTask;

public abstract class AbstractDerivedGeometriesProcess
extends AbstractMonitorableTask
implements DerivedGeometriesProcess {
    private DerivedGeometriesParameters parameters;

    public AbstractDerivedGeometriesProcess(String name, DerivedGeometriesParameters parameters) {
        super(name);
        this.parameters = parameters;
    }

    protected FeatureStore addLayerToMapContex(String name, String path, IProjection projection) throws Exception {
        DataManager dataManager = DALLocator.getDataManager();
        MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
        DataStoreParameters dataStoreParams = dataManager.createStoreParameters("Shape");
        dataStoreParams.setDynValue("shpfile", (Object)path);
        dataStoreParams.setDynValue("CRS", (Object)projection);
        dataStoreParams.setDynValue("useNullGeometry", (Object)false);
        dataStoreParams.validate();
        FLyrVect newLayer = (FLyrVect)mapContextManager.createLayer(name, dataStoreParams);
        this.getParameters().getMapControl().getMapContext().getLayers().addLayer((FLayer)newLayer);
        return newLayer.getFeatureStore();
    }

    protected Surface closeSurfaceIfNecessary(Surface surface) {
        if (!this.isClosed(surface) && surface != null) {
            Point firstp = surface.getVertex(0);
            firstp = firstp.cloneGeometry();
            surface.addVertex(firstp);
        }
        return surface;
    }

    protected void createNewFeatureStore(FeatureType sourceFeatureType, int outputLayerType, String outputLayerPath, IProjection projection) throws Exception {
        DataManager dataManager = DALLocator.getDataManager();
        DataServerExplorerParameters eparams = dataManager.createServerExplorerParameters("FilesystemExplorer");
        eparams.setDynValue("initialpath", (Object)"/data");
        DataServerExplorer serverExplorer = dataManager.openServerExplorer(eparams.getExplorerName(), eparams);
        NewFeatureStoreParameters sparams = (NewFeatureStoreParameters)serverExplorer.getAddParameters("Shape");
        EditableFeatureType newEditableFeatureType = sparams.getDefaultFeatureType();
        for (int i = 0; i < sourceFeatureType.size(); ++i) {
            String fieldName = sourceFeatureType.getAttributeDescriptor(i).getName();
            int fieldType = sourceFeatureType.getAttributeDescriptor(i).getType();
            if (fieldType == 66) continue;
            newEditableFeatureType.add(fieldName, fieldType);
        }
        FeatureAttributeDescriptor geometryAttribute = (FeatureAttributeDescriptor)sourceFeatureType.get(sourceFeatureType.getDefaultGeometryAttributeName());
        EditableFeatureAttributeDescriptor newGeometryAttribute = newEditableFeatureType.add(geometryAttribute.getName(), geometryAttribute.getType(), geometryAttribute.getSize());
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        GeometryType sourceLayerGeomType = sourceFeatureType.getDefaultGeometryAttribute().getGeomType();
        GeometryType outputLayerGeomType = geoManager.getGeometryType(outputLayerType, sourceLayerGeomType.getSubType());
        newGeometryAttribute.setGeometryType(outputLayerGeomType);
        newGeometryAttribute.setPrecision(geometryAttribute.getPrecision());
        newGeometryAttribute.setDefaultValue(geometryAttribute.getDefaultValue());
        newEditableFeatureType.setDefaultGeometryAttributeName(geometryAttribute.getName());
        sparams.setDynValue("geometryType", null);
        sparams.setDynValue("shpfile", (Object)outputLayerPath);
        sparams.setDynValue("CRS", (Object)projection);
        sparams.setDynValue("useNullGeometry", (Object)false);
        sparams.setDefaultFeatureType((FeatureType)newEditableFeatureType);
        sparams.validate();
        serverExplorer.add("Shape", (NewDataStoreParameters)sparams, true);
    }

    protected void endEditingMode(FeatureStore featureStore) throws Exception {
        EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
        EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, "BEFORE_EXIT_EDITING_STORE", null, (DataStore)featureStore);
        if (notification.isCanceled()) {
            String message = String.format("FinishEditing of %1 has been canceled by some observer", featureStore.getName());
            throw new InterruptedException(message);
        }
        this.getParameters().getMapControl().getCanceldraw().setCanceled(true);
        featureStore.finishEditing();
        featureStore.deleteObserver((Observer)this.parameters.getMapControl());
        editingNotificationManager.notifyObservers((Object)this, "AFTER_EXIT_EDITING_STORE", null, (DataStore)featureStore);
    }

    protected FeatureStore getFeatureStore(String outputLayerPath, IProjection projection) throws Exception {
        DataManager dataManager = DALLocator.getDataManager();
        DataStoreParameters dataStoreParams = dataManager.createStoreParameters("Shape");
        dataStoreParams.setDynValue("shpfile", (Object)outputLayerPath);
        dataStoreParams.setDynValue("CRS", (Object)projection);
        dataStoreParams.setDynValue("useNullGeometry", (Object)false);
        dataStoreParams.validate();
        return (FeatureStore)dataManager.openStore("Shape", dataStoreParams);
    }

    protected List<Geometry> getGeometries(List<FeatureReference> selectedFeatures) throws Exception {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (FeatureReference featureReference : selectedFeatures) {
            Geometry geom = featureReference.getFeature().getDefaultGeometry();
            geometries.add(geom);
        }
        return geometries;
    }

    public DerivedGeometriesParameters getParameters() {
        return this.parameters;
    }

    protected void insertGeometryIntoFeauteStore(FeatureStore newFeatureStore, Geometry geometry) throws Exception {
        EditableFeature eFeature = newFeatureStore.createNewFeature(true);
        eFeature.setGeometry(newFeatureStore.getDefaultFeatureType().getDefaultGeometryAttributeName(), geometry);
        newFeatureStore.insert(eFeature);
    }

    private boolean isClosed(Surface surface) {
        Point lastPoint;
        Point firstPoint;
        return surface != null && (firstPoint = surface.getVertex(0)).equals(lastPoint = surface.getVertex(surface.getNumVertices() - 1));
    }

    protected void setEditingMode(FeatureStore featureStore) throws Exception {
        EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
        EditingNotification notification = editingNotificationManager.notifyObservers((Object)this, "BEFORE_ENTER_EDITING_STORE", null, (DataStore)featureStore);
        if (notification.isCanceled()) {
            String message = String.format("Edit of %1 has been canceled by some observer", featureStore.getName());
            throw new InterruptedException(message);
        }
        featureStore.edit();
        featureStore.addObserver((Observer)this.parameters.getMapControl());
        editingNotificationManager.notifyObservers((Object)this, "AFTER_ENTER_EDITING_STORE", null, (DataStore)featureStore);
    }

    public void setParameters(DerivedGeometriesParameters theParameters) {
        this.parameters = theParameters;
    }
}

