/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.derivedgeometries.swing.impl.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import org.gvsig.derivedgeometries.swing.api.DerivedGeometriesParameters;
import org.gvsig.derivedgeometries.swing.api.exceptions.DerivedGeometriesException;
import org.gvsig.derivedgeometries.swing.api.exceptions.ValidateSourceLayerException;
import org.gvsig.derivedgeometries.swing.api.panels.DerivedGeometriesPanel;
import org.gvsig.derivedgeometries.swing.impl.views.DerivedGeometriesPanelView;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDerivedGeometriesPanel
extends DerivedGeometriesPanelView
implements DerivedGeometriesPanel {
    private static final long serialVersionUID = -2874430817496441084L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDerivedGeometriesPanel.class);

    public DefaultDerivedGeometriesPanel(MapControl theMapControl) {
        super(theMapControl);
        this.initNextButton();
        this.initCancelButton();
    }

    public JComponent asJComponent() {
        return this;
    }

    private void closeWindow() {
        this.setVisible(false);
    }

    private void initCancelButton() {
        this.getCancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureStore featureStore;
                DerivedGeometriesParameters parameters = null;
                if (DefaultDerivedGeometriesPanel.this.getLayerAndProcessSelectionPanel().asJComponent().isVisible()) {
                    parameters = DefaultDerivedGeometriesPanel.this.getLayerAndProcessSelectionPanel().getParameters();
                } else if (DefaultDerivedGeometriesPanel.this.getFeaturesControlPanel().asJComponent().isVisible()) {
                    parameters = DefaultDerivedGeometriesPanel.this.getFeaturesControlPanel().getParameters();
                }
                if (parameters != null && (featureStore = parameters.getFeatureStore()) != null) {
                    featureStore.dispose();
                }
                DefaultDerivedGeometriesPanel.this.closeWindow();
            }
        });
    }

    private void initNextButton() {
        this.getNextButton().addActionListener(new ActionListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadSafeDialogsManager dlgManager = ToolsSwingLocator.getThreadSafeDialogsManager();
                if (DefaultDerivedGeometriesPanel.this.getLayerAndProcessSelectionPanel().asJComponent().isVisible()) {
                    try {
                        if (!DefaultDerivedGeometriesPanel.this.validateSelectedSourceLayer()) {
                            String title = "_no_valid_source_layer";
                            String message = "_cant_process_this_type_of_layer";
                            dlgManager.messageDialog(message, title, 0);
                            return;
                        }
                    }
                    catch (DerivedGeometriesException ex) {
                        LOG.warn("Error validating source layer", (Throwable)ex);
                        return;
                    }
                    if (DefaultDerivedGeometriesPanel.this.validateLayerAndOutputLayerFields()) {
                        DefaultDerivedGeometriesPanel.this.getLayerAndProcessSelectionPanel().doAccept();
                        DerivedGeometriesParameters parameters = DefaultDerivedGeometriesPanel.this.getLayerAndProcessSelectionPanel().getParameters();
                        DefaultDerivedGeometriesPanel.this.getLayerAndProcessSelectionPanel().asJComponent().setVisible(false);
                        DefaultDerivedGeometriesPanel.this.getFeaturesControlPanel().setParameters(parameters);
                        DefaultDerivedGeometriesPanel.this.getFeaturesControlPanel().asJComponent().setVisible(true);
                        I18nManager i18nManager = ToolsLocator.getI18nManager();
                        DefaultDerivedGeometriesPanel.this.getCancelButton().setText(i18nManager.getTranslation("finish"));
                        DefaultDerivedGeometriesPanel.this.getNextButton().setText(i18nManager.getTranslation("generate"));
                        return;
                    }
                    String title = "_no_valid_data";
                    String message = "_no_valid_data_make_sure_data_are_valid";
                    dlgManager.messageDialog(message, title, 0);
                    return;
                }
                if (!DefaultDerivedGeometriesPanel.this.getFeaturesControlPanel().asJComponent().isVisible()) return;
                if (DefaultDerivedGeometriesPanel.this.validateFeaturesControlPanelFields()) {
                    DefaultDerivedGeometriesPanel.this.getFeaturesControlPanel().doAction();
                    return;
                }
                String title = "_no_valid_data";
                String message = "_no_valid_data_make_sure_data_are_valid";
                dlgManager.messageDialog(message, title, 0);
            }
        });
    }

    private boolean validateLayerAndOutputLayerFields() {
        return this.getLayerAndProcessSelectionPanel().validateFields();
    }

    private boolean validateFeaturesControlPanelFields() {
        return this.getFeaturesControlPanel().validateFields();
    }

    private boolean validateSelectedSourceLayer() throws ValidateSourceLayerException {
        return this.getLayerAndProcessSelectionPanel().validateSourceLayer();
    }
}

