/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.derivedgeometries.swing.impl.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gvsig.derivedgeometries.swing.api.exceptions.FormatRowException;
import org.gvsig.derivedgeometries.swing.api.exceptions.LoadSelectedFeatureDataException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class SelectedFeaturesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3905635376996886077L;
    private List<String[]> data = null;
    private String[] columnNames = null;
    private int rowCount = 0;
    private FeatureStore featureStore;
    private int orderCount = 0;

    public SelectedFeaturesTableModel() {
        this.featureStore = null;
    }

    public SelectedFeaturesTableModel(FeatureStore theFeatureStore) {
        this.featureStore = theFeatureStore;
    }

    public void loadData(List<FeatureReference> features) throws LoadSelectedFeatureDataException {
        this.clear();
        ArrayList<String[]> tmpData = new ArrayList<String[]>();
        Feature feature = null;
        for (FeatureReference featureReference : features) {
            try {
                feature = featureReference.getFeature();
                tmpData.add(this.formatRow(feature));
            }
            catch (DataException e) {
                String message = String.format("Error getting feature through %1 ", featureReference);
                throw new LoadSelectedFeatureDataException(message, (Throwable)e);
            }
            catch (FormatRowException e) {
                String message = String.format("Error formatting data of %1", feature);
                throw new LoadSelectedFeatureDataException(message, (Throwable)e);
            }
        }
        this.data = Collections.unmodifiableList(tmpData);
        this.rowCount = this.data.size();
        try {
            this.columnNames = this.getColumnNamesFromType(this.featureStore.getDefaultFeatureType());
        }
        catch (DataException e) {
            String message = String.format("Error getting feature type of %1", this.featureStore);
            throw new LoadSelectedFeatureDataException(message, (Throwable)e);
        }
        this.fireTableStructureChanged();
    }

    private String[] getColumnNamesFromType(FeatureType featureType) {
        int count = featureType.size();
        ArrayList<String> names = new ArrayList<String>();
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        names.add(i18nManager.getTranslation("_Order"));
        for (int i = 0; i < count; ++i) {
            names.add(featureType.getAttributeDescriptor(i).getName());
        }
        return names.toArray(new String[0]);
    }

    private String[] formatRow(Feature feature) throws FormatRowException {
        FeatureType featureType;
        try {
            featureType = this.featureStore.getDefaultFeatureType();
        }
        catch (DataException e) {
            String message = String.format("Error getting feature type of %1", this.featureStore.getName());
            throw new FormatRowException(message, (Throwable)e);
        }
        int featureSize = featureType.size();
        ArrayList<String> featureData = null;
        if (featureSize > 0) {
            featureData = new ArrayList<String>();
            featureData.add(String.valueOf(this.orderCount));
            ++this.orderCount;
            for (int i = 0; i < featureSize; ++i) {
                featureData.add(String.valueOf(feature.get(i)));
            }
        }
        return featureData.toArray(new String[0]);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        if (this.columnNames == null) {
            return 0;
        }
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.data == null) {
            return "";
        }
        return this.data.get(rowIndex)[columnIndex];
    }

    @Override
    public String getColumnName(int column) {
        if (this.columnNames == null) {
            return null;
        }
        return this.columnNames[column];
    }

    public void clear() {
        this.data = null;
        this.columnNames = null;
        this.rowCount = 0;
        this.orderCount = 0;
        this.fireTableDataChanged();
    }
}

