/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.swing.impl;

import java.util.Comparator;
import java.util.Objects;
import org.gvsig.expressionevaluator.ExpressionUtils;

public class Utils {
    public static Comparator naturalComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof Integer && o2 instanceof Number) {
                    return Long.compare(((Integer)o1).intValue(), ((Number)o2).intValue());
                }
                if (o1 instanceof Long && o2 instanceof Number) {
                    return Long.compare((Long)o1, ((Number)o2).longValue());
                }
                if (o1 instanceof Double && o2 instanceof Number) {
                    return Double.compare((Double)o1, ((Number)o2).doubleValue());
                }
                if (o1 instanceof Float && o2 instanceof Number) {
                    return Double.compare(((Float)o1).floatValue(), ((Number)o2).floatValue());
                }
                if (o1 instanceof Number && o2 instanceof Number) {
                    return Double.compare(Utils.getDouble((Number)o1), Utils.getDouble((Number)o2));
                }
                if (o1 instanceof String && o2 instanceof String) {
                    return ((String)o1).compareToIgnoreCase((String)o2);
                }
                try {
                    return ((Comparable)o1).compareTo((Comparable)o2);
                }
                catch (Exception ex) {
                    return Objects.toString(o1, "").compareTo(Objects.toString(o2, ""));
                }
            }
        };
    }

    private static double getDouble(Number n) {
        if (n == null) {
            return 0.0;
        }
        return n.doubleValue();
    }

    public static String repr(Object value) {
        return ExpressionUtils.repr((Object)value);
    }
}

