/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformfield.Script;

import java.awt.event.FocusListener;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.script.ScriptSwingManager;

public class JDynFormFieldScript
extends AbstractJDynFormField
implements JDynFormField {
    private String assignedValue = null;
    private ScriptSwingManager.ScriptEditor editor;

    public JDynFormFieldScript(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = Objects.toString(value, null);
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponent() {
        ScriptSwingManager scriptSwingManager = ToolsSwingLocator.getScriptSwingManager();
        this.editor = scriptSwingManager.createScriptEditor();
        this.contents = this.editor.asJComponent();
        if (this.getDefinition().isReadOnly()) {
            this.editor.setEditable(false);
        }
        this.editor.addFocusListener((FocusListener)((Object)this));
        this.setValue(this.assignedValue);
    }

    public void setValue(Object value) {
        String s = Objects.toString(value, "");
        this.assignedValue = Objects.toString(value, null);
        Script script = ToolsLocator.getScriptManager().createScript("main", s, "cosa");
        this.editor.set(script);
    }

    public Object getValue() {
        Script script = ToolsLocator.getScriptManager().createScript("main", "", "cosa");
        this.editor.fetch(script);
        String s = script.getCode();
        return s;
    }

    public boolean hasValidValue() {
        return true;
    }

    public boolean isModified() {
        Script script = ToolsLocator.getScriptManager().createScript("main", "", "cosa");
        this.editor.fetch(script);
        String value = script.getCode();
        String assigned = (String)this.getAssignedValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return StringUtils.isNotBlank((CharSequence)assigned);
        }
        return !Objects.equals(value, assigned);
    }
}

