/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformfield.Time;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.sql.Time;
import java.util.Date;
import java.util.Objects;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.CustomSpinnerDateModel;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.exception.DynFieldValidateException;

public class JDynFormFieldTime
extends AbstractJDynFormField
implements JDynFormField,
FocusListener {
    protected Object assignedValue = null;

    public JDynFormFieldTime(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = value;
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    protected JSpinner getJSpinner() {
        return (JSpinner)this.contents;
    }

    public void initComponent() {
        DynObjectValueItem[] availableValues = this.getDefinition().getAvailableValues();
        if (availableValues == null) {
            JSpinner timeSpinner = this.getComponentsFactory().getJSpinner(this.getDefinition(), null);
            CustomSpinnerDateModel model = new CustomSpinnerDateModel(true);
            timeSpinner.setModel((SpinnerModel)model);
            JSpinner.DateEditor timeEditor = new JSpinner.DateEditor(timeSpinner, "HH:mm:ss");
            timeSpinner.setEditor(timeEditor);
            this.contents = timeSpinner;
            this.contents.addFocusListener(this);
            if (this.getDefinition().isReadOnly()) {
                timeSpinner.setEnabled(false);
            }
        }
        this.setValue(this.assignedValue);
    }

    public void setValue(Object value) {
        Object s = null;
        if (value == null) {
            value = this.getDefinition().getDefaultValue();
            if (value == null) {
                value = new Date();
            }
        } else {
            try {
                this.getDefinition().validate(value);
                this.problemIndicator().clear();
            }
            catch (DynFieldValidateException e) {
                this.problemIndicator().set(e.getLocalizedMessage());
            }
        }
        if (this.contents instanceof JSpinner) {
            this.getJSpinner().setValue(value);
        }
        this.assignedValue = value;
    }

    public Object getValue() {
        Time value = null;
        if (this.contents instanceof JSpinner) {
            value = this.getValueAsTime();
        }
        try {
            this.getDefinition().validate((Object)value);
            this.problemIndicator().clear();
        }
        catch (DynFieldValidateException e) {
            throw new AbstractJDynFormField.IllegalFieldValue((AbstractJDynFormField)this, (JDynFormField)this, e.getLocalizedMessage());
        }
        return value;
    }

    public boolean hasValidValue() {
        try {
            Object object = this.getValue();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.fireFieldEnterEvent();
        this.problemIndicator().restore();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        if (this.hasValidValue()) {
            this.problemIndicator().clear();
        } else {
            try {
                Object object = this.getValue();
            }
            catch (Exception e) {
                this.problemIndicator().set(e.getLocalizedMessage());
            }
        }
        this.fireFieldExitEvent();
    }

    public void clear() {
        Object value = this.getDefinition().getDefaultValue();
        if (value != null) {
            value = value.toString();
        }
        this.getJSpinner().setValue(value);
    }

    public boolean isModified() {
        Time assigned = (Time)this.getAssignedValue();
        if (this.getJSpinner() != null) {
            Time value = this.getValueAsTime();
            return !Objects.equals(value, assigned);
        }
        return false;
    }

    private Time getValueAsTime() {
        Date date = (Date)this.getJSpinner().getValue();
        if (date == null) {
            return null;
        }
        if (date instanceof Time) {
            return (Time)date;
        }
        return new Time(date.getTime());
    }
}

