/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.svgsupport;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.StaticRenderer;
import org.gvsig.svgsupport.SVGRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultSVGRenderer
implements SVGRenderer {
    private final GVTBuilder gvtBuilder = new GVTBuilder();
    private final UserAgentAdapter userAgent;
    private final DocumentLoader loader;
    private final StaticRenderer renderer = new StaticRenderer();
    private GraphicsNode gvtRoot;
    private final BridgeContext ctx;
    private Element elt;
    private URL source;
    private static RenderingHints defaultRenderingHints = null;

    public DefaultSVGRenderer() {
        this.userAgent = new UserAgentAdapter();
        this.loader = new DocumentLoader((UserAgent)this.userAgent);
        this.ctx = new BridgeContext((UserAgent)this.userAgent, this.loader);
        this.renderer.setDoubleBuffered(true);
    }

    public Rectangle2D getBounds() {
        Rectangle2D bounds = this.gvtRoot.getBounds();
        return bounds;
    }

    public void drawInsideRectangle(Graphics2D g, Rectangle2D rect, boolean keepAspectRatio) {
        if (keepAspectRatio) {
            AffineTransform ataux = null;
            if (this.elt.hasAttribute("viewBox")) {
                try {
                    ataux = ViewBox.getViewTransform(null, (Element)this.elt, (float)((float)rect.getWidth()), (float)((float)rect.getHeight()), (BridgeContext)this.ctx);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (ataux == null) {
                Rectangle2D bounds = this.gvtRoot.getBounds();
                ataux = this.getNoRotationTransform(bounds, new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()), true);
            }
            RenderingHints renderingHints = new RenderingHints(null);
            renderingHints.putAll((Map<?, ?>)this.getDefaultRenderingHints());
            g.setRenderingHints(renderingHints);
            this.gvtRoot.setTransform(ataux);
            this.gvtRoot.paint(g);
        } else {
            Rectangle2D bounds = this.gvtRoot.getBounds();
            AffineTransform ataux = this.getNoRotationTransform(bounds, new Rectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight()), false);
            RenderingHints renderingHints = new RenderingHints(null);
            renderingHints.putAll((Map<?, ?>)this.getDefaultRenderingHints());
            g.setRenderingHints(renderingHints);
            this.gvtRoot.setTransform(ataux);
            this.gvtRoot.paint(g);
        }
    }

    public void setSource(URL url) throws IOException {
        Document svgDoc;
        this.source = url;
        try {
            svgDoc = this.loader.loadDocument(url.toURI().toString());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        this.gvtRoot = this.gvtBuilder.build(this.ctx, svgDoc);
        this.renderer.setTree(this.gvtRoot);
        this.elt = ((SVGOMDocument)svgDoc).getRootElement();
    }

    public URL getSource() {
        return this.source;
    }

    private AffineTransform getNoRotationTransform(Rectangle2D from_rect, Rectangle2D to_rect, boolean keep_aspect) {
        double scalex = to_rect.getWidth() / from_rect.getWidth();
        double scaley = to_rect.getHeight() / from_rect.getHeight();
        if (keep_aspect) {
            scaley = scalex = Math.min(scalex, scaley);
        }
        double from_new_center_x = scalex * from_rect.getCenterX();
        double from_new_center_y = scaley * from_rect.getCenterY();
        double offx = to_rect.getCenterX() - from_new_center_x;
        double offy = to_rect.getCenterY() - from_new_center_y;
        AffineTransform resp = AffineTransform.getTranslateInstance(offx, offy);
        resp.concatenate(AffineTransform.getScaleInstance(scalex, scaley));
        return resp;
    }

    private RenderingHints getDefaultRenderingHints() {
        if (defaultRenderingHints == null) {
            defaultRenderingHints = new RenderingHints(null);
            defaultRenderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            defaultRenderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        return defaultRenderingHints;
    }

    public void setSource(File f) throws IOException {
        this.setSource(f.toURI().toURL());
    }
}

