/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.dynamiclegend;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingMethod;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IZoomConstraints;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.symbology.fmap.mapcontext.rendering.dynamiclegend.DynamicLabelingStrategy;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.AttrInTableLabelingStrategy;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractCartographicSupport;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.CartographicSupportToolkit;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.impl.SimpleTextSymbol;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDynamicLabelingStrategy
extends AbstractCartographicSupport
implements DynamicLabelingStrategy {
    private Feature feature;
    public String LROTATION = "LROTATION";
    public String LTEXT = "LTEXT";
    public String LHEIGHT = "LHEIGHT";
    public String LCOLOR = "LCOLOR";
    public String LFONT = "LFONT";
    public String LFONTSTYLE = "LFONTS";
    public static Expression expRotation = null;
    public static Expression expText = null;
    public static Expression expHeight = null;
    public static Expression expColor = null;
    public static Expression expFont = null;
    public static Expression expFontStyle = null;
    public static Expression expUnit;
    public static Expression expReferenceSystem;
    private MutableSymbolTable symbolTable = null;
    private FeatureSymbolTable featureSymbolTable = null;
    private FLyrVect layer;
    private List<Geometry> drawnGeometryLabels;
    private final boolean printMode = false;
    private final IZoomConstraints zoom = null;
    private static final Logger logger;

    public SymbolTable getFeatureSymbolTable() {
        if (this.symbolTable == null) {
            MutableSymbolTable s = ExpressionEvaluatorLocator.getManager().createSymbolTable();
            this.featureSymbolTable = DALLocator.getDataManager().createFeatureSymbolTable();
            s.addSymbolTable((SymbolTable)this.featureSymbolTable);
            if (this.feature != null) {
                this.featureSymbolTable.setFeature(this.feature);
            }
            this.symbolTable = s;
        }
        return this.symbolTable;
    }

    private Object getValueFromExpression(Expression exp) {
        if (exp == null) {
            return null;
        }
        Object value = exp.execute(this.getFeatureSymbolTable());
        return value;
    }

    public Object getComputedValue(String field) {
        Object value = this.feature.get(field);
        return value;
    }

    public Expression getRotation() {
        return expRotation;
    }

    public int getComputedRotation() {
        Integer value = (Integer)this.getValueFromExpression(this.getRotation());
        return value;
    }

    public Expression getText() {
        return expText;
    }

    public String getComputedText() {
        String value = (String)this.getValueFromExpression(this.getText());
        return value;
    }

    public Expression getHeight() {
        return expHeight;
    }

    public int getComputedHeight() {
        int value = (Integer)this.getValueFromExpression(this.getHeight());
        return value;
    }

    public Expression getColor() {
        return expColor;
    }

    public Color getComputedColor() {
        int rgbcolor = (Integer)this.getColor().execute(this.getFeatureSymbolTable());
        Color color = new Color(rgbcolor, true);
        return color;
    }

    public Expression getFixedSize() {
        return expHeight;
    }

    public double getComputedFixedSize() {
        double value = (Double)this.getValueFromExpression(this.getFixedSize());
        return value;
    }

    public int getComputedUnit() {
        int value = (Integer)this.getValueFromExpression(this.getUnitExp());
        return value;
    }

    public void setText(Expression expression) {
        expText = expression;
    }

    public void setRotation(Expression expression) {
        expRotation = expression;
    }

    public void setHeight(Expression expression) {
        expHeight = expression;
    }

    public void setColor(Expression expression) {
        expColor = expression;
    }

    public void setUsesFixedSize(boolean b) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean usesFixedSize() {
        return false;
    }

    public void setFixedSize(double fixedSize) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setUsesFixedColor(boolean b) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean usesFixedColor() {
        return true;
    }

    public Expression getFixedColor() {
        return expColor;
    }

    public Color getComputedFixedColor() {
        int rgbcolor = (Integer)this.getFixedColor().execute(this.getFeatureSymbolTable());
        Color color = new Color(rgbcolor, true);
        return color;
    }

    public void setFixedColor(Color fixedColor) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Expression getColorFont() {
        return expColor;
    }

    public Color getComputedColorFont() {
        int rgbcolor = (Integer)this.getColorFont().execute(this.getFeatureSymbolTable());
        Color color = new Color(rgbcolor, true);
        return color;
    }

    public void setColorFont(Color colorFont) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Expression getFont() {
        return expFont;
    }

    public Font getComputedFont() {
        String value = (String)this.getFont().execute(this.getFeatureSymbolTable());
        Font font = new Font(value, this.getComputedFontStyle(), this.getComputedHeight());
        return font;
    }

    public void setFont(Font selFont) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Expression getFontStyle() {
        return expFontStyle;
    }

    public int getComputedFontStyle() {
        int value = (Integer)this.getFontStyle().execute(this.getFeatureSymbolTable());
        return value;
    }

    public void setFontStyle(Expression expression) {
        expFontStyle = expression;
    }

    public void setFeature(Feature f) {
        this.feature = f;
        if (this.featureSymbolTable == null) {
            this.getFeatureSymbolTable();
        }
        this.featureSymbolTable.setFeature(f);
    }

    public ILabelingMethod getLabelingMethod() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLabelingMethod(ILabelingMethod method) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IPlacementConstraints getPlacementConstraints() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setPlacementConstraints(IPlacementConstraints constraints) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IZoomConstraints getZoomConstraints() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setZoomConstraints(IZoomConstraints constraints) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Expression getUnitExp() {
        return expUnit;
    }

    public Expression getReferenceSystemExp() {
        return expReferenceSystem;
    }

    private Point createLabelPoint(Geometry geom) throws CreateGeometryException {
        try {
            return geom.centroid();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void draw(BufferedImage mapImage, Graphics2D mapGraphics, double scale, ViewPort viewPort, Cancellable cancel, double dpi) throws ReadException {
        PrintAttributes props = null;
        if (this.layer == null) {
            return;
        }
        if (this.zoom == null || this.zoom.isUserDefined() && scale >= (double)this.zoom.getMaxScale() && scale <= (double)this.zoom.getMinScale()) {
            FeatureSet set = null;
            DisposableIterator iterator = null;
            try {
                ArrayList<String> fields = new ArrayList<String>();
                FeatureStore featureStore = this.layer.getFeatureStore();
                ICoordTrans ct = this.layer.getCoordTrans();
                String geomName = featureStore.getDefaultFeatureType().getDefaultGeometryAttributeName();
                fields.add(this.LCOLOR);
                fields.add(this.LFONT);
                fields.add(this.LFONTSTYLE);
                fields.add(this.LHEIGHT);
                fields.add(this.LROTATION);
                fields.add(this.LTEXT);
                fields.add(geomName);
                FeatureQuery featureQuery = this.layer.createFeatureQuery();
                if (viewPort.getAdjustedEnvelope().contains(this.layer.getFullEnvelope())) {
                    set = featureStore.getFeatureSet(featureQuery);
                } else {
                    Evaluator iee = null;
                    IProjection data_proj = null;
                    Envelope env_in_store_crs = null;
                    if (ct == null) {
                        env_in_store_crs = viewPort.getAdjustedEnvelope();
                        data_proj = viewPort.getProjection();
                    } else {
                        env_in_store_crs = viewPort.getAdjustedEnvelope().convert(ct.getInverted());
                        data_proj = ct.getPOrig();
                    }
                    iee = SpatialEvaluatorsFactory.getInstance().intersects(env_in_store_crs, data_proj, featureStore);
                    featureQuery.setAttributeNames(fields.toArray(new String[fields.size()]));
                    featureQuery.setFilter(iee);
                    set = featureStore.getFeatureSet(featureQuery);
                }
                FeatureSelection selection = this.layer.getFeatureStore().getFeatureSelection();
                iterator = set.fastIterator();
                while (iterator.hasNext()) {
                    if (cancel.isCanceled()) {
                        return;
                    }
                    try {
                        Feature feat = (Feature)iterator.next();
                        Geometry geom = feat.getDefaultGeometry();
                        if (geom == null) continue;
                        double size = 0.0;
                        Color color = null;
                        this.setFeature(feat);
                        if ("".equals(this.getComputedText()) || this.getComputedText() == null) continue;
                        SimpleTextSymbol sym = new SimpleTextSymbol();
                        sym.setFont(this.getComputedFont());
                        sym.setUnit(this.getComputedUnit());
                        sym.setReferenceSystem(this.getComputedReferenceSystem());
                        size = this.usesFixedSize() ? this.getComputedFixedSize() : (double)this.getComputedHeight();
                        double the_dpi = viewPort.getDPI();
                        if (props != null) {
                            int len = PrintAttributes.PRINT_QUALITY_DPI.length;
                            int priq = props.getPrintQuality();
                            if (priq < 0 || priq >= len) {
                                throw new ReadException(featureStore.getName(), (Throwable)new Exception("Bad print quality value: " + priq));
                            }
                            the_dpi = PrintAttributes.PRINT_QUALITY_DPI[priq];
                        }
                        if ((size = CartographicSupportToolkit.getCartographicLength((CartographicSupport)this, (double)size, (ViewPort)viewPort, (double)the_dpi)) <= 3.0) continue;
                        double font_size = size * 72.0 / the_dpi;
                        sym.setFontSize(font_size);
                        color = selection.isSelected(feat) ? viewPort.getSelectionColor() : this.getComputedColorFont();
                        sym.setTextColor(color);
                        if (ct != null) {
                            geom = geom.cloneGeometry();
                            geom.reProject(ct);
                        }
                        Point p = null;
                        double rotation = -Math.toRadians(((Number)this.getComputedRotation()).doubleValue());
                        p = this.createLabelPoint(geom);
                        sym.setText(this.getComputedText());
                        sym.setRotation(rotation);
                        if (p == null) continue;
                        if (props == null) {
                            sym.draw(mapGraphics, viewPort.getAffineTransform(), (Geometry)p, feat, cancel);
                            continue;
                        }
                        sym.print(mapGraphics, viewPort.getAffineTransform(), (Geometry)p, props);
                    }
                    catch (Exception ex) {
                        logger.warn("", (Throwable)ex);
                    }
                }
            }
            catch (BaseException e) {
                throw new ReadException("Could not draw annotation in the layer.", (Throwable)e);
            }
            finally {
                if (iterator != null) {
                    iterator.dispose();
                }
                if (set != null) {
                    set.dispose();
                }
            }
        }
    }

    public void print(Graphics2D g, double scale, ViewPort viewPort, Cancellable cancel, PrintAttributes properties) throws ReadException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] getUsedFields() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLayer(FLayer flayer) {
        this.layer = (FLyrVect)flayer;
    }

    public boolean shouldDrawLabels(double scale) {
        return true;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setUnit(int unitIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setUnit(Expression expression) {
        expUnit = expression;
    }

    public int getUnit() {
        return this.getComputedUnitExp();
    }

    public int getComputedUnitExp() {
        int value = (Integer)this.getValueFromExpression(this.getUnitExp());
        return value;
    }

    public int getComputedReferenceSystem() {
        int value = (Integer)this.getValueFromExpression(this.getReferenceSystemExp());
        return value;
    }

    public int getReferenceSystem() {
        return this.getComputedReferenceSystem();
    }

    public void setReferenceSystem(int referenceSystem) {
    }

    public void setFont(Expression expression) {
        expFont = expression;
    }

    public void setFontStyle(int style) {
    }

    public void setReferenceSystem(Expression expression) {
        expReferenceSystem = expression;
    }

    static {
        logger = LoggerFactory.getLogger(AttrInTableLabelingStrategy.class);
    }
}

