/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.dynamiclegend;

import java.util.ArrayList;
import java.util.Arrays;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.dynamiclegend.DynamicSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.dynamiclegend.DynamicVectorLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractVectorialLegend;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDynamicVectorLegend
extends AbstractVectorialLegend
implements DynamicVectorLegend {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDynamicVectorLegend.class);
    public static final String DYNAMIC_VECTOR_PERSISTENCE_DEFINITION_NAME = "SingleSymbolLegend";
    private ISymbol defaultSymbol;
    private int shapeType = 3;
    public static Expression expOutlineColor = null;
    public static Expression expFillColor = null;
    public static Expression expSize = null;
    public static Expression expRotation = null;
    public static String[] requiredAttributes = null;

    public DefaultDynamicVectorLegend() {
    }

    public DefaultDynamicVectorLegend(ISymbol style) {
        this.setDefaultSymbol(style);
    }

    public void setDefaultSymbol(ISymbol s) {
        if (s == null) {
            throw new NullPointerException("Default symbol cannot be null");
        }
        ISymbol old = this.defaultSymbol;
        this.defaultSymbol = s;
    }

    public ISymbol getSymbol(int recordIndex) {
        return this.defaultSymbol;
    }

    public ISymbol getDefaultSymbol() {
        if (this.defaultSymbol == null) {
            SymbolManager symbolManager = MapContextLocator.getSymbolManager();
            this.defaultSymbol = symbolManager.createSymbol("DynamicSymbol");
        }
        return this.defaultSymbol;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(int shapeType) {
        if (this.shapeType != shapeType) {
            if (this.defaultSymbol == null || this.defaultSymbol.getSymbolType() != shapeType) {
                this.defaultSymbol = this.getSymbolManager().createSymbol(shapeType);
            }
            this.shapeType = shapeType;
        }
    }

    private Expression getExpressionFromString(String value) {
        Expression expression = ExpressionEvaluatorLocator.getManager().createExpression();
        expression.setPhrase(value);
        return expression;
    }

    public void setOutlineColor(Expression expression) {
        expOutlineColor = expression;
    }

    public void setFillColor(Expression expression) {
        expFillColor = expression;
    }

    public void setSize(Expression expression) {
        expSize = expression;
    }

    public void setRotation(Expression expression) {
        expRotation = expression;
    }

    public ISymbol getSymbolByFeature(Feature feat) {
        DynamicSymbol symbol = (DynamicSymbol)this.getDefaultSymbol();
        symbol.setFillColor(expFillColor);
        symbol.setOutlineColor(expOutlineColor);
        symbol.setSize(expSize);
        symbol.setRotation(expRotation);
        Point pointOffset = null;
        String value = "";
        try {
            pointOffset = GeometryLocator.getGeometryManager().createPoint(0.0, 0.0, 0);
            value = pointOffset.convertToWKT();
        }
        catch (Exception ex) {
            LOG.warn("Not been able to convert to WKT a point offset", (Throwable)ex);
        }
        Expression offset = this.getExpressionFromString(value);
        symbol.setOffset(offset);
        try {
            String[] strList = this.getRequiredFeatureAttributeNames(feat.getStore());
            ArrayList<String> reqAttr = new ArrayList<String>();
            reqAttr.addAll(Arrays.asList(strList));
            symbol.setRequiredFeatureAttributesNames(reqAttr);
        }
        catch (DataException ex) {
            LOG.warn("Not been able to assign its feature attributes", (Throwable)ex);
        }
        symbol.setFeature(feat);
        return symbol;
    }

    public void useDefaultSymbol(boolean b) {
        LOG.warn("Not implemented DefaultDynamicVectorLegend.useDefaultSymbol");
    }

    public String[] getUsedFields() {
        return new String[0];
    }

    public boolean isUseDefaultSymbol() {
        return true;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public boolean isSuitableForShapeType(int shapeType) {
        return this.getShapeType() == shapeType;
    }

    public void setFeatureStore(FeatureStore fs) throws DataException {
        LOG.warn("Not implemented DefaultDynamicVectorLegend.setFeatureStore");
    }

    @Override
    protected String[] getRequiredFeatureAttributeNames(FeatureStore featureStore) throws DataException {
        if (requiredAttributes == null) {
            int arraySize = featureStore.getDefaultFeatureType().size();
            requiredAttributes = new String[arraySize];
            for (int i = 0; i < featureStore.getDefaultFeatureType().size(); ++i) {
                FeatureAttributeDescriptor att = featureStore.getDefaultFeatureType().get(i);
                DefaultDynamicVectorLegend.requiredAttributes[i] = att.getName();
            }
        }
        return requiredAttributes;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DynamicVectorLegend clone = (DynamicVectorLegend)super.clone();
        return clone;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
    }

    public static void selfRegister() {
        MapContextManager manager = MapContextLocator.getMapContextManager();
        manager.registerLegend("DynamicVectorLegend", DefaultDynamicVectorLegend.class);
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(DefaultDynamicVectorLegend.DYNAMIC_VECTOR_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(DynamicVectorLegend.class, DefaultDynamicVectorLegend.DYNAMIC_VECTOR_PERSISTENCE_DEFINITION_NAME, "SingleSymbolLegend Persistence definition", null, null);
                definition.extend(manager.getDefinition("VectorialLegend"));
            }
            return Boolean.TRUE;
        }
    }
}

