/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl;

import java.util.Arrays;
import java.util.HashSet;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.rendering.legend.IClassifiedVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendClearEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendContentsChangedListener;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractVectorialLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public abstract class AbstractClassifiedVectorLegend
extends AbstractVectorialLegend
implements IClassifiedVectorLegend {
    public static final String CLASSIFIED_VECTOR_LEGEND_PERSISTENCE_DEFINITION_NAME = "ClassifiedVectorLegend";
    private static final String FIELD_FIELD_NAMES = "fieldNames";
    private static final String FIELD_FIELD_TYPES = "fieldTypes";
    private String[] fieldNames;
    private int[] fieldTypes;
    private String[] requiredFieldNames = null;

    public void fireClassifiedSymbolChangeEvent(SymbolLegendEvent event) {
        for (LegendContentsChangedListener listener : this.getListeners()) {
            listener.symbolChanged(event);
        }
    }

    public void fireLegendClearEvent(LegendClearEvent event) {
        for (LegendContentsChangedListener listener : this.getListeners()) {
            listener.legendCleared(event);
        }
    }

    public String[] getClassifyingFieldNames() {
        return this.fieldNames;
    }

    public void setClassifyingFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    public int[] getClassifyingFieldTypes() {
        return this.fieldTypes;
    }

    public void setClassifyingFieldTypes(int[] fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public boolean isSuitableForShapeType(int shapeType) {
        return this.getShapeType() == shapeType;
    }

    @Override
    protected String[] getRequiredFeatureAttributeNames(FeatureStore featureStore) throws DataException {
        if (this.requiredFieldNames == null) {
            HashSet<String> theRequiredFieldNames = new HashSet<String>();
            theRequiredFieldNames.add(featureStore.getDefaultFeatureType().getDefaultGeometryAttributeName());
            theRequiredFieldNames.addAll(Arrays.asList(this.getClassifyingFieldNames()));
            for (ISymbol symbol : this.getSymbols()) {
                if (!(symbol instanceof AbstractSymbol)) continue;
                String[] names = ((AbstractSymbol)symbol).getRequiredFeatureAttributeNames(featureStore);
                theRequiredFieldNames.addAll(Arrays.asList(names));
            }
            this.requiredFieldNames = theRequiredFieldNames.toArray(new String[theRequiredFieldNames.size()]);
        }
        return this.requiredFieldNames;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractClassifiedVectorLegend clone = (AbstractClassifiedVectorLegend)super.clone();
        clone.fieldNames = new String[this.fieldNames.length];
        System.arraycopy(this.fieldNames, 0, clone.fieldNames, 0, this.fieldNames.length);
        clone.fieldTypes = new int[this.fieldTypes.length];
        System.arraycopy(this.fieldTypes, 0, clone.fieldTypes, 0, this.fieldTypes.length);
        return clone;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.fieldNames = state.getStringArray(FIELD_FIELD_NAMES);
        this.fieldTypes = state.getIntArray(FIELD_FIELD_TYPES);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_FIELD_NAMES, this.fieldNames);
        state.set(FIELD_FIELD_TYPES, this.fieldTypes);
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(AbstractClassifiedVectorLegend.CLASSIFIED_VECTOR_LEGEND_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(AbstractClassifiedVectorLegend.class, AbstractClassifiedVectorLegend.CLASSIFIED_VECTOR_LEGEND_PERSISTENCE_DEFINITION_NAME, "ClassifiedVectorLegend Persistence definition", null, null);
                definition.extend(manager.getDefinition("VectorialLegend"));
                definition.addDynFieldArray(AbstractClassifiedVectorLegend.FIELD_FIELD_NAMES).setClassOfItems(String.class);
                definition.addDynFieldArray(AbstractClassifiedVectorLegend.FIELD_FIELD_TYPES).setClassOfItems(Integer.TYPE);
            }
            return true;
        }
    }
}

