/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.legend.IInterval;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialIntervalLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractClassifiedVectorLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.FInterval;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.NaturalIntervalGenerator;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.QuantileIntervalGenerator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.IMultiShapeSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIntervalLegend
extends AbstractClassifiedVectorLegend
implements IVectorialIntervalLegend {
    public static final String INTERVAL_LEGEND_PERSISTENCE_DEFINITION_NAME = "IntervalLegend";
    private static final String FIELD_KEYS = "keys";
    private static final String FIELD_INTERVAL_TYPE = "intervalType";
    private static final String FIELD_USE_DEFAULT_SYMBOL = "useDefaultSymbol";
    private static final String FIELD_SYMBOLS = "symbols";
    protected List<Object> keys = new ArrayList<Object>();
    protected ISymbol defaultSymbol;
    protected int intervalType = 1;
    protected boolean useDefaultSymbol = false;
    public static final int EQUAL_INTERVALS = 0;
    public static final int NATURAL_INTERVALS = 1;
    public static final int QUANTILE_INTERVALS = 2;
    protected Map<Object, ISymbol> symbols = this.createSymbolMap();
    private static final Logger logger = LoggerFactory.getLogger(AbstractIntervalLegend.class);

    public void addSymbol(Object key, ISymbol symbol) {
        if (key == null) {
            logger.info("Warning: tried to add symbol with null key.", (Throwable)new Exception("Key is NULL"));
        } else {
            this.symbols.put(key, symbol);
            this.keys.add(key);
            this.fireClassifiedSymbolChangeEvent(new SymbolLegendEvent(null, symbol));
        }
    }

    public ISymbol getSymbol(FeatureReference featureID) throws MapContextException, DataException {
        return this.getSymbolByFeature(featureID.getFeature());
    }

    public ISymbol getSymbolByFeature(Feature feat) throws MapContextException {
        Object val = feat.get(this.getClassifyingFieldNames()[0]);
        IInterval interval = this.getInterval(val);
        ISymbol theSymbol = this.getSymbolByInterval(interval);
        if (theSymbol != null) {
            return theSymbol;
        }
        if (this.useDefaultSymbol) {
            return this.getDefaultSymbol();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IInterval[] calculateIntervals(FeatureStore featureStore, String fieldName, int numIntervalos, int shapeType) throws DataException {
        logger.debug("elRs.start()");
        FeatureSet set = null;
        DisposableIterator iterator = null;
        try {
            this.setClassifyingFieldNames(new String[]{fieldName});
            String[] fieldNames = this.getClassifyingFieldNames();
            FeatureQuery featureQuery = featureStore.createFeatureQuery();
            featureQuery.setAttributeNames(fieldNames);
            set = featureStore.getFeatureSet(featureQuery);
            iterator = set.fastIterator();
            double minValue = Double.MAX_VALUE;
            double maxValue = Double.NEGATIVE_INFINITY;
            IVectorialIntervalLegend auxLegend = (IVectorialIntervalLegend)MapContextLocator.getMapContextManager().createLegend("VectorialInterval");
            auxLegend.setShapeType(shapeType);
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                Object clave = feature.get(fieldName);
                IInterval interval = auxLegend.getInterval(clave);
                if (auxLegend.getSymbolByInterval(interval) != null) continue;
                double valor = 0.0;
                if (clave instanceof Number) {
                    valor = ((Number)clave).doubleValue();
                } else if (clave instanceof Date) {
                    // empty if block
                }
                if (valor < minValue) {
                    minValue = valor;
                }
                if (!(valor > maxValue)) continue;
                maxValue = valor;
            }
            IInterval[] intervalArray = null;
            switch (this.getIntervalType()) {
                case 0: {
                    intervalArray = this.calculateEqualIntervals(numIntervalos, minValue, maxValue, fieldName);
                    break;
                }
                case 1: {
                    intervalArray = this.calculateNaturalIntervals(featureStore, numIntervalos, minValue, maxValue, fieldName);
                    break;
                }
                case 2: {
                    intervalArray = this.calculateQuantileIntervals(featureStore, numIntervalos, minValue, maxValue, fieldName);
                }
            }
            IInterval[] iIntervalArray = intervalArray;
            return iIntervalArray;
        }
        finally {
            if (iterator != null) {
                iterator.dispose();
            }
            if (set != null) {
                set.dispose();
            }
        }
    }

    private IInterval[] calculateEqualIntervals(int numIntervals, double minValue, double maxValue, String fieldName) {
        IInterval[] theIntervalArray = new IInterval[numIntervals];
        double step = (maxValue - minValue) / (double)numIntervals;
        if (numIntervals > 1) {
            theIntervalArray[0] = new FInterval(minValue, minValue + step);
            for (int i = 1; i < numIntervals - 1; ++i) {
                theIntervalArray[i] = new FInterval(minValue + (double)i * step + 0.01, minValue + (double)(i + 1) * step);
            }
            theIntervalArray[numIntervals - 1] = new FInterval(minValue + (double)(numIntervals - 1) * step + 0.01, maxValue);
        } else {
            theIntervalArray[0] = new FInterval(minValue, maxValue);
        }
        return theIntervalArray;
    }

    private IInterval[] calculateNaturalIntervals(FeatureStore featureStore, int numIntervals, double minValue, double maxValue, String fieldName) throws DataException {
        NaturalIntervalGenerator intervalGenerator = new NaturalIntervalGenerator(featureStore, fieldName, numIntervals);
        intervalGenerator.generarIntervalos();
        int numIntervalsGen = intervalGenerator.getNumIntervals() - 1;
        if (numIntervalsGen == -1) {
            numIntervalsGen = 1;
        }
        IInterval[] theIntervalArray = new FInterval[numIntervalsGen];
        if (numIntervalsGen > 1) {
            theIntervalArray[0] = new FInterval(minValue, intervalGenerator.getValorRuptura(0));
            for (int i = 1; i < numIntervalsGen - 1; ++i) {
                theIntervalArray[i] = new FInterval(intervalGenerator.getValInit(i - 1), intervalGenerator.getValorRuptura(i));
            }
            theIntervalArray[numIntervalsGen - 1] = new FInterval(intervalGenerator.getValInit(numIntervalsGen - 2), maxValue);
        } else {
            theIntervalArray[numIntervalsGen - 1] = new FInterval(minValue, maxValue);
        }
        return theIntervalArray;
    }

    private IInterval[] calculateQuantileIntervals(FeatureStore featureStore, int numIntervals, double minValue, double maxValue, String fieldName) throws DataException {
        QuantileIntervalGenerator intervalGenerator = new QuantileIntervalGenerator(featureStore, fieldName, numIntervals);
        intervalGenerator.generarIntervalos();
        int numIntervalsGen = intervalGenerator.getNumIntervalGen();
        IInterval[] theIntervalArray = new FInterval[numIntervalsGen];
        if (intervalGenerator.getNumIntervalGen() > 1) {
            theIntervalArray[0] = new FInterval(minValue, intervalGenerator.getValRuptura(0));
            for (int i = 1; i < numIntervalsGen - 1; ++i) {
                theIntervalArray[i] = new FInterval(intervalGenerator.getValInit(i - 1), intervalGenerator.getValRuptura(i));
            }
            theIntervalArray[numIntervalsGen - 1] = new FInterval(intervalGenerator.getValInit(numIntervalsGen - 2), maxValue);
        } else {
            theIntervalArray[numIntervalsGen - 1] = new FInterval(minValue, maxValue);
        }
        return theIntervalArray;
    }

    public ISymbol getSymbolByInterval(IInterval key) {
        if (key == null) {
            if (this.isUseDefaultSymbol()) {
                return this.defaultSymbol;
            }
            return null;
        }
        if (this.symbols.containsKey(key)) {
            return this.symbols.get(key);
        }
        if (this.isUseDefaultSymbol()) {
            return this.defaultSymbol;
        }
        return null;
    }

    public String[] getDescriptions() {
        String[] descriptions = new String[this.symbols.size()];
        ISymbol[] auxSym = this.getSymbols();
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = auxSym[i].getDescription();
        }
        return descriptions;
    }

    public Object[] getValues() {
        return this.symbols.keySet().toArray();
    }

    public void clear() {
        this.keys.clear();
        this.symbols.clear();
    }

    public ISymbol[] getSymbols() {
        ISymbol[] symbolList = new ISymbol[this.symbols.size()];
        return this.symbols.values().toArray(symbolList);
    }

    public void setDefaultSymbol(ISymbol s) {
        ISymbol old = this.defaultSymbol;
        if (s == null) {
            throw new NullPointerException("Default symbol cannot be null");
        }
        this.defaultSymbol = s;
        this.fireDefaultSymbolChangedEvent(new SymbolLegendEvent(old, this.defaultSymbol));
    }

    public ISymbol getDefaultSymbol() {
        if (this.defaultSymbol == null) {
            this.defaultSymbol = this.getSymbolManager().createSymbol(this.getShapeType());
        }
        return this.defaultSymbol;
    }

    public IInterval getInterval(Object v) {
        if (v != null) {
            for (int i = 0; i < this.keys.size(); ++i) {
                Object obj_key = this.keys.get(i);
                if (!(obj_key instanceof IInterval) || !((IInterval)obj_key).isInInterval(v)) continue;
                return (IInterval)obj_key;
            }
        }
        return null;
    }

    public void setIntervalType(int intervalType) {
        this.intervalType = intervalType;
    }

    public int getIntervalType() {
        return this.intervalType;
    }

    public void useDefaultSymbol(boolean b) {
        this.useDefaultSymbol = b;
    }

    public boolean isUseDefaultSymbol() {
        return this.useDefaultSymbol;
    }

    public void delSymbol(Object obj) {
        this.keys.remove(obj);
        this.symbols.remove(obj);
        this.fireClassifiedSymbolChangeEvent(new SymbolLegendEvent(this.symbols.remove(obj), null));
    }

    public void replace(ISymbol oldSymbol, ISymbol newSymbol) {
        if (this.symbols.containsValue(oldSymbol)) {
            Iterator<Object> it = this.symbols.keySet().iterator();
            ArrayList<Object> key_list = new ArrayList<Object>();
            while (it.hasNext()) {
                Object key = it.next();
                if (!this.symbols.get(key).equals(oldSymbol)) continue;
                key_list.add(key);
            }
            for (int i = 0; i < key_list.size(); ++i) {
                Object k = key_list.get(i);
                this.symbols.put(k, newSymbol);
            }
            this.fireClassifiedSymbolChangeEvent(new SymbolLegendEvent(oldSymbol, newSymbol));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractIntervalLegend clone = (AbstractIntervalLegend)super.clone();
        if (this.defaultSymbol != null) {
            clone.defaultSymbol = (ISymbol)this.defaultSymbol.clone();
        }
        clone.keys = new ArrayList<Object>();
        if (this.symbols != null) {
            clone.symbols = this.createSymbolMap();
            for (Map.Entry<Object, ISymbol> entry : this.symbols.entrySet()) {
                Object key = entry.getKey();
                IInterval key_interval = null;
                if (key instanceof IInterval) {
                    key_interval = (IInterval)key;
                    key = key_interval.clone();
                }
                ISymbol symbolClone = (ISymbol)entry.getValue().clone();
                clone.addSymbol(key, symbolClone);
            }
        }
        clone.setIntervalType(this.getIntervalType());
        return clone;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setIntervalType(state.getInt(FIELD_INTERVAL_TYPE));
        this.keys = new ArrayList<Object>(state.getList(FIELD_KEYS));
        this.useDefaultSymbol(state.getBoolean(FIELD_USE_DEFAULT_SYMBOL));
        Map persistedSymbolMap = (Map)state.get(FIELD_SYMBOLS);
        if (persistedSymbolMap != null) {
            this.symbols.putAll(persistedSymbolMap);
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_INTERVAL_TYPE, this.getIntervalType());
        state.set(FIELD_KEYS, this.keys);
        state.set(FIELD_USE_DEFAULT_SYMBOL, this.isUseDefaultSymbol());
        state.set(FIELD_SYMBOLS, this.symbols);
    }

    private Map<Object, ISymbol> createSymbolMap() {
        return new TreeMap<Object, ISymbol>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 != null && o2 != null) {
                    boolean o1_inte = o1 instanceof FInterval;
                    boolean o2_inte = o2 instanceof FInterval;
                    if (!o1_inte && !o2_inte) {
                        return 0;
                    }
                    if (o1_inte && !o2_inte) {
                        return 1;
                    }
                    if (!o1_inte && o2_inte) {
                        return -1;
                    }
                    FInterval i2 = (FInterval)o2;
                    FInterval i1 = (FInterval)o1;
                    if (i1.getMin() > i2.getMin()) {
                        return 1;
                    }
                    if (i1.getMin() < i2.getMin()) {
                        return -1;
                    }
                    if (i1.getMax() < i2.getMax()) {
                        return -1;
                    }
                    if (i1.getMax() > i2.getMax()) {
                        return 1;
                    }
                }
                return 0;
            }
        });
    }

    public Map<IInterval, ISymbol> createSymbols(IInterval[] intervals) {
        try {
            NumberFormat formatter = NumberFormat.getInstance();
            Color startColor = this.getStartColor();
            Color endColor = this.getEndColor();
            HashMap<IInterval, ISymbol> symbols = new HashMap<IInterval, ISymbol>();
            SymbolManager symbolManager = MapContextLocator.getSymbolManager();
            formatter.setMaximumFractionDigits(2);
            int r = startColor.getRed();
            int g = startColor.getGreen();
            int b = startColor.getBlue();
            int stepR = (int)Math.floor((endColor.getRed() - r) / (intervals.length - 1));
            int stepG = (int)Math.floor((endColor.getGreen() - g) / (intervals.length - 1));
            int stepB = (int)Math.floor((endColor.getBlue() - b) / (intervals.length - 1));
            for (int k = 0; k < intervals.length; ++k) {
                IInterval interval = intervals[k];
                ISymbol theSymbol = null;
                Color color = new Color(r, g, b);
                int intervalos = intervals.length - 1;
                if (intervalos == k) {
                    color = endColor;
                }
                if ((theSymbol = symbolManager.createSymbol(this.getShapeType(), color)) instanceof IMultiShapeSymbol) {
                    IMultiShapeSymbol mss = (IMultiShapeSymbol)theSymbol;
                    mss.getLineSymbol().setLineColor(color);
                    mss.getFillSymbol().setFillColor(color);
                }
                theSymbol.setDescription(formatter.format(interval.getMin()) + " - " + formatter.format(interval.getMax()));
                r += stepR;
                g += stepG;
                b += stepB;
                symbols.put(interval, theSymbol);
            }
            return symbols;
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create symbols from the intervals", e);
        }
    }

    public void setIntervals(IInterval[] intervals) {
        Map<IInterval, ISymbol> symbols = this.createSymbols(intervals);
        this.clear();
        for (Map.Entry<IInterval, ISymbol> entrySet : symbols.entrySet()) {
            IInterval key = entrySet.getKey();
            ISymbol value = entrySet.getValue();
            this.addSymbol(key, value);
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(AbstractIntervalLegend.INTERVAL_LEGEND_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(AbstractIntervalLegend.class, AbstractIntervalLegend.INTERVAL_LEGEND_PERSISTENCE_DEFINITION_NAME, "IntervalLegend Persistence definition (FIXME check keys type)", null, null);
                definition.extend(manager.getDefinition("ClassifiedVectorLegend"));
                definition.addDynFieldInt(AbstractIntervalLegend.FIELD_INTERVAL_TYPE).setMandatory(true);
                definition.addDynFieldList(AbstractIntervalLegend.FIELD_KEYS).setClassOfItems(Integer.TYPE);
                definition.addDynFieldBoolean(AbstractIntervalLegend.FIELD_USE_DEFAULT_SYMBOL);
                definition.addDynFieldMap(AbstractIntervalLegend.FIELD_SYMBOLS).setClassOfItems(ISymbol.class);
            }
            return Boolean.TRUE;
        }
    }
}

