/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendContentsChangedListener;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLegend
implements ILegend {
    public static final String LEGEND_PERSISTENCE_DEFINITION_NAME = "Legend";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLegend.class);
    private final List<LegendContentsChangedListener> listeners = new ArrayList<LegendContentsChangedListener>();
    private final BaseWeakReferencingObservable delegateDrawingObservable = new BaseWeakReferencingObservable();
    private final MapContextManager manager = MapContextLocator.getMapContextManager();

    public MapContextManager getManager() {
        return this.manager;
    }

    public SymbolManager getSymbolManager() {
        return this.manager.getSymbolManager();
    }

    public void addLegendListener(LegendContentsChangedListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeLegendListener(LegendContentsChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void fireDefaultSymbolChangedEvent(SymbolLegendEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).symbolChanged(event);
        }
    }

    public LegendContentsChangedListener[] getListeners() {
        return this.listeners.toArray(new LegendContentsChangedListener[this.listeners.size()]);
    }

    public void addDrawingObserver(Observer observer) {
        this.delegateDrawingObservable.addObserver(observer);
    }

    public void deleteDrawingObserver(Observer observer) {
        this.delegateDrawingObservable.deleteObserver(observer);
    }

    public void deleteDrawingObservers() {
        this.delegateDrawingObservable.deleteObservers();
    }

    public void addObserver(Reference<Observer> ref) {
        this.delegateDrawingObservable.addObserver(ref);
    }

    public void beginComplexNotification() {
        this.delegateDrawingObservable.beginComplexNotification();
    }

    public int countObservers() {
        return this.delegateDrawingObservable.countObservers();
    }

    public void deleteObserver(Reference<Observer> ref) {
        this.delegateDrawingObservable.deleteObserver(ref);
    }

    public void disableNotifications() {
        this.delegateDrawingObservable.disableNotifications();
    }

    public void enableNotifications() {
        this.delegateDrawingObservable.enableNotifications();
    }

    public void endComplexNotification() {
        this.delegateDrawingObservable.endComplexNotification();
    }

    public boolean inComplex() {
        return this.delegateDrawingObservable.inComplex();
    }

    public boolean isEnabledNotifications() {
        return this.delegateDrawingObservable.isEnabledNotifications();
    }

    public void notifyObservers() {
        this.delegateDrawingObservable.notifyObservers();
    }

    public void notifyObservers(Object arg) {
        this.delegateDrawingObservable.notifyObservers(arg);
    }

    public ILegend cloneLegend() {
        try {
            return (ILegend)this.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error("Error creating the clone of the legend: " + this, (Throwable)e);
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractLegend legendClone = (AbstractLegend)super.clone();
        return legendClone;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
    }

    public void saveToState(PersistentState state) throws PersistenceException {
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(AbstractLegend.LEGEND_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct dynStruct = manager.addDefinition(AbstractLegend.class, AbstractLegend.LEGEND_PERSISTENCE_DEFINITION_NAME, "Legend persistence definition", null, null);
            }
            return Boolean.TRUE;
        }
    }
}

